/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TagsProvider<T>
implements IDataProvider {
    private static final Logger field_200436_d = LogManager.getLogger();
    private static final Gson field_200437_e = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator field_200433_a;
    protected final Registry<T> field_200435_c;
    private final Map<ResourceLocation, ITag.Builder> field_200434_b = Maps.newLinkedHashMap();

    protected TagsProvider(DataGenerator dataGenerator, Registry<T> registry) {
        this.field_200433_a = dataGenerator;
        this.field_200435_c = registry;
    }

    protected abstract void func_200432_c();

    @Override
    public void func_200398_a(DirectoryCache directoryCache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        Tag tag = Tag.func_241284_a_();
        Function<ResourceLocation, ITag> \u26032 = resourceLocation -> this.field_200434_b.containsKey(resourceLocation) ? tag : null;
        Function<ResourceLocation, Object> \u26033 = resourceLocation -> this.field_200435_c.func_218349_b((ResourceLocation)resourceLocation).orElse(null);
        this.field_200434_b.forEach((resourceLocation, builder) -> {
            List list = builder.func_232963_b_(\u26032, \u26033).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", resourceLocation, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject \u26032 = builder.func_232965_c_();
            Path \u26033 = this.func_200431_a((ResourceLocation)resourceLocation);
            try {
                DirectoryCache directoryCache2;
                String string = field_200437_e.toJson((JsonElement)\u26032);
                \u2603 = field_208307_a.hashUnencodedChars((CharSequence)string).toString();
                if (!Objects.equals(directoryCache.func_208323_a(\u26033), \u2603) || !Files.exists(\u26033, new LinkOption[0])) {
                    Files.createDirectories(\u26033.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(\u26033, new OpenOption[0]);){
                        bufferedWriter.write(string);
                    }
                }
                directoryCache.func_208316_a(\u26033, \u2603);
            }
            catch (IOException iOException) {
                field_200436_d.error("Couldn't save tags to {}", (Object)\u26033, (Object)iOException);
            }
        });
    }

    protected abstract Path func_200431_a(ResourceLocation var1);

    protected Builder<T> func_240522_a_(ITag.INamedTag<T> iNamedTag) {
        ITag.Builder builder = this.func_240525_b_(iNamedTag);
        return new Builder(builder, this.field_200435_c, "vanilla");
    }

    protected ITag.Builder func_240525_b_(ITag.INamedTag<T> iNamedTag) {
        return this.field_200434_b.computeIfAbsent(iNamedTag.func_230234_a_(), resourceLocation -> new ITag.Builder());
    }

    public static class Builder<T> {
        private final ITag.Builder field_240528_a_;
        private final Registry<T> field_240529_b_;
        private final String field_240530_c_;

        private Builder(ITag.Builder builder, Registry<T> registry, String string) {
            this.field_240528_a_ = builder;
            this.field_240529_b_ = registry;
            this.field_240530_c_ = string;
        }

        public Builder<T> func_240532_a_(T t) {
            this.field_240528_a_.func_232961_a_(this.field_240529_b_.func_177774_c(t), this.field_240530_c_);
            return this;
        }

        public Builder<T> func_240531_a_(ITag.INamedTag<T> iNamedTag) {
            this.field_240528_a_.func_232964_b_(iNamedTag.func_230234_a_(), this.field_240530_c_);
            return this;
        }

        @SafeVarargs
        public final Builder<T> func_240534_a_(T ... TArray) {
            Stream.of(TArray).map(this.field_240529_b_::func_177774_c).forEach(resourceLocation -> this.field_240528_a_.func_232961_a_((ResourceLocation)resourceLocation, this.field_240530_c_));
            return this;
        }
    }
}

