/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.CombatRules;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;

public abstract class LivingEntity
extends Entity {
    private static final UUID field_110156_b = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID field_233625_c_ = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final AttributeModifier field_110157_c = new AttributeModifier(field_110156_b, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected static final DataParameter<Byte> field_184621_as = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Float> field_184632_c = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184633_f = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184634_g = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184635_h = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_226291_bp_ = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> field_213379_bs = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187201_k);
    protected static final EntitySize field_213377_as = EntitySize.func_220311_c(0.2f, 0.2f);
    private final AttributeModifierManager field_110155_d;
    private final CombatTracker field_94063_bt = new CombatTracker(this);
    private final Map<Effect, EffectInstance> field_70713_bf = Maps.newHashMap();
    private final NonNullList<ItemStack> field_184630_bs = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
    private final NonNullList<ItemStack> field_184631_bt = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
    public boolean field_82175_bq;
    public Hand field_184622_au;
    public int field_110158_av;
    public int field_70720_be;
    public int field_226290_au_;
    public int field_70737_aN;
    public int field_70738_aO;
    public float field_70739_aP;
    public int field_70725_aQ;
    public float field_70732_aI;
    public float field_70733_aJ;
    protected int field_184617_aD;
    public float field_184618_aE;
    public float field_70721_aZ;
    public float field_184619_aG;
    public final int field_70771_an = 20;
    public final float field_70769_ao;
    public final float field_70770_ap;
    public float field_70761_aq;
    public float field_70760_ar;
    public float field_70759_as;
    public float field_70758_at;
    public float field_70747_aH = 0.02f;
    @Nullable
    protected PlayerEntity field_70717_bb;
    protected int field_70718_bc;
    protected boolean field_70729_aU;
    protected int field_70708_bq;
    protected float field_70768_au;
    protected float field_110154_aX;
    protected float field_70764_aw;
    protected float field_70763_ax;
    protected float field_70741_aB;
    protected int field_70744_aE;
    protected float field_110153_bc;
    protected boolean field_70703_bu;
    public float field_70702_br;
    public float field_70701_bs;
    public float field_191988_bg;
    protected int field_70716_bi;
    protected double field_184623_bh;
    protected double field_184624_bi;
    protected double field_184625_bj;
    protected double field_184626_bk;
    protected double field_70709_bj;
    protected double field_208001_bq;
    protected int field_208002_br;
    private boolean field_70752_e = true;
    @Nullable
    private LivingEntity field_70755_b;
    private int field_70756_c;
    private LivingEntity field_110150_bn;
    private int field_142016_bo;
    private float field_70746_aG;
    private int field_70773_bE;
    private float field_110151_bq;
    protected ItemStack field_184627_bm = ItemStack.field_190927_a;
    protected int field_184628_bn;
    protected int field_184629_bo;
    private BlockPos field_184620_bC;
    private Optional<BlockPos> field_233624_bE_ = Optional.empty();
    private DamageSource field_189750_bF;
    private long field_189751_bG;
    protected int field_204807_bs;
    private float field_205017_bL;
    private float field_205018_bM;
    protected Brain<?> field_213378_br;

    protected LivingEntity(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
        this.field_110155_d = new AttributeModifierManager(GlobalEntityTypeAttributes.func_233835_a_(entityType));
        this.func_70606_j(this.func_110138_aP());
        this.field_70156_m = true;
        this.field_70770_ap = (float)((Math.random() + 1.0) * (double)0.01f);
        this.func_226264_Z_();
        this.field_70769_ao = (float)Math.random() * 12398.0f;
        this.field_70759_as = this.field_70177_z = (float)(Math.random() * 6.2831854820251465);
        this.field_70138_W = 0.6f;
        NBTDynamicOps nBTDynamicOps = NBTDynamicOps.field_210820_a;
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)nBTDynamicOps, nBTDynamicOps.createMap((Map)ImmutableMap.of((Object)nBTDynamicOps.createString("memories"), (Object)nBTDynamicOps.emptyMap()))));
    }

    public Brain<?> func_213375_cj() {
        return this.field_213378_br;
    }

    protected Brain.BrainCodec<?> func_230289_cH_() {
        return Brain.func_233705_a_(ImmutableList.of(), ImmutableList.of());
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        return this.func_230289_cH_().func_233748_a_(dynamic);
    }

    @Override
    public void func_174812_G() {
        this.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
    }

    public boolean func_213358_a(EntityType<?> entityType) {
        return true;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184621_as, (byte)0);
        this.field_70180_af.func_187214_a(field_184633_f, 0);
        this.field_70180_af.func_187214_a(field_184634_g, false);
        this.field_70180_af.func_187214_a(field_184635_h, 0);
        this.field_70180_af.func_187214_a(field_226291_bp_, 0);
        this.field_70180_af.func_187214_a(field_184632_c, Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(field_213379_bs, Optional.empty());
    }

    public static AttributeModifierMap.MutableAttribute func_233639_cI_() {
        return AttributeModifierMap.func_233803_a_().func_233814_a_(Attributes.field_233818_a_).func_233814_a_(Attributes.field_233820_c_).func_233814_a_(Attributes.field_233821_d_).func_233814_a_(Attributes.field_233826_i_).func_233814_a_(Attributes.field_233827_j_);
    }

    @Override
    protected void func_184231_a(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
        if (!this.func_70090_H()) {
            this.func_233567_aH_();
        }
        if (!this.field_70170_p.field_72995_K && bl && this.field_70143_R > 0.0f) {
            this.func_233641_cN_();
            this.func_233642_cO_();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70143_R > 3.0f && bl) {
            float f = MathHelper.func_76123_f(this.field_70143_R - 3.0f);
            if (!blockState.func_196958_f()) {
                double d2 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int \u26032 = (int)(150.0 * d2);
                ((ServerWorld)this.field_70170_p).func_195598_a(new BlockParticleData(ParticleTypes.field_197611_d, blockState), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), \u26032, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.func_184231_a(d, bl, blockState, blockPos);
    }

    public boolean func_70648_aU() {
        return this.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }

    @Override
    public void func_70030_z() {
        this.field_70732_aI = this.field_70733_aJ;
        if (this.field_70148_d) {
            this.func_213374_dv().ifPresent(this::func_213370_a);
        }
        if (this.func_230490_cK_()) {
            this.func_233640_cL_();
        }
        super.func_70030_z();
        this.field_70170_p.func_217381_Z().func_76320_a("livingEntityBaseTick");
        boolean bl = this instanceof PlayerEntity;
        if (this.func_70089_S()) {
            if (this.func_70094_T()) {
                this.func_70097_a(DamageSource.field_76368_d, 1.0f);
            } else if (bl && !this.field_70170_p.func_175723_af().func_177743_a(this.func_174813_aQ()) && (\u2603 = this.field_70170_p.func_175723_af().func_177745_a(this) + this.field_70170_p.func_175723_af().func_177742_m()) < 0.0 && (\u2603 = this.field_70170_p.func_175723_af().func_177727_n()) > 0.0) {
                this.func_70097_a(DamageSource.field_76368_d, Math.max(1, MathHelper.func_76128_c(-\u2603 * \u2603)));
            }
        }
        if (this.func_230279_az_() || this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
        boolean bl2 = \u2603 = bl && ((PlayerEntity)this).field_71075_bZ.field_75102_a;
        if (this.func_70089_S()) {
            Object object;
            if (this.func_208600_a(FluidTags.field_206959_a) && !this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_())).func_203425_a(Blocks.field_203203_C)) {
                if (!(this.func_70648_aU() || EffectUtils.func_205133_c(this) || \u2603)) {
                    this.func_70050_g(this.func_70682_h(this.func_70086_ai()));
                    if (this.func_70086_ai() == -20) {
                        this.func_70050_g(0);
                        object = this.func_213322_ci();
                        for (int i = 0; i < 8; ++i) {
                            double d = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            \u2603 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            \u2603 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            this.field_70170_p.func_195594_a(ParticleTypes.field_197612_e, this.func_226277_ct_() + d, this.func_226278_cu_() + \u2603, this.func_226281_cx_() + \u2603, ((Vector3d)object).field_72450_a, ((Vector3d)object).field_72448_b, ((Vector3d)object).field_72449_c);
                        }
                        this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                }
                if (!this.field_70170_p.field_72995_K && this.func_184218_aH() && this.func_184187_bx() != null && !this.func_184187_bx().func_205710_ba()) {
                    this.func_184210_p();
                }
            } else if (this.func_70086_ai() < this.func_205010_bg()) {
                this.func_70050_g(this.func_207300_l(this.func_70086_ai()));
            }
            if (!this.field_70170_p.field_72995_K && !Objects.equal((Object)this.field_184620_bC, (Object)(object = this.func_233580_cy_()))) {
                this.field_184620_bC = object;
                this.func_184594_b((BlockPos)object);
            }
        }
        if (this.func_70089_S() && this.func_203008_ap()) {
            this.func_70066_B();
        }
        if (this.field_70737_aN > 0) {
            --this.field_70737_aN;
        }
        if (this.field_70172_ad > 0 && !(this instanceof ServerPlayerEntity)) {
            --this.field_70172_ad;
        }
        if (this.func_233643_dh_()) {
            this.func_70609_aI();
        }
        if (this.field_70718_bc > 0) {
            --this.field_70718_bc;
        } else {
            this.field_70717_bb = null;
        }
        if (this.field_110150_bn != null && !this.field_110150_bn.func_70089_S()) {
            this.field_110150_bn = null;
        }
        if (this.field_70755_b != null) {
            if (!this.field_70755_b.func_70089_S()) {
                this.func_70604_c(null);
            } else if (this.field_70173_aa - this.field_70756_c > 100) {
                this.func_70604_c(null);
            }
        }
        this.func_70679_bo();
        this.field_70763_ax = this.field_70764_aw;
        this.field_70760_ar = this.field_70761_aq;
        this.field_70758_at = this.field_70759_as;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    public boolean func_230490_cK_() {
        return this.field_70173_aa % 5 == 0 && this.func_213322_ci().field_72450_a != 0.0 && this.func_213322_ci().field_72449_c != 0.0 && !this.func_175149_v() && EnchantmentHelper.func_234846_j_(this) && this.func_230296_cM_();
    }

    protected void func_233640_cL_() {
        Vector3d vector3d = this.func_213322_ci();
        this.field_70170_p.func_195594_a(ParticleTypes.field_239812_C_, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), vector3d.field_72450_a * -0.2, 0.1, vector3d.field_72449_c * -0.2);
        float \u26032 = this.field_70146_Z.nextFloat() * 0.4f + this.field_70146_Z.nextFloat() > 0.9f ? 0.6f : 0.0f;
        this.func_184185_a(SoundEvents.field_232831_nS_, \u26032, 0.6f + this.field_70146_Z.nextFloat() * 0.4f);
    }

    protected boolean func_230296_cM_() {
        return this.func_233568_aJ_().func_235714_a_(BlockTags.field_232876_aq_);
    }

    @Override
    protected float func_225515_ai_() {
        if (this.func_230296_cM_() && EnchantmentHelper.func_185284_a(Enchantments.field_234847_l_, this) > 0) {
            return 1.0f;
        }
        return super.func_225515_ai_();
    }

    protected boolean func_230295_b_(BlockState blockState) {
        return !blockState.func_196958_f() || this.func_184613_cA();
    }

    protected void func_233641_cN_() {
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233821_d_);
        if (modifiableAttributeInstance == null) {
            return;
        }
        if (modifiableAttributeInstance.func_111127_a(field_233625_c_) != null) {
            modifiableAttributeInstance.func_188479_b(field_233625_c_);
        }
    }

    protected void func_233642_cO_() {
        int n;
        if (!this.func_233568_aJ_().func_196958_f() && (n = EnchantmentHelper.func_185284_a(Enchantments.field_234847_l_, this)) > 0 && this.func_230296_cM_()) {
            ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233821_d_);
            if (modifiableAttributeInstance == null) {
                return;
            }
            modifiableAttributeInstance.func_233767_b_(new AttributeModifier(field_233625_c_, "Soul speed boost", (double)(0.03f * (1.0f + (float)n * 0.35f)), AttributeModifier.Operation.ADDITION));
            if (this.func_70681_au().nextFloat() < 0.04f) {
                ItemStack itemStack = this.func_184582_a(EquipmentSlotType.FEET);
                itemStack.func_222118_a(1, this, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.FEET));
            }
        }
    }

    protected void func_184594_b(BlockPos blockPos) {
        int n = EnchantmentHelper.func_185284_a(Enchantments.field_185301_j, this);
        if (n > 0) {
            FrostWalkerEnchantment.func_185266_a(this, this.field_70170_p, blockPos, n);
        }
        if (this.func_230295_b_(this.func_233568_aJ_())) {
            this.func_233641_cN_();
        }
        this.func_233642_cO_();
    }

    public boolean func_70631_g_() {
        return false;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.5f : 1.0f;
    }

    protected boolean func_241208_cS_() {
        return true;
    }

    @Override
    public boolean func_205710_ba() {
        return false;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            this.func_70106_y();
            for (int i = 0; i < 20; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
                \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a(ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d, \u2603, \u2603);
            }
        }
    }

    protected boolean func_146066_aG() {
        return !this.func_70631_g_();
    }

    protected boolean func_230282_cS_() {
        return !this.func_70631_g_();
    }

    protected int func_70682_h(int n) {
        \u2603 = EnchantmentHelper.func_185292_c(this);
        if (\u2603 > 0 && this.field_70146_Z.nextInt(\u2603 + 1) > 0) {
            return n;
        }
        return n - 1;
    }

    protected int func_207300_l(int n) {
        return Math.min(n + 4, this.func_205010_bg());
    }

    protected int func_70693_a(PlayerEntity playerEntity) {
        return 0;
    }

    protected boolean func_70684_aJ() {
        return false;
    }

    public Random func_70681_au() {
        return this.field_70146_Z;
    }

    @Nullable
    public LivingEntity func_70643_av() {
        return this.field_70755_b;
    }

    public int func_142015_aE() {
        return this.field_70756_c;
    }

    public void func_230246_e_(@Nullable PlayerEntity playerEntity) {
        this.field_70717_bb = playerEntity;
        this.field_70718_bc = this.field_70173_aa;
    }

    public void func_70604_c(@Nullable LivingEntity livingEntity) {
        this.field_70755_b = livingEntity;
        this.field_70756_c = this.field_70173_aa;
    }

    @Nullable
    public LivingEntity func_110144_aD() {
        return this.field_110150_bn;
    }

    public int func_142013_aG() {
        return this.field_142016_bo;
    }

    public void func_130011_c(Entity entity) {
        this.field_110150_bn = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        this.field_142016_bo = this.field_70173_aa;
    }

    public int func_70654_ax() {
        return this.field_70708_bq;
    }

    public void func_213332_m(int n) {
        this.field_70708_bq = n;
    }

    protected void func_184606_a_(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        SoundEvent soundEvent = SoundEvents.field_187719_p;
        Item \u26032 = itemStack.func_77973_b();
        if (\u26032 instanceof ArmorItem) {
            soundEvent = ((ArmorItem)\u26032).func_200880_d().func_200899_b();
        } else if (\u26032 == Items.field_185160_cR) {
            soundEvent = SoundEvents.field_191258_p;
        }
        this.func_184185_a(soundEvent, 1.0f, 1.0f);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        DataResult<INBT> \u26032;
        compoundNBT2.func_74776_a("Health", this.func_110143_aJ());
        compoundNBT2.func_74777_a("HurtTime", (short)this.field_70737_aN);
        compoundNBT2.func_74768_a("HurtByTimestamp", this.field_70756_c);
        compoundNBT2.func_74777_a("DeathTime", (short)this.field_70725_aQ);
        compoundNBT2.func_74776_a("AbsorptionAmount", this.func_110139_bj());
        compoundNBT2.func_218657_a("Attributes", this.func_233645_dx_().func_233794_c_());
        if (!this.field_70713_bf.isEmpty()) {
            \u26032 = new DataResult<INBT>();
            for (EffectInstance effectInstance : this.field_70713_bf.values()) {
                \u26032.add(effectInstance.func_82719_a(new CompoundNBT()));
            }
            compoundNBT2.func_218657_a("ActiveEffects", (INBT)\u26032);
        }
        compoundNBT2.func_74757_a("FallFlying", this.func_184613_cA());
        this.func_213374_dv().ifPresent(blockPos -> {
            compoundNBT2.func_74768_a("SleepingX", blockPos.func_177958_n());
            compoundNBT2.func_74768_a("SleepingY", blockPos.func_177956_o());
            compoundNBT2.func_74768_a("SleepingZ", blockPos.func_177952_p());
        });
        \u26032 = this.field_213378_br.func_233702_a_(NBTDynamicOps.field_210820_a);
        \u26032.resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(iNBT -> compoundNBT2.func_218657_a("Brain", (INBT)iNBT));
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        Object object;
        this.func_110149_m(compoundNBT.func_74760_g("AbsorptionAmount"));
        if (compoundNBT.func_150297_b("Attributes", 9) && this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.func_233645_dx_().func_233788_a_(compoundNBT.func_150295_c("Attributes", 10));
        }
        if (compoundNBT.func_150297_b("ActiveEffects", 9)) {
            object = compoundNBT.func_150295_c("ActiveEffects", 10);
            for (int i = 0; i < ((ListNBT)object).size(); ++i) {
                CompoundNBT compoundNBT2 = ((ListNBT)object).func_150305_b(i);
                EffectInstance \u26032 = EffectInstance.func_82722_b(compoundNBT2);
                if (\u26032 == null) continue;
                this.field_70713_bf.put(\u26032.func_188419_a(), \u26032);
            }
        }
        if (compoundNBT.func_150297_b("Health", 99)) {
            this.func_70606_j(compoundNBT.func_74760_g("Health"));
        }
        this.field_70737_aN = compoundNBT.func_74765_d("HurtTime");
        this.field_70725_aQ = compoundNBT.func_74765_d("DeathTime");
        this.field_70756_c = compoundNBT.func_74762_e("HurtByTimestamp");
        if (compoundNBT.func_150297_b("Team", 8)) {
            object = compoundNBT.func_74779_i("Team");
            ScorePlayerTeam \u26033 = this.field_70170_p.func_96441_U().func_96508_e((String)object);
            boolean bl = \u2603 = \u26033 != null && this.field_70170_p.func_96441_U().func_197901_a(this.func_189512_bd(), \u26033);
            if (!\u2603) {
                field_184243_a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", object);
            }
        }
        if (compoundNBT.func_74767_n("FallFlying")) {
            this.func_70052_a(7, true);
        }
        if (compoundNBT.func_150297_b("SleepingX", 99) && compoundNBT.func_150297_b("SleepingY", 99) && compoundNBT.func_150297_b("SleepingZ", 99)) {
            object = new BlockPos(compoundNBT.func_74762_e("SleepingX"), compoundNBT.func_74762_e("SleepingY"), compoundNBT.func_74762_e("SleepingZ"));
            this.func_213369_d((BlockPos)object);
            this.field_70180_af.func_187227_b(field_213330_X, Pose.SLEEPING);
            if (!this.field_70148_d) {
                this.func_213370_a((BlockPos)object);
            }
        }
        if (compoundNBT.func_150297_b("Brain", 10)) {
            this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT.func_74781_a("Brain")));
        }
    }

    protected void func_70679_bo() {
        Iterator<Effect> iterator = this.field_70713_bf.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                Effect effect = iterator.next();
                EffectInstance \u26032 = this.field_70713_bf.get(effect);
                if (!\u26032.func_76455_a(this, () -> this.func_70695_b(\u26032, true))) {
                    if (this.field_70170_p.field_72995_K) continue;
                    iterator.remove();
                    this.func_70688_c(\u26032);
                    continue;
                }
                if (\u26032.func_76459_b() % 600 != 0) continue;
                this.func_70695_b(\u26032, false);
            }
        }
        catch (ConcurrentModificationException effect) {
            // empty catch block
        }
        if (this.field_70752_e) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_175135_B();
            }
            this.field_70752_e = false;
        }
        int n = this.field_70180_af.func_187225_a(field_184633_f);
        boolean \u26033 = this.field_70180_af.func_187225_a(field_184634_g);
        if (n > 0) {
            boolean bl = this.func_82150_aj() ? this.field_70146_Z.nextInt(15) == 0 : this.field_70146_Z.nextBoolean();
            if (\u26033) {
                bl &= this.field_70146_Z.nextInt(5) == 0;
            }
            if (bl && n > 0) {
                double d = (double)(n >> 16 & 0xFF) / 255.0;
                \u2603 = (double)(n >> 8 & 0xFF) / 255.0;
                \u2603 = (double)(n >> 0 & 0xFF) / 255.0;
                this.field_70170_p.func_195594_a(\u26033 ? ParticleTypes.field_197608_a : ParticleTypes.field_197625_r, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d, \u2603, \u2603);
            }
        }
    }

    protected void func_175135_B() {
        if (this.field_70713_bf.isEmpty()) {
            this.func_175133_bi();
            this.func_82142_c(false);
        } else {
            Collection<EffectInstance> collection = this.field_70713_bf.values();
            this.field_70180_af.func_187227_b(field_184634_g, LivingEntity.func_184593_a(collection));
            this.field_70180_af.func_187227_b(field_184633_f, PotionUtils.func_185181_a(collection));
            this.func_82142_c(this.func_70644_a(Effects.field_76441_p));
        }
    }

    public double func_213340_A(@Nullable Entity entity2) {
        Entity entity2;
        double d = 1.0;
        if (this.func_226273_bm_()) {
            d *= 0.8;
        }
        if (this.func_82150_aj()) {
            float f = this.func_213343_cS();
            if (f < 0.1f) {
                f = 0.1f;
            }
            d *= 0.7 * (double)f;
        }
        if (entity2 != null) {
            ItemStack itemStack = this.func_184582_a(EquipmentSlotType.HEAD);
            Item \u26032 = itemStack.func_77973_b();
            EntityType<?> \u26033 = entity2.func_200600_R();
            if (\u26033 == EntityType.field_200741_ag && \u26032 == Items.field_196182_dv || \u26033 == EntityType.field_200725_aD && \u26032 == Items.field_196186_dz || \u26033 == EntityType.field_200797_k && \u26032 == Items.field_196185_dy) {
                d *= 0.5;
            }
        }
        return d;
    }

    public boolean func_213336_c(LivingEntity livingEntity) {
        return true;
    }

    public boolean func_213344_a(LivingEntity livingEntity, EntityPredicate entityPredicate) {
        return entityPredicate.func_221015_a(this, livingEntity);
    }

    public static boolean func_184593_a(Collection<EffectInstance> collection) {
        for (EffectInstance effectInstance : collection) {
            if (effectInstance.func_82720_e()) continue;
            return false;
        }
        return true;
    }

    protected void func_175133_bi() {
        this.field_70180_af.func_187227_b(field_184634_g, false);
        this.field_70180_af.func_187227_b(field_184633_f, 0);
    }

    public boolean func_195061_cb() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        Iterator<EffectInstance> iterator = this.field_70713_bf.values().iterator();
        boolean \u26032 = false;
        while (iterator.hasNext()) {
            this.func_70688_c(iterator.next());
            iterator.remove();
            \u26032 = true;
        }
        return \u26032;
    }

    public Collection<EffectInstance> func_70651_bq() {
        return this.field_70713_bf.values();
    }

    public Map<Effect, EffectInstance> func_193076_bZ() {
        return this.field_70713_bf;
    }

    public boolean func_70644_a(Effect effect) {
        return this.field_70713_bf.containsKey(effect);
    }

    @Nullable
    public EffectInstance func_70660_b(Effect effect) {
        return this.field_70713_bf.get(effect);
    }

    public boolean func_195064_c(EffectInstance effectInstance) {
        if (!this.func_70687_e(effectInstance)) {
            return false;
        }
        \u2603 = this.field_70713_bf.get(effectInstance.func_188419_a());
        if (\u2603 == null) {
            this.field_70713_bf.put(effectInstance.func_188419_a(), effectInstance);
            this.func_70670_a(effectInstance);
            return true;
        }
        if (\u2603.func_199308_a(effectInstance)) {
            this.func_70695_b(\u2603, true);
            return true;
        }
        return false;
    }

    public boolean func_70687_e(EffectInstance effectInstance) {
        return this.func_70668_bt() != CreatureAttribute.field_223223_b_ || (\u2603 = effectInstance.func_188419_a()) != Effects.field_76428_l && \u2603 != Effects.field_76436_u;
    }

    public boolean func_70662_br() {
        return this.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }

    @Nullable
    public EffectInstance func_184596_c(@Nullable Effect effect) {
        return this.field_70713_bf.remove(effect);
    }

    public boolean func_195063_d(Effect effect) {
        EffectInstance effectInstance = this.func_184596_c(effect);
        if (effectInstance != null) {
            this.func_70688_c(effectInstance);
            return true;
        }
        return false;
    }

    protected void func_70670_a(EffectInstance effectInstance) {
        this.field_70752_e = true;
        if (!this.field_70170_p.field_72995_K) {
            effectInstance.func_188419_a().func_111185_a(this, this.func_233645_dx_(), effectInstance.func_76458_c());
        }
    }

    protected void func_70695_b(EffectInstance effectInstance, boolean bl) {
        this.field_70752_e = true;
        if (bl && !this.field_70170_p.field_72995_K) {
            Effect effect = effectInstance.func_188419_a();
            effect.func_111187_a(this, this.func_233645_dx_(), effectInstance.func_76458_c());
            effect.func_111185_a(this, this.func_233645_dx_(), effectInstance.func_76458_c());
        }
    }

    protected void func_70688_c(EffectInstance effectInstance) {
        this.field_70752_e = true;
        if (!this.field_70170_p.field_72995_K) {
            effectInstance.func_188419_a().func_111187_a(this, this.func_233645_dx_(), effectInstance.func_76458_c());
        }
    }

    public void func_70691_i(float f) {
        \u2603 = this.func_110143_aJ();
        if (\u2603 > 0.0f) {
            this.func_70606_j(\u2603 + f);
        }
    }

    public float func_110143_aJ() {
        return this.field_70180_af.func_187225_a(field_184632_c).floatValue();
    }

    public void func_70606_j(float f) {
        this.field_70180_af.func_187227_b(field_184632_c, Float.valueOf(MathHelper.func_76131_a(f, 0.0f, this.func_110138_aP())));
    }

    public boolean func_233643_dh_() {
        return this.func_110143_aJ() <= 0.0f;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f2) {
        DamageSource damageSource2;
        if (this.func_180431_b(damageSource2)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_233643_dh_()) {
            return false;
        }
        if (damageSource2.func_76347_k() && this.func_70644_a(Effects.field_76426_n)) {
            return false;
        }
        if (this.func_70608_bn() && !this.field_70170_p.field_72995_K) {
            this.func_213366_dy();
        }
        this.field_70708_bq = 0;
        \u2603 = f2;
        if (!(damageSource2 != DamageSource.field_82728_o && damageSource2 != DamageSource.field_82729_p || this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b())) {
            this.func_184582_a(EquipmentSlotType.HEAD).func_222118_a((int)(f2 * 4.0f + this.field_70146_Z.nextFloat() * f2 * 2.0f), this, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.HEAD));
            f2 *= 0.75f;
        }
        boolean \u26033 = false;
        float \u26032 = 0.0f;
        if (f2 > 0.0f && this.func_184583_d(damageSource2)) {
            this.func_184590_k(f2);
            \u26032 = f2;
            float f2 = 0.0f;
            if (!damageSource2.func_76352_a() && (\u2603 = damageSource2.func_76364_f()) instanceof LivingEntity) {
                this.func_190629_c((LivingEntity)\u2603);
            }
            \u26033 = true;
        }
        this.field_70721_aZ = 1.5f;
        boolean bl = true;
        if ((float)this.field_70172_ad > 10.0f) {
            if (f2 <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(damageSource2, f2 - this.field_110153_bc);
            this.field_110153_bc = f2;
            bl = false;
        } else {
            this.field_110153_bc = f2;
            this.field_70172_ad = 20;
            this.func_70665_d(damageSource2, f2);
            this.field_70737_aN = this.field_70738_aO = 10;
        }
        this.field_70739_aP = 0.0f;
        Entity \u26034 = damageSource2.func_76346_g();
        if (\u26034 != null) {
            if (\u26034 instanceof LivingEntity) {
                this.func_70604_c((LivingEntity)\u26034);
            }
            if (\u26034 instanceof PlayerEntity) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (PlayerEntity)\u26034;
            } else if (\u26034 instanceof WolfEntity && ((TameableEntity)(object = (WolfEntity)\u26034)).func_70909_n()) {
                this.field_70718_bc = 100;
                LivingEntity livingEntity2 = ((TameableEntity)object).func_70902_q();
                this.field_70717_bb = livingEntity2 != null && livingEntity2.func_200600_R() == EntityType.field_200729_aH ? (PlayerEntity)livingEntity2 : null;
            }
        }
        if (bl) {
            if (\u26033) {
                this.field_70170_p.func_72960_a(this, (byte)29);
            } else if (damageSource2 instanceof EntityDamageSource && ((EntityDamageSource)damageSource2).func_180139_w()) {
                this.field_70170_p.func_72960_a(this, (byte)33);
            } else {
                int n = damageSource2 == DamageSource.field_76369_e ? 36 : (damageSource2.func_76347_k() ? 37 : (damageSource2 == DamageSource.field_220302_v ? 44 : 2));
                this.field_70170_p.func_72960_a(this, (byte)n);
            }
            if (damageSource2 != DamageSource.field_76369_e && (!\u26033 || f2 > 0.0f)) {
                this.func_70018_K();
            }
            if (\u26034 != null) {
                double d = \u26034.func_226277_ct_() - this.func_226277_ct_();
                \u2603 = \u26034.func_226281_cx_() - this.func_226281_cx_();
                while (d * d + \u2603 * \u2603 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    \u2603 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875 - (double)this.field_70177_z);
                this.func_233627_a_(0.4f, d, \u2603);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_233643_dh_()) {
            if (!this.func_190628_d(damageSource2)) {
                Object object = this.func_184615_bR();
                if (bl && object != null) {
                    this.func_184185_a((SoundEvent)object, this.func_70599_aP(), this.func_70647_i());
                }
                this.func_70645_a(damageSource2);
            }
        } else if (bl) {
            this.func_184581_c(damageSource2);
        }
        boolean bl2 = \u2603 = !\u26033 || f2 > 0.0f;
        if (\u2603) {
            this.field_189750_bF = damageSource2;
            this.field_189751_bG = this.field_70170_p.func_82737_E();
        }
        if (this instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192128_h.func_192200_a((ServerPlayerEntity)this, damageSource2, \u2603, f2, \u26033);
            if (\u26032 > 0.0f && \u26032 < 3.4028235E37f) {
                ((ServerPlayerEntity)this).func_195067_a(Stats.field_212737_I, Math.round(\u26032 * 10.0f));
            }
        }
        if (\u26034 instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192127_g.func_192220_a((ServerPlayerEntity)\u26034, this, damageSource2, \u2603, f2, \u26033);
        }
        return \u2603;
    }

    protected void func_190629_c(LivingEntity livingEntity) {
        livingEntity.func_213371_e(this);
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        livingEntity.func_233627_a_(0.5f, livingEntity.func_226277_ct_() - this.func_226277_ct_(), livingEntity.func_226281_cx_() - this.func_226281_cx_());
    }

    private boolean func_190628_d(DamageSource damageSource) {
        if (damageSource.func_76357_e()) {
            return false;
        }
        ItemStack itemStack = null;
        for (Hand hand : Hand.values()) {
            ItemStack itemStack2 = this.func_184586_b(hand);
            if (itemStack2.func_77973_b() != Items.field_190929_cY) continue;
            itemStack = itemStack2.func_77946_l();
            itemStack2.func_190918_g(1);
            break;
        }
        if (itemStack != null) {
            if (this instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)this;
                serverPlayerEntity.func_71029_a(Stats.field_75929_E.func_199076_b(Items.field_190929_cY));
                CriteriaTriggers.field_193130_A.func_193187_a(serverPlayerEntity, itemStack);
            }
            this.func_70606_j(1.0f);
            this.func_195061_cb();
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
            this.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
            this.field_70170_p.func_72960_a(this, (byte)35);
        }
        return itemStack != null;
    }

    @Nullable
    public DamageSource func_189748_bU() {
        if (this.field_70170_p.func_82737_E() - this.field_189751_bG > 40L) {
            this.field_189750_bF = null;
        }
        return this.field_189750_bF;
    }

    protected void func_184581_c(DamageSource damageSource) {
        SoundEvent soundEvent = this.func_184601_bQ(damageSource);
        if (soundEvent != null) {
            this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    private boolean func_184583_d(DamageSource damageSource) {
        Entity entity = damageSource.func_76364_f();
        boolean \u26032 = false;
        if (entity instanceof AbstractArrowEntity && ((AbstractArrowEntity)(\u2603 = (AbstractArrowEntity)entity)).func_213874_s() > 0) {
            \u26032 = true;
        }
        if (!damageSource.func_76363_c() && this.func_184585_cz() && !\u26032 && (\u2603 = damageSource.func_188404_v()) != null) {
            Vector3d vector3d = this.func_70676_i(1.0f);
            \u2603 = ((Vector3d)\u2603).func_72444_a(this.func_213303_ch()).func_72432_b();
            \u2603 = new Vector3d(\u2603.field_72450_a, 0.0, \u2603.field_72449_c);
            if (\u2603.func_72430_b(vector3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public void func_70645_a(DamageSource damageSource) {
        if (this.field_70128_L || this.field_70729_aU) {
            return;
        }
        Entity entity = damageSource.func_76346_g();
        LivingEntity \u26032 = this.func_94060_bK();
        if (this.field_70744_aE >= 0 && \u26032 != null) {
            \u26032.func_191956_a(this, this.field_70744_aE, damageSource);
        }
        if (entity != null) {
            entity.func_70074_a(this);
        }
        if (this.func_70608_bn()) {
            this.func_213366_dy();
        }
        this.field_70729_aU = true;
        this.func_110142_aN().func_94549_h();
        if (!this.field_70170_p.field_72995_K) {
            this.func_213345_d(damageSource);
            this.func_226298_f_(\u26032);
        }
        this.field_70170_p.func_72960_a(this, (byte)3);
        this.func_213301_b(Pose.DYING);
    }

    protected void func_226298_f_(@Nullable LivingEntity livingEntity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean bl = false;
        if (livingEntity instanceof WitherEntity) {
            Object object;
            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                object = this.func_233580_cy_();
                BlockState \u26032 = Blocks.field_222388_bz.func_176223_P();
                if (this.field_70170_p.func_180495_p((BlockPos)object).func_196958_f() && \u26032.func_196955_c(this.field_70170_p, (BlockPos)object)) {
                    this.field_70170_p.func_180501_a((BlockPos)object, \u26032, 3);
                    bl = true;
                }
            }
            if (!bl) {
                object = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new ItemStack(Items.field_221690_bg));
                this.field_70170_p.func_217376_c((Entity)object);
            }
        }
    }

    protected void func_213345_d(DamageSource damageSource) {
        Entity entity = damageSource.func_76346_g();
        int \u26032 = entity instanceof PlayerEntity ? EnchantmentHelper.func_185283_h((LivingEntity)entity) : 0;
        boolean bl = \u2603 = this.field_70718_bc > 0;
        if (this.func_230282_cS_() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_213354_a(damageSource, \u2603);
            this.func_213333_a(damageSource, \u26032, \u2603);
        }
        this.func_213337_cE();
        this.func_226294_cV_();
    }

    protected void func_213337_cE() {
    }

    protected void func_226294_cV_() {
        if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e))) {
            int n;
            for (\u2603 = this.func_70693_a(this.field_70717_bb); \u2603 > 0; \u2603 -= n) {
                n = ExperienceOrbEntity.func_70527_a(\u2603);
                this.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), n));
            }
        }
    }

    protected void func_213333_a(DamageSource damageSource, int n, boolean bl) {
    }

    public ResourceLocation func_213346_cF() {
        return this.func_200600_R().func_220348_g();
    }

    protected void func_213354_a(DamageSource damageSource, boolean bl) {
        ResourceLocation resourceLocation = this.func_213346_cF();
        LootTable \u26032 = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourceLocation);
        LootContext.Builder \u26033 = this.func_213363_a(bl, damageSource);
        \u26032.func_216120_b(\u26033.func_216022_a(LootParameterSets.field_216263_d), this::func_199701_a_);
    }

    protected LootContext.Builder func_213363_a(boolean bl, DamageSource damageSource) {
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70146_Z).func_216015_a(LootParameters.field_216281_a, this).func_216015_a(LootParameters.field_216286_f, this.func_233580_cy_()).func_216015_a(LootParameters.field_216283_c, damageSource).func_216021_b(LootParameters.field_216284_d, damageSource.func_76346_g()).func_216021_b(LootParameters.field_216285_e, damageSource.func_76364_f());
        if (bl && this.field_70717_bb != null) {
            builder = builder.func_216015_a(LootParameters.field_216282_b, this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
        }
        return builder;
    }

    public void func_233627_a_(float f, double d, double d2) {
        if ((f = (float)((double)f * (1.0 - this.func_233637_b_(Attributes.field_233820_c_)))) <= 0.0f) {
            return;
        }
        this.field_70160_al = true;
        Vector3d vector3d = this.func_213322_ci();
        \u2603 = new Vector3d(d, 0.0, d2).func_72432_b().func_186678_a(f);
        this.func_213293_j(vector3d.field_72450_a / 2.0 - \u2603.field_72450_a, this.field_70122_E ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)f) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - \u2603.field_72449_c);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187543_bD;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187661_by;
    }

    protected SoundEvent func_184588_d(int n) {
        if (n > 4) {
            return SoundEvents.field_187655_bw;
        }
        return SoundEvents.field_187545_bE;
    }

    protected SoundEvent func_213351_c(ItemStack itemStack) {
        return itemStack.func_226629_F_();
    }

    public SoundEvent func_213353_d(ItemStack itemStack) {
        return itemStack.func_226630_G_();
    }

    @Override
    public void func_230245_c_(boolean bl) {
        super.func_230245_c_(bl);
        if (bl) {
            this.field_233624_bE_ = Optional.empty();
        }
    }

    public Optional<BlockPos> func_233644_dn_() {
        return this.field_233624_bE_;
    }

    public boolean func_70617_f_() {
        if (this.func_175149_v()) {
            return false;
        }
        BlockPos blockPos = this.func_233580_cy_();
        BlockState \u26032 = this.func_213339_cH();
        Block \u26033 = \u26032.func_177230_c();
        if (\u26033.func_203417_a(BlockTags.field_232878_as_)) {
            this.field_233624_bE_ = Optional.of(blockPos);
            return true;
        }
        if (\u26033 instanceof TrapDoorBlock && this.func_184604_a(blockPos, \u26032)) {
            this.field_233624_bE_ = Optional.of(blockPos);
            return true;
        }
        return false;
    }

    public BlockState func_213339_cH() {
        return this.field_70170_p.func_180495_p(this.func_233580_cy_());
    }

    private boolean func_184604_a(BlockPos blockPos, BlockState blockState) {
        return blockState.func_177229_b(TrapDoorBlock.field_176283_b) != false && (\u2603 = this.field_70170_p.func_180495_p(blockPos.func_177977_b())).func_203425_a(Blocks.field_150468_ap) && \u2603.func_177229_b(LadderBlock.field_176382_a) == blockState.func_177229_b(TrapDoorBlock.field_185512_D);
    }

    @Override
    public boolean func_70089_S() {
        return !this.field_70128_L && this.func_110143_aJ() > 0.0f;
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        boolean bl = super.func_225503_b_(f, f2);
        int \u26032 = this.func_225508_e_(f, f2);
        if (\u26032 > 0) {
            this.func_184185_a(this.func_184588_d(\u26032), 1.0f, 1.0f);
            this.func_226295_cZ_();
            this.func_70097_a(DamageSource.field_76379_h, \u26032);
            return true;
        }
        return bl;
    }

    protected int func_225508_e_(float f, float f2) {
        EffectInstance effectInstance = this.func_70660_b(Effects.field_76430_j);
        float \u26032 = effectInstance == null ? 0.0f : (float)(effectInstance.func_76458_c() + 1);
        return MathHelper.func_76123_f((f - 3.0f - \u26032) * f2);
    }

    protected void func_226295_cZ_() {
        if (this.func_174814_R()) {
            return;
        }
        int n = MathHelper.func_76128_c(this.func_226277_ct_());
        BlockState \u26032 = this.field_70170_p.func_180495_p(new BlockPos(n, \u2603 = MathHelper.func_76128_c(this.func_226278_cu_() - (double)0.2f), \u2603 = MathHelper.func_76128_c(this.func_226281_cx_())));
        if (!\u26032.func_196958_f()) {
            SoundType soundType = \u26032.func_215695_r();
            this.func_184185_a(soundType.func_185842_g(), soundType.func_185843_a() * 0.5f, soundType.func_185847_b() * 0.75f);
        }
    }

    public int func_70658_aO() {
        return MathHelper.func_76128_c(this.func_233637_b_(Attributes.field_233826_i_));
    }

    protected void func_230294_b_(DamageSource damageSource, float f) {
    }

    protected void func_184590_k(float f) {
    }

    protected float func_70655_b(DamageSource damageSource, float f) {
        if (!damageSource.func_76363_c()) {
            this.func_230294_b_(damageSource, f);
            f = CombatRules.func_189427_a(f, this.func_70658_aO(), (float)this.func_233637_b_(Attributes.field_233827_j_));
        }
        return f;
    }

    protected float func_70672_c(DamageSource damageSource, float f2) {
        float f2;
        if (damageSource.func_151517_h()) {
            return f2;
        }
        if (this.func_70644_a(Effects.field_76429_m) && damageSource != DamageSource.field_76380_i && (\u2603 = (\u2603 = f2) - (f2 = Math.max((\u2603 = f2 * (float)(\u2603 = 25 - (n = (this.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && \u2603 < 3.4028235E37f) {
            if (this instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)this).func_195067_a(Stats.field_212739_K, Math.round(\u2603 * 10.0f));
            } else if (damageSource.func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)damageSource.func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(\u2603 * 10.0f));
            }
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        int n = EnchantmentHelper.func_77508_a(this.func_184193_aE(), damageSource);
        if (n > 0) {
            f2 = CombatRules.func_188401_b(f2, n);
        }
        return f2;
    }

    protected void func_70665_d(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return;
        }
        f = this.func_70655_b(damageSource, f);
        \u2603 = f = this.func_70672_c(damageSource, f);
        f = Math.max(f - this.func_110139_bj(), 0.0f);
        this.func_110149_m(this.func_110139_bj() - (\u2603 - f));
        \u2603 = \u2603 - f;
        if (\u2603 > 0.0f && \u2603 < 3.4028235E37f && damageSource.func_76346_g() instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)damageSource.func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(\u2603 * 10.0f));
        }
        if (f == 0.0f) {
            return;
        }
        \u2603 = this.func_110143_aJ();
        this.func_70606_j(\u2603 - f);
        this.func_110142_aN().func_94547_a(damageSource, \u2603, f);
        this.func_110149_m(this.func_110139_bj() - f);
    }

    public CombatTracker func_110142_aN() {
        return this.field_94063_bt;
    }

    @Nullable
    public LivingEntity func_94060_bK() {
        if (this.field_94063_bt.func_94550_c() != null) {
            return this.field_94063_bt.func_94550_c();
        }
        if (this.field_70717_bb != null) {
            return this.field_70717_bb;
        }
        if (this.field_70755_b != null) {
            return this.field_70755_b;
        }
        return null;
    }

    public final float func_110138_aP() {
        return (float)this.func_233637_b_(Attributes.field_233818_a_);
    }

    public final int func_85035_bI() {
        return this.field_70180_af.func_187225_a(field_184635_h);
    }

    public final void func_85034_r(int n) {
        this.field_70180_af.func_187227_b(field_184635_h, n);
    }

    public final int func_226297_df_() {
        return this.field_70180_af.func_187225_a(field_226291_bp_);
    }

    public final void func_226300_q_(int n) {
        this.field_70180_af.func_187227_b(field_226291_bp_, n);
    }

    private int func_82166_i() {
        if (EffectUtils.func_205135_a(this)) {
            return 6 - (1 + EffectUtils.func_205134_b(this));
        }
        if (this.func_70644_a(Effects.field_76419_f)) {
            return 6 + (1 + this.func_70660_b(Effects.field_76419_f).func_76458_c()) * 2;
        }
        return 6;
    }

    public void func_184609_a(Hand hand) {
        this.func_226292_a_(hand, false);
    }

    public void func_226292_a_(Hand hand, boolean bl) {
        if (!this.field_82175_bq || this.field_110158_av >= this.func_82166_i() / 2 || this.field_110158_av < 0) {
            this.field_110158_av = -1;
            this.field_82175_bq = true;
            this.field_184622_au = hand;
            if (this.field_70170_p instanceof ServerWorld) {
                SAnimateHandPacket sAnimateHandPacket = new SAnimateHandPacket(this, hand == Hand.MAIN_HAND ? 0 : 3);
                ServerChunkProvider \u26032 = ((ServerWorld)this.field_70170_p).func_72863_F();
                if (bl) {
                    \u26032.func_217216_a(this, sAnimateHandPacket);
                } else {
                    \u26032.func_217218_b(this, sAnimateHandPacket);
                }
            }
        }
    }

    @Override
    protected void func_70076_C() {
        this.func_70097_a(DamageSource.field_76380_i, 4.0f);
    }

    protected void func_82168_bl() {
        int n = this.func_82166_i();
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= n) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)n;
    }

    @Nullable
    public ModifiableAttributeInstance func_110148_a(Attribute attribute) {
        return this.func_233645_dx_().func_233779_a_(attribute);
    }

    public double func_233637_b_(Attribute attribute) {
        return this.func_233645_dx_().func_233795_c_(attribute);
    }

    public double func_233638_c_(Attribute attribute) {
        return this.func_233645_dx_().func_233797_d_(attribute);
    }

    public AttributeModifierManager func_233645_dx_() {
        return this.field_110155_d;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public ItemStack func_184614_ca() {
        return this.func_184582_a(EquipmentSlotType.MAINHAND);
    }

    public ItemStack func_184592_cb() {
        return this.func_184582_a(EquipmentSlotType.OFFHAND);
    }

    public boolean func_233631_a_(Item item) {
        return this.func_233634_a_(item2 -> item2 == item);
    }

    public boolean func_233634_a_(Predicate<Item> predicate) {
        return predicate.test(this.func_184614_ca().func_77973_b()) || predicate.test(this.func_184592_cb().func_77973_b());
    }

    public ItemStack func_184586_b(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return this.func_184582_a(EquipmentSlotType.MAINHAND);
        }
        if (hand == Hand.OFF_HAND) {
            return this.func_184582_a(EquipmentSlotType.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + (Object)((Object)hand));
    }

    public void func_184611_a(Hand hand, ItemStack itemStack) {
        if (hand == Hand.MAIN_HAND) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
        } else if (hand == Hand.OFF_HAND) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, itemStack);
        } else {
            throw new IllegalArgumentException("Invalid hand " + (Object)((Object)hand));
        }
    }

    public boolean func_190630_a(EquipmentSlotType equipmentSlotType) {
        return !this.func_184582_a(equipmentSlotType).func_190926_b();
    }

    @Override
    public abstract Iterable<ItemStack> func_184193_aE();

    public abstract ItemStack func_184582_a(EquipmentSlotType var1);

    @Override
    public abstract void func_184201_a(EquipmentSlotType var1, ItemStack var2);

    public float func_213343_cS() {
        Iterable<ItemStack> iterable = this.func_184193_aE();
        int \u26032 = 0;
        int \u26033 = 0;
        for (ItemStack itemStack : iterable) {
            if (!itemStack.func_190926_b()) {
                ++\u26033;
            }
            ++\u26032;
        }
        return \u26032 > 0 ? (float)\u26033 / (float)\u26032 : 0.0f;
    }

    @Override
    public void func_70031_b(boolean bl) {
        super.func_70031_b(bl);
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233821_d_);
        if (modifiableAttributeInstance.func_111127_a(field_110156_b) != null) {
            modifiableAttributeInstance.func_111124_b(field_110157_c);
        }
        if (bl) {
            modifiableAttributeInstance.func_233767_b_(field_110157_c);
        }
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_70647_i() {
        if (this.func_70631_g_()) {
            return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean func_70610_aX() {
        return this.func_233643_dh_();
    }

    @Override
    public void func_70108_f(Entity entity) {
        if (!this.func_70608_bn()) {
            super.func_70108_f(entity);
        }
    }

    private void func_233628_a_(Entity entity) {
        Vector3d vector3d = entity.field_70128_L || this.field_70170_p.func_180495_p(entity.func_233580_cy_()).func_177230_c().func_203417_a(BlockTags.field_226154_ad_) ? new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_213302_cg(), entity.func_226281_cx_()) : entity.func_230268_c_(this);
        this.func_70634_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    protected float func_175134_bD() {
        return 0.42f * this.func_226269_ah_();
    }

    protected void func_70664_aZ() {
        float f = this.func_175134_bD();
        if (this.func_70644_a(Effects.field_76430_j)) {
            f += 0.1f * (float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1);
        }
        Vector3d \u26032 = this.func_213322_ci();
        this.func_213293_j(\u26032.field_72450_a, f, \u26032.field_72449_c);
        if (this.func_70051_ag()) {
            \u2603 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c(-MathHelper.func_76126_a(\u2603) * 0.2f, 0.0, MathHelper.func_76134_b(\u2603) * 0.2f));
        }
        this.field_70160_al = true;
    }

    protected void func_180466_bG(ITag<Fluid> iTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.04f, 0.0));
    }

    protected float func_189749_co() {
        return 0.8f;
    }

    public boolean func_230285_a_(Fluid fluid) {
        return false;
    }

    public void func_213352_e(Vector3d vector3d) {
        if (this.func_70613_aW() || this.func_184186_bw()) {
            double d = 0.08;
            boolean bl = \u2603 = this.func_213322_ci().field_72448_b <= 0.0;
            if (\u2603 && this.func_70644_a(Effects.field_204839_B)) {
                d = 0.01;
                this.field_70143_R = 0.0f;
            }
            FluidState \u26032 = this.field_70170_p.func_204610_c(this.func_233580_cy_());
            if (this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(\u26032.func_206886_c())) {
                \u2603 = this.func_226278_cu_();
                float f = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                \u2603 = 0.02f;
                \u2603 = EnchantmentHelper.func_185294_d(this);
                if (\u2603 > 3.0f) {
                    \u2603 = 3.0f;
                }
                if (!this.field_70122_E) {
                    \u2603 *= 0.5f;
                }
                if (\u2603 > 0.0f) {
                    f += (0.54600006f - f) * \u2603 / 3.0f;
                    \u2603 += (this.func_70689_ay() - \u2603) * \u2603 / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    f = 0.96f;
                }
                this.func_213309_a(\u2603, vector3d);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vector3d \u26033 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    \u26033 = new Vector3d(\u26033.field_72450_a, 0.2, \u26033.field_72449_c);
                }
                this.func_213317_d(\u26033.func_216372_d(f, 0.8f, f));
                Vector3d \u26034 = this.func_233626_a_(d, \u2603, this.func_213322_ci());
                this.func_213317_d(\u26034);
                if (this.field_70123_F && this.func_70038_c(\u26034.field_72450_a, \u26034.field_72448_b + (double)0.6f - this.func_226278_cu_() + \u2603, \u26034.field_72449_c)) {
                    this.func_213293_j(\u26034.field_72450_a, 0.3f, \u26034.field_72449_c);
                }
            } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(\u26032.func_206886_c())) {
                Vector3d vector3d2;
                double \u26035 = this.func_226278_cu_();
                this.func_213309_a(0.02f, vector3d);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.func_233571_b_(FluidTags.field_206960_b) <= this.func_233579_cu_()) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.8f, 0.5));
                    vector3d2 = this.func_233626_a_(d, \u2603, this.func_213322_ci());
                    this.func_213317_d(vector3d2);
                } else {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                }
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d / 4.0, 0.0));
                }
                vector3d2 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - this.func_226278_cu_() + \u26035, vector3d2.field_72449_c)) {
                    this.func_213293_j(vector3d2.field_72450_a, 0.3f, vector3d2.field_72449_c);
                }
            } else if (this.func_184613_cA()) {
                float f;
                double d2;
                Vector3d \u260311 = this.func_213322_ci();
                if (\u260311.field_72448_b > -0.5) {
                    this.field_70143_R = 1.0f;
                }
                vector3d3 = this.func_70040_Z();
                float \u26036 = this.field_70125_A * ((float)Math.PI / 180);
                double \u26037 = Math.sqrt(vector3d3.field_72450_a * vector3d3.field_72450_a + vector3d3.field_72449_c * vector3d3.field_72449_c);
                double \u26038 = Math.sqrt(LivingEntity.func_213296_b(\u260311));
                double \u26039 = vector3d3.func_72433_c();
                float \u260310 = MathHelper.func_76134_b(\u26036);
                \u260310 = (float)((double)\u260310 * ((double)\u260310 * Math.min(1.0, \u26039 / 0.4)));
                \u260311 = this.func_213322_ci().func_72441_c(0.0, d * (-1.0 + (double)\u260310 * 0.75), 0.0);
                if (\u260311.field_72448_b < 0.0 && \u26037 > 0.0) {
                    d2 = \u260311.field_72448_b * -0.1 * (double)\u260310;
                    \u260311 = \u260311.func_72441_c(vector3d3.field_72450_a * d2 / \u26037, d2, vector3d3.field_72449_c * d2 / \u26037);
                }
                if (\u26036 < 0.0f && \u26037 > 0.0) {
                    d2 = \u26038 * (double)(-MathHelper.func_76126_a(\u26036)) * 0.04;
                    \u260311 = \u260311.func_72441_c(-vector3d3.field_72450_a * d2 / \u26037, d2 * 3.2, -vector3d3.field_72449_c * d2 / \u26037);
                }
                if (\u26037 > 0.0) {
                    Vector3d vector3d3;
                    \u260311 = \u260311.func_72441_c((vector3d3.field_72450_a / \u26037 * \u26038 - \u260311.field_72450_a) * 0.1, 0.0, (vector3d3.field_72449_c / \u26037 * \u26038 - \u260311.field_72449_c) * 0.1);
                }
                this.func_213317_d(\u260311.func_216372_d(0.99f, 0.98f, 0.99f));
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f = (float)((\u2603 = \u26038 - (d2 = Math.sqrt(LivingEntity.func_213296_b(this.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                    this.func_184185_a(this.func_184588_d((int)f), 1.0f, 1.0f);
                    this.func_70097_a(DamageSource.field_188406_j, f);
                }
                if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                    this.func_70052_a(7, false);
                }
            } else {
                BlockPos blockPos = this.func_226270_aj_();
                float \u260312 = this.field_70170_p.func_180495_p(blockPos).func_177230_c().func_208618_m();
                float \u260313 = this.field_70122_E ? \u260312 * 0.91f : 0.91f;
                Vector3d \u260314 = this.func_233633_a_(vector3d, \u260312);
                double \u260315 = \u260314.field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    \u260315 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - \u260314.field_72448_b) * 0.2;
                    this.field_70143_R = 0.0f;
                } else if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e(blockPos)) {
                    if (!this.func_189652_ae()) {
                        \u260315 -= d;
                    }
                } else {
                    \u260315 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                }
                this.func_213293_j(\u260314.field_72450_a * (double)\u260313, \u260315 * (double)0.98f, \u260314.field_72449_c * (double)\u260313);
            }
        }
        this.func_233629_a_(this, this instanceof IFlyingAnimal);
    }

    public void func_233629_a_(LivingEntity livingEntity, boolean bl) {
        livingEntity.field_184618_aE = livingEntity.field_70721_aZ;
        double d = livingEntity.func_226277_ct_() - livingEntity.field_70169_q;
        float \u26032 = MathHelper.func_76133_a(d * d + (\u2603 = bl ? livingEntity.func_226278_cu_() - livingEntity.field_70167_r : 0.0) * \u2603 + (\u2603 = livingEntity.func_226281_cx_() - livingEntity.field_70166_s) * \u2603) * 4.0f;
        if (\u26032 > 1.0f) {
            \u26032 = 1.0f;
        }
        livingEntity.field_70721_aZ += (\u26032 - livingEntity.field_70721_aZ) * 0.4f;
        livingEntity.field_184619_aG += livingEntity.field_70721_aZ;
    }

    public Vector3d func_233633_a_(Vector3d vector3d, float f) {
        this.func_213309_a(this.func_213335_r(f), vector3d);
        this.func_213317_d(this.func_213362_f(this.func_213322_ci()));
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Vector3d vector3d2 = this.func_213322_ci();
        if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
            vector3d2 = new Vector3d(vector3d2.field_72450_a, 0.2, vector3d2.field_72449_c);
        }
        return vector3d2;
    }

    public Vector3d func_233626_a_(double d, boolean bl, Vector3d vector3d2) {
        Vector3d vector3d2;
        if (!this.func_189652_ae() && !this.func_70051_ag()) {
            double d2 = bl && Math.abs(vector3d2.field_72448_b - 0.005) >= 0.003 && Math.abs(vector3d2.field_72448_b - d / 16.0) < 0.003 ? -0.003 : vector3d2.field_72448_b - d / 16.0;
            return new Vector3d(vector3d2.field_72450_a, d2, vector3d2.field_72449_c);
        }
        return vector3d2;
    }

    private Vector3d func_213362_f(Vector3d \u260352) {
        Vector3d \u260352;
        if (this.func_70617_f_()) {
            this.field_70143_R = 0.0f;
            float f = 0.15f;
            double \u26032 = MathHelper.func_151237_a(\u260352.field_72450_a, -0.15f, 0.15f);
            double \u26033 = MathHelper.func_151237_a(\u260352.field_72449_c, -0.15f, 0.15f);
            double \u26034 = Math.max(\u260352.field_72448_b, (double)-0.15f);
            if (\u26034 < 0.0 && !this.func_213339_cH().func_203425_a(Blocks.field_222420_lI) && this.func_230491_ea_() && this instanceof PlayerEntity) {
                \u26034 = 0.0;
            }
            \u260352 = new Vector3d(\u26032, \u26034, \u26033);
        }
        return \u260352;
    }

    private float func_213335_r(float f) {
        if (this.field_70122_E) {
            return this.func_70689_ay() * (0.21600002f / (f * f * f));
        }
        return this.field_70747_aH;
    }

    public float func_70689_ay() {
        return this.field_70746_aG;
    }

    public void func_70659_e(float f) {
        this.field_70746_aG = f;
    }

    public boolean func_70652_k(Entity entity) {
        this.func_130011_c(entity);
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_184608_ct();
        this.func_205014_p();
        if (!this.field_70170_p.field_72995_K) {
            int n = this.func_85035_bI();
            if (n > 0) {
                if (this.field_70720_be <= 0) {
                    this.field_70720_be = 20 * (30 - n);
                }
                --this.field_70720_be;
                if (this.field_70720_be <= 0) {
                    this.func_85034_r(n - 1);
                }
            }
            if ((\u2603 = this.func_226297_df_()) > 0) {
                if (this.field_226290_au_ <= 0) {
                    this.field_226290_au_ = 20 * (30 - \u2603);
                }
                --this.field_226290_au_;
                if (this.field_226290_au_ <= 0) {
                    this.func_226300_q_(\u2603 - 1);
                }
            }
            this.func_241353_q_();
            if (this.field_70173_aa % 20 == 0) {
                this.func_110142_aN().func_94549_h();
            }
            if (!this.field_184238_ar) {
                boolean bl = this.func_70644_a(Effects.field_188423_x);
                if (this.func_70083_f(6) != bl) {
                    this.func_70052_a(6, bl);
                }
            }
            if (this.func_70608_bn() && !this.func_213359_p()) {
                this.func_213366_dy();
            }
        }
        this.func_70636_d();
        double d = this.func_226277_ct_() - this.field_70169_q;
        \u2603 = this.func_226281_cx_() - this.field_70166_s;
        float \u26032 = (float)(d * d + \u2603 * \u2603);
        float \u26033 = this.field_70761_aq;
        float \u26034 = 0.0f;
        this.field_70768_au = this.field_110154_aX;
        float \u26035 = 0.0f;
        if (\u26032 > 0.0025000002f) {
            \u26035 = 1.0f;
            \u26034 = (float)Math.sqrt(\u26032) * 3.0f;
            float f = (float)MathHelper.func_181159_b(\u2603, d) * 57.295776f - 90.0f;
            \u2603 = MathHelper.func_76135_e(MathHelper.func_76142_g(this.field_70177_z) - f);
            \u26033 = 95.0f < \u2603 && \u2603 < 265.0f ? f - 180.0f : f;
        }
        if (this.field_70733_aJ > 0.0f) {
            \u26033 = this.field_70177_z;
        }
        if (!this.field_70122_E) {
            \u26035 = 0.0f;
        }
        this.field_110154_aX += (\u26035 - this.field_110154_aX) * 0.3f;
        this.field_70170_p.func_217381_Z().func_76320_a("headTurn");
        \u26034 = this.func_110146_f(\u26033, \u26034);
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("rangeChecks");
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar < -180.0f) {
            this.field_70760_ar -= 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar >= 180.0f) {
            this.field_70760_ar += 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at < -180.0f) {
            this.field_70758_at -= 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at >= 180.0f) {
            this.field_70758_at += 360.0f;
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70764_aw += \u26034;
        this.field_184629_bo = this.func_184613_cA() ? ++this.field_184629_bo : 0;
        if (this.func_70608_bn()) {
            this.field_70125_A = 0.0f;
        }
    }

    private void func_241353_q_() {
        Map<EquipmentSlotType, ItemStack> map = this.func_241354_r_();
        if (map != null) {
            this.func_241342_a_(map);
            if (!map.isEmpty()) {
                this.func_241344_b_(map);
            }
        }
    }

    @Nullable
    private Map<EquipmentSlotType, ItemStack> func_241354_r_() {
        EnumMap enumMap = null;
        block4: for (EquipmentSlotType equipmentSlotType2 : EquipmentSlotType.values()) {
            ItemStack \u26032;
            switch (equipmentSlotType2.func_188453_a()) {
                case HAND: {
                    \u26032 = this.func_241347_e_(equipmentSlotType2);
                    break;
                }
                case ARMOR: {
                    EquipmentSlotType equipmentSlotType2;
                    \u26032 = this.func_241346_d_(equipmentSlotType2);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemStack = this.func_184582_a(equipmentSlotType2);
            if (ItemStack.func_77989_b(itemStack, \u26032)) continue;
            if (enumMap == null) {
                enumMap = Maps.newEnumMap(EquipmentSlotType.class);
            }
            enumMap.put(equipmentSlotType2, itemStack);
            if (!\u26032.func_190926_b()) {
                this.func_233645_dx_().func_233785_a_(\u26032.func_111283_C(equipmentSlotType2));
            }
            if (itemStack.func_190926_b()) continue;
            this.func_233645_dx_().func_233793_b_(itemStack.func_111283_C(equipmentSlotType2));
        }
        return enumMap;
    }

    private void func_241342_a_(Map<EquipmentSlotType, ItemStack> map) {
        ItemStack itemStack = map.get((Object)EquipmentSlotType.MAINHAND);
        \u2603 = map.get((Object)EquipmentSlotType.OFFHAND);
        if (itemStack != null && \u2603 != null && ItemStack.func_77989_b(itemStack, this.func_241347_e_(EquipmentSlotType.OFFHAND)) && ItemStack.func_77989_b(\u2603, this.func_241347_e_(EquipmentSlotType.MAINHAND))) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(this, new SEntityStatusPacket(this, 55));
            map.remove((Object)EquipmentSlotType.MAINHAND);
            map.remove((Object)EquipmentSlotType.OFFHAND);
            this.func_241345_c_(EquipmentSlotType.MAINHAND, itemStack.func_77946_l());
            this.func_241345_c_(EquipmentSlotType.OFFHAND, \u2603.func_77946_l());
        }
    }

    private void func_241344_b_(Map<EquipmentSlotType, ItemStack> map) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((equipmentSlotType, itemStack) -> {
            \u2603 = itemStack.func_77946_l();
            arrayList.add(Pair.of((Object)equipmentSlotType, (Object)\u2603));
            switch (equipmentSlotType.func_188453_a()) {
                case HAND: {
                    this.func_241345_c_((EquipmentSlotType)((Object)equipmentSlotType), \u2603);
                    break;
                }
                case ARMOR: {
                    this.func_241343_b_((EquipmentSlotType)((Object)equipmentSlotType), \u2603);
                }
            }
        });
        ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(this, new SEntityEquipmentPacket(this.func_145782_y(), arrayList));
    }

    private ItemStack func_241346_d_(EquipmentSlotType equipmentSlotType) {
        return this.field_184631_bt.get(equipmentSlotType.func_188454_b());
    }

    private void func_241343_b_(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        this.field_184631_bt.set(equipmentSlotType.func_188454_b(), itemStack);
    }

    private ItemStack func_241347_e_(EquipmentSlotType equipmentSlotType) {
        return this.field_184630_bs.get(equipmentSlotType.func_188454_b());
    }

    private void func_241345_c_(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        this.field_184630_bs.set(equipmentSlotType.func_188454_b(), itemStack);
    }

    protected float func_110146_f(float f, float f2) {
        \u2603 = MathHelper.func_76142_g(f - this.field_70761_aq);
        this.field_70761_aq += \u2603 * 0.3f;
        \u2603 = MathHelper.func_76142_g(this.field_70177_z - this.field_70761_aq);
        boolean bl = \u2603 = \u2603 < -90.0f || \u2603 >= 90.0f;
        if (\u2603 < -75.0f) {
            \u2603 = -75.0f;
        }
        if (\u2603 >= 75.0f) {
            \u2603 = 75.0f;
        }
        this.field_70761_aq = this.field_70177_z - \u2603;
        if (\u2603 * \u2603 > 2500.0f) {
            this.field_70761_aq += \u2603 * 0.2f;
        }
        if (\u2603) {
            f2 *= -1.0f;
        }
        return f2;
    }

    public void func_70636_d() {
        if (this.field_70773_bE > 0) {
            --this.field_70773_bE;
        }
        if (this.func_184186_bw()) {
            this.field_70716_bi = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.field_70716_bi > 0) {
            double d = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
            \u2603 = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
            \u2603 = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
            \u2603 = MathHelper.func_76138_g(this.field_184626_bk - (double)this.field_70177_z);
            this.field_70177_z = (float)((double)this.field_70177_z + \u2603 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d, \u2603, \u2603);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
        if (this.field_208002_br > 0) {
            this.field_70759_as = (float)((double)this.field_70759_as + MathHelper.func_76138_g(this.field_208001_bq - (double)this.field_70759_as) / (double)this.field_208002_br);
            --this.field_208002_br;
        }
        Vector3d vector3d = this.func_213322_ci();
        double \u26032 = vector3d.field_72450_a;
        double \u26033 = vector3d.field_72448_b;
        double \u26034 = vector3d.field_72449_c;
        if (Math.abs(vector3d.field_72450_a) < 0.003) {
            \u26032 = 0.0;
        }
        if (Math.abs(vector3d.field_72448_b) < 0.003) {
            \u26033 = 0.0;
        }
        if (Math.abs(vector3d.field_72449_c) < 0.003) {
            \u26034 = 0.0;
        }
        this.func_213293_j(\u26032, \u26033, \u26034);
        this.field_70170_p.func_217381_Z().func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        } else if (this.func_70613_aW()) {
            this.field_70170_p.func_217381_Z().func_76320_a("newAi");
            this.func_70626_be();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("jump");
        if (this.field_70703_bu && this.func_241208_cS_()) {
            double d = this.func_180799_ab() ? this.func_233571_b_(FluidTags.field_206960_b) : this.func_233571_b_(FluidTags.field_206959_a);
            boolean \u26035 = this.func_70090_H() && d > 0.0;
            \u2603 = this.func_233579_cu_();
            if (\u26035 && (!this.field_70122_E || d > \u2603)) {
                this.func_180466_bG(FluidTags.field_206959_a);
            } else if (this.func_180799_ab() && (!this.field_70122_E || d > \u2603)) {
                this.func_180466_bG(FluidTags.field_206960_b);
            } else if ((this.field_70122_E || \u26035 && d <= \u2603) && this.field_70773_bE == 0) {
                this.func_70664_aZ();
                this.field_70773_bE = 10;
            }
        } else {
            this.field_70773_bE = 0;
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_191988_bg *= 0.98f;
        this.func_184616_r();
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        this.func_213352_e(new Vector3d(this.field_70702_br, this.field_70701_bs, this.field_191988_bg));
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("push");
        if (this.field_204807_bs > 0) {
            --this.field_204807_bs;
            this.func_204801_a(axisAlignedBB, this.func_174813_aQ());
        }
        this.func_85033_bc();
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.field_70170_p.field_72995_K && this.func_230270_dK_() && this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public boolean func_230270_dK_() {
        return false;
    }

    private void func_184616_r() {
        boolean bl = this.func_70083_f(7);
        if (bl && !this.field_70122_E && !this.func_184218_aH() && !this.func_70644_a(Effects.field_188424_y)) {
            ItemStack itemStack = this.func_184582_a(EquipmentSlotType.CHEST);
            if (itemStack.func_77973_b() == Items.field_185160_cR && ElytraItem.func_185069_d(itemStack)) {
                bl = true;
                if (!this.field_70170_p.field_72995_K && (this.field_184629_bo + 1) % 20 == 0) {
                    itemStack.func_222118_a(1, this, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.CHEST));
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(7, bl);
        }
    }

    protected void func_70626_be() {
    }

    protected void func_85033_bc() {
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), EntityPredicates.func_200823_a(this));
        if (!list.isEmpty()) {
            int n = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (n > 0 && list.size() > n - 1 && this.field_70146_Z.nextInt(4) == 0) {
                \u2603 = 0;
                for (\u2603 = 0; \u2603 < list.size(); ++\u2603) {
                    if (list.get(\u2603).func_184218_aH()) continue;
                    ++\u2603;
                }
                if (\u2603 > n - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (\u2603 = 0; \u2603 < list.size(); ++\u2603) {
                Entity entity = list.get(\u2603);
                this.func_82167_n(entity);
            }
        }
    }

    protected void func_204801_a(AxisAlignedBB axisAlignedBB, AxisAlignedBB axisAlignedBB2) {
        \u2603 = axisAlignedBB.func_111270_a(axisAlignedBB2);
        List<Entity> list = this.field_70170_p.func_72839_b(this, \u2603);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (!(entity instanceof LivingEntity)) continue;
                this.func_204804_d((LivingEntity)entity);
                this.field_204807_bs = 0;
                this.func_213317_d(this.func_213322_ci().func_186678_a(-0.2));
                break;
            }
        } else if (this.field_70123_F) {
            this.field_204807_bs = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.field_204807_bs <= 0) {
            this.func_204802_c(4, false);
        }
    }

    protected void func_82167_n(Entity entity) {
        entity.func_70108_f(this);
    }

    protected void func_204804_d(LivingEntity livingEntity) {
    }

    public void func_204803_n(int n) {
        this.field_204807_bs = n;
        if (!this.field_70170_p.field_72995_K) {
            this.func_204802_c(4, true);
        }
    }

    public boolean func_204805_cN() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 4) != 0;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        if (entity != null && entity != this.func_184187_bx() && !this.field_70170_p.field_72995_K) {
            this.func_233628_a_(entity);
        }
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        this.field_70768_au = this.field_110154_aX;
        this.field_110154_aX = 0.0f;
        this.field_70143_R = 0.0f;
    }

    public void func_70637_d(boolean bl) {
        this.field_70703_bu = bl;
    }

    public void func_233630_a_(ItemEntity itemEntity) {
        PlayerEntity playerEntity = \u2603 = itemEntity.func_200214_m() != null ? this.field_70170_p.func_217371_b(itemEntity.func_200214_m()) : null;
        if (\u2603 instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_232609_O_.func_234830_a_((ServerPlayerEntity)\u2603, itemEntity.func_92059_d(), this);
        }
    }

    public void func_71001_a(Entity entity, int n) {
        if (!entity.field_70128_L && !this.field_70170_p.field_72995_K && (entity instanceof ItemEntity || entity instanceof AbstractArrowEntity || entity instanceof ExperienceOrbEntity)) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(entity, new SCollectItemPacket(entity.func_145782_y(), this.func_145782_y(), n));
        }
    }

    public boolean func_70685_l(Entity entity) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, \u2603 = new Vector3d(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    @Override
    public float func_195046_g(float f) {
        if (f == 1.0f) {
            return this.field_70759_as;
        }
        return MathHelper.func_219799_g(f, this.field_70758_at, this.field_70759_as);
    }

    public boolean func_70613_aW() {
        return !this.field_70170_p.field_72995_K;
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public boolean func_70104_M() {
        return this.func_70089_S() && !this.func_70617_f_();
    }

    @Override
    protected void func_70018_K() {
        this.field_70133_I = this.field_70146_Z.nextDouble() >= this.func_233637_b_(Attributes.field_233820_c_);
    }

    @Override
    public float func_70079_am() {
        return this.field_70759_as;
    }

    @Override
    public void func_70034_d(float f) {
        this.field_70759_as = f;
    }

    @Override
    public void func_181013_g(float f) {
        this.field_70761_aq = f;
    }

    public float func_110139_bj() {
        return this.field_110151_bq;
    }

    public void func_110149_m(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.field_110151_bq = f;
    }

    public void func_152111_bt() {
    }

    public void func_152112_bu() {
    }

    protected void func_175136_bO() {
        this.field_70752_e = true;
    }

    public abstract HandSide func_184591_cq();

    public boolean func_184587_cr() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 1) > 0;
    }

    public Hand func_184600_cs() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 2) > 0 ? Hand.OFF_HAND : Hand.MAIN_HAND;
    }

    private void func_184608_ct() {
        if (this.func_184587_cr()) {
            if (ItemStack.func_185132_d(this.func_184586_b(this.func_184600_cs()), this.field_184627_bm)) {
                this.field_184627_bm = this.func_184586_b(this.func_184600_cs());
                this.field_184627_bm.func_222121_b(this.field_70170_p, this, this.func_184605_cv());
                if (this.func_226299_p_()) {
                    this.func_226293_b_(this.field_184627_bm, 5);
                }
                if (--this.field_184628_bn == 0 && !this.field_70170_p.field_72995_K && !this.field_184627_bm.func_222122_m()) {
                    this.func_71036_o();
                }
            } else {
                this.func_184602_cy();
            }
        }
    }

    private boolean func_226299_p_() {
        int n = this.func_184605_cv();
        Food \u26032 = this.field_184627_bm.func_77973_b().func_219967_s();
        boolean \u26033 = \u26032 != null && \u26032.func_221465_e();
        return (\u26033 |= n <= this.field_184627_bm.func_77988_m() - 7) && n % 4 == 0;
    }

    private void func_205014_p() {
        this.field_205018_bM = this.field_205017_bL;
        this.field_205017_bL = this.func_213314_bj() ? Math.min(1.0f, this.field_205017_bL + 0.09f) : Math.max(0.0f, this.field_205017_bL - 0.09f);
    }

    protected void func_204802_c(int n, boolean bl) {
        int n2 = this.field_70180_af.func_187225_a(field_184621_as).byteValue();
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.field_70180_af.func_187227_b(field_184621_as, (byte)n2);
    }

    public void func_184598_c(Hand hand) {
        ItemStack itemStack = this.func_184586_b(hand);
        if (itemStack.func_190926_b() || this.func_184587_cr()) {
            return;
        }
        this.field_184627_bm = itemStack;
        this.field_184628_bn = itemStack.func_77988_m();
        if (!this.field_70170_p.field_72995_K) {
            this.func_204802_c(1, true);
            this.func_204802_c(2, hand == Hand.OFF_HAND);
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        super.func_184206_a(dataParameter);
        if (field_213379_bs.equals(dataParameter)) {
            if (this.field_70170_p.field_72995_K) {
                this.func_213374_dv().ifPresent(this::func_213370_a);
            }
        } else if (field_184621_as.equals(dataParameter) && this.field_70170_p.field_72995_K) {
            if (this.func_184587_cr() && this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = this.func_184586_b(this.func_184600_cs());
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = this.field_184627_bm.func_77988_m();
                }
            } else if (!this.func_184587_cr() && !this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = ItemStack.field_190927_a;
                this.field_184628_bn = 0;
            }
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type type, Vector3d vector3d) {
        super.func_200602_a(type, vector3d);
        this.field_70758_at = this.field_70759_as;
        this.field_70760_ar = this.field_70761_aq = this.field_70759_as;
    }

    protected void func_226293_b_(ItemStack itemStack, int n) {
        if (itemStack.func_190926_b() || !this.func_184587_cr()) {
            return;
        }
        if (itemStack.func_77975_n() == UseAction.DRINK) {
            this.func_184185_a(this.func_213351_c(itemStack), 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (itemStack.func_77975_n() == UseAction.EAT) {
            this.func_195062_a(itemStack, n);
            this.func_184185_a(this.func_213353_d(itemStack), 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void func_195062_a(ItemStack itemStack, int n) {
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vector3d = vector3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vector3d = vector3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            double \u26032 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
            \u2603 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, \u26032, 0.6);
            \u2603 = \u2603.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            \u2603 = \u2603.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            \u2603 = \u2603.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
            this.field_70170_p.func_195594_a(new ItemParticleData(ParticleTypes.field_197591_B, itemStack), \u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
        }
    }

    protected void func_71036_o() {
        if (!this.field_184627_bm.equals(this.func_184586_b(this.func_184600_cs()))) {
            this.func_184597_cx();
            return;
        }
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.func_226293_b_(this.field_184627_bm, 16);
            this.func_184611_a(this.func_184600_cs(), this.field_184627_bm.func_77950_b(this.field_70170_p, this));
            this.func_184602_cy();
        }
    }

    public ItemStack func_184607_cu() {
        return this.field_184627_bm;
    }

    public int func_184605_cv() {
        return this.field_184628_bn;
    }

    public int func_184612_cw() {
        if (this.func_184587_cr()) {
            return this.field_184627_bm.func_77988_m() - this.func_184605_cv();
        }
        return 0;
    }

    public void func_184597_cx() {
        if (!this.field_184627_bm.func_190926_b()) {
            this.field_184627_bm.func_77974_b(this.field_70170_p, this, this.func_184605_cv());
            if (this.field_184627_bm.func_222122_m()) {
                this.func_184608_ct();
            }
        }
        this.func_184602_cy();
    }

    public void func_184602_cy() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_204802_c(1, false);
        }
        this.field_184627_bm = ItemStack.field_190927_a;
        this.field_184628_bn = 0;
    }

    public boolean func_184585_cz() {
        if (!this.func_184587_cr() || this.field_184627_bm.func_190926_b()) {
            return false;
        }
        Item item = this.field_184627_bm.func_77973_b();
        if (item.func_77661_b(this.field_184627_bm) != UseAction.BLOCK) {
            return false;
        }
        return item.func_77626_a(this.field_184627_bm) - this.field_184628_bn >= 5;
    }

    public boolean func_230491_ea_() {
        return this.func_225608_bj_();
    }

    public boolean func_184613_cA() {
        return this.func_70083_f(7);
    }

    @Override
    public boolean func_213314_bj() {
        return super.func_213314_bj() || !this.func_184613_cA() && this.func_213283_Z() == Pose.FALL_FLYING;
    }

    public boolean func_213373_a(double d, double d2, double d3, boolean bl2) {
        boolean bl2;
        double d4 = this.func_226277_ct_();
        \u2603 = this.func_226278_cu_();
        \u2603 = this.func_226281_cx_();
        \u2603 = d2;
        boolean \u26032 = false;
        World \u26033 = this.field_70170_p;
        BlockPos \u26034 = new BlockPos(d, \u2603, d3);
        if (\u26033.func_175667_e(\u26034)) {
            boolean bl3 = false;
            while (!bl3 && \u26034.func_177956_o() > 0) {
                BlockPos blockPos = \u26034.func_177977_b();
                BlockState \u26035 = \u26033.func_180495_p(blockPos);
                if (\u26035.func_185904_a().func_76230_c()) {
                    bl3 = true;
                    continue;
                }
                \u2603 -= 1.0;
                \u26034 = blockPos;
            }
            if (bl3) {
                this.func_70634_a(d, \u2603, d3);
                if (\u26033.func_226669_j_(this) && !\u26033.func_72953_d(this.func_174813_aQ())) {
                    \u26032 = true;
                }
            }
        }
        if (!\u26032) {
            this.func_70634_a(d4, \u2603, \u2603);
            return false;
        }
        if (bl2) {
            \u26033.func_72960_a(this, (byte)46);
        }
        if (this instanceof CreatureEntity) {
            ((CreatureEntity)this).func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184603_cC() {
        return true;
    }

    public boolean func_190631_cK() {
        return true;
    }

    public boolean func_213365_e(ItemStack itemStack) {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnMobPacket(this);
    }

    @Override
    public EntitySize func_213305_a(Pose pose) {
        return pose == Pose.SLEEPING ? field_213377_as : super.func_213305_a(pose).func_220313_a(this.func_213355_cm());
    }

    public ImmutableList<Pose> func_230297_ef_() {
        return ImmutableList.of((Object)((Object)Pose.STANDING));
    }

    public AxisAlignedBB func_233648_f_(Pose pose) {
        EntitySize entitySize = this.func_213305_a(pose);
        return new AxisAlignedBB(-entitySize.field_220315_a / 2.0f, 0.0, -entitySize.field_220315_a / 2.0f, entitySize.field_220315_a / 2.0f, entitySize.field_220316_b, entitySize.field_220315_a / 2.0f);
    }

    public Optional<BlockPos> func_213374_dv() {
        return this.field_70180_af.func_187225_a(field_213379_bs);
    }

    public void func_213369_d(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_213379_bs, Optional.of(blockPos));
    }

    public void func_213372_dw() {
        this.field_70180_af.func_187227_b(field_213379_bs, Optional.empty());
    }

    public boolean func_70608_bn() {
        return this.func_213374_dv().isPresent();
    }

    public void func_213342_e(BlockPos blockPos) {
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(blockPos)).func_177230_c() instanceof BedBlock) {
            this.field_70170_p.func_180501_a(blockPos, (BlockState)\u2603.func_206870_a(BedBlock.field_176471_b, true), 3);
        }
        this.func_213301_b(Pose.SLEEPING);
        this.func_213370_a(blockPos);
        this.func_213369_d(blockPos);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70160_al = true;
    }

    private void func_213370_a(BlockPos blockPos) {
        this.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.6875, (double)blockPos.func_177952_p() + 0.5);
    }

    private boolean func_213359_p() {
        return this.func_213374_dv().map(blockPos -> this.field_70170_p.func_180495_p((BlockPos)blockPos).func_177230_c() instanceof BedBlock).orElse(false);
    }

    public void func_213366_dy() {
        this.func_213374_dv().filter(this.field_70170_p::func_175667_e).ifPresent(blockPos -> {
            BlockState blockState = this.field_70170_p.func_180495_p((BlockPos)blockPos);
            if (blockState.func_177230_c() instanceof BedBlock) {
                this.field_70170_p.func_180501_a((BlockPos)blockPos, (BlockState)blockState.func_206870_a(BedBlock.field_176471_b, false), 3);
                Vector3d vector3d = BedBlock.func_220172_a(this.func_200600_R(), this.field_70170_p, blockPos, 0).orElseGet(() -> {
                    \u2603 = blockPos.func_177984_a();
                    return new Vector3d((double)\u2603.func_177958_n() + 0.5, (double)\u2603.func_177956_o() + 0.1, (double)\u2603.func_177952_p() + 0.5);
                });
                this.func_70107_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
        });
        Vector3d vector3d = this.func_213303_ch();
        this.func_213301_b(Pose.STANDING);
        this.func_70107_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
        this.func_213372_dw();
    }

    @Override
    public boolean func_70094_T() {
        return !this.func_70608_bn() && super.func_70094_T();
    }

    @Override
    protected final float func_213316_a(Pose pose, EntitySize entitySize) {
        return pose == Pose.SLEEPING ? 0.2f : this.func_213348_b(pose, entitySize);
    }

    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return super.func_213316_a(pose, entitySize);
    }

    public ItemStack func_213356_f(ItemStack itemStack) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_213357_a(World world, ItemStack itemStack) {
        if (itemStack.func_222117_E()) {
            world.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213353_d(itemStack), SoundCategory.NEUTRAL, 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
            this.func_213349_a(itemStack, world, this);
            if (!(this instanceof PlayerEntity) || !((PlayerEntity)this).field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
        }
        return itemStack;
    }

    private void func_213349_a(ItemStack itemStack, World world, LivingEntity livingEntity) {
        Item item = itemStack.func_77973_b();
        if (item.func_219971_r()) {
            List<Pair<EffectInstance, Float>> list = item.func_219967_s().func_221464_f();
            for (Pair<EffectInstance, Float> pair : list) {
                if (world.field_72995_K || pair.getFirst() == null || !(world.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                livingEntity.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
            }
        }
    }

    private static byte func_213350_d(EquipmentSlotType equipmentSlotType) {
        switch (equipmentSlotType) {
            case MAINHAND: {
                return 47;
            }
            case OFFHAND: {
                return 48;
            }
            case HEAD: {
                return 49;
            }
            case CHEST: {
                return 50;
            }
            case FEET: {
                return 52;
            }
            case LEGS: {
                return 51;
            }
        }
        return 47;
    }

    public void func_213361_c(EquipmentSlotType equipmentSlotType) {
        this.field_70170_p.func_72960_a(this, LivingEntity.func_213350_d(equipmentSlotType));
    }

    public void func_213334_d(Hand hand) {
        this.func_213361_c(hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND);
    }
}

