/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class DrownedEntity
extends ZombieEntity
implements IRangedAttackMob {
    private boolean field_204718_bx;
    protected final SwimmerPathNavigator field_204716_a;
    protected final GroundPathNavigator field_204717_b;

    public DrownedEntity(EntityType<? extends DrownedEntity> entityType, World world) {
        super((EntityType<? extends ZombieEntity>)entityType, world);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_204716_a = new SwimmerPathNavigator(this, world);
        this.field_204717_b = new GroundPathNavigator(this, world);
    }

    @Override
    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(1, new GoToWaterGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, new TridentAttackGoal(this, 1.0, 40, 10.0f));
        this.field_70714_bg.func_75776_a(2, new AttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new GoToBeachGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new SwimUpGoal(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(7, new RandomWalkingGoal(this, 1.0));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, DrownedEntity.class).func_220794_a(ZombifiedPiglinEntity.class));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, this::func_204714_e));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, new NearestAttackableTargetGoal<TurtleEntity>(this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
        if (this.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b() && this.field_70146_Z.nextFloat() < 0.03f) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack(Items.field_205157_eZ));
            this.field_82174_bp[EquipmentSlotType.OFFHAND.func_188454_b()] = 2.0f;
        }
        return iLivingEntityData2;
    }

    public static boolean func_223332_b(EntityType<DrownedEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        Biome biome = iWorld.func_226691_t_(blockPos);
        boolean bl = \u2603 = iWorld.func_175659_aa() != Difficulty.PEACEFUL && DrownedEntity.func_223323_a(iWorld, blockPos, random) && (spawnReason == SpawnReason.SPAWNER || iWorld.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a));
        if (biome == Biomes.field_76781_i || biome == Biomes.field_76777_m) {
            return random.nextInt(15) == 0 && \u2603;
        }
        return random.nextInt(40) == 0 && DrownedEntity.func_223333_a(iWorld, blockPos) && \u2603;
    }

    private static boolean func_223333_a(IWorld iWorld, BlockPos blockPos) {
        return blockPos.func_177956_o() < iWorld.func_181545_F() - 5;
    }

    @Override
    protected boolean func_204900_dz() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_70090_H()) {
            return SoundEvents.field_204775_aZ;
        }
        return SoundEvents.field_204774_aY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.func_70090_H()) {
            return SoundEvents.field_204779_bd;
        }
        return SoundEvents.field_204778_bc;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        if (this.func_70090_H()) {
            return SoundEvents.field_204777_bb;
        }
        return SoundEvents.field_204776_ba;
    }

    @Override
    protected SoundEvent func_190731_di() {
        return SoundEvents.field_204781_bf;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_204782_bg;
    }

    @Override
    protected ItemStack func_190732_dj() {
        return ItemStack.field_190927_a;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if ((double)this.field_70146_Z.nextFloat() > 0.9) {
            int n = this.field_70146_Z.nextInt(16);
            if (n < 10) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_203184_eO));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151112_aM));
            }
        }
    }

    @Override
    protected boolean func_208003_a(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack2.func_77973_b() == Items.field_205157_eZ) {
            return false;
        }
        if (itemStack2.func_77973_b() == Items.field_203184_eO) {
            if (itemStack.func_77973_b() == Items.field_203184_eO) {
                return itemStack.func_77952_i() < itemStack2.func_77952_i();
            }
            return false;
        }
        if (itemStack.func_77973_b() == Items.field_203184_eO) {
            return true;
        }
        return super.func_208003_a(itemStack, itemStack2);
    }

    @Override
    protected boolean func_204703_dA() {
        return false;
    }

    @Override
    public boolean func_205019_a(IWorldReader iWorldReader) {
        return iWorldReader.func_226668_i_(this);
    }

    public boolean func_204714_e(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            return !this.field_70170_p.func_72935_r() || livingEntity.func_70090_H();
        }
        return false;
    }

    @Override
    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    private boolean func_204715_dF() {
        if (this.field_204718_bx) {
            return true;
        }
        LivingEntity livingEntity = this.func_70638_az();
        return livingEntity != null && livingEntity.func_70090_H();
    }

    @Override
    public void func_213352_e(Vector3d vector3d) {
        if (this.func_70613_aW() && this.func_70090_H() && this.func_204715_dF()) {
            this.func_213309_a(0.01f, vector3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vector3d);
        }
    }

    @Override
    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.func_204715_dF()) {
                this.field_70699_by = this.field_204716_a;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.field_204717_b;
                this.func_204711_a(false);
            }
        }
    }

    protected boolean func_204710_dB() {
        Path path = this.func_70661_as().func_75505_d();
        return path != null && (\u2603 = path.func_224770_k()) != null && (\u2603 = this.func_70092_e(\u2603.func_177958_n(), \u2603.func_177956_o(), \u2603.func_177952_p())) < 4.0;
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        TridentEntity tridentEntity = new TridentEntity(this.field_70170_p, (LivingEntity)this, new ItemStack(Items.field_203184_eO));
        double \u26032 = livingEntity.func_226277_ct_() - this.func_226277_ct_();
        double \u26033 = livingEntity.func_226283_e_(0.3333333333333333) - tridentEntity.func_226278_cu_();
        double \u26034 = livingEntity.func_226281_cx_() - this.func_226281_cx_();
        double \u26035 = MathHelper.func_76133_a(\u26032 * \u26032 + \u26034 * \u26034);
        tridentEntity.func_70186_c(\u26032, \u26033 + \u26035 * (double)0.2f, \u26034, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_204780_be, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c(tridentEntity);
    }

    public void func_204713_s(boolean bl) {
        this.field_204718_bx = bl;
    }

    static class MoveHelperController
    extends MovementController {
        private final DrownedEntity field_204725_i;

        public MoveHelperController(DrownedEntity drownedEntity) {
            super(drownedEntity);
            this.field_204725_i = drownedEntity;
        }

        @Override
        public void func_75641_c() {
            LivingEntity livingEntity = this.field_204725_i.func_70638_az();
            if (this.field_204725_i.func_204715_dF() && this.field_204725_i.func_70090_H()) {
                if (livingEntity != null && livingEntity.func_226278_cu_() > this.field_204725_i.func_226278_cu_() || this.field_204725_i.field_204718_bx) {
                    this.field_204725_i.func_213317_d(this.field_204725_i.func_213322_ci().func_72441_c(0.0, 0.002, 0.0));
                }
                if (this.field_188491_h != MovementController.Action.MOVE_TO || this.field_204725_i.func_70661_as().func_75500_f()) {
                    this.field_204725_i.func_70659_e(0.0f);
                    return;
                }
                double d = this.field_75646_b - this.field_204725_i.func_226277_ct_();
                \u2603 = this.field_75647_c - this.field_204725_i.func_226278_cu_();
                \u2603 = this.field_75644_d - this.field_204725_i.func_226281_cx_();
                \u2603 = MathHelper.func_76133_a(d * d + \u2603 * \u2603 + \u2603 * \u2603);
                \u2603 /= \u2603;
                float \u26032 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
                this.field_204725_i.field_70761_aq = this.field_204725_i.field_70177_z = this.func_75639_a(this.field_204725_i.field_70177_z, \u26032, 90.0f);
                float \u26033 = (float)(this.field_75645_e * this.field_204725_i.func_233637_b_(Attributes.field_233821_d_));
                float \u26034 = MathHelper.func_219799_g(0.125f, this.field_204725_i.func_70689_ay(), \u26033);
                this.field_204725_i.func_70659_e(\u26034);
                this.field_204725_i.func_213317_d(this.field_204725_i.func_213322_ci().func_72441_c((double)\u26034 * d * 0.005, (double)\u26034 * \u2603 * 0.1, (double)\u26034 * \u2603 * 0.005));
            } else {
                if (!this.field_204725_i.field_70122_E) {
                    this.field_204725_i.func_213317_d(this.field_204725_i.func_213322_ci().func_72441_c(0.0, -0.008, 0.0));
                }
                super.func_75641_c();
            }
        }
    }

    static class AttackGoal
    extends ZombieAttackGoal {
        private final DrownedEntity field_204726_g;

        public AttackGoal(DrownedEntity drownedEntity, double d, boolean bl) {
            super(drownedEntity, d, bl);
            this.field_204726_g = drownedEntity;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_204726_g.func_204714_e(this.field_204726_g.func_70638_az());
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_204726_g.func_204714_e(this.field_204726_g.func_70638_az());
        }
    }

    static class GoToWaterGoal
    extends Goal {
        private final CreatureEntity field_204730_a;
        private double field_204731_b;
        private double field_204732_c;
        private double field_204733_d;
        private final double field_204734_e;
        private final World field_204735_f;

        public GoToWaterGoal(CreatureEntity creatureEntity, double d) {
            this.field_204730_a = creatureEntity;
            this.field_204734_e = d;
            this.field_204735_f = creatureEntity.field_70170_p;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            if (!this.field_204735_f.func_72935_r()) {
                return false;
            }
            if (this.field_204730_a.func_70090_H()) {
                return false;
            }
            Vector3d vector3d = this.func_204729_f();
            if (vector3d == null) {
                return false;
            }
            this.field_204731_b = vector3d.field_72450_a;
            this.field_204732_c = vector3d.field_72448_b;
            this.field_204733_d = vector3d.field_72449_c;
            return true;
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_204730_a.func_70661_as().func_75500_f();
        }

        @Override
        public void func_75249_e() {
            this.field_204730_a.func_70661_as().func_75492_a(this.field_204731_b, this.field_204732_c, this.field_204733_d, this.field_204734_e);
        }

        @Nullable
        private Vector3d func_204729_f() {
            Random random = this.field_204730_a.func_70681_au();
            BlockPos \u26032 = this.field_204730_a.func_233580_cy_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockPos = \u26032.func_177982_a(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (!this.field_204735_f.func_180495_p(blockPos).func_203425_a(Blocks.field_150355_j)) continue;
                return Vector3d.func_237492_c_(blockPos);
            }
            return null;
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final DrownedEntity field_204727_f;

        public GoToBeachGoal(DrownedEntity drownedEntity, double d) {
            super(drownedEntity, d, 8, 2);
            this.field_204727_f = drownedEntity;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_204727_f.field_70170_p.func_72935_r() && this.field_204727_f.func_70090_H() && this.field_204727_f.func_226278_cu_() >= (double)(this.field_204727_f.field_70170_p.func_181545_F() - 3);
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        @Override
        protected boolean func_179488_a(IWorldReader iWorldReader, BlockPos blockPos) {
            \u2603 = blockPos.func_177984_a();
            if (!iWorldReader.func_175623_d(\u2603) || !iWorldReader.func_175623_d(\u2603.func_177984_a())) {
                return false;
            }
            return iWorldReader.func_180495_p(blockPos).func_235719_a_(iWorldReader, blockPos, this.field_204727_f);
        }

        @Override
        public void func_75249_e() {
            this.field_204727_f.func_204713_s(false);
            this.field_204727_f.field_70699_by = this.field_204727_f.field_204717_b;
            super.func_75249_e();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final DrownedEntity field_204736_a;
        private final double field_204737_b;
        private final int field_204738_c;
        private boolean field_204739_d;

        public SwimUpGoal(DrownedEntity drownedEntity, double d, int n) {
            this.field_204736_a = drownedEntity;
            this.field_204737_b = d;
            this.field_204738_c = n;
        }

        @Override
        public boolean func_75250_a() {
            return !this.field_204736_a.field_70170_p.func_72935_r() && this.field_204736_a.func_70090_H() && this.field_204736_a.func_226278_cu_() < (double)(this.field_204738_c - 2);
        }

        @Override
        public boolean func_75253_b() {
            return this.func_75250_a() && !this.field_204739_d;
        }

        @Override
        public void func_75246_d() {
            if (this.field_204736_a.func_226278_cu_() < (double)(this.field_204738_c - 1) && (this.field_204736_a.func_70661_as().func_75500_f() || this.field_204736_a.func_204710_dB())) {
                Vector3d vector3d = RandomPositionGenerator.func_75464_a(this.field_204736_a, 4, 8, new Vector3d(this.field_204736_a.func_226277_ct_(), this.field_204738_c - 1, this.field_204736_a.func_226281_cx_()));
                if (vector3d == null) {
                    this.field_204739_d = true;
                    return;
                }
                this.field_204736_a.func_70661_as().func_75492_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, this.field_204737_b);
            }
        }

        @Override
        public void func_75249_e() {
            this.field_204736_a.func_204713_s(true);
            this.field_204739_d = false;
        }

        @Override
        public void func_75251_c() {
            this.field_204736_a.func_204713_s(false);
        }
    }

    static class TridentAttackGoal
    extends RangedAttackGoal {
        private final DrownedEntity field_204728_a;

        public TridentAttackGoal(IRangedAttackMob iRangedAttackMob, double d, int n, float f) {
            super(iRangedAttackMob, d, n, f);
            this.field_204728_a = (DrownedEntity)iRangedAttackMob;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_204728_a.func_184614_ca().func_77973_b() == Items.field_203184_eO;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.field_204728_a.func_213395_q(true);
            this.field_204728_a.func_184598_c(Hand.MAIN_HAND);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.field_204728_a.func_184602_cy();
            this.field_204728_a.func_213395_q(false);
        }
    }
}

