/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class MooshroomEntity
extends CowEntity
implements IShearable {
    private static final DataParameter<String> field_213449_bz = EntityDataManager.func_187226_a(MooshroomEntity.class, DataSerializers.field_187194_d);
    private Effect field_213450_bA;
    private int field_213447_bB;
    private UUID field_213448_bD;

    public MooshroomEntity(EntityType<? extends MooshroomEntity> entityType, World world) {
        super((EntityType<? extends CowEntity>)entityType, world);
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        if (iWorldReader.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_150391_bh)) {
            return 10.0f;
        }
        return iWorldReader.func_205052_D(blockPos) - 0.5f;
    }

    public static boolean func_223318_c(EntityType<MooshroomEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return iWorld.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_150391_bh) && iWorld.func_226659_b_(blockPos, 0) > 8;
    }

    @Override
    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
        UUID uUID = lightningBoltEntity.func_110124_au();
        if (!uUID.equals(this.field_213448_bD)) {
            this.func_213446_a(this.func_213444_dV() == Type.RED ? Type.BROWN : Type.RED);
            this.field_213448_bD = uUID;
            this.func_184185_a(SoundEvents.field_219658_gv, 2.0f, 1.0f);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213449_bz, Type.RED.field_221098_c);
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity22, Hand hand) {
        PlayerEntity playerEntity22;
        ItemStack itemStack = playerEntity22.func_184586_b(hand);
        if (itemStack.func_77973_b() == Items.field_151054_z && !this.func_70631_g_()) {
            ItemStack itemStack2;
            boolean bl = false;
            if (this.field_213450_bA != null) {
                bl = true;
                itemStack2 = new ItemStack(Items.field_222115_pz);
                SuspiciousStewItem.func_220037_a(itemStack2, this.field_213450_bA, this.field_213447_bB);
                this.field_213450_bA = null;
                this.field_213447_bB = 0;
            } else {
                itemStack2 = new ItemStack(Items.field_151009_A);
            }
            \u2603 = DrinkHelper.func_241445_a_(itemStack, playerEntity22, itemStack2);
            playerEntity22.func_184611_a(hand, \u2603);
            SoundEvent \u26032 = bl ? SoundEvents.field_219661_gy : SoundEvents.field_219660_gx;
            this.func_184185_a(\u26032, 1.0f, 1.0f);
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        if (itemStack.func_77973_b() == Items.field_151097_aZ && this.func_230262_K__()) {
            this.func_230263_a_(SoundCategory.PLAYERS);
            if (!this.field_70170_p.field_72995_K) {
                itemStack.func_222118_a(1, playerEntity22, playerEntity -> playerEntity.func_213334_d(hand));
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        if (this.func_213444_dV() == Type.BROWN && itemStack.func_77973_b().func_206844_a(ItemTags.field_219770_E)) {
            if (this.field_213450_bA != null) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a(ParticleTypes.field_197601_L, this.func_226277_ct_() + this.field_70146_Z.nextDouble() / 2.0, this.func_226283_e_(0.5), this.func_226281_cx_() + this.field_70146_Z.nextDouble() / 2.0, 0.0, this.field_70146_Z.nextDouble() / 5.0, 0.0);
                }
            } else {
                Optional<Pair<Effect, Integer>> \u26033 = this.func_213443_j(itemStack);
                if (!\u26033.isPresent()) {
                    return ActionResultType.PASS;
                }
                Pair<Effect, Integer> \u26034 = \u26033.get();
                if (!playerEntity22.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a(ParticleTypes.field_197620_m, this.func_226277_ct_() + this.field_70146_Z.nextDouble() / 2.0, this.func_226283_e_(0.5), this.func_226281_cx_() + this.field_70146_Z.nextDouble() / 2.0, 0.0, this.field_70146_Z.nextDouble() / 5.0, 0.0);
                }
                this.field_213450_bA = (Effect)\u26034.getLeft();
                this.field_213447_bB = (Integer)\u26034.getRight();
                this.func_184185_a(SoundEvents.field_219659_gw, 2.0f, 1.0f);
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(playerEntity22, hand);
    }

    @Override
    public void func_230263_a_(SoundCategory soundCategory) {
        this.field_70170_p.func_217384_a(null, this, SoundEvents.field_187784_dt, soundCategory, 1.0f, 1.0f);
        if (!this.field_70170_p.func_201670_d()) {
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.func_70106_y();
            CowEntity cowEntity = EntityType.field_200796_j.func_200721_a(this.field_70170_p);
            cowEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            cowEntity.func_70606_j(this.func_110143_aJ());
            cowEntity.field_70761_aq = this.field_70761_aq;
            if (this.func_145818_k_()) {
                cowEntity.func_200203_b(this.func_200201_e());
                cowEntity.func_174805_g(this.func_174833_aM());
            }
            if (this.func_104002_bU()) {
                cowEntity.func_110163_bv();
            }
            cowEntity.func_184224_h(this.func_190530_aW());
            this.field_70170_p.func_217376_c(cowEntity);
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_217376_c(new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226283_e_(1.0), this.func_226281_cx_(), new ItemStack(this.func_213444_dV().field_221099_d.func_177230_c())));
            }
        }
    }

    @Override
    public boolean func_230262_K__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74778_a("Type", this.func_213444_dV().field_221098_c);
        if (this.field_213450_bA != null) {
            compoundNBT.func_74774_a("EffectId", (byte)Effect.func_188409_a(this.field_213450_bA));
            compoundNBT.func_74768_a("EffectDuration", this.field_213447_bB);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_213446_a(Type.func_221097_b(compoundNBT.func_74779_i("Type")));
        if (compoundNBT.func_150297_b("EffectId", 1)) {
            this.field_213450_bA = Effect.func_188412_a(compoundNBT.func_74771_c("EffectId"));
        }
        if (compoundNBT.func_150297_b("EffectDuration", 3)) {
            this.field_213447_bB = compoundNBT.func_74762_e("EffectDuration");
        }
    }

    private Optional<Pair<Effect, Integer>> func_213443_j(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof BlockItem && (\u2603 = ((BlockItem)item).func_179223_d()) instanceof FlowerBlock) {
            FlowerBlock flowerBlock = (FlowerBlock)\u2603;
            return Optional.of(Pair.of((Object)flowerBlock.func_220094_d(), (Object)flowerBlock.func_220095_e()));
        }
        return Optional.empty();
    }

    private void func_213446_a(Type type) {
        this.field_70180_af.func_187227_b(field_213449_bz, type.field_221098_c);
    }

    public Type func_213444_dV() {
        return Type.func_221097_b(this.field_70180_af.func_187225_a(MooshroomEntity.field_213449_bz));
    }

    @Override
    public MooshroomEntity func_90011_a(AgeableEntity ageableEntity) {
        MooshroomEntity mooshroomEntity = EntityType.field_200780_T.func_200721_a(this.field_70170_p);
        mooshroomEntity.func_213446_a(this.func_213445_a((MooshroomEntity)ageableEntity));
        return mooshroomEntity;
    }

    private Type func_213445_a(MooshroomEntity mooshroomEntity) {
        Type type = this.func_213444_dV();
        \u2603 = type == (\u2603 = mooshroomEntity.func_213444_dV()) && this.field_70146_Z.nextInt(1024) == 0 ? (type == Type.BROWN ? Type.RED : Type.BROWN) : (this.field_70146_Z.nextBoolean() ? type : \u2603);
        return \u2603;
    }

    @Override
    public /* synthetic */ CowEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }

    public static enum Type {
        RED("red", Blocks.field_150337_Q.func_176223_P()),
        BROWN("brown", Blocks.field_150338_P.func_176223_P());

        private final String field_221098_c;
        private final BlockState field_221099_d;

        private Type(String string2, BlockState blockState) {
            this.field_221098_c = string2;
            this.field_221099_d = blockState;
        }

        private static Type func_221097_b(String string) {
            for (Type type : Type.values()) {
                if (!type.field_221098_c.equals(string)) continue;
                return type;
            }
            return RED;
        }
    }
}

