/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.IArmorVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ArmorItem
extends Item
implements IArmorVanishable {
    private static final UUID[] field_185084_n = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final IDispenseItemBehavior field_96605_cw = new DefaultDispenseItemBehavior(){

        @Override
        protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
            return ArmorItem.func_226626_a_(iBlockSource, itemStack) ? itemStack : super.func_82487_b(iBlockSource, itemStack);
        }
    };
    protected final EquipmentSlotType field_77881_a;
    private final int field_77879_b;
    private final float field_189415_e;
    protected final float field_234655_c_;
    protected final IArmorMaterial field_200882_e;
    private final Multimap<Attribute, AttributeModifier> field_234656_m_;

    public static boolean func_226626_a_(IBlockSource iBlockSource, ItemStack itemStack) {
        BlockPos blockPos = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
        List<Entity> \u26032 = iBlockSource.func_197524_h().func_175647_a(LivingEntity.class, new AxisAlignedBB(blockPos), EntityPredicates.field_180132_d.and(new EntityPredicates.ArmoredMob(itemStack)));
        if (\u26032.isEmpty()) {
            return false;
        }
        LivingEntity \u26033 = (LivingEntity)\u26032.get(0);
        EquipmentSlotType \u26034 = MobEntity.func_184640_d(itemStack);
        ItemStack \u26035 = itemStack.func_77979_a(1);
        \u26033.func_184201_a(\u26034, \u26035);
        if (\u26033 instanceof MobEntity) {
            ((MobEntity)\u26033).func_184642_a(\u26034, 2.0f);
            ((MobEntity)\u26033).func_110163_bv();
        }
        return true;
    }

    public ArmorItem(IArmorMaterial iArmorMaterial, EquipmentSlotType equipmentSlotType, Item.Properties properties) {
        super(properties.func_200915_b(iArmorMaterial.func_200896_a(equipmentSlotType)));
        this.field_200882_e = iArmorMaterial;
        this.field_77881_a = equipmentSlotType;
        this.field_77879_b = iArmorMaterial.func_200902_b(equipmentSlotType);
        this.field_189415_e = iArmorMaterial.func_200901_e();
        this.field_234655_c_ = iArmorMaterial.func_230304_f_();
        DispenserBlock.func_199774_a(this, field_96605_cw);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID \u26032 = field_185084_n[equipmentSlotType.func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(\u26032, "Armor modifier", (double)this.field_77879_b, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(\u26032, "Armor toughness", (double)this.field_189415_e, AttributeModifier.Operation.ADDITION));
        if (iArmorMaterial == ArmorMaterial.NETHERITE) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(\u26032, "Armor knockback resistance", (double)this.field_234655_c_, AttributeModifier.Operation.ADDITION));
        }
        this.field_234656_m_ = builder.build();
    }

    public EquipmentSlotType func_185083_B_() {
        return this.field_77881_a;
    }

    @Override
    public int func_77619_b() {
        return this.field_200882_e.func_200900_a();
    }

    public IArmorMaterial func_200880_d() {
        return this.field_200882_e;
    }

    @Override
    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return this.field_200882_e.func_200898_c().test(itemStack2) || super.func_82789_a(itemStack, itemStack2);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        EquipmentSlotType \u26032 = MobEntity.func_184640_d(itemStack);
        \u2603 = playerEntity.func_184582_a(\u26032);
        if (\u2603.func_190926_b()) {
            playerEntity.func_184201_a(\u26032, itemStack.func_77946_l());
            itemStack.func_190920_e(0);
            return ActionResult.func_233538_a_(itemStack, world.func_201670_d());
        }
        return ActionResult.func_226251_d_(itemStack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlotType) {
        if (equipmentSlotType == this.field_77881_a) {
            return this.field_234656_m_;
        }
        return super.func_111205_h(equipmentSlotType);
    }

    public int func_200881_e() {
        return this.field_77879_b;
    }

    public float func_234657_f_() {
        return this.field_189415_e;
    }
}

