/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.ArrayUtils;

public class IntArrayNBT
extends CollectionNBT<IntNBT> {
    public static final INBTType<IntArrayNBT> field_229690_a_ = new INBTType<IntArrayNBT>(){

        @Override
        public IntArrayNBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            nBTSizeTracker.func_152450_a(192L);
            int n2 = dataInput.readInt();
            nBTSizeTracker.func_152450_a(32L * (long)n2);
            int[] \u26032 = new int[n2];
            for (\u2603 = 0; \u2603 < n2; ++\u2603) {
                \u26032[\u2603] = dataInput.readInt();
            }
            return new IntArrayNBT(\u26032);
        }

        @Override
        public String func_225648_a_() {
            return "INT[]";
        }

        @Override
        public String func_225650_b_() {
            return "TAG_Int_Array";
        }

        @Override
        public /* synthetic */ INBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            return this.func_225649_b_(dataInput, n, nBTSizeTracker);
        }
    };
    private int[] field_74749_a;

    public IntArrayNBT(int[] nArray) {
        this.field_74749_a = nArray;
    }

    public IntArrayNBT(List<Integer> list) {
        this(IntArrayNBT.func_193584_a(list));
    }

    private static int[] func_193584_a(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n = list.get(i);
            nArray[i] = n == null ? 0 : n;
        }
        return nArray;
    }

    @Override
    public void func_74734_a(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.field_74749_a.length);
        for (int n : this.field_74749_a) {
            dataOutput.writeInt(n);
        }
    }

    @Override
    public byte func_74732_a() {
        return 11;
    }

    public INBTType<IntArrayNBT> func_225647_b_() {
        return field_229690_a_;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.field_74749_a.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.field_74749_a[i]);
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public IntArrayNBT func_74737_b() {
        int[] nArray = new int[this.field_74749_a.length];
        System.arraycopy(this.field_74749_a, 0, nArray, 0, this.field_74749_a.length);
        return new IntArrayNBT(nArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof IntArrayNBT && Arrays.equals(this.field_74749_a, ((IntArrayNBT)object).field_74749_a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.field_74749_a);
    }

    public int[] func_150302_c() {
        return this.field_74749_a;
    }

    @Override
    public ITextComponent func_199850_a(String string, int n) {
        IFormattableTextComponent iFormattableTextComponent;
        IFormattableTextComponent iFormattableTextComponent2 = new StringTextComponent("I").func_240699_a_(field_197641_e);
        iFormattableTextComponent = new StringTextComponent("[").func_230529_a_(iFormattableTextComponent2).func_240702_b_(";");
        for (int i = 0; i < this.field_74749_a.length; ++i) {
            iFormattableTextComponent.func_240702_b_(" ").func_230529_a_(new StringTextComponent(String.valueOf(this.field_74749_a[i])).func_240699_a_(field_197640_d));
            if (i == this.field_74749_a.length - 1) continue;
            iFormattableTextComponent.func_240702_b_(",");
        }
        iFormattableTextComponent.func_240702_b_("]");
        return iFormattableTextComponent;
    }

    @Override
    public int size() {
        return this.field_74749_a.length;
    }

    @Override
    public IntNBT get(int n) {
        return IntNBT.func_229692_a_(this.field_74749_a[n]);
    }

    @Override
    public IntNBT set(int n, IntNBT intNBT) {
        int n2 = this.field_74749_a[n];
        this.field_74749_a[n] = intNBT.func_150287_d();
        return IntNBT.func_229692_a_(n2);
    }

    @Override
    public void add(int n, IntNBT intNBT) {
        this.field_74749_a = ArrayUtils.add((int[])this.field_74749_a, (int)n, (int)intNBT.func_150287_d());
    }

    @Override
    public boolean func_218659_a(int n, INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            this.field_74749_a[n] = ((NumberNBT)iNBT).func_150287_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean func_218660_b(int n, INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            this.field_74749_a = ArrayUtils.add((int[])this.field_74749_a, (int)n, (int)((NumberNBT)iNBT).func_150287_d());
            return true;
        }
        return false;
    }

    @Override
    public IntNBT remove(int n) {
        \u2603 = this.field_74749_a[n];
        this.field_74749_a = ArrayUtils.remove((int[])this.field_74749_a, (int)n);
        return IntNBT.func_229692_a_(\u2603);
    }

    @Override
    public byte func_230528_d__() {
        return 3;
    }

    @Override
    public void clear() {
        this.field_74749_a = new int[0];
    }

    @Override
    public /* synthetic */ INBT remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, INBT iNBT) {
        this.add(n, (IntNBT)iNBT);
    }

    @Override
    public /* synthetic */ INBT set(int n, INBT iNBT) {
        return this.set(n, (IntNBT)iNBT);
    }

    @Override
    public /* synthetic */ INBT func_74737_b() {
        return this.func_74737_b();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (IntNBT)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (IntNBT)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

