/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Queue;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NettyCompressionDecoder;
import net.minecraft.network.NettyCompressionEncoder;
import net.minecraft.network.NettyEncryptingDecoder;
import net.minecraft.network.NettyEncryptingEncoder;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.SkipableEncoderException;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.util.CryptManager;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NetworkManager
extends SimpleChannelInboundHandler<IPacket<?>> {
    private static final Logger field_150735_g = LogManager.getLogger();
    public static final Marker field_150740_a = MarkerManager.getMarker((String)"NETWORK");
    public static final Marker field_150738_b = MarkerManager.getMarker((String)"NETWORK_PACKETS", (Marker)field_150740_a);
    public static final AttributeKey<ProtocolType> field_150739_c = AttributeKey.valueOf((String)"protocol");
    public static final LazyValue<NioEventLoopGroup> field_179295_d = new LazyValue<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final LazyValue<EpollEventLoopGroup> field_181125_e = new LazyValue<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final LazyValue<DefaultEventLoopGroup> field_179296_e = new LazyValue<DefaultEventLoopGroup>(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private final PacketDirection field_179294_g;
    private final Queue<QueuedPacket> field_150745_j = Queues.newConcurrentLinkedQueue();
    private Channel field_150746_k;
    private SocketAddress field_150743_l;
    private INetHandler field_150744_m;
    private ITextComponent field_150742_o;
    private boolean field_152463_r;
    private boolean field_179297_n;
    private int field_211394_q;
    private int field_211395_r;
    private float field_211396_s;
    private float field_211397_t;
    private int field_211398_u;
    private boolean field_211399_v;

    public NetworkManager(PacketDirection packetDirection) {
        this.field_179294_g = packetDirection;
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelActive(channelHandlerContext);
        this.field_150746_k = channelHandlerContext.channel();
        this.field_150743_l = this.field_150746_k.remoteAddress();
        try {
            this.func_150723_a(ProtocolType.HANDSHAKING);
        }
        catch (Throwable throwable) {
            field_150735_g.fatal((Object)throwable);
        }
    }

    public void func_150723_a(ProtocolType protocolType) {
        this.field_150746_k.attr(field_150739_c).set((Object)protocolType);
        this.field_150746_k.config().setAutoRead(true);
        field_150735_g.debug("Enabled auto read");
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.func_150718_a(new TranslationTextComponent("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof SkipableEncoderException) {
            field_150735_g.debug("Skipping packet due to errors", throwable.getCause());
            return;
        }
        boolean bl = !this.field_211399_v;
        this.field_211399_v = true;
        if (!this.field_150746_k.isOpen()) {
            return;
        }
        if (throwable instanceof TimeoutException) {
            field_150735_g.debug("Timeout", throwable);
            this.func_150718_a(new TranslationTextComponent("disconnect.timeout"));
        } else {
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("disconnect.genericReason", "Internal Exception: " + throwable);
            if (bl) {
                field_150735_g.debug("Failed to sent packet", throwable);
                this.func_201058_a(new SDisconnectPacket(translationTextComponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.func_150718_a(translationTextComponent)));
                this.func_150721_g();
            } else {
                field_150735_g.debug("Double fault", throwable);
                this.func_150718_a(translationTextComponent);
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, IPacket<?> iPacket) throws Exception {
        if (this.field_150746_k.isOpen()) {
            try {
                NetworkManager.func_197664_a(iPacket, this.field_150744_m);
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
            ++this.field_211394_q;
        }
    }

    private static <T extends INetHandler> void func_197664_a(IPacket<T> iPacket, INetHandler iNetHandler) {
        iPacket.func_148833_a(iNetHandler);
    }

    public void func_150719_a(INetHandler iNetHandler) {
        Validate.notNull((Object)iNetHandler, (String)"packetListener", (Object[])new Object[0]);
        this.field_150744_m = iNetHandler;
    }

    public void func_179290_a(IPacket<?> iPacket) {
        this.func_201058_a(iPacket, null);
    }

    public void func_201058_a(IPacket<?> iPacket, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        if (this.func_150724_d()) {
            this.func_150733_h();
            this.func_150732_b(iPacket, genericFutureListener);
        } else {
            this.field_150745_j.add(new QueuedPacket(iPacket, genericFutureListener));
        }
    }

    private void func_150732_b(IPacket<?> iPacket, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        ProtocolType protocolType = ProtocolType.func_150752_a(iPacket);
        \u2603 = (ProtocolType)((Object)this.field_150746_k.attr(field_150739_c).get());
        ++this.field_211395_r;
        if (\u2603 != protocolType) {
            field_150735_g.debug("Disabled auto read");
            this.field_150746_k.config().setAutoRead(false);
        }
        if (this.field_150746_k.eventLoop().inEventLoop()) {
            if (protocolType != \u2603) {
                this.func_150723_a(protocolType);
            }
            ChannelFuture channelFuture = this.field_150746_k.writeAndFlush(iPacket);
            if (genericFutureListener != null) {
                channelFuture.addListener(genericFutureListener);
            }
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        } else {
            this.field_150746_k.eventLoop().execute(() -> {
                if (protocolType != \u2603) {
                    this.func_150723_a(protocolType);
                }
                ChannelFuture channelFuture = this.field_150746_k.writeAndFlush((Object)iPacket);
                if (genericFutureListener != null) {
                    channelFuture.addListener(genericFutureListener);
                }
                channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_150733_h() {
        if (this.field_150746_k == null || !this.field_150746_k.isOpen()) {
            return;
        }
        Queue<QueuedPacket> queue = this.field_150745_j;
        synchronized (queue) {
            QueuedPacket queuedPacket;
            while ((queuedPacket = this.field_150745_j.poll()) != null) {
                this.func_150732_b(queuedPacket.field_150774_a, (GenericFutureListener<? extends Future<? super Void>>)queuedPacket.field_201049_b);
            }
        }
    }

    public void func_74428_b() {
        this.func_150733_h();
        if (this.field_150744_m instanceof ServerLoginNetHandler) {
            ((ServerLoginNetHandler)this.field_150744_m).func_73660_a();
        }
        if (this.field_150744_m instanceof ServerPlayNetHandler) {
            ((ServerPlayNetHandler)this.field_150744_m).func_73660_a();
        }
        if (this.field_150746_k != null) {
            this.field_150746_k.flush();
        }
        if (this.field_211398_u++ % 20 == 0) {
            this.field_211397_t = this.field_211397_t * 0.75f + (float)this.field_211395_r * 0.25f;
            this.field_211396_s = this.field_211396_s * 0.75f + (float)this.field_211394_q * 0.25f;
            this.field_211395_r = 0;
            this.field_211394_q = 0;
        }
    }

    public SocketAddress func_74430_c() {
        return this.field_150743_l;
    }

    public void func_150718_a(ITextComponent iTextComponent) {
        if (this.field_150746_k.isOpen()) {
            this.field_150746_k.close().awaitUninterruptibly();
            this.field_150742_o = iTextComponent;
        }
    }

    public boolean func_150731_c() {
        return this.field_150746_k instanceof LocalChannel || this.field_150746_k instanceof LocalServerChannel;
    }

    public void func_150727_a(SecretKey secretKey) {
        this.field_152463_r = true;
        this.field_150746_k.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new NettyEncryptingDecoder(CryptManager.func_151229_a(2, secretKey)));
        this.field_150746_k.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new NettyEncryptingEncoder(CryptManager.func_151229_a(1, secretKey)));
    }

    public boolean func_150724_d() {
        return this.field_150746_k != null && this.field_150746_k.isOpen();
    }

    public boolean func_179291_h() {
        return this.field_150746_k == null;
    }

    public INetHandler func_150729_e() {
        return this.field_150744_m;
    }

    @Nullable
    public ITextComponent func_150730_f() {
        return this.field_150742_o;
    }

    public void func_150721_g() {
        this.field_150746_k.config().setAutoRead(false);
    }

    public void func_179289_a(int n) {
        if (n >= 0) {
            if (this.field_150746_k.pipeline().get("decompress") instanceof NettyCompressionDecoder) {
                ((NettyCompressionDecoder)this.field_150746_k.pipeline().get("decompress")).func_179303_a(n);
            } else {
                this.field_150746_k.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new NettyCompressionDecoder(n));
            }
            if (this.field_150746_k.pipeline().get("compress") instanceof NettyCompressionEncoder) {
                ((NettyCompressionEncoder)this.field_150746_k.pipeline().get("compress")).func_179299_a(n);
            } else {
                this.field_150746_k.pipeline().addBefore("encoder", "compress", (ChannelHandler)new NettyCompressionEncoder(n));
            }
        } else {
            if (this.field_150746_k.pipeline().get("decompress") instanceof NettyCompressionDecoder) {
                this.field_150746_k.pipeline().remove("decompress");
            }
            if (this.field_150746_k.pipeline().get("compress") instanceof NettyCompressionEncoder) {
                this.field_150746_k.pipeline().remove("compress");
            }
        }
    }

    public void func_179293_l() {
        if (this.field_150746_k == null || this.field_150746_k.isOpen()) {
            return;
        }
        if (this.field_179297_n) {
            field_150735_g.warn("handleDisconnection() called twice");
        } else {
            this.field_179297_n = true;
            if (this.func_150730_f() != null) {
                this.func_150729_e().func_147231_a(this.func_150730_f());
            } else if (this.func_150729_e() != null) {
                this.func_150729_e().func_147231_a(new TranslationTextComponent("multiplayer.disconnect.generic"));
            }
        }
    }

    protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        this.channelRead0(channelHandlerContext, (IPacket)object);
    }

    static class QueuedPacket {
        private final IPacket<?> field_150774_a;
        @Nullable
        private final GenericFutureListener<? extends Future<? super Void>> field_201049_b;

        public QueuedPacket(IPacket<?> iPacket, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
            this.field_150774_a = iPacket;
            this.field_201049_b = genericFutureListener;
        }
    }
}

