/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Pose;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;

public class DataSerializers {
    private static final IntIdentityHashBiMap<IDataSerializer<?>> field_187204_n = new IntIdentityHashBiMap(16);
    public static final IDataSerializer<Byte> field_187191_a = new IDataSerializer<Byte>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Byte by) {
            packetBuffer.writeByte(by.byteValue());
        }

        @Override
        public Byte func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.readByte();
        }

        @Override
        public Byte func_192717_a(Byte by) {
            return by;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Integer> field_187192_b = new IDataSerializer<Integer>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Integer n) {
            packetBuffer.func_150787_b(n);
        }

        @Override
        public Integer func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150792_a();
        }

        @Override
        public Integer func_192717_a(Integer n) {
            return n;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Float> field_187193_c = new IDataSerializer<Float>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Float f) {
            packetBuffer.writeFloat(f.floatValue());
        }

        @Override
        public Float func_187159_a(PacketBuffer packetBuffer) {
            return Float.valueOf(packetBuffer.readFloat());
        }

        @Override
        public Float func_192717_a(Float f) {
            return f;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<String> field_187194_d = new IDataSerializer<String>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, String string) {
            packetBuffer.func_180714_a(string);
        }

        @Override
        public String func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150789_c(Short.MAX_VALUE);
        }

        @Override
        public String func_192717_a(String string) {
            return string;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<ITextComponent> field_187195_e = new IDataSerializer<ITextComponent>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, ITextComponent iTextComponent) {
            packetBuffer.func_179256_a(iTextComponent);
        }

        @Override
        public ITextComponent func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_179258_d();
        }

        @Override
        public ITextComponent func_192717_a(ITextComponent iTextComponent) {
            return iTextComponent;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Optional<ITextComponent>> field_200544_f = new IDataSerializer<Optional<ITextComponent>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<ITextComponent> optional) {
            if (optional.isPresent()) {
                packetBuffer.writeBoolean(true);
                packetBuffer.func_179256_a(optional.get());
            } else {
                packetBuffer.writeBoolean(false);
            }
        }

        @Override
        public Optional<ITextComponent> func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.readBoolean() ? Optional.of(packetBuffer.func_179258_d()) : Optional.empty();
        }

        @Override
        public Optional<ITextComponent> func_192717_a(Optional<ITextComponent> optional) {
            return optional;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<ItemStack> field_187196_f = new IDataSerializer<ItemStack>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, ItemStack itemStack) {
            packetBuffer.func_150788_a(itemStack);
        }

        @Override
        public ItemStack func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150791_c();
        }

        @Override
        public ItemStack func_192717_a(ItemStack itemStack) {
            return itemStack.func_77946_l();
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Optional<BlockState>> field_187197_g = new IDataSerializer<Optional<BlockState>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<BlockState> optional) {
            if (optional.isPresent()) {
                packetBuffer.func_150787_b(Block.func_196246_j(optional.get()));
            } else {
                packetBuffer.func_150787_b(0);
            }
        }

        @Override
        public Optional<BlockState> func_187159_a(PacketBuffer packetBuffer) {
            int n = packetBuffer.func_150792_a();
            if (n == 0) {
                return Optional.empty();
            }
            return Optional.of(Block.func_196257_b(n));
        }

        @Override
        public Optional<BlockState> func_192717_a(Optional<BlockState> optional) {
            return optional;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Boolean> field_187198_h = new IDataSerializer<Boolean>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Boolean bl) {
            packetBuffer.writeBoolean(bl);
        }

        @Override
        public Boolean func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.readBoolean();
        }

        @Override
        public Boolean func_192717_a(Boolean bl) {
            return bl;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<IParticleData> field_198166_i = new IDataSerializer<IParticleData>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, IParticleData iParticleData) {
            packetBuffer.func_150787_b(Registry.field_212632_u.func_148757_b(iParticleData.func_197554_b()));
            iParticleData.func_197553_a(packetBuffer);
        }

        @Override
        public IParticleData func_187159_a(PacketBuffer packetBuffer) {
            return this.func_200543_a(packetBuffer, (ParticleType)Registry.field_212632_u.func_148745_a(packetBuffer.func_150792_a()));
        }

        private <T extends IParticleData> T func_200543_a(PacketBuffer packetBuffer, ParticleType<T> particleType) {
            return particleType.func_197571_g().func_197543_b(particleType, packetBuffer);
        }

        @Override
        public IParticleData func_192717_a(IParticleData iParticleData) {
            return iParticleData;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Rotations> field_187199_i = new IDataSerializer<Rotations>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Rotations rotations) {
            packetBuffer.writeFloat(rotations.func_179415_b());
            packetBuffer.writeFloat(rotations.func_179416_c());
            packetBuffer.writeFloat(rotations.func_179413_d());
        }

        @Override
        public Rotations func_187159_a(PacketBuffer packetBuffer) {
            return new Rotations(packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat());
        }

        @Override
        public Rotations func_192717_a(Rotations rotations) {
            return rotations;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<BlockPos> field_187200_j = new IDataSerializer<BlockPos>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, BlockPos blockPos) {
            packetBuffer.func_179255_a(blockPos);
        }

        @Override
        public BlockPos func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_179259_c();
        }

        @Override
        public BlockPos func_192717_a(BlockPos blockPos) {
            return blockPos;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Optional<BlockPos>> field_187201_k = new IDataSerializer<Optional<BlockPos>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<BlockPos> optional) {
            packetBuffer.writeBoolean(optional.isPresent());
            if (optional.isPresent()) {
                packetBuffer.func_179255_a(optional.get());
            }
        }

        @Override
        public Optional<BlockPos> func_187159_a(PacketBuffer packetBuffer) {
            if (!packetBuffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(packetBuffer.func_179259_c());
        }

        @Override
        public Optional<BlockPos> func_192717_a(Optional<BlockPos> optional) {
            return optional;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Direction> field_187202_l = new IDataSerializer<Direction>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Direction direction) {
            packetBuffer.func_179249_a(direction);
        }

        @Override
        public Direction func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_179257_a(Direction.class);
        }

        @Override
        public Direction func_192717_a(Direction direction) {
            return direction;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Optional<UUID>> field_187203_m = new IDataSerializer<Optional<UUID>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<UUID> optional) {
            packetBuffer.writeBoolean(optional.isPresent());
            if (optional.isPresent()) {
                packetBuffer.func_179252_a(optional.get());
            }
        }

        @Override
        public Optional<UUID> func_187159_a(PacketBuffer packetBuffer) {
            if (!packetBuffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(packetBuffer.func_179253_g());
        }

        @Override
        public Optional<UUID> func_192717_a(Optional<UUID> optional) {
            return optional;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<CompoundNBT> field_192734_n = new IDataSerializer<CompoundNBT>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, CompoundNBT compoundNBT) {
            packetBuffer.func_150786_a(compoundNBT);
        }

        @Override
        public CompoundNBT func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150793_b();
        }

        @Override
        public CompoundNBT func_192717_a(CompoundNBT compoundNBT) {
            return compoundNBT.func_74737_b();
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<VillagerData> field_218813_q = new IDataSerializer<VillagerData>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, VillagerData villagerData) {
            packetBuffer.func_150787_b(Registry.field_218369_K.func_148757_b(villagerData.func_221129_a()));
            packetBuffer.func_150787_b(Registry.field_218370_L.func_148757_b(villagerData.func_221130_b()));
            packetBuffer.func_150787_b(villagerData.func_221132_c());
        }

        @Override
        public VillagerData func_187159_a(PacketBuffer packetBuffer) {
            return new VillagerData(Registry.field_218369_K.func_148745_a(packetBuffer.func_150792_a()), Registry.field_218370_L.func_148745_a(packetBuffer.func_150792_a()), packetBuffer.func_150792_a());
        }

        @Override
        public VillagerData func_192717_a(VillagerData villagerData) {
            return villagerData;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<OptionalInt> field_218814_r = new IDataSerializer<OptionalInt>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, OptionalInt optionalInt) {
            packetBuffer.func_150787_b(optionalInt.orElse(-1) + 1);
        }

        @Override
        public OptionalInt func_187159_a(PacketBuffer packetBuffer) {
            int n = packetBuffer.func_150792_a();
            return n == 0 ? OptionalInt.empty() : OptionalInt.of(n - 1);
        }

        @Override
        public OptionalInt func_192717_a(OptionalInt optionalInt) {
            return optionalInt;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final IDataSerializer<Pose> field_218815_s = new IDataSerializer<Pose>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Pose pose) {
            packetBuffer.func_179249_a(pose);
        }

        @Override
        public Pose func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_179257_a(Pose.class);
        }

        @Override
        public Pose func_192717_a(Pose pose) {
            return pose;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };

    public static void func_187189_a(IDataSerializer<?> iDataSerializer) {
        field_187204_n.func_186808_c(iDataSerializer);
    }

    @Nullable
    public static IDataSerializer<?> func_187190_a(int n) {
        return field_187204_n.func_148745_a(n);
    }

    public static int func_187188_b(IDataSerializer<?> iDataSerializer) {
        return field_187204_n.func_186815_a(iDataSerializer);
    }

    static {
        DataSerializers.func_187189_a(field_187191_a);
        DataSerializers.func_187189_a(field_187192_b);
        DataSerializers.func_187189_a(field_187193_c);
        DataSerializers.func_187189_a(field_187194_d);
        DataSerializers.func_187189_a(field_187195_e);
        DataSerializers.func_187189_a(field_200544_f);
        DataSerializers.func_187189_a(field_187196_f);
        DataSerializers.func_187189_a(field_187198_h);
        DataSerializers.func_187189_a(field_187199_i);
        DataSerializers.func_187189_a(field_187200_j);
        DataSerializers.func_187189_a(field_187201_k);
        DataSerializers.func_187189_a(field_187202_l);
        DataSerializers.func_187189_a(field_187203_m);
        DataSerializers.func_187189_a(field_187197_g);
        DataSerializers.func_187189_a(field_192734_n);
        DataSerializers.func_187189_a(field_198166_i);
        DataSerializers.func_187189_a(field_218813_q);
        DataSerializers.func_187189_a(field_218814_r);
        DataSerializers.func_187189_a(field_218815_s);
    }
}

