/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import net.minecraft.network.rcon.ClientThread;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConThread;
import net.minecraft.server.dedicated.ServerProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainThread
extends RConThread {
    private static final Logger field_232652_d_ = LogManager.getLogger();
    private final int field_72647_g;
    private String field_72652_i;
    private ServerSocket field_72649_j;
    private final String field_72650_k;
    private final List<ClientThread> field_72648_l = Lists.newArrayList();
    private final IServer field_232653_j_;

    public MainThread(IServer iServer) {
        super("RCON Listener");
        this.field_232653_j_ = iServer;
        ServerProperties serverProperties = iServer.func_213221_d_();
        this.field_72647_g = serverProperties.field_219031_y;
        this.field_72650_k = serverProperties.field_219032_z;
        this.field_72652_i = iServer.func_71277_t();
        if (this.field_72652_i.isEmpty()) {
            this.field_72652_i = "0.0.0.0";
        }
    }

    private void func_72645_g() {
        this.field_72648_l.removeIf(clientThread -> !clientThread.func_72613_c());
    }

    @Override
    public void run() {
        field_232652_d_.info("RCON running on {}:{}", (Object)this.field_72652_i, (Object)this.field_72647_g);
        try {
            while (this.field_72619_a) {
                try {
                    Socket socket = this.field_72649_j.accept();
                    ClientThread \u26032 = new ClientThread(this.field_232653_j_, this.field_72650_k, socket);
                    \u26032.func_72602_a();
                    this.field_72648_l.add(\u26032);
                    this.func_72645_g();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.func_72645_g();
                }
                catch (IOException iOException) {
                    if (!this.field_72619_a) continue;
                    field_232652_d_.info("IO exception: ", (Throwable)iOException);
                }
            }
        }
        finally {
            this.func_232655_a_(this.field_72649_j);
        }
    }

    @Override
    public void func_72602_a() {
        if (this.field_72650_k.isEmpty()) {
            field_232652_d_.warn("No rcon password set in server.properties, rcon disabled!");
            return;
        }
        if (0 >= this.field_72647_g || 65535 < this.field_72647_g) {
            field_232652_d_.warn("Invalid rcon port {} found in server.properties, rcon disabled!", (Object)this.field_72647_g);
            return;
        }
        if (this.field_72619_a) {
            return;
        }
        try {
            this.field_72649_j = new ServerSocket(this.field_72647_g, 0, InetAddress.getByName(this.field_72652_i));
            this.field_72649_j.setSoTimeout(500);
            super.func_72602_a();
        }
        catch (IOException iOException) {
            field_232652_d_.warn("Unable to initialise rcon on {}:{}", (Object)this.field_72652_i, (Object)this.field_72647_g, (Object)iOException);
        }
    }

    @Override
    public void func_219591_b() {
        this.field_72619_a = false;
        this.func_232655_a_(this.field_72649_j);
        super.func_219591_b();
        for (ClientThread clientThread : this.field_72648_l) {
            if (!clientThread.func_72613_c()) continue;
            clientThread.func_219591_b();
        }
        this.field_72648_l.clear();
    }

    private void func_232655_a_(ServerSocket serverSocket) {
        field_232652_d_.debug("closeSocket: {}", (Object)serverSocket);
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            field_232652_d_.warn("Failed to close socket", (Throwable)iOException);
        }
    }
}

