/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;

public class WalkNodeProcessor
extends NodeProcessor {
    protected float field_176183_h;
    private final Long2ObjectMap<PathNodeType> field_237226_k_ = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AxisAlignedBB> field_237227_l_ = new Object2BooleanOpenHashMap();

    @Override
    public void func_225578_a_(Region region, MobEntity mobEntity) {
        super.func_225578_a_(region, mobEntity);
        this.field_176183_h = mobEntity.func_184643_a(PathNodeType.WATER);
    }

    @Override
    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WATER, this.field_176183_h);
        this.field_237226_k_.clear();
        this.field_237227_l_.clear();
        super.func_176163_a();
    }

    @Override
    public PathPoint func_186318_b() {
        Object \u26035;
        BlockPos blockPos;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int \u26032 = MathHelper.func_76128_c(this.field_186326_b.func_226278_cu_());
        BlockState \u26033 = this.field_176169_a.func_180495_p(mutable.func_189532_c(this.field_186326_b.func_226277_ct_(), \u26032, this.field_186326_b.func_226281_cx_()));
        if (this.field_186326_b.func_230285_a_(\u26033.func_204520_s().func_206886_c())) {
            while (this.field_186326_b.func_230285_a_(\u26033.func_204520_s().func_206886_c())) {
                \u26033 = this.field_176169_a.func_180495_p(mutable.func_189532_c(this.field_186326_b.func_226277_ct_(), ++\u26032, this.field_186326_b.func_226281_cx_()));
            }
            --\u26032;
        } else if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            while (\u26033.func_177230_c() == Blocks.field_150355_j || \u26033.func_204520_s() == Fluids.field_204546_a.func_207204_a(false)) {
                \u26033 = this.field_176169_a.func_180495_p(mutable.func_189532_c(this.field_186326_b.func_226277_ct_(), ++\u26032, this.field_186326_b.func_226281_cx_()));
            }
            --\u26032;
        } else if (this.field_186326_b.func_233570_aj_()) {
            \u26032 = MathHelper.func_76128_c(this.field_186326_b.func_226278_cu_() + 0.5);
        } else {
            blockPos = this.field_186326_b.func_233580_cy_();
            while ((this.field_176169_a.func_180495_p(blockPos).func_196958_f() || this.field_176169_a.func_180495_p(blockPos).func_196957_g(this.field_176169_a, blockPos, PathType.LAND)) && blockPos.func_177956_o() > 0) {
                blockPos = blockPos.func_177977_b();
            }
            \u26032 = blockPos.func_177984_a().func_177956_o();
        }
        blockPos = this.field_186326_b.func_233580_cy_();
        PathNodeType \u26034 = this.func_237230_a_(this.field_186326_b, blockPos.func_177958_n(), \u26032, blockPos.func_177952_p());
        if (this.field_186326_b.func_184643_a(\u26034) < 0.0f) {
            \u26035 = this.field_186326_b.func_174813_aQ();
            if (this.func_237239_b_(mutable.func_189532_c(((AxisAlignedBB)\u26035).field_72340_a, \u26032, ((AxisAlignedBB)\u26035).field_72339_c)) || this.func_237239_b_(mutable.func_189532_c(((AxisAlignedBB)\u26035).field_72340_a, \u26032, ((AxisAlignedBB)\u26035).field_72334_f)) || this.func_237239_b_(mutable.func_189532_c(((AxisAlignedBB)\u26035).field_72336_d, \u26032, ((AxisAlignedBB)\u26035).field_72339_c)) || this.func_237239_b_(mutable.func_189532_c(((AxisAlignedBB)\u26035).field_72336_d, \u26032, ((AxisAlignedBB)\u26035).field_72334_f))) {
                PathPoint pathPoint = this.func_237223_a_(mutable);
                pathPoint.field_186287_m = this.func_186329_a(this.field_186326_b, pathPoint.func_224759_a());
                pathPoint.field_186286_l = this.field_186326_b.func_184643_a(pathPoint.field_186287_m);
                return pathPoint;
            }
        }
        \u26035 = this.func_176159_a(blockPos.func_177958_n(), \u26032, blockPos.func_177952_p());
        ((PathPoint)\u26035).field_186287_m = this.func_186329_a(this.field_186326_b, ((PathPoint)\u26035).func_224759_a());
        ((PathPoint)\u26035).field_186286_l = this.field_186326_b.func_184643_a(((PathPoint)\u26035).field_186287_m);
        return \u26035;
    }

    private boolean func_237239_b_(BlockPos blockPos) {
        PathNodeType pathNodeType = this.func_186329_a(this.field_186326_b, blockPos);
        return this.field_186326_b.func_184643_a(pathNodeType) >= 0.0f;
    }

    @Override
    public FlaggedPathPoint func_224768_a(double d, double d2, double d3) {
        return new FlaggedPathPoint(this.func_176159_a(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3)));
    }

    @Override
    public int func_222859_a(PathPoint[] pathPointArray, PathPoint pathPoint) {
        int n = 0;
        \u2603 = 0;
        PathNodeType \u26032 = this.func_237230_a_(this.field_186326_b, pathPoint.field_75839_a, pathPoint.field_75837_b + 1, pathPoint.field_75838_c);
        PathNodeType \u26033 = this.func_237230_a_(this.field_186326_b, pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(\u26032) >= 0.0f && \u26033 != PathNodeType.STICKY_HONEY) {
            \u2603 = MathHelper.func_76141_d(Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        if (this.func_237235_a_(\u2603 = this.func_186332_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u2603, \u2603 = WalkNodeProcessor.func_197682_a(this.field_176169_a, new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c)), Direction.SOUTH, \u26033), pathPoint)) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_237235_a_(\u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c, \u2603, \u2603, Direction.WEST, \u26033), pathPoint)) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_237235_a_(\u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c, \u2603, \u2603, Direction.EAST, \u26033), pathPoint)) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_237235_a_(\u2603 = this.func_186332_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u2603, \u2603, Direction.NORTH, \u26033), pathPoint)) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u2603, \u2603, Direction.NORTH, \u26033))) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u2603, \u2603, Direction.NORTH, \u26033))) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u2603, \u2603, Direction.SOUTH, \u26033))) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u2603, \u2603, Direction.SOUTH, \u26033))) {
            pathPointArray[n++] = \u2603;
        }
        return n;
    }

    private boolean func_237235_a_(PathPoint pathPoint, PathPoint pathPoint2) {
        return pathPoint != null && !pathPoint.field_75842_i && (pathPoint.field_186286_l >= 0.0f || pathPoint2.field_186286_l < 0.0f);
    }

    private boolean func_222860_a(PathPoint pathPoint, @Nullable PathPoint pathPoint2, @Nullable PathPoint pathPoint3, @Nullable PathPoint pathPoint4) {
        if (pathPoint4 == null || pathPoint3 == null || pathPoint2 == null) {
            return false;
        }
        if (pathPoint4.field_75842_i) {
            return false;
        }
        if (pathPoint3.field_75837_b > pathPoint.field_75837_b || pathPoint2.field_75837_b > pathPoint.field_75837_b) {
            return false;
        }
        boolean bl = pathPoint3.field_186287_m == PathNodeType.FENCE && pathPoint2.field_186287_m == PathNodeType.FENCE && (double)this.field_186326_b.func_213311_cf() < 0.5;
        return pathPoint4.field_186286_l >= 0.0f && (pathPoint3.field_75837_b < pathPoint.field_75837_b || pathPoint3.field_186286_l >= 0.0f || bl) && (pathPoint2.field_75837_b < pathPoint.field_75837_b || pathPoint2.field_186286_l >= 0.0f || bl);
    }

    private boolean func_237234_a_(PathPoint pathPoint) {
        Vector3d vector3d = new Vector3d((double)pathPoint.field_75839_a - this.field_186326_b.func_226277_ct_(), (double)pathPoint.field_75837_b - this.field_186326_b.func_226278_cu_(), (double)pathPoint.field_75838_c - this.field_186326_b.func_226281_cx_());
        AxisAlignedBB \u26032 = this.field_186326_b.func_174813_aQ();
        int \u26033 = MathHelper.func_76143_f(vector3d.func_72433_c() / \u26032.func_72320_b());
        vector3d = vector3d.func_186678_a(1.0f / (float)\u26033);
        for (int i = 1; i <= \u26033; ++i) {
            if (!this.func_237236_a_(\u26032 = \u26032.func_191194_a(vector3d))) continue;
            return false;
        }
        return true;
    }

    public static double func_197682_a(IBlockReader iBlockReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        VoxelShape voxelShape = iBlockReader.func_180495_p(\u2603).func_196952_d(iBlockReader, \u2603);
        return (double)\u2603.func_177956_o() + (voxelShape.func_197766_b() ? 0.0 : voxelShape.func_197758_c(Direction.Axis.Y));
    }

    @Nullable
    private PathPoint func_186332_a(int n5, int n2, int n3, int n4, double d, Direction direction, PathNodeType pathNodeType) {
        int n5;
        PathPoint \u26038 = null;
        BlockPos.Mutable \u26032 = new BlockPos.Mutable();
        double \u26033 = WalkNodeProcessor.func_197682_a(this.field_176169_a, \u26032.func_181079_c(n5, n2, n3));
        if (\u26033 - d > 1.125) {
            return null;
        }
        PathNodeType \u26034 = this.func_237230_a_(this.field_186326_b, n5, n2, n3);
        float \u26035 = this.field_186326_b.func_184643_a(\u26034);
        double \u26036 = (double)this.field_186326_b.func_213311_cf() / 2.0;
        if (\u26035 >= 0.0f) {
            \u26038 = this.func_176159_a(n5, n2, n3);
            \u26038.field_186287_m = \u26034;
            \u26038.field_186286_l = Math.max(\u26038.field_186286_l, \u26035);
        }
        if (pathNodeType == PathNodeType.FENCE && \u26038 != null && \u26038.field_186286_l >= 0.0f && !this.func_237234_a_(\u26038)) {
            \u26038 = null;
        }
        if (\u26034 == PathNodeType.WALKABLE) {
            return \u26038;
        }
        if ((\u26038 == null || \u26038.field_186286_l < 0.0f) && n4 > 0 && \u26034 != PathNodeType.FENCE && \u26034 != PathNodeType.UNPASSABLE_RAIL && \u26034 != PathNodeType.TRAPDOOR && (\u26038 = this.func_186332_a(n5, n2 + 1, n3, n4 - 1, d, direction, pathNodeType)) != null && (\u26038.field_186287_m == PathNodeType.OPEN || \u26038.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.func_213311_cf() < 1.0f && this.func_237236_a_(\u2603 = new AxisAlignedBB((\u2603 = (double)(n5 - direction.func_82601_c()) + 0.5) - \u26036, WalkNodeProcessor.func_197682_a(this.field_176169_a, \u26032.func_189532_c(\u2603, n2 + 1, \u2603 = (double)(n3 - direction.func_82599_e()) + 0.5)) + 0.001, \u2603 - \u26036, \u2603 + \u26036, (double)this.field_186326_b.func_213302_cg() + WalkNodeProcessor.func_197682_a(this.field_176169_a, \u26032.func_189532_c(\u26038.field_75839_a, \u26038.field_75837_b, \u26038.field_75838_c)) - 0.002, \u2603 + \u26036))) {
            \u26038 = null;
        }
        if (\u26034 == PathNodeType.WATER && !this.func_186322_e()) {
            if (this.func_237230_a_(this.field_186326_b, n5, n2 - 1, n3) != PathNodeType.WATER) {
                return \u26038;
            }
            while (n2 > 0) {
                if ((\u26034 = this.func_237230_a_(this.field_186326_b, n5, --n2, n3)) == PathNodeType.WATER) {
                    \u26038 = this.func_176159_a(n5, n2, n3);
                    \u26038.field_186287_m = \u26034;
                    \u26038.field_186286_l = Math.max(\u26038.field_186286_l, this.field_186326_b.func_184643_a(\u26034));
                    continue;
                }
                return \u26038;
            }
        }
        if (\u26034 == PathNodeType.OPEN) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)n5 - \u26036 + 0.5, (double)n2 + 0.001, (double)n3 - \u26036 + 0.5, (double)n5 + \u26036 + 0.5, (float)n2 + this.field_186326_b.func_213302_cg(), (double)n3 + \u26036 + 0.5);
            if (this.func_237236_a_(axisAlignedBB)) {
                return null;
            }
            if (this.field_186326_b.func_213311_cf() >= 1.0f && (\u2603 = this.func_237230_a_(this.field_186326_b, n5, n2 - 1, n3)) == PathNodeType.BLOCKED) {
                \u26038 = this.func_176159_a(n5, n2, n3);
                \u26038.field_186287_m = PathNodeType.WALKABLE;
                \u26038.field_186286_l = Math.max(\u26038.field_186286_l, \u26035);
                return \u26038;
            }
            int n6 = 0;
            \u2603 = n2;
            while (\u26034 == PathNodeType.OPEN) {
                PathPoint \u26037;
                if (--n2 < 0) {
                    \u26037 = this.func_176159_a(n5, \u2603, n3);
                    \u26037.field_186287_m = PathNodeType.BLOCKED;
                    \u26037.field_186286_l = -1.0f;
                    return \u26037;
                }
                \u26037 = this.func_176159_a(n5, n2, n3);
                if (n6++ >= this.field_186326_b.func_82143_as()) {
                    \u26037.field_186287_m = PathNodeType.BLOCKED;
                    \u26037.field_186286_l = -1.0f;
                    return \u26037;
                }
                \u26034 = this.func_237230_a_(this.field_186326_b, n5, n2, n3);
                \u26035 = this.field_186326_b.func_184643_a(\u26034);
                if (\u26034 != PathNodeType.OPEN && \u26035 >= 0.0f) {
                    \u26038 = \u26037;
                    \u26038.field_186287_m = \u26034;
                    \u26038.field_186286_l = Math.max(\u26038.field_186286_l, \u26035);
                    break;
                }
                if (!(\u26035 < 0.0f)) continue;
                \u26037.field_186287_m = PathNodeType.BLOCKED;
                \u26037.field_186286_l = -1.0f;
                return \u26037;
            }
        }
        if (\u26034 == PathNodeType.FENCE) {
            \u26038 = this.func_176159_a(n5, n2, n3);
            \u26038.field_75842_i = true;
            \u26038.field_186287_m = \u26034;
            \u26038.field_186286_l = \u26034.func_186289_a();
        }
        return \u26038;
    }

    private boolean func_237236_a_(AxisAlignedBB axisAlignedBB) {
        return (Boolean)this.field_237227_l_.computeIfAbsent((Object)axisAlignedBB, axisAlignedBB2 -> !this.field_176169_a.func_226665_a__(this.field_186326_b, axisAlignedBB));
    }

    @Override
    public PathNodeType func_186319_a(IBlockReader iBlockReader, int n, int n2, int n3, MobEntity mobEntity2, int n4, int n5, int n6, boolean bl, boolean bl2) {
        MobEntity mobEntity2;
        EnumSet<PathNodeType> enumSet = EnumSet.noneOf(PathNodeType.class);
        PathNodeType \u26032 = PathNodeType.BLOCKED;
        BlockPos \u26033 = mobEntity2.func_233580_cy_();
        \u26032 = this.func_193577_a(iBlockReader, n, n2, n3, n4, n5, n6, bl, bl2, enumSet, \u26032, \u26033);
        if (enumSet.contains((Object)PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        if (enumSet.contains((Object)PathNodeType.UNPASSABLE_RAIL)) {
            return PathNodeType.UNPASSABLE_RAIL;
        }
        PathNodeType \u26034 = PathNodeType.BLOCKED;
        for (PathNodeType pathNodeType : enumSet) {
            if (mobEntity2.func_184643_a(pathNodeType) < 0.0f) {
                return pathNodeType;
            }
            if (!(mobEntity2.func_184643_a(pathNodeType) >= mobEntity2.func_184643_a(\u26034))) continue;
            \u26034 = pathNodeType;
        }
        if (\u26032 == PathNodeType.OPEN && mobEntity2.func_184643_a(\u26034) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return \u26034;
    }

    public PathNodeType func_193577_a(IBlockReader iBlockReader, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, EnumSet<PathNodeType> enumSet, PathNodeType pathNodeType2, BlockPos blockPos) {
        PathNodeType pathNodeType2;
        for (int i = 0; i < n4; ++i) {
            for (\u2603 = 0; \u2603 < n5; ++\u2603) {
                for (\u2603 = 0; \u2603 < n6; ++\u2603) {
                    \u2603 = i + n;
                    \u2603 = \u2603 + n2;
                    \u2603 = \u2603 + n3;
                    PathNodeType pathNodeType3 = this.func_186330_a(iBlockReader, \u2603, \u2603, \u2603);
                    pathNodeType3 = this.func_215744_a(iBlockReader, bl, bl2, blockPos, pathNodeType3);
                    if (i == 0 && \u2603 == 0 && \u2603 == 0) {
                        pathNodeType2 = pathNodeType3;
                    }
                    enumSet.add(pathNodeType3);
                }
            }
        }
        return pathNodeType2;
    }

    protected PathNodeType func_215744_a(IBlockReader iBlockReader, boolean bl, boolean bl2, BlockPos blockPos, PathNodeType pathNodeType) {
        if (pathNodeType == PathNodeType.DOOR_WOOD_CLOSED && bl && bl2) {
            pathNodeType = PathNodeType.WALKABLE;
        }
        if (pathNodeType == PathNodeType.DOOR_OPEN && !bl2) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        if (pathNodeType == PathNodeType.RAIL && !(iBlockReader.func_180495_p(blockPos).func_177230_c() instanceof AbstractRailBlock) && !(iBlockReader.func_180495_p(blockPos.func_177977_b()).func_177230_c() instanceof AbstractRailBlock)) {
            pathNodeType = PathNodeType.UNPASSABLE_RAIL;
        }
        if (pathNodeType == PathNodeType.LEAVES) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        return pathNodeType;
    }

    private PathNodeType func_186329_a(MobEntity mobEntity, BlockPos blockPos) {
        return this.func_237230_a_(mobEntity, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    private PathNodeType func_237230_a_(MobEntity mobEntity, int n, int n2, int n3) {
        return (PathNodeType)((Object)this.field_237226_k_.computeIfAbsent(BlockPos.func_218276_a(n, n2, n3), l -> this.func_186319_a(this.field_176169_a, n, n2, n3, mobEntity, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c())));
    }

    @Override
    public PathNodeType func_186330_a(IBlockReader iBlockReader, int n, int n2, int n3) {
        return WalkNodeProcessor.func_237231_a_(iBlockReader, new BlockPos.Mutable(n, n2, n3));
    }

    public static PathNodeType func_237231_a_(IBlockReader iBlockReader2, BlockPos.Mutable mutable) {
        int n = mutable.func_177958_n();
        \u2603 = mutable.func_177956_o();
        \u2603 = mutable.func_177952_p();
        PathNodeType \u26032 = WalkNodeProcessor.func_237238_b_(iBlockReader2, mutable);
        if (\u26032 == PathNodeType.OPEN && \u2603 >= 1) {
            PathNodeType pathNodeType = WalkNodeProcessor.func_237238_b_(iBlockReader2, mutable.func_181079_c(n, \u2603 - 1, \u2603));
            PathNodeType pathNodeType2 = \u26032 = pathNodeType == PathNodeType.WALKABLE || pathNodeType == PathNodeType.OPEN || pathNodeType == PathNodeType.WATER || pathNodeType == PathNodeType.LAVA ? PathNodeType.OPEN : PathNodeType.WALKABLE;
            if (pathNodeType == PathNodeType.DAMAGE_FIRE) {
                \u26032 = PathNodeType.DAMAGE_FIRE;
            }
            if (pathNodeType == PathNodeType.DAMAGE_CACTUS) {
                \u26032 = PathNodeType.DAMAGE_CACTUS;
            }
            if (pathNodeType == PathNodeType.DAMAGE_OTHER) {
                \u26032 = PathNodeType.DAMAGE_OTHER;
            }
            if (pathNodeType == PathNodeType.STICKY_HONEY) {
                \u26032 = PathNodeType.STICKY_HONEY;
            }
        }
        if (\u26032 == PathNodeType.WALKABLE) {
            IBlockReader iBlockReader2;
            \u26032 = WalkNodeProcessor.func_237232_a_(iBlockReader2, mutable.func_181079_c(n, \u2603, \u2603), \u26032);
        }
        return \u26032;
    }

    public static PathNodeType func_237232_a_(IBlockReader iBlockReader, BlockPos.Mutable mutable, PathNodeType pathNodeType) {
        int n = mutable.func_177958_n();
        \u2603 = mutable.func_177956_o();
        \u2603 = mutable.func_177952_p();
        for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
            for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                    if (\u2603 == 0 && \u2603 == 0) continue;
                    mutable.func_181079_c(n + \u2603, \u2603 + \u2603, \u2603 + \u2603);
                    BlockState blockState = iBlockReader.func_180495_p(mutable);
                    if (blockState.func_203425_a(Blocks.field_150434_aF)) {
                        return PathNodeType.DANGER_CACTUS;
                    }
                    if (blockState.func_203425_a(Blocks.field_222434_lW)) {
                        return PathNodeType.DANGER_OTHER;
                    }
                    if (WalkNodeProcessor.func_237233_a_(blockState)) {
                        return PathNodeType.DANGER_FIRE;
                    }
                    FluidState \u26032 = iBlockReader.func_204610_c(mutable);
                    if (\u26032.func_206884_a(FluidTags.field_206959_a)) {
                        return PathNodeType.WATER_BORDER;
                    }
                    if (!\u26032.func_206884_a(FluidTags.field_206960_b)) continue;
                    return PathNodeType.LAVA;
                }
            }
        }
        return pathNodeType;
    }

    protected static PathNodeType func_237238_b_(IBlockReader iBlockReader, BlockPos blockPos) {
        BlockState blockState = iBlockReader.func_180495_p(blockPos);
        Block \u26032 = blockState.func_177230_c();
        Material \u26033 = blockState.func_185904_a();
        if (blockState.func_196958_f()) {
            return PathNodeType.OPEN;
        }
        if (blockState.func_235714_a_(BlockTags.field_212185_E) || blockState.func_203425_a(Blocks.field_196651_dG)) {
            return PathNodeType.TRAPDOOR;
        }
        if (blockState.func_203425_a(Blocks.field_150434_aF)) {
            return PathNodeType.DAMAGE_CACTUS;
        }
        if (blockState.func_203425_a(Blocks.field_222434_lW)) {
            return PathNodeType.DAMAGE_OTHER;
        }
        if (blockState.func_203425_a(Blocks.field_226907_mc_)) {
            return PathNodeType.STICKY_HONEY;
        }
        if (blockState.func_203425_a(Blocks.field_150375_by)) {
            return PathNodeType.COCOA;
        }
        if (WalkNodeProcessor.func_237233_a_(blockState)) {
            return PathNodeType.DAMAGE_FIRE;
        }
        if (DoorBlock.func_235492_h_(blockState) && !blockState.func_177229_b(DoorBlock.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_WOOD_CLOSED;
        }
        if (\u26032 instanceof DoorBlock && \u26033 == Material.field_151573_f && !blockState.func_177229_b(DoorBlock.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_IRON_CLOSED;
        }
        if (\u26032 instanceof DoorBlock && blockState.func_177229_b(DoorBlock.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_OPEN;
        }
        if (\u26032 instanceof AbstractRailBlock) {
            return PathNodeType.RAIL;
        }
        if (\u26032 instanceof LeavesBlock) {
            return PathNodeType.LEAVES;
        }
        if (\u26032.func_203417_a(BlockTags.field_219748_G) || \u26032.func_203417_a(BlockTags.field_219757_z) || \u26032 instanceof FenceGateBlock && !blockState.func_177229_b(FenceGateBlock.field_176466_a).booleanValue()) {
            return PathNodeType.FENCE;
        }
        if (!blockState.func_196957_g(iBlockReader, blockPos, PathType.LAND)) {
            return PathNodeType.BLOCKED;
        }
        FluidState \u26034 = iBlockReader.func_204610_c(blockPos);
        if (\u26034.func_206884_a(FluidTags.field_206959_a)) {
            return PathNodeType.WATER;
        }
        if (\u26034.func_206884_a(FluidTags.field_206960_b)) {
            return PathNodeType.LAVA;
        }
        return PathNodeType.OPEN;
    }

    private static boolean func_237233_a_(BlockState blockState) {
        return blockState.func_235714_a_(BlockTags.field_232872_am_) || blockState.func_203425_a(Blocks.field_196814_hQ) || CampfireBlock.func_226915_i_(blockState);
    }
}

