/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public enum Direction implements IStringSerializable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vector3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vector3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vector3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vector3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vector3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vector3i(1, 0, 0));

    private final int field_176748_g;
    private final int field_176759_h;
    private final int field_176760_i;
    private final String field_176757_j;
    private final Axis field_176758_k;
    private final AxisDirection field_176755_l;
    private final Vector3i field_176756_m;
    private static final Direction[] field_199792_n;
    private static final Map<String, Direction> field_176761_p;
    private static final Direction[] field_82609_l;
    private static final Direction[] field_176754_o;
    private static final Long2ObjectMap<Direction> field_218387_r;

    private Direction(int n2, int n3, int n4, String string2, AxisDirection axisDirection, Axis axis, Vector3i vector3i) {
        this.field_176748_g = n2;
        this.field_176760_i = n4;
        this.field_176759_h = n3;
        this.field_176757_j = string2;
        this.field_176758_k = axis;
        this.field_176755_l = axisDirection;
        this.field_176756_m = vector3i;
    }

    public static Direction[] func_196054_a(Entity entity) {
        float f = entity.func_195050_f(1.0f) * ((float)Math.PI / 180);
        \u2603 = -entity.func_195046_g(1.0f) * ((float)Math.PI / 180);
        \u2603 = MathHelper.func_76126_a(f);
        \u2603 = MathHelper.func_76134_b(f);
        \u2603 = MathHelper.func_76126_a(\u2603);
        \u2603 = MathHelper.func_76134_b(\u2603);
        boolean \u26032 = \u2603 > 0.0f;
        boolean \u26033 = \u2603 < 0.0f;
        boolean \u26034 = \u2603 > 0.0f;
        \u2603 = \u26032 ? \u2603 : -\u2603;
        \u2603 = \u26033 ? -\u2603 : \u2603;
        \u2603 = \u26034 ? \u2603 : -\u2603;
        \u2603 = \u2603 * \u2603;
        \u2603 = \u2603 * \u2603;
        Direction \u26035 = \u26032 ? EAST : WEST;
        Direction \u26036 = \u26033 ? UP : DOWN;
        Direction direction = \u2603 = \u26034 ? SOUTH : NORTH;
        if (\u2603 > \u2603) {
            if (\u2603 > \u2603) {
                return Direction.func_196053_a(\u26036, \u26035, \u2603);
            }
            if (\u2603 > \u2603) {
                return Direction.func_196053_a(\u26035, \u2603, \u26036);
            }
            return Direction.func_196053_a(\u26035, \u26036, \u2603);
        }
        if (\u2603 > \u2603) {
            return Direction.func_196053_a(\u26036, \u2603, \u26035);
        }
        if (\u2603 > \u2603) {
            return Direction.func_196053_a(\u2603, \u26035, \u26036);
        }
        return Direction.func_196053_a(\u2603, \u26036, \u26035);
    }

    private static Direction[] func_196053_a(Direction direction, Direction direction2, Direction direction3) {
        return new Direction[]{direction, direction2, direction3, direction3.func_176734_d(), direction2.func_176734_d(), direction.func_176734_d()};
    }

    public int func_176745_a() {
        return this.field_176748_g;
    }

    public int func_176736_b() {
        return this.field_176760_i;
    }

    public AxisDirection func_176743_c() {
        return this.field_176755_l;
    }

    public Direction func_176734_d() {
        return Direction.func_82600_a(this.field_176759_h);
    }

    public Direction func_176746_e() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
    }

    public Direction func_176735_f() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + this);
    }

    public int func_82601_c() {
        return this.field_176756_m.func_177958_n();
    }

    public int func_96559_d() {
        return this.field_176756_m.func_177956_o();
    }

    public int func_82599_e() {
        return this.field_176756_m.func_177952_p();
    }

    public String func_176742_j() {
        return this.field_176757_j;
    }

    public Axis func_176740_k() {
        return this.field_176758_k;
    }

    public static Direction func_82600_a(int n) {
        return field_82609_l[MathHelper.func_76130_a(n % field_82609_l.length)];
    }

    public static Direction func_176731_b(int n) {
        return field_176754_o[MathHelper.func_76130_a(n % field_176754_o.length)];
    }

    @Nullable
    public static Direction func_218383_a(int n, int n2, int n3) {
        return (Direction)field_218387_r.get(BlockPos.func_218276_a(n, n2, n3));
    }

    public static Direction func_176733_a(double d) {
        return Direction.func_176731_b(MathHelper.func_76128_c(d / 90.0 + 0.5) & 3);
    }

    public static Direction func_211699_a(Axis axis, AxisDirection axisDirection) {
        switch (axis) {
            case X: {
                return axisDirection == AxisDirection.POSITIVE ? EAST : WEST;
            }
            case Y: {
                return axisDirection == AxisDirection.POSITIVE ? UP : DOWN;
            }
        }
        return axisDirection == AxisDirection.POSITIVE ? SOUTH : NORTH;
    }

    public float func_185119_l() {
        return (this.field_176760_i & 3) * 90;
    }

    public static Direction func_239631_a_(Random random) {
        return Util.func_240989_a_(field_199792_n, random);
    }

    public static Direction func_210769_a(double d, double d2, double d3) {
        return Direction.func_176737_a((float)d, (float)d2, (float)d3);
    }

    public static Direction func_176737_a(float f, float f2, float f3) {
        Direction \u26033 = NORTH;
        float \u26032 = Float.MIN_VALUE;
        for (Direction direction : field_199792_n) {
            float f4 = f * (float)direction.field_176756_m.func_177958_n() + f2 * (float)direction.field_176756_m.func_177956_o() + f3 * (float)direction.field_176756_m.func_177952_p();
            if (!(f4 > \u26032)) continue;
            \u26032 = f4;
            \u26033 = direction;
        }
        return \u26033;
    }

    public String toString() {
        return this.field_176757_j;
    }

    @Override
    public String func_176610_l() {
        return this.field_176757_j;
    }

    public static Direction func_181076_a(AxisDirection axisDirection2, Axis axis) {
        AxisDirection axisDirection2;
        for (Direction direction : field_199792_n) {
            if (direction.func_176743_c() != axisDirection2 || direction.func_176740_k() != axis) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)axisDirection2) + " " + axis);
    }

    public Vector3i func_176730_m() {
        return this.field_176756_m;
    }

    static {
        field_199792_n = Direction.values();
        field_176761_p = Arrays.stream(field_199792_n).collect(Collectors.toMap(Direction::func_176742_j, direction -> direction));
        field_82609_l = (Direction[])Arrays.stream(field_199792_n).sorted(Comparator.comparingInt(direction -> direction.field_176748_g)).toArray(Direction[]::new);
        field_176754_o = (Direction[])Arrays.stream(field_199792_n).filter(direction -> direction.func_176740_k().func_176722_c()).sorted(Comparator.comparingInt(direction -> direction.field_176760_i)).toArray(Direction[]::new);
        field_218387_r = (Long2ObjectMap)Arrays.stream(field_199792_n).collect(Collectors.toMap(direction -> new BlockPos(direction.func_176730_m()).func_218275_a(), direction -> direction, (direction, direction2) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] field_209387_c;
        private final Axis[] field_209388_d;

        private Plane(Direction[] directionArray, Axis[] axisArray) {
            this.field_209387_c = directionArray;
            this.field_209388_d = axisArray;
        }

        public Direction func_179518_a(Random random) {
            return Util.func_240989_a_(this.field_209387_c, random);
        }

        @Override
        public boolean test(@Nullable Direction direction) {
            return direction != null && direction.func_176740_k().func_176716_d() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.field_209387_c);
        }

        public Stream<Direction> func_239636_a_() {
            return Arrays.stream(this.field_209387_c);
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((Direction)object);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int field_179528_c;
        private final String field_179525_d;

        private AxisDirection(int n2, String string2) {
            this.field_179528_c = n2;
            this.field_179525_d = string2;
        }

        public int func_179524_a() {
            return this.field_179528_c;
        }

        public String toString() {
            return this.field_179525_d;
        }

        public AxisDirection func_239635_c_() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Axis implements IStringSerializable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int func_196052_a(int n, int n2, int n3) {
                return n;
            }

            @Override
            public double func_196051_a(double d, double d2, double d3) {
                return d;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        }
        ,
        Y("y"){

            @Override
            public int func_196052_a(int n, int n2, int n3) {
                return n2;
            }

            @Override
            public double func_196051_a(double d, double d2, double d3) {
                return d2;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        }
        ,
        Z("z"){

            @Override
            public int func_196052_a(int n, int n2, int n3) {
                return n3;
            }

            @Override
            public double func_196051_a(double d, double d2, double d3) {
                return d3;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        };

        private static final Axis[] field_239633_e_;
        public static final Codec<Axis> field_239632_d_;
        private static final Map<String, Axis> field_176725_d;
        private final String field_176726_e;

        private Axis(String string2) {
            this.field_176726_e = string2;
        }

        @Nullable
        public static Axis func_176717_a(String string) {
            return field_176725_d.get(string.toLowerCase(Locale.ROOT));
        }

        public String func_176719_a() {
            return this.field_176726_e;
        }

        public boolean func_200128_b() {
            return this == Y;
        }

        public boolean func_176722_c() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.field_176726_e;
        }

        public static Axis func_239634_a_(Random random) {
            return Util.func_240989_a_(field_239633_e_, random);
        }

        @Override
        public boolean test(@Nullable Direction direction) {
            return direction != null && direction.func_176740_k() == this;
        }

        public Plane func_176716_d() {
            switch (this) {
                case X: 
                case Z: {
                    return Plane.HORIZONTAL;
                }
                case Y: {
                    return Plane.VERTICAL;
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        @Override
        public String func_176610_l() {
            return this.field_176726_e;
        }

        public abstract int func_196052_a(int var1, int var2, int var3);

        public abstract double func_196051_a(double var1, double var3, double var5);

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((Direction)object);
        }

        static {
            field_239633_e_ = Axis.values();
            field_239632_d_ = IStringSerializable.func_233023_a_(Axis::values, Axis::func_176717_a);
            field_176725_d = Arrays.stream(field_239633_e_).collect(Collectors.toMap(Axis::func_176719_a, axis -> axis));
        }
    }
}

