/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.concurrent;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import net.minecraft.util.concurrent.ITaskExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ThreadTaskExecutor<R extends Runnable>
implements ITaskExecutor<R>,
Executor {
    private final String field_213171_b;
    private static final Logger field_213172_c = LogManager.getLogger();
    private final Queue<R> field_213173_d = Queues.newConcurrentLinkedQueue();
    private int field_213174_e;

    protected ThreadTaskExecutor(String string) {
        this.field_213171_b = string;
    }

    protected abstract R func_212875_d_(Runnable var1);

    protected abstract boolean func_212874_c_(R var1);

    public boolean func_213162_bc() {
        return Thread.currentThread() == this.func_213170_ax();
    }

    protected abstract Thread func_213170_ax();

    protected boolean func_213164_aw() {
        return !this.func_213162_bc();
    }

    public int func_223704_be() {
        return this.field_213173_d.size();
    }

    @Override
    public String func_213142_bd() {
        return this.field_213171_b;
    }

    private CompletableFuture<Void> func_213165_a(Runnable runnable) {
        return CompletableFuture.supplyAsync(() -> {
            runnable.run();
            return null;
        }, this);
    }

    public CompletableFuture<Void> func_222817_e(Runnable runnable) {
        if (this.func_213164_aw()) {
            return this.func_213165_a(runnable);
        }
        runnable.run();
        return CompletableFuture.completedFuture(null);
    }

    public void func_213167_f(Runnable runnable) {
        if (!this.func_213162_bc()) {
            this.func_213165_a(runnable).join();
        } else {
            runnable.run();
        }
    }

    @Override
    public void func_212871_a_(R r) {
        this.field_213173_d.add(r);
        LockSupport.unpark(this.func_213170_ax());
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.func_213164_aw()) {
            this.func_212871_a_(this.func_212875_d_(runnable));
        } else {
            runnable.run();
        }
    }

    protected void func_213160_bf() {
        while (this.func_213168_p()) {
        }
    }

    protected boolean func_213168_p() {
        Runnable runnable = (Runnable)this.field_213173_d.peek();
        if (runnable == null) {
            return false;
        }
        if (this.field_213174_e == 0 && !this.func_212874_c_(runnable)) {
            return false;
        }
        this.func_213166_h((Runnable)this.field_213173_d.remove());
        return true;
    }

    public void func_213161_c(BooleanSupplier booleanSupplier) {
        ++this.field_213174_e;
        try {
            while (!booleanSupplier.getAsBoolean()) {
                if (this.func_213168_p()) continue;
                this.func_223705_bi();
            }
        }
        finally {
            --this.field_213174_e;
        }
    }

    protected void func_223705_bi() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void func_213166_h(R r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            field_213172_c.fatal("Error executing task on {}", (Object)this.func_213142_bd(), (Object)exception);
        }
    }

    @Override
    public /* synthetic */ void func_212871_a_(Object object) {
        this.func_212871_a_((R)((Runnable)object));
    }
}

