/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class RangeCodec {
    private static Function<Integer, DataResult<Integer>> func_232992_b_(int n, int n2) {
        return n3 -> {
            if (n3 >= n && n3 <= n2) {
                return DataResult.success((Object)n3);
            }
            return DataResult.error((String)("Value " + n3 + " outside of range [" + n + ":" + n2 + "]"), (Object)n3);
        };
    }

    public static Codec<Integer> func_232989_a_(int n, int n2) {
        Function<Integer, DataResult<Integer>> function = RangeCodec.func_232992_b_(n, n2);
        return Codec.INT.flatXmap(function, function);
    }

    private static Function<Double, DataResult<Double>> func_232991_b_(double d, double d2) {
        return d3 -> {
            if (d3 >= d && d3 <= d2) {
                return DataResult.success((Object)d3);
            }
            return DataResult.error((String)("Value " + d3 + " outside of range [" + d + ":" + d2 + "]"), (Object)d3);
        };
    }

    public static Codec<Double> func_232987_a_(double d, double d2) {
        Function<Double, DataResult<Double>> function = RangeCodec.func_232991_b_(d, d2);
        return Codec.DOUBLE.flatXmap(function, function);
    }

    public static <T> MapCodec<Pair<RegistryKey<T>, T>> func_241293_a_(RegistryKey<Registry<T>> registryKey, MapCodec<T> mapCodec) {
        return Codec.mapPair((MapCodec)ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(registryKey), RegistryKey::func_240901_a_).fieldOf("name"), mapCodec);
    }

    private static <A> MapCodec<A> func_241290_a_(final MapCodec<A> mapCodec, final ICodecModifier<A> iCodecModifier) {
        return new MapCodec<A>(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return mapCodec.keys(dynamicOps);
            }

            public <T> RecordBuilder<T> encode(A a, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                return iCodecModifier.func_241814_a(dynamicOps, a, mapCodec.encode(a, dynamicOps, recordBuilder));
            }

            public <T> DataResult<A> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return iCodecModifier.func_241812_a(dynamicOps, mapLike, mapCodec.decode(dynamicOps, mapLike));
            }

            public String toString() {
                return mapCodec + "[mapResult " + iCodecModifier + "]";
            }
        };
    }

    public static <A> MapCodec<A> func_241291_a_(MapCodec<A> mapCodec, final Consumer<String> consumer, final Supplier<? extends A> supplier) {
        return RangeCodec.func_241290_a_(mapCodec, new ICodecModifier<A>(){

            @Override
            public <T> DataResult<A> func_241812_a(DynamicOps<T> dynamicOps, MapLike<T> mapLike, DataResult<A> dataResult) {
                return DataResult.success(dataResult.resultOrPartial(consumer).orElseGet(supplier));
            }

            @Override
            public <T> RecordBuilder<T> func_241814_a(DynamicOps<T> dynamicOps, A a, RecordBuilder<T> recordBuilder) {
                return recordBuilder;
            }

            public String toString() {
                return "WithDefault[" + supplier.get() + "]";
            }
        });
    }

    public static <A> MapCodec<A> func_241292_a_(MapCodec<A> mapCodec, final Supplier<A> supplier) {
        return RangeCodec.func_241290_a_(mapCodec, new ICodecModifier<A>(){

            @Override
            public <T> DataResult<A> func_241812_a(DynamicOps<T> dynamicOps, MapLike<T> mapLike, DataResult<A> dataResult) {
                return dataResult.setPartial(supplier);
            }

            @Override
            public <T> RecordBuilder<T> func_241814_a(DynamicOps<T> dynamicOps, A a, RecordBuilder<T> recordBuilder) {
                return recordBuilder;
            }

            public String toString() {
                return "SetPartial[" + supplier + "]";
            }
        });
    }

    static interface ICodecModifier<A> {
        public <T> DataResult<A> func_241812_a(DynamicOps<T> var1, MapLike<T> var2, DataResult<A> var3);

        public <T> RecordBuilder<T> func_241814_a(DynamicOps<T> var1, A var2, RecordBuilder<T> var3);
    }
}

