/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DelegatingDynamicOps;
import net.minecraft.util.datafix.codec.RangeCodec;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSettingsImport<T>
extends DelegatingDynamicOps<T> {
    private static final Logger field_240870_b_ = LogManager.getLogger();
    private final IResourceManager field_240871_c_;
    private final IDynamicRegistries field_240872_d_;
    private final Map<RegistryKey<? extends Registry<?>>, ResultMap<?>> field_240873_e_ = Maps.newIdentityHashMap();

    public static <T> WorldSettingsImport<T> func_240876_a_(DynamicOps<T> dynamicOps, IResourceManager iResourceManager, IDynamicRegistries iDynamicRegistries) {
        return new WorldSettingsImport<T>(dynamicOps, iResourceManager, iDynamicRegistries);
    }

    private WorldSettingsImport(DynamicOps<T> dynamicOps, IResourceManager iResourceManager, IDynamicRegistries iDynamicRegistries) {
        super(dynamicOps);
        this.field_240871_c_ = iResourceManager;
        this.field_240872_d_ = iDynamicRegistries;
    }

    protected <E> DataResult<Pair<java.util.function.Supplier<E>, T>> func_241802_a_(T t, RegistryKey<Registry<E>> registryKey, MapCodec<E> mapCodec) {
        Optional<MutableRegistry<E>> optional = this.field_240872_d_.func_230521_a_(registryKey);
        if (!optional.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + registryKey));
        }
        MutableRegistry \u26032 = optional.get();
        DataResult \u26033 = ResourceLocation.field_240908_a_.decode(this.field_240857_a_, t);
        if (!\u26033.result().isPresent()) {
            return RangeCodec.func_241293_a_(registryKey, mapCodec).codec().decode(this.field_240857_a_, t).map(pair2 -> pair2.mapFirst(pair -> {
                \u26032.func_218381_a((RegistryKey)pair.getFirst(), pair.getSecond());
                \u26032.func_239662_d_((RegistryKey)pair.getFirst());
                return () -> ((Pair)pair).getSecond();
            }));
        }
        Pair \u26034 = (Pair)\u26033.result().get();
        ResourceLocation \u26035 = (ResourceLocation)\u26034.getFirst();
        return this.func_241805_a_(registryKey, \u26032, mapCodec, \u26035).map(supplier -> Pair.of((Object)supplier, (Object)\u26034.getSecond()));
    }

    public <E> DataResult<SimpleRegistry<E>> func_241797_a_(SimpleRegistry<E> simpleRegistry2, RegistryKey<Registry<E>> registryKey, MapCodec<E> mapCodec) {
        ResourceLocation resourceLocation = registryKey.func_240901_a_();
        Collection<ResourceLocation> \u26032 = this.field_240871_c_.func_230231_a_(resourceLocation, string -> string.endsWith(".json"));
        DataResult \u26033 = DataResult.success(simpleRegistry2, (Lifecycle)Lifecycle.stable());
        for (ResourceLocation resourceLocation2 : \u26032) {
            String string2 = resourceLocation2.func_110623_a();
            if (!string2.endsWith(".json")) {
                field_240870_b_.warn("Skipping resource {} since it is not a json file", (Object)resourceLocation2);
                continue;
            }
            if (!string2.startsWith(resourceLocation.func_110623_a() + "/")) {
                field_240870_b_.warn("Skipping resource {} since it does not have a registry name prefix", (Object)resourceLocation2);
                continue;
            }
            \u2603 = string2.substring(0, string2.length() - ".json".length()).substring(resourceLocation.func_110623_a().length() + 1);
            int \u26034 = \u2603.indexOf(47);
            if (\u26034 < 0) {
                field_240870_b_.warn("Skipping resource {} since it does not have a namespace", (Object)resourceLocation2);
                continue;
            }
            \u2603 = \u2603.substring(0, \u26034);
            \u2603 = \u2603.substring(\u26034 + 1);
            ResourceLocation \u26035 = new ResourceLocation(\u2603, \u2603);
            \u26033 = \u26033.flatMap(simpleRegistry -> this.func_241805_a_(registryKey, (MutableRegistry)simpleRegistry, mapCodec, \u26035).map(supplier -> simpleRegistry));
        }
        return \u26033.setPartial(simpleRegistry2);
    }

    private <E> DataResult<java.util.function.Supplier<E>> func_241805_a_(RegistryKey<Registry<E>> registryKey, MutableRegistry<E> mutableRegistry, MapCodec<E> mapCodec, ResourceLocation resourceLocation) {
        RegistryKey registryKey2 = RegistryKey.func_240903_a_(registryKey, resourceLocation);
        Object \u26032 = mutableRegistry.func_230516_a_(registryKey2);
        if (\u26032 != null) {
            return DataResult.success(() -> \u26032, (Lifecycle)Lifecycle.stable());
        }
        ResultMap<E> \u26033 = this.func_240884_a_(registryKey);
        DataResult \u26034 = (DataResult)((ResultMap)\u26033).field_240893_a_.get(registryKey2);
        if (\u26034 != null) {
            return \u26034;
        }
        Supplier \u26035 = Suppliers.memoize(() -> {
            Object t = mutableRegistry.func_230516_a_(registryKey2);
            if (t == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + registryKey2);
            }
            return t;
        });
        ((ResultMap)\u26033).field_240893_a_.put(registryKey2, DataResult.success((Object)\u26035));
        DataResult<E> \u26036 = this.func_241806_a_(registryKey, registryKey2, mapCodec);
        \u26036.result().ifPresent(object -> mutableRegistry.func_218381_a(registryKey2, object));
        DataResult \u26037 = \u26036.map(object -> () -> object);
        ((ResultMap)\u26033).field_240893_a_.put(registryKey2, \u26037);
        return \u26037;
    }

    /*
     * Exception decompiling
     */
    private <E> DataResult<E> func_241806_a_(RegistryKey<Registry<E>> \u2603, RegistryKey<E> \u2603, MapCodec<E> \u2603) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <E> ResultMap<E> func_240884_a_(RegistryKey<Registry<E>> registryKey2) {
        return this.field_240873_e_.computeIfAbsent(registryKey2, registryKey -> new ResultMap());
    }

    static final class ResultMap<E> {
        private final Map<RegistryKey<E>, DataResult<java.util.function.Supplier<E>>> field_240893_a_ = Maps.newIdentityHashMap();

        private ResultMap() {
        }
    }
}

