/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.SerializableTickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkSerializer {
    private static final Logger field_222658_a = LogManager.getLogger();

    public static ChunkPrimer func_222656_a(ServerWorld serverWorld, TemplateManager templateManager, PointOfInterestManager pointOfInterestManager, ChunkPos chunkPos, CompoundNBT compoundNBT) {
        ChunkPrimer \u260319;
        Object object;
        Object object2;
        ChunkGenerator chunkGenerator = serverWorld.func_72863_F().func_201711_g();
        BiomeProvider \u26032 = chunkGenerator.func_202090_b();
        CompoundNBT \u26033 = compoundNBT.func_74775_l("Level");
        ChunkPos \u26034 = new ChunkPos(\u26033.func_74762_e("xPos"), \u26033.func_74762_e("zPos"));
        if (!Objects.equals(chunkPos, \u26034)) {
            field_222658_a.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)chunkPos, (Object)chunkPos, (Object)\u26034);
        }
        BiomeContainer \u26035 = new BiomeContainer(chunkPos, \u26032, \u26033.func_150297_b("Biomes", 11) ? \u26033.func_74759_k("Biomes") : null);
        UpgradeData \u26036 = \u26033.func_150297_b("UpgradeData", 10) ? new UpgradeData(\u26033.func_74775_l("UpgradeData")) : UpgradeData.field_196994_a;
        ChunkPrimerTickList<Block> \u26037 = new ChunkPrimerTickList<Block>(block -> block == null || block.func_176223_P().func_196958_f(), chunkPos, \u26033.func_150295_c("ToBeTicked", 9));
        ChunkPrimerTickList<Fluid> \u26038 = new ChunkPrimerTickList<Fluid>(fluid -> fluid == null || fluid == Fluids.field_204541_a, chunkPos, \u26033.func_150295_c("LiquidsToBeTicked", 9));
        boolean \u26039 = \u26033.func_74767_n("isLightOn");
        ListNBT \u260310 = \u26033.func_150295_c("Sections", 10);
        int \u260311 = 16;
        ChunkSection[] \u260312 = new ChunkSection[16];
        boolean \u260313 = serverWorld.func_230315_m_().func_218272_d();
        ServerChunkProvider \u260314 = serverWorld.func_72863_F();
        WorldLightManager \u260315 = ((AbstractChunkProvider)\u260314).func_212863_j_();
        if (\u26039) {
            \u260315.func_223115_b(chunkPos, true);
        }
        for (int i = 0; i < \u260310.size(); ++i) {
            CompoundNBT compoundNBT2 = \u260310.func_150305_b(i);
            byte \u260316 = compoundNBT2.func_74771_c("Y");
            if (compoundNBT2.func_150297_b("Palette", 9) && compoundNBT2.func_150297_b("BlockStates", 12)) {
                object2 = new ChunkSection(\u260316 << 4);
                ((ChunkSection)object2).func_186049_g().func_222642_a(compoundNBT2.func_150295_c("Palette", 10), compoundNBT2.func_197645_o("BlockStates"));
                ((ChunkSection)object2).func_76672_e();
                if (!((ChunkSection)object2).func_76663_a()) {
                    \u260312[\u260316] = object2;
                }
                pointOfInterestManager.func_219139_a(chunkPos, (ChunkSection)object2);
            }
            if (!\u26039) continue;
            if (compoundNBT2.func_150297_b("BlockLight", 7)) {
                \u260315.func_215574_a(LightType.BLOCK, SectionPos.func_218156_a(chunkPos, \u260316), new NibbleArray(compoundNBT2.func_74770_j("BlockLight")), true);
            }
            if (!\u260313 || !compoundNBT2.func_150297_b("SkyLight", 7)) continue;
            \u260315.func_215574_a(LightType.SKY, SectionPos.func_218156_a(chunkPos, \u260316), new NibbleArray(compoundNBT2.func_74770_j("SkyLight")), true);
        }
        long l = \u26033.func_74763_f("InhabitedTime");
        ChunkStatus.Type \u260317 = ChunkSerializer.func_222651_a(compoundNBT);
        if (\u260317 == ChunkStatus.Type.LEVELCHUNK) {
            ChunkPrimerTickList<Fluid> \u260318;
            ChunkPrimerTickList<Block> iTickList;
            if (\u26033.func_150297_b("TileTicks", 9)) {
                object = SerializableTickList.func_222984_a(\u26033.func_150295_c("TileTicks", 10), Registry.field_212618_g::func_177774_c, Registry.field_212618_g::func_82594_a);
            } else {
                iTickList = \u26037;
            }
            if (\u26033.func_150297_b("LiquidTicks", 9)) {
                Object object3 = SerializableTickList.func_222984_a(\u26033.func_150295_c("LiquidTicks", 10), Registry.field_212619_h::func_177774_c, Registry.field_212619_h::func_82594_a);
            } else {
                \u260318 = \u26038;
            }
            object2 = new Chunk(serverWorld.func_201672_e(), chunkPos, \u26035, \u26036, iTickList, \u260318, l, \u260312, chunk -> ChunkSerializer.func_222650_a(\u26033, chunk));
        } else {
            object = new ChunkPrimer(chunkPos, \u26036, \u260312, \u26037, \u26038);
            ((ChunkPrimer)object).func_225548_a_(\u26035);
            \u260319 = object;
            \u260319.func_177415_c(l);
            ((ChunkPrimer)object).func_201574_a(ChunkStatus.func_222591_a(\u26033.func_74779_i("Status")));
            if (\u260319.func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
                ((ChunkPrimer)object).func_217306_a(\u260315);
            }
            if (!\u26039 && \u260319.func_201589_g().func_209003_a(ChunkStatus.field_222614_j)) {
                for (BlockPos blockPos : BlockPos.func_191531_b(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d(), chunkPos.func_180332_e(), 255, chunkPos.func_180330_f())) {
                    if (\u260319.func_180495_p(blockPos).func_185906_d() == 0) continue;
                    ((ChunkPrimer)object).func_201637_h(blockPos);
                }
            }
        }
        \u260319.func_217305_b(\u26039);
        object = \u26033.func_74775_l("Heightmaps");
        object3 = EnumSet.noneOf(Heightmap.Type.class);
        for (Heightmap.Type type : \u260319.func_201589_g().func_222595_h()) {
            String string = type.func_203500_b();
            if (((CompoundNBT)object).func_150297_b(string, 12)) {
                \u260319.func_201607_a(type, ((CompoundNBT)object).func_197645_o(string));
                continue;
            }
            ((AbstractCollection)object3).add(type);
        }
        Heightmap.func_222690_a(\u260319, (Set<Heightmap.Type>)object3);
        CompoundNBT compoundNBT2 = \u26033.func_74775_l("Structures");
        \u260319.func_201612_a(ChunkSerializer.func_235967_a_(templateManager, compoundNBT2, serverWorld.func_72905_C()));
        \u260319.func_201606_b(ChunkSerializer.func_227075_a_(chunkPos, compoundNBT2));
        if (\u26033.func_74767_n("shouldSave")) {
            \u260319.func_177427_f(true);
        }
        ListNBT listNBT = \u26033.func_150295_c("PostProcessing", 9);
        for (int i = 0; i < listNBT.size(); ++i) {
            ListNBT \u260320 = listNBT.func_202169_e(i);
            for (int n = 0; n < \u260320.size(); ++n) {
                \u260319.func_201636_b(\u260320.func_202170_f(n), i);
            }
        }
        if (\u260317 == ChunkStatus.Type.LEVELCHUNK) {
            return new ChunkPrimerWrapper((Chunk)((Object)\u260319));
        }
        ChunkPrimer chunkPrimer = \u260319;
        ListNBT \u260321 = \u26033.func_150295_c("Entities", 10);
        for (int i = 0; i < \u260321.size(); ++i) {
            chunkPrimer.func_201626_b(\u260321.func_150305_b(i));
        }
        ListNBT listNBT2 = \u26033.func_150295_c("TileEntities", 10);
        for (int i = 0; i < listNBT2.size(); ++i) {
            CompoundNBT compoundNBT3 = listNBT2.func_150305_b(i);
            \u260319.func_201591_a(compoundNBT3);
        }
        ListNBT listNBT22 = \u26033.func_150295_c("Lights", 9);
        for (int i = 0; i < listNBT22.size(); ++i) {
            ListNBT listNBT3 = listNBT22.func_202169_e(i);
            for (int j = 0; j < listNBT3.size(); ++j) {
                chunkPrimer.func_201646_a(listNBT3.func_202170_f(j), i);
            }
        }
        CompoundNBT compoundNBT4 = \u26033.func_74775_l("CarvingMasks");
        for (String string : compoundNBT4.func_150296_c()) {
            GenerationStage.Carving carving = GenerationStage.Carving.valueOf(string);
            chunkPrimer.func_205767_a(carving, BitSet.valueOf(compoundNBT4.func_74770_j(string)));
        }
        return chunkPrimer;
    }

    public static CompoundNBT func_222645_a(ServerWorld serverWorld, IChunk iChunk2) {
        CompoundNBT compoundNBT;
        BiomeContainer biomeContainer;
        ChunkPos chunkPos = iChunk2.func_76632_l();
        CompoundNBT \u26032 = new CompoundNBT();
        CompoundNBT \u26033 = new CompoundNBT();
        \u26032.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        \u26032.func_218657_a("Level", \u26033);
        \u26033.func_74768_a("xPos", chunkPos.field_77276_a);
        \u26033.func_74768_a("zPos", chunkPos.field_77275_b);
        \u26033.func_74772_a("LastUpdate", serverWorld.func_82737_E());
        \u26033.func_74772_a("InhabitedTime", iChunk2.func_177416_w());
        \u26033.func_74778_a("Status", iChunk2.func_201589_g().func_222596_d());
        UpgradeData \u26034 = iChunk2.func_196966_y();
        if (!\u26034.func_196988_a()) {
            \u26033.func_218657_a("UpgradeData", \u26034.func_196992_b());
        }
        ChunkSection[] \u26035 = iChunk2.func_76587_i();
        ListNBT \u26036 = new ListNBT();
        ServerWorldLightManager \u26037 = serverWorld.func_72863_F().func_212863_j_();
        boolean \u26038 = iChunk2.func_217310_r();
        for (int i = -1; i < 17; ++i) {
            int n = i;
            ChunkSection object2 = Arrays.stream(\u26035).filter(chunkSection -> chunkSection != null && chunkSection.func_222632_g() >> 4 == n).findFirst().orElse(Chunk.field_186036_a);
            NibbleArray nibbleArray = \u26037.func_215569_a(LightType.BLOCK).func_215612_a(SectionPos.func_218156_a(chunkPos, n));
            NibbleArray \u260311 = \u26037.func_215569_a(LightType.SKY).func_215612_a(SectionPos.func_218156_a(chunkPos, n));
            if (object2 == Chunk.field_186036_a && nibbleArray == null && \u260311 == null) continue;
            GenerationStage.Carving[] object = new CompoundNBT();
            object.func_74774_a("Y", (byte)(n & 0xFF));
            if (object2 != Chunk.field_186036_a) {
                object2.func_186049_g().func_196963_b((CompoundNBT)object, "Palette", "BlockStates");
            }
            if (nibbleArray != null && !nibbleArray.func_215655_c()) {
                object.func_74773_a("BlockLight", nibbleArray.func_177481_a());
            }
            if (\u260311 != null && !\u260311.func_215655_c()) {
                object.func_74773_a("SkyLight", \u260311.func_177481_a());
            }
            \u26036.add(object);
        }
        \u26033.func_218657_a("Sections", \u26036);
        if (\u26038) {
            \u26033.func_74757_a("isLightOn", true);
        }
        if ((biomeContainer = iChunk2.func_225549_i_()) != null) {
            \u26033.func_74783_a("Biomes", biomeContainer.func_227055_a_());
        }
        ListNBT \u26039 = new ListNBT();
        for (BlockPos blockPos : iChunk2.func_203066_o()) {
            compoundNBT = iChunk2.func_223134_j(blockPos);
            if (compoundNBT == null) continue;
            \u26039.add(compoundNBT);
        }
        \u26033.func_218657_a("TileEntities", \u26039);
        ListNBT listNBT = new ListNBT();
        if (iChunk2.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
            Chunk chunk = (Chunk)iChunk2;
            chunk.func_177409_g(false);
            for (int i = 0; i < chunk.func_177429_s().length; ++i) {
                for (Entity entity : chunk.func_177429_s()[i]) {
                    if (!entity.func_70039_c(\u2603 = new CompoundNBT())) continue;
                    chunk.func_177409_g(true);
                    listNBT.add(\u2603);
                }
            }
        } else {
            ChunkPrimer chunkPrimer = (ChunkPrimer)iChunk2;
            listNBT.addAll(chunkPrimer.func_201652_l());
            \u26033.func_218657_a("Lights", ChunkSerializer.func_222647_a(chunkPrimer.func_201647_i()));
            compoundNBT = new CompoundNBT();
            for (GenerationStage.Carving carving : GenerationStage.Carving.values()) {
                BitSet bitSet = chunkPrimer.func_205749_a(carving);
                if (bitSet == null) continue;
                compoundNBT.func_74773_a(carving.toString(), bitSet.toByteArray());
            }
            \u26033.func_218657_a("CarvingMasks", compoundNBT);
        }
        \u26033.func_218657_a("Entities", listNBT);
        ITickList<Block> iTickList = iChunk2.func_205218_i_();
        if (iTickList instanceof ChunkPrimerTickList) {
            \u26033.func_218657_a("ToBeTicked", ((ChunkPrimerTickList)iTickList).func_205379_a());
        } else if (iTickList instanceof SerializableTickList) {
            \u26033.func_218657_a("TileTicks", ((SerializableTickList)iTickList).func_234857_b_());
        } else {
            \u26033.func_218657_a("TileTicks", ((ServerTickList)serverWorld.func_205220_G_()).func_219503_a(chunkPos));
        }
        ITickList<Fluid> \u260312 = iChunk2.func_212247_j();
        if (\u260312 instanceof ChunkPrimerTickList) {
            \u26033.func_218657_a("LiquidsToBeTicked", ((ChunkPrimerTickList)\u260312).func_205379_a());
        } else if (\u260312 instanceof SerializableTickList) {
            \u26033.func_218657_a("LiquidTicks", ((SerializableTickList)\u260312).func_234857_b_());
        } else {
            \u26033.func_218657_a("LiquidTicks", ((ServerTickList)serverWorld.func_205219_F_()).func_219503_a(chunkPos));
        }
        \u26033.func_218657_a("PostProcessing", ChunkSerializer.func_222647_a(iChunk2.func_201614_D()));
        CompoundNBT \u260310 = new CompoundNBT();
        for (Map.Entry<Heightmap.Type, Heightmap> entry : iChunk2.func_217311_f()) {
            if (!iChunk2.func_201589_g().func_222595_h().contains(entry.getKey())) continue;
            \u260310.func_218657_a(entry.getKey().func_203500_b(), new LongArrayNBT(entry.getValue().func_202269_a()));
        }
        \u26033.func_218657_a("Heightmaps", \u260310);
        \u26033.func_218657_a("Structures", ChunkSerializer.func_222649_a(chunkPos, iChunk2.func_201609_c(), iChunk2.func_201604_d()));
        return \u26032;
    }

    public static ChunkStatus.Type func_222651_a(@Nullable CompoundNBT compoundNBT) {
        if (compoundNBT != null && (\u2603 = ChunkStatus.func_222591_a(compoundNBT.func_74775_l("Level").func_74779_i("Status"))) != null) {
            return \u2603.func_202129_d();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    private static void func_222650_a(CompoundNBT compoundNBT2, Chunk chunk) {
        CompoundNBT compoundNBT2;
        ListNBT listNBT = compoundNBT2.func_150295_c("Entities", 10);
        World \u26032 = chunk.func_177412_p();
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT3 = listNBT.func_150305_b(i);
            EntityType.func_220335_a(compoundNBT3, \u26032, entity -> {
                chunk.func_76612_a((Entity)entity);
                return entity;
            });
            chunk.func_177409_g(true);
        }
        ListNBT \u26033 = compoundNBT2.func_150295_c("TileEntities", 10);
        for (int i = 0; i < \u26033.size(); ++i) {
            CompoundNBT compoundNBT4 = \u26033.func_150305_b(i);
            boolean \u26034 = compoundNBT4.func_74767_n("keepPacked");
            if (\u26034) {
                chunk.func_201591_a(compoundNBT4);
                continue;
            }
            BlockPos \u26035 = new BlockPos(compoundNBT4.func_74762_e("x"), compoundNBT4.func_74762_e("y"), compoundNBT4.func_74762_e("z"));
            TileEntity \u26036 = TileEntity.func_235657_b_(chunk.func_180495_p(\u26035), compoundNBT4);
            if (\u26036 == null) continue;
            chunk.func_150813_a(\u26036);
        }
    }

    private static CompoundNBT func_222649_a(ChunkPos chunkPos, Map<Structure<?>, StructureStart<?>> map, Map<Structure<?>, LongSet> map2) {
        CompoundNBT compoundNBT = new CompoundNBT();
        \u2603 = new CompoundNBT();
        for (Map.Entry<Structure<?>, StructureStart<?>> entry : map.entrySet()) {
            \u2603.func_218657_a(entry.getKey().func_143025_a(), entry.getValue().func_143021_a(chunkPos.field_77276_a, chunkPos.field_77275_b));
        }
        compoundNBT.func_218657_a("Starts", \u2603);
        \u2603 = new CompoundNBT();
        for (Map.Entry<Structure<?>, LongSet> entry : map2.entrySet()) {
            \u2603.func_218657_a(entry.getKey().func_143025_a(), new LongArrayNBT(entry.getValue()));
        }
        compoundNBT.func_218657_a("References", \u2603);
        return compoundNBT;
    }

    private static Map<Structure<?>, StructureStart<?>> func_235967_a_(TemplateManager templateManager, CompoundNBT compoundNBT, long l) {
        HashMap hashMap = Maps.newHashMap();
        CompoundNBT \u26032 = compoundNBT.func_74775_l("Starts");
        for (String string : \u26032.func_150296_c()) {
            \u2603 = string.toLowerCase(Locale.ROOT);
            Structure structure = (Structure)Structure.field_236365_a_.get((Object)\u2603);
            if (structure == null) {
                field_222658_a.error("Unknown structure start: {}", (Object)\u2603);
                continue;
            }
            StructureStart<?> \u26033 = Structure.func_236393_a_(templateManager, \u26032.func_74775_l(string), l);
            if (\u26033 == null) continue;
            hashMap.put(structure, \u26033);
        }
        return hashMap;
    }

    private static Map<Structure<?>, LongSet> func_227075_a_(ChunkPos chunkPos, CompoundNBT compoundNBT) {
        HashMap hashMap = Maps.newHashMap();
        CompoundNBT \u26032 = compoundNBT.func_74775_l("References");
        for (String string : \u26032.func_150296_c()) {
            hashMap.put(Structure.field_236365_a_.get((Object)string.toLowerCase(Locale.ROOT)), new LongOpenHashSet(Arrays.stream(\u26032.func_197645_o(string)).filter(l -> {
                ChunkPos chunkPos2 = new ChunkPos(l);
                if (chunkPos2.func_226661_a_(chunkPos) > 8) {
                    field_222658_a.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", (Object)string, (Object)chunkPos2, (Object)chunkPos);
                    return false;
                }
                return true;
            }).toArray()));
        }
        return hashMap;
    }

    public static ListNBT func_222647_a(ShortList[] shortListArray) {
        ListNBT listNBT = new ListNBT();
        for (ShortList shortList : shortListArray) {
            ListNBT listNBT2 = new ListNBT();
            if (shortList != null) {
                for (Short s : shortList) {
                    listNBT2.add(ShortNBT.func_229701_a_(s));
                }
            }
            listNBT.add(listNBT2);
        }
        return listNBT;
    }
}

