/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.codec.RangeCodec;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public final class DimensionSettings {
    public static final Codec<DimensionSettings> field_236097_a_ = RecordCodecBuilder.create(instance -> instance.group((App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(DimensionSettings::func_236108_a_), (App)NoiseSettings.field_236156_a_.fieldOf("noise").forGetter(DimensionSettings::func_236113_b_), (App)BlockState.field_235877_b_.fieldOf("default_block").forGetter(DimensionSettings::func_236115_c_), (App)BlockState.field_235877_b_.fieldOf("default_fluid").forGetter(DimensionSettings::func_236116_d_), (App)RangeCodec.func_232989_a_(-20, 276).fieldOf("bedrock_roof_position").forGetter(DimensionSettings::func_236117_e_), (App)RangeCodec.func_232989_a_(-20, 276).fieldOf("bedrock_floor_position").forGetter(DimensionSettings::func_236118_f_), (App)RangeCodec.func_232989_a_(0, 255).fieldOf("sea_level").forGetter(DimensionSettings::func_236119_g_), (App)Codec.BOOL.fieldOf("disable_mob_generation").forGetter(DimensionSettings::func_236120_h_)).apply((Applicative)instance, DimensionSettings::new));
    public static final Codec<DimensionSettings> field_236098_b_ = Codec.either(Preset.field_236121_a_, field_236097_a_).xmap(either -> (DimensionSettings)either.map(Preset::func_236137_b_, Function.identity()), dimensionSettings -> dimensionSettings.field_236107_k_.map(Either::left).orElseGet(() -> Either.right((Object)dimensionSettings)));
    private final DimensionStructuresSettings field_236099_c_;
    private final NoiseSettings field_236100_d_;
    private final BlockState field_236101_e_;
    private final BlockState field_236102_f_;
    private final int field_236103_g_;
    private final int field_236104_h_;
    private final int field_236105_i_;
    private final boolean field_236106_j_;
    private final Optional<Preset> field_236107_k_;

    private DimensionSettings(DimensionStructuresSettings dimensionStructuresSettings, NoiseSettings noiseSettings, BlockState blockState, BlockState blockState2, int n, int n2, int n3, boolean bl) {
        this(dimensionStructuresSettings, noiseSettings, blockState, blockState2, n, n2, n3, bl, Optional.empty());
    }

    private DimensionSettings(DimensionStructuresSettings dimensionStructuresSettings, NoiseSettings noiseSettings, BlockState blockState, BlockState blockState2, int n, int n2, int n3, boolean bl, Optional<Preset> optional) {
        this.field_236099_c_ = dimensionStructuresSettings;
        this.field_236100_d_ = noiseSettings;
        this.field_236101_e_ = blockState;
        this.field_236102_f_ = blockState2;
        this.field_236103_g_ = n;
        this.field_236104_h_ = n2;
        this.field_236105_i_ = n3;
        this.field_236106_j_ = bl;
        this.field_236107_k_ = optional;
    }

    public DimensionStructuresSettings func_236108_a_() {
        return this.field_236099_c_;
    }

    public NoiseSettings func_236113_b_() {
        return this.field_236100_d_;
    }

    public BlockState func_236115_c_() {
        return this.field_236101_e_;
    }

    public BlockState func_236116_d_() {
        return this.field_236102_f_;
    }

    public int func_236117_e_() {
        return this.field_236103_g_;
    }

    public int func_236118_f_() {
        return this.field_236104_h_;
    }

    public int func_236119_g_() {
        return this.field_236105_i_;
    }

    @Deprecated
    protected boolean func_236120_h_() {
        return this.field_236106_j_;
    }

    public boolean func_236109_a_(Preset preset) {
        return Objects.equals(this.field_236107_k_, Optional.of(preset));
    }

    public static class Preset {
        private static final Map<ResourceLocation, Preset> field_236128_h_ = Maps.newHashMap();
        public static final Codec<Preset> field_236121_a_ = ResourceLocation.field_240908_a_.flatXmap(resourceLocation -> Optional.ofNullable(field_236128_h_.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + resourceLocation))), preset -> DataResult.success((Object)preset.field_236130_j_)).stable();
        public static final Preset field_236122_b_ = new Preset("overworld", preset -> Preset.func_236135_a_(new DimensionStructuresSettings(true), false, preset));
        public static final Preset field_236123_c_ = new Preset("amplified", preset -> Preset.func_236135_a_(new DimensionStructuresSettings(true), true, preset));
        public static final Preset field_236124_d_ = new Preset("nether", preset -> Preset.func_236133_a_(new DimensionStructuresSettings(false), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150353_l.func_176223_P(), preset));
        public static final Preset field_236125_e_ = new Preset("end", preset -> Preset.func_236134_a_(new DimensionStructuresSettings(false), Blocks.field_150377_bs.func_176223_P(), Blocks.field_150350_a.func_176223_P(), preset, true, true));
        public static final Preset field_236126_f_ = new Preset("caves", preset -> Preset.func_236133_a_(new DimensionStructuresSettings(false), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), preset));
        public static final Preset field_236127_g_ = new Preset("floating_islands", preset -> Preset.func_236134_a_(new DimensionStructuresSettings(false), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), preset, false, false));
        private final ITextComponent field_236129_i_;
        private final ResourceLocation field_236130_j_;
        private final DimensionSettings field_236131_k_;

        public Preset(String string, Function<Preset, DimensionSettings> function) {
            this.field_236130_j_ = new ResourceLocation(string);
            this.field_236129_i_ = new TranslationTextComponent("generator.noise." + string);
            this.field_236131_k_ = function.apply(this);
            field_236128_h_.put(this.field_236130_j_, this);
        }

        public DimensionSettings func_236137_b_() {
            return this.field_236131_k_;
        }

        private static DimensionSettings func_236134_a_(DimensionStructuresSettings dimensionStructuresSettings, BlockState blockState, BlockState blockState2, Preset preset, boolean bl, boolean bl2) {
            return new DimensionSettings(dimensionStructuresSettings, new NoiseSettings(128, new ScalingSettings(2.0, 1.0, 80.0, 160.0), new SlideSettings(-3000, 64, -46), new SlideSettings(-30, 7, 1), 2, 1, 0.0, 0.0, true, false, bl2, false), blockState, blockState2, -10, -10, 0, bl, Optional.of(preset));
        }

        private static DimensionSettings func_236133_a_(DimensionStructuresSettings dimensionStructuresSettings, BlockState blockState, BlockState blockState2, Preset preset) {
            HashMap hashMap = Maps.newHashMap(DimensionStructuresSettings.field_236191_b_);
            hashMap.put(Structure.field_236372_h_, new StructureSeparationSettings(25, 10, 34222645));
            return new DimensionSettings(new DimensionStructuresSettings(Optional.ofNullable(dimensionStructuresSettings.func_236199_b_()), hashMap), new NoiseSettings(128, new ScalingSettings(1.0, 3.0, 80.0, 60.0), new SlideSettings(120, 3, 0), new SlideSettings(320, 4, -1), 1, 2, 0.0, 0.019921875, false, false, false, false), blockState, blockState2, 0, 0, 32, false, Optional.of(preset));
        }

        private static DimensionSettings func_236135_a_(DimensionStructuresSettings dimensionStructuresSettings, boolean bl, Preset preset) {
            double d = 0.9999999814507745;
            return new DimensionSettings(dimensionStructuresSettings, new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, bl), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), -10, 0, 63, false, Optional.of(preset));
        }
    }
}

