/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;

public class OctavesNoiseGenerator
implements INoiseGenerator {
    private final ImprovedNoiseGenerator[] field_76307_a;
    private final double field_227460_b_;
    private final double field_227461_c_;

    public OctavesNoiseGenerator(SharedSeedRandom sharedSeedRandom, IntStream intStream) {
        this(sharedSeedRandom, (List)intStream.boxed().collect(ImmutableList.toImmutableList()));
    }

    public OctavesNoiseGenerator(SharedSeedRandom sharedSeedRandom, List<Integer> list) {
        this(sharedSeedRandom, (IntSortedSet)new IntRBTreeSet(list));
    }

    private OctavesNoiseGenerator(SharedSeedRandom sharedSeedRandom, IntSortedSet intSortedSet) {
        int n;
        if (intSortedSet.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int n2 = -intSortedSet.firstInt();
        \u2603 = n2 + (n = intSortedSet.lastInt()) + 1;
        if (\u2603 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        ImprovedNoiseGenerator \u26032 = new ImprovedNoiseGenerator(sharedSeedRandom);
        \u2603 = n;
        this.field_76307_a = new ImprovedNoiseGenerator[\u2603];
        if (\u2603 >= 0 && \u2603 < \u2603 && intSortedSet.contains(0)) {
            this.field_76307_a[\u2603] = \u26032;
        }
        for (\u2603 = \u2603 + 1; \u2603 < \u2603; ++\u2603) {
            if (\u2603 >= 0 && intSortedSet.contains(\u2603 - \u2603)) {
                this.field_76307_a[\u2603] = new ImprovedNoiseGenerator(sharedSeedRandom);
                continue;
            }
            sharedSeedRandom.func_202423_a(262);
        }
        if (n > 0) {
            long l = (long)(\u26032.func_215456_a(0.0, 0.0, 0.0, 0.0, 0.0) * 9.223372036854776E18);
            SharedSeedRandom \u26033 = new SharedSeedRandom(l);
            for (int i = \u2603 - 1; i >= 0; --i) {
                if (i < \u2603 && intSortedSet.contains(\u2603 - i)) {
                    this.field_76307_a[i] = new ImprovedNoiseGenerator(\u26033);
                    continue;
                }
                \u26033.func_202423_a(262);
            }
        }
        this.field_227461_c_ = Math.pow(2.0, n);
        this.field_227460_b_ = 1.0 / (Math.pow(2.0, \u2603) - 1.0);
    }

    public double func_205563_a(double d, double d2, double d3) {
        return this.func_215462_a(d, d2, d3, 0.0, 0.0, false);
    }

    public double func_215462_a(double d, double d2, double d3, double d4, double d5, boolean bl) {
        double d6 = 0.0;
        \u2603 = this.field_227461_c_;
        \u2603 = this.field_227460_b_;
        for (ImprovedNoiseGenerator improvedNoiseGenerator : this.field_76307_a) {
            if (improvedNoiseGenerator != null) {
                d6 += improvedNoiseGenerator.func_215456_a(OctavesNoiseGenerator.func_215461_a(d * \u2603), bl ? -improvedNoiseGenerator.field_76313_b : OctavesNoiseGenerator.func_215461_a(d2 * \u2603), OctavesNoiseGenerator.func_215461_a(d3 * \u2603), d4 * \u2603, d5 * \u2603) * \u2603;
            }
            \u2603 /= 2.0;
            \u2603 *= 2.0;
        }
        return d6;
    }

    @Nullable
    public ImprovedNoiseGenerator func_215463_a(int n) {
        return this.field_76307_a[n];
    }

    public static double func_215461_a(double d) {
        return d - (double)MathHelper.func_76124_d(d / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    @Override
    public double func_215460_a(double d, double d2, double d3, double d4) {
        return this.func_215462_a(d, d2, 0.0, d3, d4, false);
    }
}

