/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BasaltDeltasFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class BasaltDeltasStructure
extends Feature<BasaltDeltasFeature> {
    private static final ImmutableList<Block> field_236274_a_ = ImmutableList.of((Object)Blocks.field_150357_h, (Object)Blocks.field_196653_dH, (Object)Blocks.field_150386_bk, (Object)Blocks.field_150387_bl, (Object)Blocks.field_150388_bm, (Object)Blocks.field_150486_ae, (Object)Blocks.field_150474_ac);
    private static final Direction[] field_236275_ac_ = Direction.values();

    private static int func_236278_a_(Random random, BasaltDeltasFeature basaltDeltasFeature) {
        return basaltDeltasFeature.field_236498_d_ + random.nextInt(basaltDeltasFeature.field_236499_e_ - basaltDeltasFeature.field_236498_d_ + 1);
    }

    private static int func_236279_b_(Random random, BasaltDeltasFeature basaltDeltasFeature) {
        return random.nextInt(basaltDeltasFeature.field_236500_f_ + 1);
    }

    public BasaltDeltasStructure(Codec<BasaltDeltasFeature> codec) {
        super(codec);
    }

    @Override
    public boolean func_230362_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, BasaltDeltasFeature basaltDeltasFeature) {
        BlockPos blockPos2 = BasaltDeltasStructure.func_236276_a_(iSeedReader, blockPos.func_239590_i_().func_239620_a_(Direction.Axis.Y, 1, iSeedReader.func_217301_I() - 1));
        if (blockPos2 == null) {
            return false;
        }
        boolean \u26032 = false;
        boolean \u26033 = random.nextDouble() < 0.9;
        int \u26034 = \u26033 ? BasaltDeltasStructure.func_236279_b_(random, basaltDeltasFeature) : 0;
        int \u26035 = \u26033 ? BasaltDeltasStructure.func_236279_b_(random, basaltDeltasFeature) : 0;
        boolean \u26036 = \u26033 && \u26034 != 0 && \u26035 != 0;
        int \u26037 = BasaltDeltasStructure.func_236278_a_(random, basaltDeltasFeature);
        int \u26038 = BasaltDeltasStructure.func_236278_a_(random, basaltDeltasFeature);
        int \u26039 = Math.max(\u26037, \u26038);
        for (BlockPos blockPos3 : BlockPos.func_239583_a_(blockPos2, \u26037, 0, \u26038)) {
            if (blockPos3.func_218139_n(blockPos2) > \u26039) break;
            if (!BasaltDeltasStructure.func_236277_a_(iSeedReader, blockPos3, basaltDeltasFeature)) continue;
            if (\u26036) {
                \u26032 = true;
                this.func_230367_a_(iSeedReader, blockPos3, basaltDeltasFeature.field_236497_c_);
            }
            if (!BasaltDeltasStructure.func_236277_a_(iSeedReader, \u2603 = blockPos3.func_177982_a(\u26034, 0, \u26035), basaltDeltasFeature)) continue;
            \u26032 = true;
            this.func_230367_a_(iSeedReader, \u2603, basaltDeltasFeature.field_236496_b_);
        }
        return \u26032;
    }

    private static boolean func_236277_a_(IWorld iWorld, BlockPos blockPos, BasaltDeltasFeature basaltDeltasFeature) {
        BlockState blockState = iWorld.func_180495_p(blockPos);
        if (blockState.func_203425_a(basaltDeltasFeature.field_236496_b_.func_177230_c())) {
            return false;
        }
        if (field_236274_a_.contains((Object)blockState.func_177230_c())) {
            return false;
        }
        for (Direction direction : field_236275_ac_) {
            boolean bl = iWorld.func_180495_p(blockPos.func_177972_a(direction)).func_196958_f();
            if ((!bl || direction == Direction.UP) && (bl || direction != Direction.UP)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static BlockPos func_236276_a_(IWorld iWorld, BlockPos.Mutable mutable2) {
        while (mutable2.func_177956_o() > 1) {
            BlockPos.Mutable mutable2;
            if (iWorld.func_180495_p(mutable2).func_196958_f()) {
                BlockState blockState = iWorld.func_180495_p(mutable2.func_189536_c(Direction.DOWN));
                mutable2.func_189536_c(Direction.UP);
                if (!(blockState.func_203425_a(Blocks.field_150353_l) || blockState.func_203425_a(Blocks.field_150357_h) || blockState.func_196958_f())) {
                    return mutable2;
                }
            }
            mutable2.func_189536_c(Direction.DOWN);
        }
        return null;
    }
}

