/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OceanMonumentPieces {

    static class YZDoubleRoomFitHelper
    implements IMonumentRoomFitHelper {
        private YZDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition roomDefinition) {
            if (roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()] && !roomDefinition.field_175965_b[Direction.NORTH.func_176745_a()].field_175963_d && roomDefinition.field_175966_c[Direction.UP.func_176745_a()] && !roomDefinition.field_175965_b[Direction.UP.func_176745_a()].field_175963_d) {
                \u2603 = roomDefinition.field_175965_b[Direction.NORTH.func_176745_a()];
                return \u2603.field_175966_c[Direction.UP.func_176745_a()] && !\u2603.field_175965_b[Direction.UP.func_176745_a()].field_175963_d;
            }
            return false;
        }

        @Override
        public Piece func_175968_a(Direction direction, RoomDefinition roomDefinition, Random random) {
            roomDefinition.field_175963_d = true;
            roomDefinition.field_175965_b[Direction.NORTH.func_176745_a()].field_175963_d = true;
            roomDefinition.field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            roomDefinition.field_175965_b[Direction.NORTH.func_176745_a()].field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            return new DoubleYZRoom(direction, roomDefinition);
        }
    }

    static class XYDoubleRoomFitHelper
    implements IMonumentRoomFitHelper {
        private XYDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition roomDefinition) {
            if (roomDefinition.field_175966_c[Direction.EAST.func_176745_a()] && !roomDefinition.field_175965_b[Direction.EAST.func_176745_a()].field_175963_d && roomDefinition.field_175966_c[Direction.UP.func_176745_a()] && !roomDefinition.field_175965_b[Direction.UP.func_176745_a()].field_175963_d) {
                \u2603 = roomDefinition.field_175965_b[Direction.EAST.func_176745_a()];
                return \u2603.field_175966_c[Direction.UP.func_176745_a()] && !\u2603.field_175965_b[Direction.UP.func_176745_a()].field_175963_d;
            }
            return false;
        }

        @Override
        public Piece func_175968_a(Direction direction, RoomDefinition roomDefinition, Random random) {
            roomDefinition.field_175963_d = true;
            roomDefinition.field_175965_b[Direction.EAST.func_176745_a()].field_175963_d = true;
            roomDefinition.field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            roomDefinition.field_175965_b[Direction.EAST.func_176745_a()].field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            return new DoubleXYRoom(direction, roomDefinition);
        }
    }

    static class ZDoubleRoomFitHelper
    implements IMonumentRoomFitHelper {
        private ZDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition roomDefinition) {
            return roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()] && !roomDefinition.field_175965_b[Direction.NORTH.func_176745_a()].field_175963_d;
        }

        @Override
        public Piece func_175968_a(Direction direction, RoomDefinition roomDefinition, Random random) {
            RoomDefinition roomDefinition2 = roomDefinition;
            if (!roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()] || roomDefinition.field_175965_b[Direction.NORTH.func_176745_a()].field_175963_d) {
                roomDefinition2 = roomDefinition.field_175965_b[Direction.SOUTH.func_176745_a()];
            }
            roomDefinition2.field_175963_d = true;
            roomDefinition2.field_175965_b[Direction.NORTH.func_176745_a()].field_175963_d = true;
            return new DoubleZRoom(direction, roomDefinition2);
        }
    }

    static class XDoubleRoomFitHelper
    implements IMonumentRoomFitHelper {
        private XDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition roomDefinition) {
            return roomDefinition.field_175966_c[Direction.EAST.func_176745_a()] && !roomDefinition.field_175965_b[Direction.EAST.func_176745_a()].field_175963_d;
        }

        @Override
        public Piece func_175968_a(Direction direction, RoomDefinition roomDefinition, Random random) {
            roomDefinition.field_175963_d = true;
            roomDefinition.field_175965_b[Direction.EAST.func_176745_a()].field_175963_d = true;
            return new DoubleXRoom(direction, roomDefinition);
        }
    }

    static class YDoubleRoomFitHelper
    implements IMonumentRoomFitHelper {
        private YDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition roomDefinition) {
            return roomDefinition.field_175966_c[Direction.UP.func_176745_a()] && !roomDefinition.field_175965_b[Direction.UP.func_176745_a()].field_175963_d;
        }

        @Override
        public Piece func_175968_a(Direction direction, RoomDefinition roomDefinition, Random random) {
            roomDefinition.field_175963_d = true;
            roomDefinition.field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            return new DoubleYRoom(direction, roomDefinition);
        }
    }

    static class FitSimpleRoomTopHelper
    implements IMonumentRoomFitHelper {
        private FitSimpleRoomTopHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition roomDefinition) {
            return !roomDefinition.field_175966_c[Direction.WEST.func_176745_a()] && !roomDefinition.field_175966_c[Direction.EAST.func_176745_a()] && !roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()] && !roomDefinition.field_175966_c[Direction.SOUTH.func_176745_a()] && !roomDefinition.field_175966_c[Direction.UP.func_176745_a()];
        }

        @Override
        public Piece func_175968_a(Direction direction, RoomDefinition roomDefinition, Random random) {
            roomDefinition.field_175963_d = true;
            return new SimpleTopRoom(direction, roomDefinition);
        }
    }

    static class FitSimpleRoomHelper
    implements IMonumentRoomFitHelper {
        private FitSimpleRoomHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition roomDefinition) {
            return true;
        }

        @Override
        public Piece func_175968_a(Direction direction, RoomDefinition roomDefinition, Random random) {
            roomDefinition.field_175963_d = true;
            return new SimpleRoom(direction, roomDefinition, random);
        }
    }

    static interface IMonumentRoomFitHelper {
        public boolean func_175969_a(RoomDefinition var1);

        public Piece func_175968_a(Direction var1, RoomDefinition var2, Random var3);
    }

    static class RoomDefinition {
        private final int field_175967_a;
        private final RoomDefinition[] field_175965_b = new RoomDefinition[6];
        private final boolean[] field_175966_c = new boolean[6];
        private boolean field_175963_d;
        private boolean field_175964_e;
        private int field_175962_f;

        public RoomDefinition(int n) {
            this.field_175967_a = n;
        }

        public void func_175957_a(Direction direction, RoomDefinition roomDefinition) {
            this.field_175965_b[direction.func_176745_a()] = roomDefinition;
            roomDefinition.field_175965_b[direction.func_176734_d().func_176745_a()] = this;
        }

        public void func_175958_a() {
            for (int i = 0; i < 6; ++i) {
                this.field_175966_c[i] = this.field_175965_b[i] != null;
            }
        }

        public boolean func_175959_a(int n) {
            if (this.field_175964_e) {
                return true;
            }
            this.field_175962_f = n;
            for (\u2603 = 0; \u2603 < 6; ++\u2603) {
                if (this.field_175965_b[\u2603] == null || !this.field_175966_c[\u2603] || this.field_175965_b[\u2603].field_175962_f == n || !this.field_175965_b[\u2603].func_175959_a(n)) continue;
                return true;
            }
            return false;
        }

        public boolean func_175961_b() {
            return this.field_175967_a >= 75;
        }

        public int func_175960_c() {
            int n = 0;
            for (\u2603 = 0; \u2603 < 6; ++\u2603) {
                if (!this.field_175966_c[\u2603]) continue;
                ++n;
            }
            return n;
        }
    }

    public static class Penthouse
    extends Piece {
        public Penthouse(Direction direction, MutableBoundingBox mutableBoundingBox) {
            super(IStructurePieceType.field_214775_V, direction, mutableBoundingBox);
        }

        public Penthouse(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214775_V, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader2, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            ISeedReader iSeedReader2;
            int \u26032;
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 2, -1, 2, 11, -1, 11, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, -1, 0, 1, -1, 11, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 12, -1, 0, 13, -1, 11, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 2, -1, 0, 11, -1, 1, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 2, -1, 12, 11, -1, 13, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, 0, 0, 0, 0, 13, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 13, 0, 0, 13, 0, 13, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 0, 0, 12, 0, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 0, 13, 12, 0, 13, field_175826_b, field_175826_b, false);
            for (\u26032 = 2; \u26032 <= 11; \u26032 += 3) {
                this.func_175811_a(iSeedReader2, field_175825_e, 0, 0, \u26032, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 13, 0, \u26032, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, \u26032, 0, 0, mutableBoundingBox);
            }
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 2, 0, 3, 4, 0, 9, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 9, 0, 3, 11, 0, 9, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 4, 0, 9, 9, 0, 11, field_175826_b, field_175826_b, false);
            this.func_175811_a(iSeedReader2, field_175826_b, 5, 0, 8, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175826_b, 8, 0, 8, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175826_b, 10, 0, 10, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175826_b, 3, 0, 10, mutableBoundingBox);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 3, 0, 3, 3, 0, 7, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 10, 0, 3, 10, 0, 7, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 6, 0, 10, 7, 0, 10, field_175827_c, field_175827_c, false);
            \u26032 = 3;
            for (int i = 0; i < 2; ++i) {
                for (\u2603 = 2; \u2603 <= 8; \u2603 += 3) {
                    this.func_175804_a(iSeedReader2, mutableBoundingBox, \u26032, 0, \u2603, \u26032, 2, \u2603, field_175826_b, field_175826_b, false);
                }
                \u26032 = 10;
            }
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 5, 0, 10, 5, 2, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 8, 0, 10, 8, 2, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 6, -1, 7, 7, -1, 8, field_175827_c, field_175827_c, false);
            this.func_209179_a(iSeedReader2, mutableBoundingBox, 6, -1, 3, 7, -1, 4);
            this.func_175817_a(iSeedReader2, mutableBoundingBox, 6, 1, 6);
            return true;
        }
    }

    public static class WingRoom
    extends Piece {
        private int field_175834_o;

        public WingRoom(Direction direction, MutableBoundingBox mutableBoundingBox, int n) {
            super(IStructurePieceType.field_214778_Y, direction, mutableBoundingBox);
            this.field_175834_o = n & 1;
        }

        public WingRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214778_Y, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader2, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            ISeedReader iSeedReader2;
            if (this.field_175834_o == 0) {
                int n;
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iSeedReader2, mutableBoundingBox, 10 - n, 3 - n, 20 - n, 12 + n, 3 - n, 20, field_175826_b, field_175826_b, false);
                }
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 0, 6, 15, 0, 16, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 6, 0, 6, 6, 3, 20, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 16, 0, 6, 16, 3, 20, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 1, 7, 7, 1, 20, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 15, 1, 7, 15, 1, 20, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 1, 6, 9, 3, 6, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 13, 1, 6, 15, 3, 6, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 8, 1, 7, 9, 1, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 13, 1, 7, 14, 1, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 9, 0, 5, 13, 0, 5, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 10, 0, 7, 12, 0, 7, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 8, 0, 10, 8, 0, 12, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 14, 0, 10, 14, 0, 12, field_175827_c, field_175827_c, false);
                for (n = 18; n >= 7; n -= 3) {
                    this.func_175811_a(iSeedReader2, field_175825_e, 6, 3, n, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, field_175825_e, 16, 3, n, mutableBoundingBox);
                }
                this.func_175811_a(iSeedReader2, field_175825_e, 10, 0, 10, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 12, 0, 10, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 10, 0, 12, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 12, 0, 12, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 8, 3, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 14, 3, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 4, 2, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 4, 1, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 4, 0, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 18, 2, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 18, 1, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 18, 0, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 4, 2, 18, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 4, 1, 18, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 4, 0, 18, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 18, 2, 18, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175825_e, 18, 1, 18, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 18, 0, 18, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 9, 7, 20, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, field_175826_b, 13, 7, 20, mutableBoundingBox);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 6, 0, 21, 7, 4, 21, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 15, 0, 21, 16, 4, 21, field_175826_b, field_175826_b, false);
                this.func_175817_a(iSeedReader2, mutableBoundingBox, 11, 2, 16);
            } else if (this.field_175834_o == 1) {
                int n;
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 9, 3, 18, 13, 3, 20, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 9, 0, 18, 9, 2, 18, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 13, 0, 18, 13, 2, 18, field_175826_b, field_175826_b, false);
                int \u26032 = 9;
                int \u26033 = 20;
                int \u26034 = 5;
                for (n = 0; n < 2; ++n) {
                    this.func_175811_a(iSeedReader2, field_175826_b, \u26032, 6, 20, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, field_175825_e, \u26032, 5, 20, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, field_175826_b, \u26032, 4, 20, mutableBoundingBox);
                    \u26032 = 13;
                }
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 3, 7, 15, 3, 14, field_175826_b, field_175826_b, false);
                \u26032 = 10;
                for (n = 0; n < 2; ++n) {
                    this.func_175804_a(iSeedReader2, mutableBoundingBox, \u26032, 0, 10, \u26032, 6, 10, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader2, mutableBoundingBox, \u26032, 0, 12, \u26032, 6, 12, field_175826_b, field_175826_b, false);
                    this.func_175811_a(iSeedReader2, field_175825_e, \u26032, 0, 10, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, field_175825_e, \u26032, 0, 12, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, field_175825_e, \u26032, 4, 10, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, field_175825_e, \u26032, 4, 12, mutableBoundingBox);
                    \u26032 = 12;
                }
                \u26032 = 8;
                for (n = 0; n < 2; ++n) {
                    this.func_175804_a(iSeedReader2, mutableBoundingBox, \u26032, 0, 7, \u26032, 2, 7, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader2, mutableBoundingBox, \u26032, 0, 14, \u26032, 2, 14, field_175826_b, field_175826_b, false);
                    \u26032 = 14;
                }
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 8, 3, 8, 8, 3, 13, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 14, 3, 8, 14, 3, 13, field_175827_c, field_175827_c, false);
                this.func_175817_a(iSeedReader2, mutableBoundingBox, 11, 5, 13);
            }
            return true;
        }
    }

    public static class MonumentCoreRoom
    extends Piece {
        public MonumentCoreRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214768_O, 1, direction, roomDefinition, 2, 2, 2);
        }

        public MonumentCoreRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214768_O, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 8, 0, 14, 8, 14, field_175828_a);
            int n = 7;
            BlockState \u26032 = field_175826_b;
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 7, 0, 0, 7, 15, \u26032, \u26032, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 15, 7, 0, 15, 7, 15, \u26032, \u26032, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 7, 0, 15, 7, 0, \u26032, \u26032, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 7, 15, 14, 7, 15, \u26032, \u26032, false);
            for (n = 1; n <= 6; ++n) {
                \u26032 = field_175826_b;
                if (n == 2 || n == 6) {
                    \u26032 = field_175828_a;
                }
                for (\u2603 = 0; \u2603 <= 15; \u2603 += 15) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, n, 0, \u2603, n, 1, \u26032, \u26032, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, n, 6, \u2603, n, 9, \u26032, \u26032, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, n, 14, \u2603, n, 15, \u26032, \u26032, false);
                }
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, n, 0, 1, n, 0, \u26032, \u26032, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, n, 0, 9, n, 0, \u26032, \u26032, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 14, n, 0, 14, n, 0, \u26032, \u26032, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, n, 15, 14, n, 15, \u26032, \u26032, false);
            }
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 3, 6, 9, 6, 9, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 4, 7, 8, 5, 8, Blocks.field_150340_R.func_176223_P(), Blocks.field_150340_R.func_176223_P(), false);
            for (n = 3; n <= 6; n += 3) {
                for (\u2603 = 6; \u2603 <= 9; \u2603 += 3) {
                    this.func_175811_a(iSeedReader, field_175825_e, \u2603, n, 6, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, field_175825_e, \u2603, n, 9, mutableBoundingBox);
                }
            }
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 6, 5, 2, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 9, 5, 2, 9, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 1, 6, 10, 2, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 1, 9, 10, 2, 9, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 5, 6, 2, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 1, 5, 9, 2, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 10, 6, 2, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 1, 10, 9, 2, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 2, 5, 5, 6, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 2, 10, 5, 6, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 2, 5, 10, 6, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 2, 10, 10, 6, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 7, 1, 5, 7, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 7, 1, 10, 7, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 7, 9, 5, 7, 14, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 7, 9, 10, 7, 14, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 7, 5, 6, 7, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 7, 10, 6, 7, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 7, 5, 14, 7, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 7, 10, 14, 7, 10, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 1, 2, 2, 1, 3, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, 2, 3, 1, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 13, 1, 2, 13, 1, 3, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 12, 1, 2, 12, 1, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 1, 12, 2, 1, 13, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, 13, 3, 1, 13, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 13, 1, 12, 13, 1, 13, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 12, 1, 13, 12, 1, 13, field_175826_b, field_175826_b, false);
            return true;
        }
    }

    public static class DoubleYZRoom
    extends Piece {
        public DoubleYZRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214772_S, 1, direction, roomDefinition, 1, 2, 2);
        }

        public DoubleYZRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214772_S, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            RoomDefinition roomDefinition;
            BlockState blockState;
            int n;
            RoomDefinition roomDefinition2 = this.field_175830_k.field_175965_b[Direction.NORTH.func_176745_a()];
            roomDefinition = this.field_175830_k;
            \u2603 = roomDefinition2.field_175965_b[Direction.UP.func_176745_a()];
            \u2603 = roomDefinition.field_175965_b[Direction.UP.func_176745_a()];
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(iSeedReader, mutableBoundingBox, 0, 8, roomDefinition2.field_175966_c[Direction.DOWN.func_176745_a()]);
                this.func_175821_a(iSeedReader, mutableBoundingBox, 0, 0, roomDefinition.field_175966_c[Direction.DOWN.func_176745_a()]);
            }
            if (\u2603.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 8, 1, 6, 8, 7, field_175828_a);
            }
            if (\u2603.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 8, 8, 6, 8, 14, field_175828_a);
            }
            for (n = 1; n <= 7; ++n) {
                blockState = field_175826_b;
                if (n == 2 || n == 6) {
                    blockState = field_175828_a;
                }
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, n, 0, 0, n, 15, blockState, blockState, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, n, 0, 7, n, 15, blockState, blockState, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, n, 0, 6, n, 0, blockState, blockState, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, n, 15, 6, n, 15, blockState, blockState, false);
            }
            for (n = 1; n <= 7; ++n) {
                blockState = field_175827_c;
                if (n == 2 || n == 6) {
                    blockState = field_175825_e;
                }
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, n, 7, 4, n, 8, blockState, blockState, false);
            }
            if (roomDefinition.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 0, 4, 2, 0);
            }
            if (roomDefinition.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 7, 1, 3, 7, 2, 4);
            }
            if (roomDefinition.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 1, 3, 0, 2, 4);
            }
            if (roomDefinition2.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 15, 4, 2, 15);
            }
            if (roomDefinition2.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 1, 11, 0, 2, 12);
            }
            if (roomDefinition2.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 7, 1, 11, 7, 2, 12);
            }
            if (\u2603.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 5, 0, 4, 6, 0);
            }
            if (\u2603.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 7, 5, 3, 7, 6, 4);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 4, 2, 6, 4, 5, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 2, 6, 3, 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 5, 6, 3, 5, field_175826_b, field_175826_b, false);
            }
            if (\u2603.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 5, 3, 0, 6, 4);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 4, 2, 2, 4, 5, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 2, 1, 3, 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 5, 1, 3, 5, field_175826_b, field_175826_b, false);
            }
            if (\u2603.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 5, 15, 4, 6, 15);
            }
            if (\u2603.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 5, 11, 0, 6, 12);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 4, 10, 2, 4, 13, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 10, 1, 3, 10, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 13, 1, 3, 13, field_175826_b, field_175826_b, false);
            }
            if (\u2603.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 7, 5, 11, 7, 6, 12);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 4, 10, 6, 4, 13, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 10, 6, 3, 10, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 13, 6, 3, 13, field_175826_b, field_175826_b, false);
            }
            return true;
        }
    }

    public static class DoubleXYRoom
    extends Piece {
        public DoubleXYRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214770_Q, 1, direction, roomDefinition, 2, 2, 1);
        }

        public DoubleXYRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214770_Q, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader2, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            ISeedReader iSeedReader2;
            RoomDefinition roomDefinition = this.field_175830_k.field_175965_b[Direction.EAST.func_176745_a()];
            \u2603 = this.field_175830_k;
            \u2603 = \u2603.field_175965_b[Direction.UP.func_176745_a()];
            \u2603 = roomDefinition.field_175965_b[Direction.UP.func_176745_a()];
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(iSeedReader2, mutableBoundingBox, 8, 0, roomDefinition.field_175966_c[Direction.DOWN.func_176745_a()]);
                this.func_175821_a(iSeedReader2, mutableBoundingBox, 0, 0, \u2603.field_175966_c[Direction.DOWN.func_176745_a()]);
            }
            if (\u2603.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader2, mutableBoundingBox, 1, 8, 1, 7, 8, 6, field_175828_a);
            }
            if (\u2603.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader2, mutableBoundingBox, 8, 8, 1, 14, 8, 6, field_175828_a);
            }
            for (int i = 1; i <= 7; ++i) {
                BlockState blockState = field_175826_b;
                if (i == 2 || i == 6) {
                    blockState = field_175828_a;
                }
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, i, 0, 0, i, 7, blockState, blockState, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 15, i, 0, 15, i, 7, blockState, blockState, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, i, 0, 15, i, 0, blockState, blockState, false);
                this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, i, 7, 14, i, 7, blockState, blockState, false);
            }
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 2, 1, 3, 2, 7, 4, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 3, 1, 2, 4, 7, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 3, 1, 5, 4, 7, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 13, 1, 3, 13, 7, 4, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 11, 1, 2, 12, 7, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 11, 1, 5, 12, 7, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 5, 1, 3, 5, 3, 4, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 10, 1, 3, 10, 3, 4, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 5, 7, 2, 10, 7, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 5, 5, 2, 5, 7, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 10, 5, 2, 10, 7, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 5, 5, 5, 5, 7, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 10, 5, 5, 10, 7, 5, field_175826_b, field_175826_b, false);
            this.func_175811_a(iSeedReader2, field_175826_b, 6, 6, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175826_b, 9, 6, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175826_b, 6, 6, 5, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175826_b, 9, 6, 5, mutableBoundingBox);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 5, 4, 3, 6, 4, 4, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 9, 4, 3, 10, 4, 4, field_175826_b, field_175826_b, false);
            this.func_175811_a(iSeedReader2, field_175825_e, 5, 4, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175825_e, 5, 4, 5, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175825_e, 10, 4, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, field_175825_e, 10, 4, 5, mutableBoundingBox);
            if (\u2603.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 3, 1, 0, 4, 2, 0);
            }
            if (\u2603.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 3, 1, 7, 4, 2, 7);
            }
            if (\u2603.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 0, 1, 3, 0, 2, 4);
            }
            if (roomDefinition.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 11, 1, 0, 12, 2, 0);
            }
            if (roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 11, 1, 7, 12, 2, 7);
            }
            if (roomDefinition.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 15, 1, 3, 15, 2, 4);
            }
            if (\u2603.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 3, 5, 0, 4, 6, 0);
            }
            if (\u2603.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 3, 5, 7, 4, 6, 7);
            }
            if (\u2603.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 0, 5, 3, 0, 6, 4);
            }
            if (\u2603.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 11, 5, 0, 12, 6, 0);
            }
            if (\u2603.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 11, 5, 7, 12, 6, 7);
            }
            if (\u2603.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 15, 5, 3, 15, 6, 4);
            }
            return true;
        }
    }

    public static class DoubleZRoom
    extends Piece {
        public DoubleZRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214773_T, 1, direction, roomDefinition, 1, 1, 2);
        }

        public DoubleZRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214773_T, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            RoomDefinition roomDefinition = this.field_175830_k.field_175965_b[Direction.NORTH.func_176745_a()];
            \u2603 = this.field_175830_k;
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(iSeedReader, mutableBoundingBox, 0, 8, roomDefinition.field_175966_c[Direction.DOWN.func_176745_a()]);
                this.func_175821_a(iSeedReader, mutableBoundingBox, 0, 0, \u2603.field_175966_c[Direction.DOWN.func_176745_a()]);
            }
            if (\u2603.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 4, 1, 6, 4, 7, field_175828_a);
            }
            if (roomDefinition.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 4, 8, 6, 4, 14, field_175828_a);
            }
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 0, 0, 3, 15, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 3, 0, 7, 3, 15, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 0, 7, 3, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 15, 6, 3, 15, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 0, 0, 2, 15, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 2, 0, 7, 2, 15, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 0, 7, 2, 0, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 15, 6, 2, 15, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 0, 0, 1, 15, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 1, 0, 7, 1, 15, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 0, 7, 1, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 15, 6, 1, 15, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 1, 1, 1, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 1, 6, 1, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 1, 1, 3, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 3, 1, 6, 3, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 13, 1, 1, 14, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 13, 6, 1, 14, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 13, 1, 3, 14, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 3, 13, 6, 3, 14, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 1, 6, 2, 3, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 6, 5, 3, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 1, 9, 2, 3, 9, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 9, 5, 3, 9, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 2, 6, 4, 2, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 2, 9, 4, 2, 9, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 2, 7, 2, 2, 8, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 2, 7, 5, 2, 8, field_175826_b, field_175826_b, false);
            this.func_175811_a(iSeedReader, field_175825_e, 2, 2, 5, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175825_e, 5, 2, 5, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175825_e, 2, 2, 10, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175825_e, 5, 2, 10, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175826_b, 2, 3, 5, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175826_b, 5, 3, 5, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175826_b, 2, 3, 10, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175826_b, 5, 3, 10, mutableBoundingBox);
            if (\u2603.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 0, 4, 2, 0);
            }
            if (\u2603.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 7, 1, 3, 7, 2, 4);
            }
            if (\u2603.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 1, 3, 0, 2, 4);
            }
            if (roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 15, 4, 2, 15);
            }
            if (roomDefinition.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 1, 11, 0, 2, 12);
            }
            if (roomDefinition.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 7, 1, 11, 7, 2, 12);
            }
            return true;
        }
    }

    public static class DoubleXRoom
    extends Piece {
        public DoubleXRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214769_P, 1, direction, roomDefinition, 2, 1, 1);
        }

        public DoubleXRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214769_P, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            RoomDefinition roomDefinition = this.field_175830_k.field_175965_b[Direction.EAST.func_176745_a()];
            \u2603 = this.field_175830_k;
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(iSeedReader, mutableBoundingBox, 8, 0, roomDefinition.field_175966_c[Direction.DOWN.func_176745_a()]);
                this.func_175821_a(iSeedReader, mutableBoundingBox, 0, 0, \u2603.field_175966_c[Direction.DOWN.func_176745_a()]);
            }
            if (\u2603.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 4, 1, 7, 4, 6, field_175828_a);
            }
            if (roomDefinition.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 8, 4, 1, 14, 4, 6, field_175828_a);
            }
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 0, 0, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 15, 3, 0, 15, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 0, 15, 3, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 7, 14, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 0, 0, 2, 7, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 15, 2, 0, 15, 2, 7, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 0, 15, 2, 0, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 7, 14, 2, 7, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 15, 1, 0, 15, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 0, 15, 1, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 7, 14, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 0, 10, 1, 4, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 2, 0, 9, 2, 3, field_175828_a, field_175828_a, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 3, 0, 10, 3, 4, field_175826_b, field_175826_b, false);
            this.func_175811_a(iSeedReader, field_175825_e, 6, 2, 3, mutableBoundingBox);
            this.func_175811_a(iSeedReader, field_175825_e, 9, 2, 3, mutableBoundingBox);
            if (\u2603.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 0, 4, 2, 0);
            }
            if (\u2603.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 7, 4, 2, 7);
            }
            if (\u2603.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 1, 3, 0, 2, 4);
            }
            if (roomDefinition.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 11, 1, 0, 12, 2, 0);
            }
            if (roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 11, 1, 7, 12, 2, 7);
            }
            if (roomDefinition.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 15, 1, 3, 15, 2, 4);
            }
            return true;
        }
    }

    public static class DoubleYRoom
    extends Piece {
        public DoubleYRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214771_R, 1, direction, roomDefinition, 1, 2, 1);
        }

        public DoubleYRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214771_R, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(iSeedReader, mutableBoundingBox, 0, 0, this.field_175830_k.field_175966_c[Direction.DOWN.func_176745_a()]);
            }
            if ((\u2603 = this.field_175830_k.field_175965_b[Direction.UP.func_176745_a()]).field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 8, 1, 6, 8, 6, field_175828_a);
            }
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 4, 0, 0, 4, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 4, 0, 7, 4, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 4, 0, 6, 4, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 4, 7, 6, 4, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 4, 1, 2, 4, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 4, 2, 1, 4, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 4, 1, 5, 4, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 4, 2, 6, 4, 2, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 4, 5, 2, 4, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 4, 5, 1, 4, 5, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 4, 5, 5, 4, 6, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 4, 5, 6, 4, 5, field_175826_b, field_175826_b, false);
            RoomDefinition roomDefinition = this.field_175830_k;
            for (int i = 1; i <= 5; i += 4) {
                \u2603 = 0;
                if (roomDefinition.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 2, i, \u2603, 2, i + 2, \u2603, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 5, i, \u2603, 5, i + 2, \u2603, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, i + 2, \u2603, 4, i + 2, \u2603, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, i, \u2603, 7, i + 2, \u2603, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, i + 1, \u2603, 7, i + 1, \u2603, field_175828_a, field_175828_a, false);
                }
                \u2603 = 7;
                if (roomDefinition.field_175966_c[Direction.NORTH.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 2, i, \u2603, 2, i + 2, \u2603, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 5, i, \u2603, 5, i + 2, \u2603, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, i + 2, \u2603, 4, i + 2, \u2603, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, i, \u2603, 7, i + 2, \u2603, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, i + 1, \u2603, 7, i + 1, \u2603, field_175828_a, field_175828_a, false);
                }
                \u2603 = 0;
                if (roomDefinition.field_175966_c[Direction.WEST.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i, 2, \u2603, i + 2, 2, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i, 5, \u2603, i + 2, 5, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i + 2, 3, \u2603, i + 2, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i, 0, \u2603, i + 2, 7, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i + 1, 0, \u2603, i + 1, 7, field_175828_a, field_175828_a, false);
                }
                \u2603 = 7;
                if (roomDefinition.field_175966_c[Direction.EAST.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i, 2, \u2603, i + 2, 2, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i, 5, \u2603, i + 2, 5, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i + 2, 3, \u2603, i + 2, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i, 0, \u2603, i + 2, 7, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, i + 1, 0, \u2603, i + 1, 7, field_175828_a, field_175828_a, false);
                }
                roomDefinition = \u2603;
            }
            return true;
        }
    }

    public static class SimpleTopRoom
    extends Piece {
        public SimpleTopRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214777_X, 1, direction, roomDefinition, 1, 1, 1);
        }

        public SimpleTopRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214777_X, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader2, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            ISeedReader iSeedReader2;
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(iSeedReader2, mutableBoundingBox, 0, 0, this.field_175830_k.field_175966_c[Direction.DOWN.func_176745_a()]);
            }
            if (this.field_175830_k.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader2, mutableBoundingBox, 1, 4, 1, 6, 4, 6, field_175828_a);
            }
            for (int i = 1; i <= 6; ++i) {
                for (\u2603 = 1; \u2603 <= 6; ++\u2603) {
                    if (random.nextInt(3) == 0) continue;
                    \u2603 = 2 + (random.nextInt(4) == 0 ? 0 : 1);
                    BlockState blockState = Blocks.field_196577_ad.func_176223_P();
                    this.func_175804_a(iSeedReader2, mutableBoundingBox, i, \u2603, \u2603, i, 3, \u2603, blockState, blockState, false);
                }
            }
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 1, 0, 7, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 1, 0, 6, 1, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 1, 7, 6, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, 2, 0, 0, 2, 7, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 2, 0, 7, 2, 7, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 2, 0, 6, 2, 0, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 2, 7, 6, 2, 7, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, 3, 0, 0, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 3, 0, 7, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 3, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 3, 7, 6, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, 1, 3, 0, 2, 4, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 7, 1, 3, 7, 2, 4, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 3, 1, 0, 4, 2, 0, field_175827_c, field_175827_c, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 3, 1, 7, 4, 2, 7, field_175827_c, field_175827_c, false);
            if (this.field_175830_k.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader2, mutableBoundingBox, 3, 1, 0, 4, 2, 0);
            }
            return true;
        }
    }

    public static class SimpleRoom
    extends Piece {
        private int field_175833_o;

        public SimpleRoom(Direction direction, RoomDefinition roomDefinition, Random random) {
            super(IStructurePieceType.field_214776_W, 1, direction, roomDefinition, 1, 1, 1);
            this.field_175833_o = random.nextInt(3);
        }

        public SimpleRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214776_W, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(iSeedReader, mutableBoundingBox, 0, 0, this.field_175830_k.field_175966_c[Direction.DOWN.func_176745_a()]);
            }
            if (this.field_175830_k.field_175965_b[Direction.UP.func_176745_a()] == null) {
                this.func_175819_a(iSeedReader, mutableBoundingBox, 1, 4, 1, 6, 4, 6, field_175828_a);
            }
            boolean bl = \u2603 = this.field_175833_o != 0 && random.nextBoolean() && !this.field_175830_k.field_175966_c[Direction.DOWN.func_176745_a()] && !this.field_175830_k.field_175966_c[Direction.UP.func_176745_a()] && this.field_175830_k.func_175960_c() > 1;
            if (this.field_175833_o == 0) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 0, 2, 1, 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 0, 2, 3, 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 0, 0, 2, 2, field_175828_a, field_175828_a, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 0, 2, 2, 0, field_175828_a, field_175828_a, false);
                this.func_175811_a(iSeedReader, field_175825_e, 1, 2, 1, mutableBoundingBox);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 0, 7, 1, 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 3, 0, 7, 3, 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 2, 0, 7, 2, 2, field_175828_a, field_175828_a, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 2, 0, 6, 2, 0, field_175828_a, field_175828_a, false);
                this.func_175811_a(iSeedReader, field_175825_e, 6, 2, 1, mutableBoundingBox);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 5, 2, 1, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 5, 2, 3, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 5, 0, 2, 7, field_175828_a, field_175828_a, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 7, 2, 2, 7, field_175828_a, field_175828_a, false);
                this.func_175811_a(iSeedReader, field_175825_e, 1, 2, 6, mutableBoundingBox);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 5, 7, 1, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 3, 5, 7, 3, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 2, 5, 7, 2, 7, field_175828_a, field_175828_a, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 2, 7, 6, 2, 7, field_175828_a, field_175828_a, false);
                this.func_175811_a(iSeedReader, field_175825_e, 6, 2, 6, mutableBoundingBox);
                if (this.field_175830_k.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 3, 0, 4, 3, 0, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 3, 0, 4, 3, 1, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 2, 0, 4, 2, 0, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, 0, 4, 1, 1, field_175826_b, field_175826_b, false);
                }
                if (this.field_175830_k.field_175966_c[Direction.NORTH.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 3, 7, 4, 3, 7, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 3, 6, 4, 3, 7, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 2, 7, 4, 2, 7, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, 6, 4, 1, 7, field_175826_b, field_175826_b, false);
                }
                if (this.field_175830_k.field_175966_c[Direction.WEST.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 3, 0, 3, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 3, 1, 3, 4, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 3, 0, 2, 4, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 3, 1, 1, 4, field_175826_b, field_175826_b, false);
                }
                if (this.field_175830_k.field_175966_c[Direction.EAST.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 3, 3, 7, 3, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 3, 3, 7, 3, 4, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 2, 3, 7, 2, 4, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 3, 7, 1, 4, field_175826_b, field_175826_b, false);
                }
            } else if (this.field_175833_o == 1) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 1, 2, 2, 3, 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 2, 1, 5, 2, 3, 5, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 5, 5, 3, 5, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 2, 5, 3, 2, field_175826_b, field_175826_b, false);
                this.func_175811_a(iSeedReader, field_175825_e, 2, 2, 2, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175825_e, 2, 2, 5, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175825_e, 5, 2, 5, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175825_e, 5, 2, 2, mutableBoundingBox);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 0, 1, 3, 0, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 1, 0, 3, 1, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 7, 1, 3, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 6, 0, 3, 6, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 7, 7, 3, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 1, 6, 7, 3, 6, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, 0, 7, 3, 0, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 1, 1, 7, 3, 1, field_175826_b, field_175826_b, false);
                this.func_175811_a(iSeedReader, field_175828_a, 1, 2, 0, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175828_a, 0, 2, 1, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175828_a, 1, 2, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175828_a, 0, 2, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175828_a, 6, 2, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175828_a, 7, 2, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175828_a, 6, 2, 0, mutableBoundingBox);
                this.func_175811_a(iSeedReader, field_175828_a, 7, 2, 1, mutableBoundingBox);
                if (!this.field_175830_k.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 0, 6, 2, 0, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 0, 6, 1, 0, field_175826_b, field_175826_b, false);
                }
                if (!this.field_175830_k.field_175966_c[Direction.NORTH.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 7, 6, 3, 7, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 7, 6, 2, 7, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 7, 6, 1, 7, field_175826_b, field_175826_b, false);
                }
                if (!this.field_175830_k.field_175966_c[Direction.WEST.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 1, 0, 3, 6, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 1, 0, 2, 6, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 1, 0, 1, 6, field_175826_b, field_175826_b, false);
                }
                if (!this.field_175830_k.field_175966_c[Direction.EAST.func_176745_a()]) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 3, 1, 7, 3, 6, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 2, 1, 7, 2, 6, field_175828_a, field_175828_a, false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 1, 1, 7, 1, 6, field_175826_b, field_175826_b, false);
                }
            } else if (this.field_175833_o == 2) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 1, 0, 7, 1, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 0, 6, 1, 0, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 7, 6, 1, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 0, 0, 2, 7, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 2, 0, 7, 2, 7, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 0, 6, 2, 0, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 2, 7, 6, 2, 7, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 0, 0, 3, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 3, 0, 7, 3, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 7, 6, 3, 7, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 3, 0, 2, 4, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 1, 3, 7, 2, 4, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, 0, 4, 2, 0, field_175827_c, field_175827_c, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, 7, 4, 2, 7, field_175827_c, field_175827_c, false);
                if (this.field_175830_k.field_175966_c[Direction.SOUTH.func_176745_a()]) {
                    this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 0, 4, 2, 0);
                }
                if (this.field_175830_k.field_175966_c[Direction.NORTH.func_176745_a()]) {
                    this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 7, 4, 2, 7);
                }
                if (this.field_175830_k.field_175966_c[Direction.WEST.func_176745_a()]) {
                    this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 1, 3, 0, 2, 4);
                }
                if (this.field_175830_k.field_175966_c[Direction.EAST.func_176745_a()]) {
                    this.func_209179_a(iSeedReader, mutableBoundingBox, 7, 1, 3, 7, 2, 4);
                }
            }
            if (\u2603) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, 3, 4, 1, 4, field_175826_b, field_175826_b, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 2, 3, 4, 2, 4, field_175828_a, field_175828_a, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 3, 3, 4, 3, 4, field_175826_b, field_175826_b, false);
            }
            return true;
        }
    }

    public static class EntryRoom
    extends Piece {
        public EntryRoom(Direction direction, RoomDefinition roomDefinition) {
            super(IStructurePieceType.field_214774_U, 1, direction, roomDefinition, 1, 1, 1);
        }

        public EntryRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214774_U, compoundNBT);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 0, 2, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 3, 0, 7, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 2, 0, 1, 2, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 2, 0, 7, 2, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 7, 1, 0, 7, 1, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 7, 7, 3, 7, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 0, 2, 3, 0, field_175826_b, field_175826_b, false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
            if (this.field_175830_k.field_175966_c[Direction.NORTH.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 3, 1, 7, 4, 2, 7);
            }
            if (this.field_175830_k.field_175966_c[Direction.WEST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 1, 3, 1, 2, 4);
            }
            if (this.field_175830_k.field_175966_c[Direction.EAST.func_176745_a()]) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, 6, 1, 3, 7, 2, 4);
            }
            return true;
        }
    }

    public static class MonumentBuilding
    extends Piece {
        private RoomDefinition field_175845_o;
        private RoomDefinition field_175844_p;
        private final List<Piece> field_175843_q = Lists.newArrayList();

        public MonumentBuilding(Random random, int n, int n2, Direction direction) {
            super(IStructurePieceType.field_214767_N, 0);
            this.func_186164_a(direction);
            Direction direction2 = this.func_186165_e();
            this.field_74887_e = direction2.func_176740_k() == Direction.Axis.Z ? new MutableBoundingBox(n, 39, n2, n + 58 - 1, 61, n2 + 58 - 1) : new MutableBoundingBox(n, 39, n2, n + 58 - 1, 61, n2 + 58 - 1);
            List<RoomDefinition> list = this.func_175836_a(random);
            this.field_175845_o.field_175963_d = true;
            this.field_175843_q.add(new EntryRoom(direction2, this.field_175845_o));
            this.field_175843_q.add(new MonumentCoreRoom(direction2, this.field_175844_p));
            ArrayList \u26032 = Lists.newArrayList();
            \u26032.add(new XYDoubleRoomFitHelper());
            \u26032.add(new YZDoubleRoomFitHelper());
            \u26032.add(new ZDoubleRoomFitHelper());
            \u26032.add(new XDoubleRoomFitHelper());
            \u26032.add(new YDoubleRoomFitHelper());
            \u26032.add(new FitSimpleRoomTopHelper());
            \u26032.add(new FitSimpleRoomHelper());
            block0: for (RoomDefinition roomDefinition : list) {
                if (roomDefinition.field_175963_d || roomDefinition.func_175961_b()) continue;
                for (Object object2 : \u26032) {
                    if (!object2.func_175969_a(roomDefinition)) continue;
                    this.field_175843_q.add(object2.func_175968_a(direction2, roomDefinition, random));
                    continue block0;
                }
            }
            int n3 = this.field_74887_e.field_78895_b;
            int \u26035 = this.func_74865_a(9, 22);
            int \u26036 = this.func_74873_b(9, 22);
            for (Piece piece : this.field_175843_q) {
                piece.func_74874_b().func_78886_a(\u26035, n3, \u26036);
            }
            MutableBoundingBox \u26037 = MutableBoundingBox.func_175899_a(this.func_74865_a(1, 1), this.func_74862_a(1), this.func_74873_b(1, 1), this.func_74865_a(23, 21), this.func_74862_a(8), this.func_74873_b(23, 21));
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175899_a(this.func_74865_a(34, 1), this.func_74862_a(1), this.func_74873_b(34, 1), this.func_74865_a(56, 21), this.func_74862_a(8), this.func_74873_b(56, 21));
            MutableBoundingBox \u26033 = MutableBoundingBox.func_175899_a(this.func_74865_a(22, 22), this.func_74862_a(13), this.func_74873_b(22, 22), this.func_74865_a(35, 35), this.func_74862_a(17), this.func_74873_b(35, 35));
            int \u26034 = random.nextInt();
            this.field_175843_q.add(new WingRoom(direction2, \u26037, \u26034++));
            this.field_175843_q.add(new WingRoom(direction2, mutableBoundingBox, \u26034++));
            this.field_175843_q.add(new Penthouse(direction2, \u26033));
        }

        public MonumentBuilding(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214767_N, compoundNBT);
        }

        private List<RoomDefinition> func_175836_a(Random random) {
            int n;
            RoomDefinition[] roomDefinitionArray = new RoomDefinition[75];
            for (int n2 = 0; n2 < 5; ++n2) {
                for (int i = 0; i < 4; ++i) {
                    \u2603 = 0;
                    \u2603 = MonumentBuilding.func_175820_a(n2, 0, i);
                    roomDefinitionArray[\u2603] = new RoomDefinition(\u2603);
                }
            }
            for (n = 0; n < 5; ++n) {
                for (i = 0; i < 4; ++i) {
                    \u2603 = 1;
                    \u2603 = MonumentBuilding.func_175820_a(n, 1, i);
                    roomDefinitionArray[\u2603] = new RoomDefinition(\u2603);
                }
            }
            for (n = 1; n < 4; ++n) {
                for (i = 0; i < 2; ++i) {
                    \u2603 = 2;
                    \u2603 = MonumentBuilding.func_175820_a(n, 2, i);
                    roomDefinitionArray[\u2603] = new RoomDefinition(\u2603);
                }
            }
            this.field_175845_o = roomDefinitionArray[field_175823_g];
            for (n = 0; n < 5; ++n) {
                for (i = 0; i < 5; ++i) {
                    for (\u2603 = 0; \u2603 < 3; ++\u2603) {
                        \u2603 = MonumentBuilding.func_175820_a(n, \u2603, i);
                        if (roomDefinitionArray[\u2603] == null) continue;
                        for (Direction direction : Direction.values()) {
                            int n2 = n + direction.func_82601_c();
                            \u2603 = \u2603 + direction.func_96559_d();
                            \u2603 = i + direction.func_82599_e();
                            if (n2 < 0 || n2 >= 5 || \u2603 < 0 || \u2603 >= 5 || \u2603 < 0 || \u2603 >= 3 || roomDefinitionArray[\u2603 = MonumentBuilding.func_175820_a(n2, \u2603, \u2603)] == null) continue;
                            if (\u2603 == i) {
                                roomDefinitionArray[\u2603].func_175957_a(direction, roomDefinitionArray[\u2603]);
                                continue;
                            }
                            roomDefinitionArray[\u2603].func_175957_a(direction.func_176734_d(), roomDefinitionArray[\u2603]);
                        }
                    }
                }
            }
            RoomDefinition roomDefinition = new RoomDefinition(1003);
            RoomDefinition roomDefinition2 = new RoomDefinition(1001);
            \u2603 = new RoomDefinition(1002);
            roomDefinitionArray[field_175831_h].func_175957_a(Direction.UP, roomDefinition);
            roomDefinitionArray[field_175832_i].func_175957_a(Direction.SOUTH, roomDefinition2);
            roomDefinitionArray[field_175829_j].func_175957_a(Direction.SOUTH, \u2603);
            roomDefinition.field_175963_d = true;
            roomDefinition2.field_175963_d = true;
            \u2603.field_175963_d = true;
            this.field_175845_o.field_175964_e = true;
            this.field_175844_p = roomDefinitionArray[MonumentBuilding.func_175820_a(random.nextInt(4), 0, 2)];
            this.field_175844_p.field_175963_d = true;
            this.field_175844_p.field_175965_b[Direction.EAST.func_176745_a()].field_175963_d = true;
            this.field_175844_p.field_175965_b[Direction.NORTH.func_176745_a()].field_175963_d = true;
            this.field_175844_p.field_175965_b[Direction.EAST.func_176745_a()].field_175965_b[Direction.NORTH.func_176745_a()].field_175963_d = true;
            this.field_175844_p.field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            this.field_175844_p.field_175965_b[Direction.EAST.func_176745_a()].field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            this.field_175844_p.field_175965_b[Direction.NORTH.func_176745_a()].field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            this.field_175844_p.field_175965_b[Direction.EAST.func_176745_a()].field_175965_b[Direction.NORTH.func_176745_a()].field_175965_b[Direction.UP.func_176745_a()].field_175963_d = true;
            ArrayList \u26032 = Lists.newArrayList();
            for (RoomDefinition roomDefinition3 : roomDefinitionArray) {
                if (roomDefinition3 == null) continue;
                roomDefinition3.func_175958_a();
                \u26032.add(roomDefinition3);
            }
            roomDefinition.func_175958_a();
            Collections.shuffle(\u26032, random);
            int \u26033 = 1;
            for (RoomDefinition roomDefinition22 : \u26032) {
                int n3 = 0;
                for (int i = 0; n3 < 2 && i < 5; ++i) {
                    \u2603 = random.nextInt(6);
                    if (!roomDefinition22.field_175966_c[\u2603]) continue;
                    \u2603 = Direction.func_82600_a(\u2603).func_176734_d().func_176745_a();
                    ((RoomDefinition)roomDefinition22).field_175966_c[\u2603] = false;
                    ((RoomDefinition)((RoomDefinition)roomDefinition22).field_175965_b[\u2603]).field_175966_c[\u2603] = false;
                    if (roomDefinition22.func_175959_a(\u26033++) && roomDefinition22.field_175965_b[\u2603].func_175959_a(\u26033++)) {
                        ++n3;
                        continue;
                    }
                    ((RoomDefinition)roomDefinition22).field_175966_c[\u2603] = true;
                    ((RoomDefinition)((RoomDefinition)roomDefinition22).field_175965_b[\u2603]).field_175966_c[\u2603] = true;
                }
            }
            \u26032.add(roomDefinition);
            \u26032.add(roomDefinition2);
            \u26032.add(\u2603);
            return \u26032;
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            int n = Math.max(iSeedReader.func_181545_F(), 64) - this.field_74887_e.field_78895_b;
            this.func_209179_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 58, n, 58);
            this.func_175840_a(false, 0, iSeedReader, random, mutableBoundingBox);
            this.func_175840_a(true, 33, iSeedReader, random, mutableBoundingBox);
            this.func_175839_b(iSeedReader, random, mutableBoundingBox);
            this.func_175837_c(iSeedReader, random, mutableBoundingBox);
            this.func_175841_d(iSeedReader, random, mutableBoundingBox);
            this.func_175835_e(iSeedReader, random, mutableBoundingBox);
            this.func_175842_f(iSeedReader, random, mutableBoundingBox);
            this.func_175838_g(iSeedReader, random, mutableBoundingBox);
            for (\u2603 = 0; \u2603 < 7; ++\u2603) {
                \u2603 = 0;
                while (\u2603 < 7) {
                    if (\u2603 == 0 && \u2603 == 3) {
                        \u2603 = 6;
                    }
                    \u2603 = \u2603 * 9;
                    \u2603 = \u2603 * 9;
                    for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                        for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                            this.func_175811_a(iSeedReader, field_175826_b, \u2603 + \u2603, 0, \u2603 + \u2603, mutableBoundingBox);
                            this.func_175808_b(iSeedReader, field_175826_b, \u2603 + \u2603, -1, \u2603 + \u2603, mutableBoundingBox);
                        }
                    }
                    if (\u2603 == 0 || \u2603 == 6) {
                        ++\u2603;
                        continue;
                    }
                    \u2603 += 6;
                }
            }
            for (\u2603 = 0; \u2603 < 5; ++\u2603) {
                this.func_209179_a(iSeedReader, mutableBoundingBox, -1 - \u2603, 0 + \u2603 * 2, -1 - \u2603, -1 - \u2603, 23, 58 + \u2603);
                this.func_209179_a(iSeedReader, mutableBoundingBox, 58 + \u2603, 0 + \u2603 * 2, -1 - \u2603, 58 + \u2603, 23, 58 + \u2603);
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0 - \u2603, 0 + \u2603 * 2, -1 - \u2603, 57 + \u2603, 23, -1 - \u2603);
                this.func_209179_a(iSeedReader, mutableBoundingBox, 0 - \u2603, 0 + \u2603 * 2, 58 + \u2603, 57 + \u2603, 23, 58 + \u2603);
            }
            for (Piece piece : this.field_175843_q) {
                if (!piece.func_74874_b().func_78884_a(mutableBoundingBox)) continue;
                piece.func_230383_a_(iSeedReader, structureManager, chunkGenerator, random, mutableBoundingBox, chunkPos, blockPos);
            }
            return true;
        }

        private void func_175840_a(boolean bl, int n, IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            int n2 = 24;
            if (this.func_175818_a(mutableBoundingBox, n, 0, n + 23, 20)) {
                this.func_175804_a(iWorld, mutableBoundingBox, n + 0, 0, 0, n + 24, 0, 20, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld, mutableBoundingBox, n + 0, 1, 0, n + 24, 10, 20);
                for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                    this.func_175804_a(iWorld, mutableBoundingBox, n + \u2603, \u2603 + 1, \u2603, n + \u2603, \u2603 + 1, 20, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, n + \u2603 + 7, \u2603 + 5, \u2603 + 7, n + \u2603 + 7, \u2603 + 5, 20, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, n + 17 - \u2603, \u2603 + 5, \u2603 + 7, n + 17 - \u2603, \u2603 + 5, 20, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, n + 24 - \u2603, \u2603 + 1, \u2603, n + 24 - \u2603, \u2603 + 1, 20, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, n + \u2603 + 1, \u2603 + 1, \u2603, n + 23 - \u2603, \u2603 + 1, \u2603, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, n + \u2603 + 8, \u2603 + 5, \u2603 + 7, n + 16 - \u2603, \u2603 + 5, \u2603 + 7, field_175826_b, field_175826_b, false);
                }
                this.func_175804_a(iWorld, mutableBoundingBox, n + 4, 4, 4, n + 6, 4, 20, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 7, 4, 4, n + 17, 4, 6, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 18, 4, 4, n + 20, 4, 20, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 11, 8, 11, n + 13, 8, 20, field_175828_a, field_175828_a, false);
                this.func_175811_a(iWorld, field_175824_d, n + 12, 9, 12, mutableBoundingBox);
                this.func_175811_a(iWorld, field_175824_d, n + 12, 9, 15, mutableBoundingBox);
                this.func_175811_a(iWorld, field_175824_d, n + 12, 9, 18, mutableBoundingBox);
                \u2603 = n + (bl ? 19 : 5);
                \u2603 = n + (bl ? 5 : 19);
                for (\u2603 = 20; \u2603 >= 5; \u2603 -= 3) {
                    this.func_175811_a(iWorld, field_175824_d, \u2603, 5, \u2603, mutableBoundingBox);
                }
                for (\u2603 = 19; \u2603 >= 7; \u2603 -= 3) {
                    this.func_175811_a(iWorld, field_175824_d, \u2603, 5, \u2603, mutableBoundingBox);
                }
                for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                    \u2603 = bl ? n + 24 - (17 - \u2603 * 3) : n + 17 - \u2603 * 3;
                    this.func_175811_a(iWorld, field_175824_d, \u2603, 5, 5, mutableBoundingBox);
                }
                this.func_175811_a(iWorld, field_175824_d, \u2603, 5, 5, mutableBoundingBox);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 11, 1, 12, n + 13, 7, 12, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 12, 1, 11, n + 12, 7, 13, field_175828_a, field_175828_a, false);
            }
        }

        private void func_175839_b(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            if (this.func_175818_a(mutableBoundingBox, 22, 5, 35, 17)) {
                this.func_209179_a(iWorld, mutableBoundingBox, 25, 0, 0, 32, 8, 20);
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(iWorld, mutableBoundingBox, 24, 2, 5 + i * 4, 24, 4, 5 + i * 4, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, 22, 4, 5 + i * 4, 23, 4, 5 + i * 4, field_175826_b, field_175826_b, false);
                    this.func_175811_a(iWorld, field_175826_b, 25, 5, 5 + i * 4, mutableBoundingBox);
                    this.func_175811_a(iWorld, field_175826_b, 26, 6, 5 + i * 4, mutableBoundingBox);
                    this.func_175811_a(iWorld, field_175825_e, 26, 5, 5 + i * 4, mutableBoundingBox);
                    this.func_175804_a(iWorld, mutableBoundingBox, 33, 2, 5 + i * 4, 33, 4, 5 + i * 4, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, 34, 4, 5 + i * 4, 35, 4, 5 + i * 4, field_175826_b, field_175826_b, false);
                    this.func_175811_a(iWorld, field_175826_b, 32, 5, 5 + i * 4, mutableBoundingBox);
                    this.func_175811_a(iWorld, field_175826_b, 31, 6, 5 + i * 4, mutableBoundingBox);
                    this.func_175811_a(iWorld, field_175825_e, 31, 5, 5 + i * 4, mutableBoundingBox);
                    this.func_175804_a(iWorld, mutableBoundingBox, 27, 6, 5 + i * 4, 30, 6, 5 + i * 4, field_175828_a, field_175828_a, false);
                }
            }
        }

        private void func_175837_c(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox) {
            if (this.func_175818_a(mutableBoundingBox, 15, 20, 42, 21)) {
                IWorld iWorld2;
                int n;
                this.func_175804_a(iWorld2, mutableBoundingBox, 15, 0, 21, 42, 0, 21, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox, 26, 1, 21, 31, 3, 21);
                this.func_175804_a(iWorld2, mutableBoundingBox, 21, 12, 21, 36, 12, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 17, 11, 21, 40, 11, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 16, 10, 21, 41, 10, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 15, 7, 21, 42, 9, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 16, 6, 21, 41, 6, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 17, 5, 21, 40, 5, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 21, 4, 21, 36, 4, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 22, 3, 21, 26, 3, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 31, 3, 21, 35, 3, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 23, 2, 21, 25, 2, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 32, 2, 21, 34, 2, 21, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 28, 4, 20, 29, 4, 21, field_175826_b, field_175826_b, false);
                this.func_175811_a(iWorld2, field_175826_b, 27, 3, 21, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 30, 3, 21, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 26, 2, 21, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 31, 2, 21, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 25, 1, 21, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 32, 1, 21, mutableBoundingBox);
                for (n = 0; n < 7; ++n) {
                    this.func_175811_a(iWorld2, field_175827_c, 28 - n, 6 + n, 21, mutableBoundingBox);
                    this.func_175811_a(iWorld2, field_175827_c, 29 + n, 6 + n, 21, mutableBoundingBox);
                }
                for (n = 0; n < 4; ++n) {
                    this.func_175811_a(iWorld2, field_175827_c, 28 - n, 9 + n, 21, mutableBoundingBox);
                    this.func_175811_a(iWorld2, field_175827_c, 29 + n, 9 + n, 21, mutableBoundingBox);
                }
                this.func_175811_a(iWorld2, field_175827_c, 28, 12, 21, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175827_c, 29, 12, 21, mutableBoundingBox);
                for (n = 0; n < 3; ++n) {
                    this.func_175811_a(iWorld2, field_175827_c, 22 - n * 2, 8, 21, mutableBoundingBox);
                    this.func_175811_a(iWorld2, field_175827_c, 22 - n * 2, 9, 21, mutableBoundingBox);
                    this.func_175811_a(iWorld2, field_175827_c, 35 + n * 2, 8, 21, mutableBoundingBox);
                    this.func_175811_a(iWorld2, field_175827_c, 35 + n * 2, 9, 21, mutableBoundingBox);
                }
                this.func_209179_a(iWorld2, mutableBoundingBox, 15, 13, 21, 42, 15, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 15, 1, 21, 15, 6, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 16, 1, 21, 16, 5, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 17, 1, 21, 20, 4, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 21, 1, 21, 21, 3, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 22, 1, 21, 22, 2, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 23, 1, 21, 24, 1, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 42, 1, 21, 42, 6, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 41, 1, 21, 41, 5, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 37, 1, 21, 40, 4, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 36, 1, 21, 36, 3, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 33, 1, 21, 34, 1, 21);
                this.func_209179_a(iWorld2, mutableBoundingBox, 35, 1, 21, 35, 2, 21);
            }
        }

        private void func_175841_d(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox) {
            if (this.func_175818_a(mutableBoundingBox, 21, 21, 36, 36)) {
                IWorld iWorld2;
                this.func_175804_a(iWorld2, mutableBoundingBox, 21, 0, 22, 36, 0, 36, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox, 21, 1, 22, 36, 23, 36);
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(iWorld2, mutableBoundingBox, 21 + i, 13 + i, 21 + i, 36 - i, 13 + i, 21 + i, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld2, mutableBoundingBox, 21 + i, 13 + i, 36 - i, 36 - i, 13 + i, 36 - i, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld2, mutableBoundingBox, 21 + i, 13 + i, 22 + i, 21 + i, 13 + i, 35 - i, field_175826_b, field_175826_b, false);
                    this.func_175804_a(iWorld2, mutableBoundingBox, 36 - i, 13 + i, 22 + i, 36 - i, 13 + i, 35 - i, field_175826_b, field_175826_b, false);
                }
                this.func_175804_a(iWorld2, mutableBoundingBox, 25, 16, 25, 32, 16, 32, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 25, 17, 25, 25, 19, 25, field_175826_b, field_175826_b, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 32, 17, 25, 32, 19, 25, field_175826_b, field_175826_b, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 25, 17, 32, 25, 19, 32, field_175826_b, field_175826_b, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 32, 17, 32, 32, 19, 32, field_175826_b, field_175826_b, false);
                this.func_175811_a(iWorld2, field_175826_b, 26, 20, 26, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 27, 21, 27, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175825_e, 27, 20, 27, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 26, 20, 31, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 27, 21, 30, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175825_e, 27, 20, 30, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 31, 20, 31, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 30, 21, 30, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175825_e, 30, 20, 30, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 31, 20, 26, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175826_b, 30, 21, 27, mutableBoundingBox);
                this.func_175811_a(iWorld2, field_175825_e, 30, 20, 27, mutableBoundingBox);
                this.func_175804_a(iWorld2, mutableBoundingBox, 28, 21, 27, 29, 21, 27, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 27, 21, 28, 27, 21, 29, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 28, 21, 30, 29, 21, 30, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 30, 21, 28, 30, 21, 29, field_175828_a, field_175828_a, false);
            }
        }

        private void func_175835_e(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox2) {
            MutableBoundingBox mutableBoundingBox2;
            IWorld iWorld2;
            int n;
            if (this.func_175818_a(mutableBoundingBox2, 0, 21, 6, 58)) {
                this.func_175804_a(iWorld2, mutableBoundingBox2, 0, 0, 21, 6, 0, 57, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox2, 0, 1, 21, 6, 7, 57);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 4, 4, 21, 6, 4, 53, field_175828_a, field_175828_a, false);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld2, mutableBoundingBox2, n, n + 1, 21, n, n + 1, 57 - n, field_175826_b, field_175826_b, false);
                }
                for (n = 23; n < 53; n += 3) {
                    this.func_175811_a(iWorld2, field_175824_d, 5, 5, n, mutableBoundingBox2);
                }
                this.func_175811_a(iWorld2, field_175824_d, 5, 5, 52, mutableBoundingBox2);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld2, mutableBoundingBox2, n, n + 1, 21, n, n + 1, 57 - n, field_175826_b, field_175826_b, false);
                }
                this.func_175804_a(iWorld2, mutableBoundingBox2, 4, 1, 52, 6, 3, 52, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 5, 1, 51, 5, 3, 53, field_175828_a, field_175828_a, false);
            }
            if (this.func_175818_a(mutableBoundingBox2, 51, 21, 58, 58)) {
                this.func_175804_a(iWorld2, mutableBoundingBox2, 51, 0, 21, 57, 0, 57, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox2, 51, 1, 21, 57, 7, 57);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 51, 4, 21, 53, 4, 53, field_175828_a, field_175828_a, false);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld2, mutableBoundingBox2, 57 - n, n + 1, 21, 57 - n, n + 1, 57 - n, field_175826_b, field_175826_b, false);
                }
                for (n = 23; n < 53; n += 3) {
                    this.func_175811_a(iWorld2, field_175824_d, 52, 5, n, mutableBoundingBox2);
                }
                this.func_175811_a(iWorld2, field_175824_d, 52, 5, 52, mutableBoundingBox2);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 51, 1, 52, 53, 3, 52, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 52, 1, 51, 52, 3, 53, field_175828_a, field_175828_a, false);
            }
            if (this.func_175818_a(mutableBoundingBox2, 0, 51, 57, 57)) {
                this.func_175804_a(iWorld2, mutableBoundingBox2, 7, 0, 51, 50, 0, 57, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox2, 7, 1, 51, 50, 10, 57);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld2, mutableBoundingBox2, n + 1, n + 1, 57 - n, 56 - n, n + 1, 57 - n, field_175826_b, field_175826_b, false);
                }
            }
        }

        private void func_175842_f(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox2) {
            MutableBoundingBox mutableBoundingBox2;
            int n;
            if (this.func_175818_a(mutableBoundingBox2, 7, 21, 13, 50)) {
                this.func_175804_a(iWorld2, mutableBoundingBox2, 7, 0, 21, 13, 0, 50, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox2, 7, 1, 21, 13, 10, 50);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 11, 8, 21, 13, 8, 53, field_175828_a, field_175828_a, false);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld2, mutableBoundingBox2, n + 7, n + 5, 21, n + 7, n + 5, 54, field_175826_b, field_175826_b, false);
                }
                for (n = 21; n <= 45; n += 3) {
                    this.func_175811_a(iWorld2, field_175824_d, 12, 9, n, mutableBoundingBox2);
                }
            }
            if (this.func_175818_a(mutableBoundingBox2, 44, 21, 50, 54)) {
                this.func_175804_a(iWorld2, mutableBoundingBox2, 44, 0, 21, 50, 0, 50, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox2, 44, 1, 21, 50, 10, 50);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 44, 8, 21, 46, 8, 53, field_175828_a, field_175828_a, false);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld2, mutableBoundingBox2, 50 - n, n + 5, 21, 50 - n, n + 5, 54, field_175826_b, field_175826_b, false);
                }
                for (n = 21; n <= 45; n += 3) {
                    this.func_175811_a(iWorld2, field_175824_d, 45, 9, n, mutableBoundingBox2);
                }
            }
            if (this.func_175818_a(mutableBoundingBox2, 8, 44, 49, 54)) {
                IWorld iWorld2;
                this.func_175804_a(iWorld2, mutableBoundingBox2, 14, 0, 44, 43, 0, 50, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld2, mutableBoundingBox2, 14, 1, 44, 43, 10, 50);
                for (n = 12; n <= 45; n += 3) {
                    this.func_175811_a(iWorld2, field_175824_d, n, 9, 45, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 9, 52, mutableBoundingBox2);
                    if (n != 12 && n != 18 && n != 24 && n != 33 && n != 39 && n != 45) continue;
                    this.func_175811_a(iWorld2, field_175824_d, n, 9, 47, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 9, 50, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 10, 45, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 10, 46, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 10, 51, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 10, 52, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 11, 47, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 11, 50, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 12, 48, mutableBoundingBox2);
                    this.func_175811_a(iWorld2, field_175824_d, n, 12, 49, mutableBoundingBox2);
                }
                for (n = 0; n < 3; ++n) {
                    this.func_175804_a(iWorld2, mutableBoundingBox2, 8 + n, 5 + n, 54, 49 - n, 5 + n, 54, field_175828_a, field_175828_a, false);
                }
                this.func_175804_a(iWorld2, mutableBoundingBox2, 11, 8, 54, 46, 8, 54, field_175826_b, field_175826_b, false);
                this.func_175804_a(iWorld2, mutableBoundingBox2, 14, 8, 44, 43, 8, 53, field_175828_a, field_175828_a, false);
            }
        }

        private void func_175838_g(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox2) {
            MutableBoundingBox mutableBoundingBox2;
            int n;
            if (this.func_175818_a(mutableBoundingBox2, 14, 21, 20, 43)) {
                this.func_175804_a(iWorld, mutableBoundingBox2, 14, 0, 21, 20, 0, 43, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld, mutableBoundingBox2, 14, 1, 22, 20, 14, 43);
                this.func_175804_a(iWorld, mutableBoundingBox2, 18, 12, 22, 20, 12, 39, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox2, 18, 12, 21, 20, 12, 21, field_175826_b, field_175826_b, false);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld, mutableBoundingBox2, n + 14, n + 9, 21, n + 14, n + 9, 43 - n, field_175826_b, field_175826_b, false);
                }
                for (n = 23; n <= 39; n += 3) {
                    this.func_175811_a(iWorld, field_175824_d, 19, 13, n, mutableBoundingBox2);
                }
            }
            if (this.func_175818_a(mutableBoundingBox2, 37, 21, 43, 43)) {
                this.func_175804_a(iWorld, mutableBoundingBox2, 37, 0, 21, 43, 0, 43, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld, mutableBoundingBox2, 37, 1, 22, 43, 14, 43);
                this.func_175804_a(iWorld, mutableBoundingBox2, 37, 12, 22, 39, 12, 39, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox2, 37, 12, 21, 39, 12, 21, field_175826_b, field_175826_b, false);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld, mutableBoundingBox2, 43 - n, n + 9, 21, 43 - n, n + 9, 43 - n, field_175826_b, field_175826_b, false);
                }
                for (n = 23; n <= 39; n += 3) {
                    this.func_175811_a(iWorld, field_175824_d, 38, 13, n, mutableBoundingBox2);
                }
            }
            if (this.func_175818_a(mutableBoundingBox2, 15, 37, 42, 43)) {
                this.func_175804_a(iWorld, mutableBoundingBox2, 21, 0, 37, 36, 0, 43, field_175828_a, field_175828_a, false);
                this.func_209179_a(iWorld, mutableBoundingBox2, 21, 1, 37, 36, 14, 43);
                this.func_175804_a(iWorld, mutableBoundingBox2, 21, 12, 37, 36, 12, 39, field_175828_a, field_175828_a, false);
                for (n = 0; n < 4; ++n) {
                    this.func_175804_a(iWorld, mutableBoundingBox2, 15 + n, n + 9, 43 - n, 42 - n, n + 9, 43 - n, field_175826_b, field_175826_b, false);
                }
                for (n = 21; n <= 36; n += 3) {
                    this.func_175811_a(iWorld, field_175824_d, n, 13, 38, mutableBoundingBox2);
                }
            }
        }
    }

    public static abstract class Piece
    extends StructurePiece {
        protected static final BlockState field_175828_a = Blocks.field_180397_cI.func_176223_P();
        protected static final BlockState field_175826_b = Blocks.field_196779_gQ.func_176223_P();
        protected static final BlockState field_175827_c = Blocks.field_196781_gR.func_176223_P();
        protected static final BlockState field_175824_d = field_175826_b;
        protected static final BlockState field_175825_e = Blocks.field_180398_cJ.func_176223_P();
        protected static final BlockState field_175822_f = Blocks.field_150355_j.func_176223_P();
        protected static final Set<Block> field_212180_g = ImmutableSet.builder().add((Object)Blocks.field_150432_aD).add((Object)Blocks.field_150403_cj).add((Object)Blocks.field_205164_gk).add((Object)field_175822_f.func_177230_c()).build();
        protected static final int field_175823_g = Piece.func_175820_a(2, 0, 0);
        protected static final int field_175831_h = Piece.func_175820_a(2, 2, 0);
        protected static final int field_175832_i = Piece.func_175820_a(0, 1, 0);
        protected static final int field_175829_j = Piece.func_175820_a(4, 1, 0);
        protected RoomDefinition field_175830_k;

        protected static final int func_175820_a(int n, int n2, int n3) {
            return n2 * 25 + n3 * 5 + n;
        }

        public Piece(IStructurePieceType iStructurePieceType, int n) {
            super(iStructurePieceType, n);
        }

        public Piece(IStructurePieceType iStructurePieceType, Direction direction, MutableBoundingBox mutableBoundingBox) {
            super(iStructurePieceType, 1);
            this.func_186164_a(direction);
            this.field_74887_e = mutableBoundingBox;
        }

        protected Piece(IStructurePieceType iStructurePieceType, int n, Direction direction, RoomDefinition roomDefinition, int n2, int n3, int n4) {
            super(iStructurePieceType, n);
            this.func_186164_a(direction);
            this.field_175830_k = roomDefinition;
            \u2603 = roomDefinition.field_175967_a;
            \u2603 = \u2603 % 5;
            \u2603 = \u2603 / 5 % 5;
            \u2603 = \u2603 / 25;
            this.field_74887_e = direction == Direction.NORTH || direction == Direction.SOUTH ? new MutableBoundingBox(0, 0, 0, n2 * 8 - 1, n3 * 4 - 1, n4 * 8 - 1) : new MutableBoundingBox(0, 0, 0, n4 * 8 - 1, n3 * 4 - 1, n2 * 8 - 1);
            switch (direction) {
                case NORTH: {
                    this.field_74887_e.func_78886_a(\u2603 * 8, \u2603 * 4, -(\u2603 + n4) * 8 + 1);
                    break;
                }
                case SOUTH: {
                    this.field_74887_e.func_78886_a(\u2603 * 8, \u2603 * 4, \u2603 * 8);
                    break;
                }
                case WEST: {
                    this.field_74887_e.func_78886_a(-(\u2603 + n4) * 8 + 1, \u2603 * 4, \u2603 * 8);
                    break;
                }
                default: {
                    this.field_74887_e.func_78886_a(\u2603 * 8, \u2603 * 4, \u2603 * 8);
                }
            }
        }

        public Piece(IStructurePieceType iStructurePieceType, CompoundNBT compoundNBT) {
            super(iStructurePieceType, compoundNBT);
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
        }

        protected void func_209179_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6) {
            for (\u2603 = n2; \u2603 <= n5; ++\u2603) {
                for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                    for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                        BlockState blockState = this.func_175807_a(iWorld, \u2603, \u2603, \u2603, mutableBoundingBox);
                        if (field_212180_g.contains(blockState.func_177230_c())) continue;
                        if (this.func_74862_a(\u2603) >= iWorld.func_181545_F() && blockState != field_175822_f) {
                            this.func_175811_a(iWorld, Blocks.field_150350_a.func_176223_P(), \u2603, \u2603, \u2603, mutableBoundingBox);
                            continue;
                        }
                        this.func_175811_a(iWorld, field_175822_f, \u2603, \u2603, \u2603, mutableBoundingBox);
                    }
                }
            }
        }

        protected void func_175821_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, boolean bl) {
            if (bl) {
                this.func_175804_a(iWorld, mutableBoundingBox, n + 0, 0, n2 + 0, n + 2, 0, n2 + 8 - 1, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 5, 0, n2 + 0, n + 8 - 1, 0, n2 + 8 - 1, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 3, 0, n2 + 0, n + 4, 0, n2 + 2, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 3, 0, n2 + 5, n + 4, 0, n2 + 8 - 1, field_175828_a, field_175828_a, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 3, 0, n2 + 2, n + 4, 0, n2 + 2, field_175826_b, field_175826_b, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 3, 0, n2 + 5, n + 4, 0, n2 + 5, field_175826_b, field_175826_b, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 2, 0, n2 + 3, n + 2, 0, n2 + 4, field_175826_b, field_175826_b, false);
                this.func_175804_a(iWorld, mutableBoundingBox, n + 5, 0, n2 + 3, n + 5, 0, n2 + 4, field_175826_b, field_175826_b, false);
            } else {
                this.func_175804_a(iWorld, mutableBoundingBox, n + 0, 0, n2 + 0, n + 8 - 1, 0, n2 + 8 - 1, field_175828_a, field_175828_a, false);
            }
        }

        protected void func_175819_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6, BlockState blockState) {
            for (int i = n2; i <= n5; ++i) {
                for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                    for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                        if (this.func_175807_a(iWorld, \u2603, i, \u2603, mutableBoundingBox) != field_175822_f) continue;
                        this.func_175811_a(iWorld, blockState, \u2603, i, \u2603, mutableBoundingBox);
                    }
                }
            }
        }

        protected boolean func_175818_a(MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4) {
            \u2603 = this.func_74865_a(n, n2);
            \u2603 = this.func_74873_b(n, n2);
            \u2603 = this.func_74865_a(n3, n4);
            \u2603 = this.func_74873_b(n3, n4);
            return mutableBoundingBox.func_78885_a(Math.min(\u2603, \u2603), Math.min(\u2603, \u2603), Math.max(\u2603, \u2603), Math.max(\u2603, \u2603));
        }

        protected boolean func_175817_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3) {
            \u2603 = this.func_74865_a(n, n3);
            if (mutableBoundingBox.func_175898_b(new BlockPos(\u2603, \u2603 = this.func_74862_a(n2), \u2603 = this.func_74873_b(n, n3)))) {
                ElderGuardianEntity elderGuardianEntity = EntityType.field_200800_n.func_200721_a(iWorld.func_201672_e());
                elderGuardianEntity.func_70691_i(elderGuardianEntity.func_110138_aP());
                elderGuardianEntity.func_70012_b((double)\u2603 + 0.5, \u2603, (double)\u2603 + 0.5, 0.0f, 0.0f);
                elderGuardianEntity.func_213386_a(iWorld, iWorld.func_175649_E(elderGuardianEntity.func_233580_cy_()), SpawnReason.STRUCTURE, null, null);
                iWorld.func_217376_c(elderGuardianEntity);
                return true;
            }
            return false;
        }
    }
}

