/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.RuinedPortalFeature;
import net.minecraft.world.gen.feature.structure.RuinedPortalPiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RuinedPortalStructure
extends Structure<RuinedPortalFeature> {
    private static final String[] field_236331_u_ = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] field_236332_v_ = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};

    public RuinedPortalStructure(Codec<RuinedPortalFeature> codec) {
        super(codec);
    }

    @Override
    public Structure.IStartFactory<RuinedPortalFeature> func_214557_a() {
        return Start::new;
    }

    private static boolean func_236337_b_(BlockPos blockPos, Biome biome) {
        return biome.func_225486_c(blockPos) < 0.15f;
    }

    private static int func_236339_b_(Random random, ChunkGenerator chunkGenerator, RuinedPortalPiece.Location location2, boolean bl, int n, int n2, MutableBoundingBox mutableBoundingBox) {
        int n3;
        int n4;
        RuinedPortalPiece.Location location2;
        int \u26032;
        if (location2 == RuinedPortalPiece.Location.IN_NETHER) {
            \u26032 = bl ? RuinedPortalStructure.func_236335_a_(random, 32, 100) : (random.nextFloat() < 0.5f ? RuinedPortalStructure.func_236335_a_(random, 27, 29) : RuinedPortalStructure.func_236335_a_(random, 29, 100));
        } else if (location2 == RuinedPortalPiece.Location.IN_MOUNTAIN) {
            n4 = n - n2;
            \u26032 = RuinedPortalStructure.func_236338_b_(random, 70, n4);
        } else if (location2 == RuinedPortalPiece.Location.UNDERGROUND) {
            n4 = n - n2;
            \u26032 = RuinedPortalStructure.func_236338_b_(random, 15, n4);
        } else {
            \u26032 = location2 == RuinedPortalPiece.Location.PARTLY_BURIED ? n - n2 + RuinedPortalStructure.func_236335_a_(random, 2, 8) : n;
        }
        ImmutableList immutableList = ImmutableList.of((Object)new BlockPos(mutableBoundingBox.field_78897_a, 0, mutableBoundingBox.field_78896_c), (Object)new BlockPos(mutableBoundingBox.field_78893_d, 0, mutableBoundingBox.field_78896_c), (Object)new BlockPos(mutableBoundingBox.field_78897_a, 0, mutableBoundingBox.field_78892_f), (Object)new BlockPos(mutableBoundingBox.field_78893_d, 0, mutableBoundingBox.field_78892_f));
        List \u26033 = immutableList.stream().map(blockPos -> chunkGenerator.func_230348_a_(blockPos.func_177958_n(), blockPos.func_177952_p())).collect(Collectors.toList());
        Heightmap.Type \u26034 = location2 == RuinedPortalPiece.Location.ON_OCEAN_FLOOR ? Heightmap.Type.OCEAN_FLOOR_WG : Heightmap.Type.WORLD_SURFACE_WG;
        BlockPos.Mutable \u26035 = new BlockPos.Mutable();
        block0: for (n3 = \u26032; n3 > 15; --n3) {
            \u2603 = 0;
            \u26035.func_181079_c(0, n3, 0);
            for (IBlockReader iBlockReader : \u26033) {
                BlockState blockState = iBlockReader.func_180495_p(\u26035);
                if (blockState == null || !\u26034.func_222684_d().test(blockState) || ++\u2603 != 3) continue;
                break block0;
            }
        }
        return n3;
    }

    private static int func_236335_a_(Random random, int n, int n2) {
        return random.nextInt(n2 - n + 1) + n;
    }

    private static int func_236338_b_(Random random, int n, int n2) {
        if (n < n2) {
            return RuinedPortalStructure.func_236335_a_(random, n, n2);
        }
        return n2;
    }

    public static enum Location implements IStringSerializable
    {
        STANDARD("standard"),
        DESERT("desert"),
        JUNGLE("jungle"),
        SWAMP("swamp"),
        MOUNTAIN("mountain"),
        OCEAN("ocean"),
        NETHER("nether");

        public static final Codec<Location> field_236342_h_;
        private static final Map<String, Location> field_236343_i_;
        private final String field_236344_j_;

        private Location(String string2) {
            this.field_236344_j_ = string2;
        }

        public String func_236347_b_() {
            return this.field_236344_j_;
        }

        public static Location func_236346_a_(String string) {
            return field_236343_i_.get(string);
        }

        @Override
        public String func_176610_l() {
            return this.field_236344_j_;
        }

        static {
            field_236342_h_ = IStringSerializable.func_233023_a_(Location::values, Location::func_236346_a_);
            field_236343_i_ = Arrays.stream(Location.values()).collect(Collectors.toMap(Location::func_236347_b_, location -> location));
        }
    }

    public static class Start
    extends StructureStart<RuinedPortalFeature> {
        protected Start(Structure<RuinedPortalFeature> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_230364_a_(ChunkGenerator chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome, RuinedPortalFeature ruinedPortalFeature2) {
            RuinedPortalFeature ruinedPortalFeature2;
            RuinedPortalPiece.Location \u26032;
            RuinedPortalPiece.Serializer serializer = new RuinedPortalPiece.Serializer();
            if (ruinedPortalFeature2.field_236628_b_ == Location.DESERT) {
                \u26032 = RuinedPortalPiece.Location.PARTLY_BURIED;
                serializer.field_237027_d_ = false;
                serializer.field_237026_c_ = 0.0f;
            } else if (ruinedPortalFeature2.field_236628_b_ == Location.JUNGLE) {
                \u26032 = RuinedPortalPiece.Location.ON_LAND_SURFACE;
                serializer.field_237027_d_ = this.field_214631_d.nextFloat() < 0.5f;
                serializer.field_237026_c_ = 0.8f;
                serializer.field_237028_e_ = true;
                serializer.field_237029_f_ = true;
            } else if (ruinedPortalFeature2.field_236628_b_ == Location.SWAMP) {
                \u26032 = RuinedPortalPiece.Location.ON_OCEAN_FLOOR;
                serializer.field_237027_d_ = false;
                serializer.field_237026_c_ = 0.5f;
                serializer.field_237029_f_ = true;
            } else if (ruinedPortalFeature2.field_236628_b_ == Location.MOUNTAIN) {
                boolean bl = this.field_214631_d.nextFloat() < 0.5f;
                \u26032 = bl ? RuinedPortalPiece.Location.IN_MOUNTAIN : RuinedPortalPiece.Location.ON_LAND_SURFACE;
                serializer.field_237027_d_ = bl || this.field_214631_d.nextFloat() < 0.5f;
            } else if (ruinedPortalFeature2.field_236628_b_ == Location.OCEAN) {
                \u26032 = RuinedPortalPiece.Location.ON_OCEAN_FLOOR;
                serializer.field_237027_d_ = false;
                serializer.field_237026_c_ = 0.8f;
            } else if (ruinedPortalFeature2.field_236628_b_ == Location.NETHER) {
                \u26032 = RuinedPortalPiece.Location.IN_NETHER;
                serializer.field_237027_d_ = this.field_214631_d.nextFloat() < 0.5f;
                serializer.field_237026_c_ = 0.0f;
                serializer.field_237030_g_ = true;
            } else {
                bl = this.field_214631_d.nextFloat() < 0.5f;
                \u26032 = bl ? RuinedPortalPiece.Location.UNDERGROUND : RuinedPortalPiece.Location.ON_LAND_SURFACE;
                serializer.field_237027_d_ = bl || this.field_214631_d.nextFloat() < 0.5f;
            }
            ResourceLocation resourceLocation = this.field_214631_d.nextFloat() < 0.05f ? new ResourceLocation(field_236332_v_[this.field_214631_d.nextInt(field_236332_v_.length)]) : new ResourceLocation(field_236331_u_[this.field_214631_d.nextInt(field_236331_u_.length)]);
            Template \u26033 = templateManager.func_200220_a(resourceLocation);
            Rotation \u26034 = Util.func_240989_a_(Rotation.values(), this.field_214631_d);
            Mirror \u26035 = this.field_214631_d.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
            BlockPos \u26036 = new BlockPos(\u26033.func_186259_a().func_177958_n() / 2, 0, \u26033.func_186259_a().func_177952_p() / 2);
            BlockPos \u26037 = new ChunkPos(n, n2).func_206849_h();
            MutableBoundingBox \u26038 = \u26033.func_237150_a_(\u26037, \u26034, \u26036, \u26035);
            Vector3i \u26039 = \u26038.func_215126_f();
            int \u260310 = \u26039.func_177958_n();
            int \u260311 = \u26039.func_177952_p();
            int \u260312 = chunkGenerator.func_222529_a(\u260310, \u260311, RuinedPortalPiece.func_237013_a_(\u26032)) - 1;
            int \u260313 = RuinedPortalStructure.func_236339_b_(this.field_214631_d, chunkGenerator, \u26032, serializer.field_237027_d_, \u260312, \u26038.func_78882_c(), \u26038);
            BlockPos \u260314 = new BlockPos(\u26037.func_177958_n(), \u260313, \u26037.func_177952_p());
            if (ruinedPortalFeature2.field_236628_b_ == Location.MOUNTAIN || ruinedPortalFeature2.field_236628_b_ == Location.OCEAN || ruinedPortalFeature2.field_236628_b_ == Location.STANDARD) {
                serializer.field_237025_b_ = RuinedPortalStructure.func_236337_b_(\u260314, biome);
            }
            this.field_75075_a.add(new RuinedPortalPiece(\u260314, \u26032, serializer, resourceLocation, \u26033, \u26034, \u26035, \u26036));
            this.func_202500_a();
        }
    }
}

