/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.RuinedPortalFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.BastionRemantsStructure;
import net.minecraft.world.gen.feature.structure.BastionRemnantConfig;
import net.minecraft.world.gen.feature.structure.BuriedTreasureConfig;
import net.minecraft.world.gen.feature.structure.BuriedTreasureStructure;
import net.minecraft.world.gen.feature.structure.DesertPyramidStructure;
import net.minecraft.world.gen.feature.structure.EndCityStructure;
import net.minecraft.world.gen.feature.structure.FortressStructure;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.IglooStructure;
import net.minecraft.world.gen.feature.structure.JunglePyramidStructure;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.NetherFossilStructure;
import net.minecraft.world.gen.feature.structure.OceanMonumentStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.PillagerOutpostStructure;
import net.minecraft.world.gen.feature.structure.RuinedPortalStructure;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.ShipwreckStructure;
import net.minecraft.world.gen.feature.structure.StrongholdStructure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.SwampHutStructure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillageStructure;
import net.minecraft.world.gen.feature.structure.WoodlandMansionStructure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Structure<C extends IFeatureConfig> {
    public static final BiMap<String, Structure<?>> field_236365_a_ = HashBiMap.create();
    private static final Map<Structure<?>, GenerationStage.Decoration> field_236385_u_ = Maps.newHashMap();
    private static final Logger field_208204_b = LogManager.getLogger();
    public static final Structure<NoFeatureConfig> field_236366_b_ = Structure.func_236394_a_("Pillager_Outpost", new PillagerOutpostStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<MineshaftConfig> field_236367_c_ = Structure.func_236394_a_("Mineshaft", new MineshaftStructure(MineshaftConfig.field_236541_a_), GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final Structure<NoFeatureConfig> field_236368_d_ = Structure.func_236394_a_("Mansion", new WoodlandMansionStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> field_236369_e_ = Structure.func_236394_a_("Jungle_Pyramid", new JunglePyramidStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> field_236370_f_ = Structure.func_236394_a_("Desert_Pyramid", new DesertPyramidStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> field_236371_g_ = Structure.func_236394_a_("Igloo", new IglooStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<RuinedPortalFeature> field_236372_h_ = Structure.func_236394_a_("Ruined_Portal", new RuinedPortalStructure(RuinedPortalFeature.field_236627_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<ShipwreckConfig> field_236373_i_ = Structure.func_236394_a_("Shipwreck", new ShipwreckStructure(ShipwreckConfig.field_236634_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final SwampHutStructure field_236374_j_ = Structure.func_236394_a_("Swamp_Hut", new SwampHutStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> field_236375_k_ = Structure.func_236394_a_("Stronghold", new StrongholdStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.STRONGHOLDS);
    public static final Structure<NoFeatureConfig> field_236376_l_ = Structure.func_236394_a_("Monument", new OceanMonumentStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<OceanRuinConfig> field_236377_m_ = Structure.func_236394_a_("Ocean_Ruin", new OceanRuinStructure(OceanRuinConfig.field_236561_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> field_236378_n_ = Structure.func_236394_a_("Fortress", new FortressStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.UNDERGROUND_DECORATION);
    public static final Structure<NoFeatureConfig> field_236379_o_ = Structure.func_236394_a_("EndCity", new EndCityStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<BuriedTreasureConfig> field_236380_p_ = Structure.func_236394_a_("Buried_Treasure", new BuriedTreasureStructure(BuriedTreasureConfig.field_236457_a_), GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final Structure<VillageConfig> field_236381_q_ = Structure.func_236394_a_("Village", new VillageStructure(VillageConfig.field_236533_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> field_236382_r_ = Structure.func_236394_a_("Nether_Fossil", new NetherFossilStructure(NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.UNDERGROUND_DECORATION);
    public static final Structure<BastionRemnantConfig> field_236383_s_ = Structure.func_236394_a_("Bastion_Remnant", new BastionRemantsStructure(BastionRemnantConfig.field_236545_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final List<Structure<?>> field_236384_t_ = ImmutableList.of(field_236366_b_, field_236381_q_, field_236382_r_);
    private final Codec<StructureFeature<C, Structure<C>>> field_236386_w_;

    private static <F extends Structure<?>> F func_236394_a_(String string, F f, GenerationStage.Decoration decoration) {
        field_236365_a_.put((Object)string.toLowerCase(Locale.ROOT), f);
        field_236385_u_.put(f, decoration);
        return (F)Registry.func_218325_a(Registry.field_218361_B, string.toLowerCase(Locale.ROOT), f);
    }

    public Structure(Codec<C> codec) {
        this.field_236386_w_ = codec.fieldOf("config").xmap(iFeatureConfig -> new StructureFeature<IFeatureConfig, Structure>(this, (IFeatureConfig)iFeatureConfig), structureFeature -> structureFeature.field_236269_c_).codec();
    }

    public GenerationStage.Decoration func_236396_f_() {
        return field_236385_u_.get(this);
    }

    public static void func_236397_g_() {
    }

    @Nullable
    public static StructureStart<?> func_236393_a_(TemplateManager templateManager, CompoundNBT compoundNBT, long l) {
        String string = compoundNBT.func_74779_i("id");
        if ("INVALID".equals(string)) {
            return StructureStart.field_214630_a;
        }
        Structure<?> \u26032 = Registry.field_218361_B.func_82594_a(new ResourceLocation(string.toLowerCase(Locale.ROOT)));
        if (\u26032 == null) {
            field_208204_b.error("Unknown feature id: {}", (Object)string);
            return null;
        }
        int \u26033 = compoundNBT.func_74762_e("ChunkX");
        int \u26034 = compoundNBT.func_74762_e("ChunkZ");
        int \u26035 = compoundNBT.func_74762_e("references");
        MutableBoundingBox \u26036 = compoundNBT.func_74764_b("BB") ? new MutableBoundingBox(compoundNBT.func_74759_k("BB")) : MutableBoundingBox.func_78887_a();
        ListNBT \u26037 = compoundNBT.func_150295_c("Children", 10);
        try {
            StructureStart<?> structureStart = super.func_236387_a_(\u26033, \u26034, \u26036, \u26035, l);
            for (int i = 0; i < \u26037.size(); ++i) {
                CompoundNBT compoundNBT2 = \u26037.func_150305_b(i);
                String \u26038 = compoundNBT2.func_74779_i("id");
                IStructurePieceType \u26039 = Registry.field_218362_C.func_82594_a(new ResourceLocation(\u26038.toLowerCase(Locale.ROOT)));
                if (\u26039 == null) {
                    field_208204_b.error("Unknown structure piece id: {}", (Object)\u26038);
                    continue;
                }
                try {
                    StructurePiece structurePiece = \u26039.load(templateManager, compoundNBT2);
                    structureStart.func_186161_c().add(structurePiece);
                    continue;
                }
                catch (Exception exception) {
                    field_208204_b.error("Exception loading structure piece with id {}", (Object)\u26038, (Object)exception);
                }
            }
            return structureStart;
        }
        catch (Exception exception) {
            field_208204_b.error("Failed Start with id {}", (Object)string, (Object)exception);
            return null;
        }
    }

    public Codec<StructureFeature<C, Structure<C>>> func_236398_h_() {
        return this.field_236386_w_;
    }

    public StructureFeature<C, ? extends Structure<C>> func_236391_a_(C c) {
        return new StructureFeature<C, Structure>(this, c);
    }

    @Nullable
    public BlockPos func_236388_a_(IWorldReader iWorldReader, StructureManager structureManager, BlockPos blockPos, int n, boolean bl, long l, StructureSeparationSettings structureSeparationSettings) {
        int n2 = structureSeparationSettings.func_236668_a_();
        \u2603 = blockPos.func_177958_n() >> 4;
        \u2603 = blockPos.func_177952_p() >> 4;
        SharedSeedRandom \u26032 = new SharedSeedRandom();
        block0: for (\u2603 = 0; \u2603 <= n; ++\u2603) {
            for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                boolean bl2 = \u2603 == -\u2603 || \u2603 == \u2603;
                for (int i = -\u2603; i <= \u2603; ++i) {
                    boolean bl3 = \u2603 = i == -\u2603 || i == \u2603;
                    if (!bl2 && !\u2603) continue;
                    \u2603 = \u2603 + n2 * \u2603;
                    \u2603 = \u2603 + n2 * i;
                    ChunkPos chunkPos = this.func_236392_a_(structureSeparationSettings, l, \u26032, \u2603, \u2603);
                    IChunk \u26033 = iWorldReader.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222606_b);
                    StructureStart<?> \u26034 = structureManager.func_235013_a_(SectionPos.func_218156_a(\u26033.func_76632_l(), 0), this, \u26033);
                    if (\u26034 != null && \u26034.func_75069_d()) {
                        if (bl && \u26034.func_212687_g()) {
                            \u26034.func_212685_h();
                            return \u26034.func_204294_a();
                        }
                        if (!bl) {
                            return \u26034.func_204294_a();
                        }
                    }
                    if (\u2603 == 0) break;
                }
                if (\u2603 == 0) continue block0;
            }
        }
        return null;
    }

    protected boolean func_230365_b_() {
        return true;
    }

    public final ChunkPos func_236392_a_(StructureSeparationSettings structureSeparationSettings, long l, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        \u2603 = structureSeparationSettings.func_236668_a_();
        \u2603 = structureSeparationSettings.func_236671_b_();
        \u2603 = Math.floorDiv(n, \u2603);
        \u2603 = Math.floorDiv(n2, \u2603);
        sharedSeedRandom.func_202427_a(l, \u2603, \u2603, structureSeparationSettings.func_236673_c_());
        if (this.func_230365_b_()) {
            \u2603 = sharedSeedRandom.nextInt(\u2603 - \u2603);
            \u2603 = sharedSeedRandom.nextInt(\u2603 - \u2603);
        } else {
            \u2603 = (sharedSeedRandom.nextInt(\u2603 - \u2603) + sharedSeedRandom.nextInt(\u2603 - \u2603)) / 2;
            \u2603 = (sharedSeedRandom.nextInt(\u2603 - \u2603) + sharedSeedRandom.nextInt(\u2603 - \u2603)) / 2;
        }
        return new ChunkPos(\u2603 * \u2603 + \u2603, \u2603 * \u2603 + \u2603);
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long l, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome, ChunkPos chunkPos, C c) {
        return true;
    }

    private StructureStart<C> func_236387_a_(int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
        return this.func_214557_a().create(this, n, n2, mutableBoundingBox, n3, l);
    }

    public StructureStart<?> func_236389_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, TemplateManager templateManager, long l, ChunkPos chunkPos, Biome biome, int n, SharedSeedRandom sharedSeedRandom, StructureSeparationSettings structureSeparationSettings, C c) {
        ChunkPos chunkPos2 = this.func_236392_a_(structureSeparationSettings, l, sharedSeedRandom, chunkPos.field_77276_a, chunkPos.field_77275_b);
        if (chunkPos.field_77276_a == chunkPos2.field_77276_a && chunkPos.field_77275_b == chunkPos2.field_77275_b && this.func_230363_a_(chunkGenerator, biomeProvider, l, sharedSeedRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, biome, chunkPos2, c)) {
            StructureStart<C> structureStart = this.func_236387_a_(chunkPos.field_77276_a, chunkPos.field_77275_b, MutableBoundingBox.func_78887_a(), n, l);
            structureStart.func_230364_a_(chunkGenerator, templateManager, chunkPos.field_77276_a, chunkPos.field_77275_b, biome, c);
            if (structureStart.func_75069_d()) {
                return structureStart;
            }
        }
        return StructureStart.field_214630_a;
    }

    public abstract IStartFactory<C> func_214557_a();

    public String func_143025_a() {
        return (String)field_236365_a_.inverse().get((Object)this);
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return Collections.emptyList();
    }

    public List<Biome.SpawnListEntry> func_214469_f() {
        return Collections.emptyList();
    }

    public static interface IStartFactory<C extends IFeatureConfig> {
        public StructureStart<C> create(Structure<C> var1, int var2, int var3, MutableBoundingBox var4, int var5, long var6);
    }
}

