/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class Raid {
    private static final TranslationTextComponent field_221338_b = new TranslationTextComponent("event.minecraft.raid");
    private static final TranslationTextComponent field_221339_c = new TranslationTextComponent("event.minecraft.raid.victory");
    private static final TranslationTextComponent field_221340_d = new TranslationTextComponent("event.minecraft.raid.defeat");
    private static final ITextComponent field_221341_e = field_221338_b.func_230532_e_().func_240702_b_(" - ").func_230529_a_(field_221339_c);
    private static final ITextComponent field_221342_f = field_221338_b.func_230532_e_().func_240702_b_(" - ").func_230529_a_(field_221340_d);
    private final Map<Integer, AbstractRaiderEntity> field_221343_g = Maps.newHashMap();
    private final Map<Integer, Set<AbstractRaiderEntity>> field_221344_h = Maps.newHashMap();
    private final Set<UUID> field_221345_i = Sets.newHashSet();
    private long field_221346_j;
    private BlockPos field_221347_k;
    private final ServerWorld field_221348_l;
    private boolean field_221349_m;
    private final int field_221350_n;
    private float field_221351_o;
    private int field_221352_p;
    private boolean field_221353_q;
    private int field_221354_r;
    private final ServerBossInfo field_221355_s = new ServerBossInfo(field_221338_b, BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10);
    private int field_221356_t;
    private int field_221357_u;
    private final Random field_221358_v = new Random();
    private final int field_221359_w;
    private Status field_221360_x;
    private int field_221361_y;
    private Optional<BlockPos> field_221362_z = Optional.empty();

    public Raid(int n, ServerWorld serverWorld, BlockPos blockPos) {
        this.field_221350_n = n;
        this.field_221348_l = serverWorld;
        this.field_221353_q = true;
        this.field_221357_u = 300;
        this.field_221355_s.func_186735_a(0.0f);
        this.field_221347_k = blockPos;
        this.field_221359_w = this.func_221306_a(serverWorld.func_175659_aa());
        this.field_221360_x = Status.ONGOING;
    }

    public Raid(ServerWorld serverWorld, CompoundNBT compoundNBT) {
        this.field_221348_l = serverWorld;
        this.field_221350_n = compoundNBT.func_74762_e("Id");
        this.field_221349_m = compoundNBT.func_74767_n("Started");
        this.field_221353_q = compoundNBT.func_74767_n("Active");
        this.field_221346_j = compoundNBT.func_74763_f("TicksActive");
        this.field_221352_p = compoundNBT.func_74762_e("BadOmenLevel");
        this.field_221354_r = compoundNBT.func_74762_e("GroupsSpawned");
        this.field_221357_u = compoundNBT.func_74762_e("PreRaidTicks");
        this.field_221356_t = compoundNBT.func_74762_e("PostRaidTicks");
        this.field_221351_o = compoundNBT.func_74760_g("TotalHealth");
        this.field_221347_k = new BlockPos(compoundNBT.func_74762_e("CX"), compoundNBT.func_74762_e("CY"), compoundNBT.func_74762_e("CZ"));
        this.field_221359_w = compoundNBT.func_74762_e("NumGroups");
        this.field_221360_x = Status.func_221275_b(compoundNBT.func_74779_i("Status"));
        this.field_221345_i.clear();
        if (compoundNBT.func_150297_b("HeroesOfTheVillage", 9)) {
            ListNBT listNBT = compoundNBT.func_150295_c("HeroesOfTheVillage", 11);
            for (int i = 0; i < listNBT.size(); ++i) {
                this.field_221345_i.add(NBTUtil.func_186860_b(listNBT.get(i)));
            }
        }
    }

    public boolean func_221319_a() {
        return this.func_221321_e() || this.func_221336_f();
    }

    public boolean func_221334_b() {
        return this.func_221297_c() && this.func_221303_s() == 0 && this.field_221357_u > 0;
    }

    public boolean func_221297_c() {
        return this.field_221354_r > 0;
    }

    public boolean func_221310_d() {
        return this.field_221360_x == Status.STOPPED;
    }

    public boolean func_221321_e() {
        return this.field_221360_x == Status.VICTORY;
    }

    public boolean func_221336_f() {
        return this.field_221360_x == Status.LOSS;
    }

    public World func_221316_i() {
        return this.field_221348_l;
    }

    public boolean func_221301_k() {
        return this.field_221349_m;
    }

    public int func_221315_l() {
        return this.field_221354_r;
    }

    private Predicate<ServerPlayerEntity> func_221299_x() {
        return serverPlayerEntity -> {
            BlockPos blockPos = serverPlayerEntity.func_233580_cy_();
            return serverPlayerEntity.func_70089_S() && this.field_221348_l.func_217475_c_(blockPos) == this;
        };
    }

    private void func_221329_y() {
        HashSet hashSet = Sets.newHashSet(this.field_221355_s.func_186757_c());
        List<ServerPlayerEntity> \u26032 = this.field_221348_l.func_217490_a(this.func_221299_x());
        for (ServerPlayerEntity \u26033 : \u26032) {
            if (hashSet.contains(\u26033)) continue;
            this.field_221355_s.func_186760_a(\u26033);
        }
        for (ServerPlayerEntity \u26033 : hashSet) {
            if (\u26032.contains(\u26033)) continue;
            this.field_221355_s.func_186761_b(\u26033);
        }
    }

    public int func_221327_m() {
        return 5;
    }

    public int func_221291_n() {
        return this.field_221352_p;
    }

    public void func_221309_a(PlayerEntity playerEntity) {
        if (playerEntity.func_70644_a(Effects.field_220309_E)) {
            this.field_221352_p += playerEntity.func_70660_b(Effects.field_220309_E).func_76458_c() + 1;
            this.field_221352_p = MathHelper.func_76125_a(this.field_221352_p, 0, this.func_221327_m());
        }
        playerEntity.func_195063_d(Effects.field_220309_E);
    }

    public void func_221295_o() {
        this.field_221353_q = false;
        this.field_221355_s.func_201360_b();
        this.field_221360_x = Status.STOPPED;
    }

    public void func_221307_p() {
        if (this.func_221310_d()) {
            return;
        }
        if (this.field_221360_x == Status.ONGOING) {
            int \u26033;
            boolean bl = this.field_221353_q;
            this.field_221353_q = this.field_221348_l.func_175667_e(this.field_221347_k);
            if (this.field_221348_l.func_175659_aa() == Difficulty.PEACEFUL) {
                this.func_221295_o();
                return;
            }
            if (bl != this.field_221353_q) {
                this.field_221355_s.func_186758_d(this.field_221353_q);
            }
            if (!this.field_221353_q) {
                return;
            }
            if (!this.field_221348_l.func_217483_b_(this.field_221347_k)) {
                this.func_223027_y();
            }
            if (!this.field_221348_l.func_217483_b_(this.field_221347_k)) {
                if (this.field_221354_r > 0) {
                    this.field_221360_x = Status.LOSS;
                } else {
                    this.func_221295_o();
                }
            }
            ++this.field_221346_j;
            if (this.field_221346_j >= 48000L) {
                this.func_221295_o();
                return;
            }
            int \u26032 = this.func_221303_s();
            if (\u26032 == 0 && this.func_221289_z()) {
                if (this.field_221357_u > 0) {
                    bl2 = this.field_221362_z.isPresent();
                    int n = \u26033 = !bl2 && this.field_221357_u % 5 == 0 ? 1 : 0;
                    if (bl2 && !this.field_221348_l.func_72863_F().func_222865_a(new ChunkPos(this.field_221362_z.get()))) {
                        \u26033 = 1;
                    }
                    if (\u26033 != 0) {
                        \u2603 = 0;
                        if (this.field_221357_u < 100) {
                            \u2603 = 1;
                        } else if (this.field_221357_u < 40) {
                            \u2603 = 2;
                        }
                        this.field_221362_z = this.func_221313_d(\u2603);
                    }
                    if (this.field_221357_u == 300 || this.field_221357_u % 20 == 0) {
                        this.func_221329_y();
                    }
                    --this.field_221357_u;
                    this.field_221355_s.func_186735_a(MathHelper.func_76131_a((float)(300 - this.field_221357_u) / 300.0f, 0.0f, 1.0f));
                } else if (this.field_221357_u == 0 && this.field_221354_r > 0) {
                    this.field_221357_u = 300;
                    this.field_221355_s.func_186739_a(field_221338_b);
                    return;
                }
            }
            if (this.field_221346_j % 20L == 0L) {
                this.func_221329_y();
                this.func_221292_E();
                if (\u26032 > 0) {
                    if (\u26032 <= 2) {
                        this.field_221355_s.func_186739_a(field_221338_b.func_230532_e_().func_240702_b_(" - ").func_230529_a_(new TranslationTextComponent("event.minecraft.raid.raiders_remaining", \u26032)));
                    } else {
                        this.field_221355_s.func_186739_a(field_221338_b);
                    }
                } else {
                    this.field_221355_s.func_186739_a(field_221338_b);
                }
            }
            boolean bl2 = false;
            \u26033 = 0;
            while (this.func_221318_F()) {
                BlockPos blockPos = \u2603 = this.field_221362_z.isPresent() ? this.field_221362_z.get() : this.func_221298_a(\u26033, 20);
                if (\u2603 != null) {
                    this.field_221349_m = true;
                    this.func_221294_b(\u2603);
                    if (!bl2) {
                        this.func_221293_a(\u2603);
                        bl2 = true;
                    }
                } else {
                    ++\u26033;
                }
                if (\u26033 <= 3) continue;
                this.func_221295_o();
                break;
            }
            if (this.func_221301_k() && !this.func_221289_z() && \u26032 == 0) {
                if (this.field_221356_t < 40) {
                    ++this.field_221356_t;
                } else {
                    this.field_221360_x = Status.VICTORY;
                    for (UUID uUID : this.field_221345_i) {
                        Entity entity = this.field_221348_l.func_217461_a(uUID);
                        if (!(entity instanceof LivingEntity) || entity.func_175149_v()) continue;
                        LivingEntity \u26034 = (LivingEntity)entity;
                        \u26034.func_195064_c(new EffectInstance(Effects.field_220310_F, 48000, this.field_221352_p - 1, false, false, true));
                        if (!(\u26034 instanceof ServerPlayerEntity)) continue;
                        ServerPlayerEntity \u26035 = (ServerPlayerEntity)\u26034;
                        \u26035.func_195066_a(Stats.field_219742_az);
                        CriteriaTriggers.field_215101_H.func_192215_a(\u26035);
                    }
                }
            }
            this.func_221331_G();
        } else if (this.func_221319_a()) {
            ++this.field_221361_y;
            if (this.field_221361_y >= 600) {
                this.func_221295_o();
                return;
            }
            if (this.field_221361_y % 20 == 0) {
                this.func_221329_y();
                this.field_221355_s.func_186758_d(true);
                if (this.func_221321_e()) {
                    this.field_221355_s.func_186735_a(0.0f);
                    this.field_221355_s.func_186739_a(field_221341_e);
                } else {
                    this.field_221355_s.func_186739_a(field_221342_f);
                }
            }
        }
    }

    private void func_223027_y() {
        Stream<SectionPos> stream = SectionPos.func_218158_a(SectionPos.func_218167_a(this.field_221347_k), 2);
        stream.filter(this.field_221348_l::func_222887_a).map(SectionPos::func_218160_t).min(Comparator.comparingDouble(blockPos -> blockPos.func_177951_i(this.field_221347_k))).ifPresent(this::func_223024_c);
    }

    private Optional<BlockPos> func_221313_d(int n) {
        for (\u2603 = 0; \u2603 < 3; ++\u2603) {
            BlockPos blockPos = this.func_221298_a(n, 1);
            if (blockPos == null) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    private boolean func_221289_z() {
        if (this.func_221328_B()) {
            return !this.func_221314_C();
        }
        return !this.func_221288_A();
    }

    private boolean func_221288_A() {
        return this.func_221315_l() == this.field_221359_w;
    }

    private boolean func_221328_B() {
        return this.field_221352_p > 1;
    }

    private boolean func_221314_C() {
        return this.func_221315_l() > this.field_221359_w;
    }

    private boolean func_221305_D() {
        return this.func_221288_A() && this.func_221303_s() == 0 && this.func_221328_B();
    }

    private void func_221292_E() {
        Iterator<Set<AbstractRaiderEntity>> iterator = this.field_221344_h.values().iterator();
        HashSet \u26032 = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<AbstractRaiderEntity> set = iterator.next();
            for (AbstractRaiderEntity abstractRaiderEntity : set) {
                BlockPos blockPos = abstractRaiderEntity.func_233580_cy_();
                if (abstractRaiderEntity.field_70128_L || abstractRaiderEntity.field_70170_p.func_234923_W_() != this.field_221348_l.func_234923_W_() || this.field_221347_k.func_177951_i(blockPos) >= 12544.0) {
                    \u26032.add(abstractRaiderEntity);
                    continue;
                }
                if (abstractRaiderEntity.field_70173_aa <= 600) continue;
                if (this.field_221348_l.func_217461_a(abstractRaiderEntity.func_110124_au()) == null) {
                    \u26032.add(abstractRaiderEntity);
                }
                if (!this.field_221348_l.func_217483_b_(blockPos) && abstractRaiderEntity.func_70654_ax() > 2400) {
                    abstractRaiderEntity.func_213653_b(abstractRaiderEntity.func_213661_eo() + 1);
                }
                if (abstractRaiderEntity.func_213661_eo() < 30) continue;
                \u26032.add(abstractRaiderEntity);
            }
        }
        for (AbstractRaiderEntity abstractRaiderEntity : \u26032) {
            this.func_221322_a(abstractRaiderEntity, true);
        }
    }

    private void func_221293_a(BlockPos blockPos) {
        float f = 13.0f;
        int \u26032 = 64;
        Collection<ServerPlayerEntity> \u26033 = this.field_221355_s.func_186757_c();
        for (ServerPlayerEntity serverPlayerEntity : this.field_221348_l.func_217369_A()) {
            Vector3d vector3d = serverPlayerEntity.func_213303_ch();
            \u2603 = Vector3d.func_237489_a_(blockPos);
            float \u26034 = MathHelper.func_76133_a((\u2603.field_72450_a - vector3d.field_72450_a) * (\u2603.field_72450_a - vector3d.field_72450_a) + (\u2603.field_72449_c - vector3d.field_72449_c) * (\u2603.field_72449_c - vector3d.field_72449_c));
            double \u26035 = vector3d.field_72450_a + (double)(13.0f / \u26034) * (\u2603.field_72450_a - vector3d.field_72450_a);
            double \u26036 = vector3d.field_72449_c + (double)(13.0f / \u26034) * (\u2603.field_72449_c - vector3d.field_72449_c);
            if (!(\u26034 <= 64.0f) && !\u26033.contains(serverPlayerEntity)) continue;
            serverPlayerEntity.field_71135_a.func_147359_a(new SPlaySoundEffectPacket(SoundEvents.field_219690_jn, SoundCategory.NEUTRAL, \u26035, serverPlayerEntity.func_226278_cu_(), \u26036, 64.0f, 1.0f));
        }
    }

    private void func_221294_b(BlockPos blockPos) {
        boolean bl = false;
        int \u26032 = this.field_221354_r + 1;
        this.field_221351_o = 0.0f;
        DifficultyInstance \u26033 = this.field_221348_l.func_175649_E(blockPos);
        \u2603 = this.func_221305_D();
        for (WaveMember waveMember : WaveMember.field_221284_f) {
            int n = this.func_221330_a(waveMember, \u26032, \u2603) + this.func_221335_a(waveMember, this.field_221358_v, \u26032, \u26033, \u2603);
            \u2603 = 0;
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                AbstractRaiderEntity abstractRaiderEntity = (AbstractRaiderEntity)waveMember.field_221285_g.func_200721_a(this.field_221348_l);
                if (!bl && abstractRaiderEntity.func_213637_dY()) {
                    abstractRaiderEntity.func_213635_r(true);
                    this.func_221324_a(\u26032, abstractRaiderEntity);
                    bl = true;
                }
                this.func_221317_a(\u26032, abstractRaiderEntity, blockPos, false);
                if (waveMember.field_221285_g != EntityType.field_220352_aU) continue;
                \u2603 = null;
                if (\u26032 == this.func_221306_a(Difficulty.NORMAL)) {
                    \u2603 = EntityType.field_220350_aJ.func_200721_a(this.field_221348_l);
                } else if (\u26032 >= this.func_221306_a(Difficulty.HARD)) {
                    \u2603 = \u2603 == 0 ? (AbstractRaiderEntity)EntityType.field_200806_t.func_200721_a(this.field_221348_l) : (AbstractRaiderEntity)EntityType.field_200758_ax.func_200721_a(this.field_221348_l);
                }
                ++\u2603;
                if (\u2603 == null) continue;
                this.func_221317_a(\u26032, \u2603, blockPos, false);
                \u2603.func_174828_a(blockPos, 0.0f, 0.0f);
                \u2603.func_184220_m(abstractRaiderEntity);
            }
        }
        this.field_221362_z = Optional.empty();
        ++this.field_221354_r;
        this.func_221320_q();
        this.func_221331_G();
    }

    public void func_221317_a(int n, AbstractRaiderEntity abstractRaiderEntity, @Nullable BlockPos blockPos, boolean bl) {
        \u2603 = this.func_221287_b(n, abstractRaiderEntity);
        if (\u2603) {
            abstractRaiderEntity.func_213652_a(this);
            abstractRaiderEntity.func_213651_a(n);
            abstractRaiderEntity.func_213644_t(true);
            abstractRaiderEntity.func_213653_b(0);
            if (!bl && blockPos != null) {
                abstractRaiderEntity.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 1.0, (double)blockPos.func_177952_p() + 0.5);
                abstractRaiderEntity.func_213386_a(this.field_221348_l, this.field_221348_l.func_175649_E(blockPos), SpawnReason.EVENT, null, null);
                abstractRaiderEntity.func_213660_a(n, false);
                abstractRaiderEntity.func_230245_c_(true);
                this.field_221348_l.func_217376_c(abstractRaiderEntity);
            }
        }
    }

    public void func_221320_q() {
        this.field_221355_s.func_186735_a(MathHelper.func_76131_a(this.func_221290_r() / this.field_221351_o, 0.0f, 1.0f));
    }

    public float func_221290_r() {
        float f = 0.0f;
        for (Set<AbstractRaiderEntity> set : this.field_221344_h.values()) {
            for (AbstractRaiderEntity abstractRaiderEntity : set) {
                f += abstractRaiderEntity.func_110143_aJ();
            }
        }
        return f;
    }

    private boolean func_221318_F() {
        return this.field_221357_u == 0 && (this.field_221354_r < this.field_221359_w || this.func_221305_D()) && this.func_221303_s() == 0;
    }

    public int func_221303_s() {
        return this.field_221344_h.values().stream().mapToInt(Set::size).sum();
    }

    public void func_221322_a(AbstractRaiderEntity abstractRaiderEntity, boolean bl) {
        Set<AbstractRaiderEntity> set = this.field_221344_h.get(abstractRaiderEntity.func_213642_em());
        if (set != null && (\u2603 = set.remove(abstractRaiderEntity))) {
            if (bl) {
                this.field_221351_o -= abstractRaiderEntity.func_110143_aJ();
            }
            abstractRaiderEntity.func_213652_a(null);
            this.func_221320_q();
            this.func_221331_G();
        }
    }

    private void func_221331_G() {
        this.field_221348_l.func_217452_C().func_76185_a();
    }

    public static ItemStack func_221312_H() {
        ItemStack itemStack = new ItemStack(Items.field_196191_eg);
        CompoundNBT \u26032 = itemStack.func_190925_c("BlockEntityTag");
        ListNBT \u26033 = new BannerPattern.Builder().func_222477_a(BannerPattern.RHOMBUS_MIDDLE, DyeColor.CYAN).func_222477_a(BannerPattern.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.STRIPE_CENTER, DyeColor.GRAY).func_222477_a(BannerPattern.BORDER, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.STRIPE_MIDDLE, DyeColor.BLACK).func_222477_a(BannerPattern.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.CIRCLE_MIDDLE, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.BORDER, DyeColor.BLACK).func_222476_a();
        \u26032.func_218657_a("Patterns", \u26033);
        itemStack.func_196082_o().func_74768_a("HideFlags", 32);
        itemStack.func_200302_a(new TranslationTextComponent("block.minecraft.ominous_banner").func_240699_a_(TextFormatting.GOLD));
        return itemStack;
    }

    @Nullable
    public AbstractRaiderEntity func_221332_b(int n) {
        return this.field_221343_g.get(n);
    }

    @Nullable
    private BlockPos func_221298_a(int n, int n2) {
        \u2603 = n == 0 ? 2 : 2 - n;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i < n2; ++i) {
            float f = this.field_221348_l.field_73012_v.nextFloat() * ((float)Math.PI * 2);
            int \u26032 = this.field_221347_k.func_177958_n() + MathHelper.func_76141_d(MathHelper.func_76134_b(f) * 32.0f * (float)\u2603) + this.field_221348_l.field_73012_v.nextInt(5);
            int \u26033 = this.field_221347_k.func_177952_p() + MathHelper.func_76141_d(MathHelper.func_76126_a(f) * 32.0f * (float)\u2603) + this.field_221348_l.field_73012_v.nextInt(5);
            int \u26034 = this.field_221348_l.func_201676_a(Heightmap.Type.WORLD_SURFACE, \u26032, \u26033);
            mutable.func_181079_c(\u26032, \u26034, \u26033);
            if (this.field_221348_l.func_217483_b_(mutable) && n < 2 || !this.field_221348_l.func_217344_a(mutable.func_177958_n() - 10, mutable.func_177956_o() - 10, mutable.func_177952_p() - 10, mutable.func_177958_n() + 10, mutable.func_177956_o() + 10, mutable.func_177952_p() + 10) || !this.field_221348_l.func_72863_F().func_222865_a(new ChunkPos(mutable)) || !WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, this.field_221348_l, mutable, EntityType.field_220352_aU) && (!this.field_221348_l.func_180495_p((BlockPos)mutable.func_177977_b()).func_203425_a(Blocks.field_150433_aE) || !this.field_221348_l.func_180495_p(mutable).func_196958_f())) continue;
            return mutable;
        }
        return null;
    }

    private boolean func_221287_b(int n, AbstractRaiderEntity abstractRaiderEntity) {
        return this.func_221300_a(n, abstractRaiderEntity, true);
    }

    public boolean func_221300_a(int n2, AbstractRaiderEntity abstractRaiderEntity, boolean bl) {
        this.field_221344_h.computeIfAbsent(n2, n -> Sets.newHashSet());
        Set<AbstractRaiderEntity> set = this.field_221344_h.get(n2);
        AbstractRaiderEntity \u26032 = null;
        for (AbstractRaiderEntity abstractRaiderEntity2 : set) {
            if (!abstractRaiderEntity2.func_110124_au().equals(abstractRaiderEntity.func_110124_au())) continue;
            \u26032 = abstractRaiderEntity2;
            break;
        }
        if (\u26032 != null) {
            set.remove(\u26032);
            set.add(abstractRaiderEntity);
        }
        set.add(abstractRaiderEntity);
        if (bl) {
            this.field_221351_o += abstractRaiderEntity.func_110143_aJ();
        }
        this.func_221320_q();
        this.func_221331_G();
        return true;
    }

    public void func_221324_a(int n, AbstractRaiderEntity abstractRaiderEntity) {
        this.field_221343_g.put(n, abstractRaiderEntity);
        abstractRaiderEntity.func_184201_a(EquipmentSlotType.HEAD, Raid.func_221312_H());
        abstractRaiderEntity.func_184642_a(EquipmentSlotType.HEAD, 2.0f);
    }

    public void func_221296_c(int n) {
        this.field_221343_g.remove(n);
    }

    public BlockPos func_221304_t() {
        return this.field_221347_k;
    }

    private void func_223024_c(BlockPos blockPos) {
        this.field_221347_k = blockPos;
    }

    public int func_221325_u() {
        return this.field_221350_n;
    }

    private int func_221330_a(WaveMember waveMember, int n, boolean bl) {
        return bl ? waveMember.field_221286_h[this.field_221359_w] : waveMember.field_221286_h[n];
    }

    private int func_221335_a(WaveMember waveMember, Random random2, int n, DifficultyInstance difficultyInstance, boolean bl) {
        int \u26034;
        Difficulty difficulty = difficultyInstance.func_203095_a();
        boolean \u26032 = difficulty == Difficulty.EASY;
        boolean \u26033 = difficulty == Difficulty.NORMAL;
        switch (waveMember) {
            case WITCH: {
                if (!\u26032 && n > 2 && n != 4) {
                    \u26034 = 1;
                    break;
                }
                return 0;
            }
            case PILLAGER: 
            case VINDICATOR: {
                if (\u26032) {
                    Random random2;
                    \u26034 = random2.nextInt(2);
                    break;
                }
                if (\u26033) {
                    \u26034 = 1;
                    break;
                }
                \u26034 = 2;
                break;
            }
            case RAVAGER: {
                \u26034 = !\u26032 && bl ? 1 : 0;
                break;
            }
            default: {
                return 0;
            }
        }
        return \u26034 > 0 ? random2.nextInt(\u26034 + 1) : 0;
    }

    public boolean func_221333_v() {
        return this.field_221353_q;
    }

    public CompoundNBT func_221326_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        compoundNBT2.func_74768_a("Id", this.field_221350_n);
        compoundNBT2.func_74757_a("Started", this.field_221349_m);
        compoundNBT2.func_74757_a("Active", this.field_221353_q);
        compoundNBT2.func_74772_a("TicksActive", this.field_221346_j);
        compoundNBT2.func_74768_a("BadOmenLevel", this.field_221352_p);
        compoundNBT2.func_74768_a("GroupsSpawned", this.field_221354_r);
        compoundNBT2.func_74768_a("PreRaidTicks", this.field_221357_u);
        compoundNBT2.func_74768_a("PostRaidTicks", this.field_221356_t);
        compoundNBT2.func_74776_a("TotalHealth", this.field_221351_o);
        compoundNBT2.func_74768_a("NumGroups", this.field_221359_w);
        compoundNBT2.func_74778_a("Status", this.field_221360_x.func_221277_a());
        compoundNBT2.func_74768_a("CX", this.field_221347_k.func_177958_n());
        compoundNBT2.func_74768_a("CY", this.field_221347_k.func_177956_o());
        compoundNBT2.func_74768_a("CZ", this.field_221347_k.func_177952_p());
        ListNBT listNBT = new ListNBT();
        for (UUID uUID : this.field_221345_i) {
            listNBT.add(NBTUtil.func_240626_a_(uUID));
        }
        compoundNBT2.func_218657_a("HeroesOfTheVillage", listNBT);
        return compoundNBT2;
    }

    public int func_221306_a(Difficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float func_221308_w() {
        int n = this.func_221291_n();
        if (n == 2) {
            return 0.1f;
        }
        if (n == 3) {
            return 0.25f;
        }
        if (n == 4) {
            return 0.5f;
        }
        if (n == 5) {
            return 0.75f;
        }
        return 0.0f;
    }

    public void func_221311_a(Entity entity) {
        this.field_221345_i.add(entity.func_110124_au());
    }

    static enum WaveMember {
        VINDICATOR(EntityType.field_200758_ax, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityType.field_200806_t, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityType.field_220350_aJ, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityType.field_200759_ay, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityType.field_220352_aU, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        private static final WaveMember[] field_221284_f;
        private final EntityType<? extends AbstractRaiderEntity> field_221285_g;
        private final int[] field_221286_h;

        private WaveMember(EntityType<? extends AbstractRaiderEntity> entityType, int[] nArray) {
            this.field_221285_g = entityType;
            this.field_221286_h = nArray;
        }

        static {
            field_221284_f = WaveMember.values();
        }
    }

    static enum Status {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final Status[] field_221278_e;

        private static Status func_221275_b(String string) {
            for (Status status : field_221278_e) {
                if (!string.equalsIgnoreCase(status.name())) continue;
                return status;
            }
            return ONGOING;
        }

        public String func_221277_a() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            field_221278_e = Status.values();
        }
    }
}

