/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.IGeneratedBlockstate;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BlockStateProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @VisibleForTesting
    protected final Map<Block, IGeneratedBlockstate> registeredBlocks = new LinkedHashMap<Block, IGeneratedBlockstate>();
    private final DataGenerator generator;
    private final String modid;
    private final BlockModelProvider blockModels;
    private final ItemModelProvider itemModels;
    private static final int DEFAULT_ANGLE_OFFSET = 180;
    public static final ImmutableMap<Direction, Property<WallHeight>> WALL_PROPS = ImmutableMap.builder().put((Object)Direction.EAST, (Object)BlockStateProperties.field_235908_S_).put((Object)Direction.NORTH, (Object)BlockStateProperties.field_235909_T_).put((Object)Direction.SOUTH, (Object)BlockStateProperties.field_235910_U_).put((Object)Direction.WEST, (Object)BlockStateProperties.field_235911_V_).build();

    public BlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        this.generator = gen;
        this.modid = modid;
        this.blockModels = new BlockModelProvider(gen, modid, exFileHelper){

            @Override
            protected void registerModels() {
            }
        };
        this.itemModels = new ItemModelProvider(gen, modid, exFileHelper){

            @Override
            protected void registerModels() {
            }
        };
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.models().clear();
        this.itemModels().clear();
        this.registeredBlocks.clear();
        this.registerStatesAndModels();
        this.models().generateAll(cache);
        this.itemModels().generateAll(cache);
        for (Map.Entry<Block, IGeneratedBlockstate> entry : this.registeredBlocks.entrySet()) {
            this.saveBlockState(cache, entry.getValue().toJson(), entry.getKey());
        }
    }

    protected abstract void registerStatesAndModels();

    public VariantBlockStateBuilder getVariantBuilder(Block b) {
        if (this.registeredBlocks.containsKey(b)) {
            IGeneratedBlockstate old = this.registeredBlocks.get(b);
            Preconditions.checkState((boolean)(old instanceof VariantBlockStateBuilder));
            return (VariantBlockStateBuilder)old;
        }
        VariantBlockStateBuilder ret = new VariantBlockStateBuilder(b);
        this.registeredBlocks.put(b, ret);
        return ret;
    }

    public MultiPartBlockStateBuilder getMultipartBuilder(Block b) {
        if (this.registeredBlocks.containsKey(b)) {
            IGeneratedBlockstate old = this.registeredBlocks.get(b);
            Preconditions.checkState((boolean)(old instanceof MultiPartBlockStateBuilder));
            return (MultiPartBlockStateBuilder)old;
        }
        MultiPartBlockStateBuilder ret = new MultiPartBlockStateBuilder(b);
        this.registeredBlocks.put(b, ret);
        return ret;
    }

    public BlockModelProvider models() {
        return this.blockModels;
    }

    public ItemModelProvider itemModels() {
        return this.itemModels;
    }

    public ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    public ResourceLocation mcLoc(String name) {
        return new ResourceLocation(name);
    }

    private String name(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    public ResourceLocation blockTexture(Block block) {
        ResourceLocation name = block.getRegistryName();
        return new ResourceLocation(name.func_110624_b(), "block/" + name.func_110623_a());
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.func_110624_b(), rl.func_110623_a() + suffix);
    }

    public ModelFile cubeAll(Block block) {
        return this.models().cubeAll(this.name(block), this.blockTexture(block));
    }

    public void simpleBlock(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
    }

    public void simpleBlock(Block block, Function<ModelFile, ConfiguredModel[]> expander) {
        this.simpleBlock(block, expander.apply(this.cubeAll(block)));
    }

    public void simpleBlock(Block block, ModelFile model) {
        this.simpleBlock(block, new ConfiguredModel(model));
    }

    public void simpleBlockItem(Block block, ModelFile model) {
        ((ItemModelBuilder)this.itemModels().getBuilder(block.getRegistryName().func_110623_a())).parent(model);
    }

    public void simpleBlock(Block block, ConfiguredModel ... models) {
        this.getVariantBuilder(block).partialState().setModels(models);
    }

    public void axisBlock(RotatedPillarBlock block) {
        this.axisBlock(block, this.blockTexture((Block)block));
    }

    public void logBlock(RotatedPillarBlock block) {
        this.axisBlock(block, this.blockTexture((Block)block), this.extend(this.blockTexture((Block)block), "_top"));
    }

    public void axisBlock(RotatedPillarBlock block, ResourceLocation baseName) {
        this.axisBlock(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"));
    }

    public void axisBlock(RotatedPillarBlock block, ResourceLocation side, ResourceLocation end) {
        this.axisBlock(block, (ModelFile)this.models().cubeColumn(this.name((Block)block), side, end), (ModelFile)this.models().cubeColumnHorizontal(this.name((Block)block) + "_horizontal", side, end));
    }

    public void axisBlock(RotatedPillarBlock block, ModelFile vertical, ModelFile horizontal) {
        this.getVariantBuilder((Block)block).partialState().with(RotatedPillarBlock.field_176298_M, Direction.Axis.Y).modelForState().modelFile(vertical).addModel().partialState().with(RotatedPillarBlock.field_176298_M, Direction.Axis.Z).modelForState().modelFile(horizontal).rotationX(90).addModel().partialState().with(RotatedPillarBlock.field_176298_M, Direction.Axis.X).modelForState().modelFile(horizontal).rotationX(90).rotationY(90).addModel();
    }

    public void horizontalBlock(Block block, ResourceLocation side, ResourceLocation front, ResourceLocation top) {
        this.horizontalBlock(block, (ModelFile)this.models().orientable(this.name(block), side, front, top));
    }

    public void horizontalBlock(Block block, ModelFile model) {
        this.horizontalBlock(block, model, 180);
    }

    public void horizontalBlock(Block block, ModelFile model, int angleOffset) {
        this.horizontalBlock(block, (BlockState $) -> model, angleOffset);
    }

    public void horizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.horizontalBlock(block, modelFunc, 180);
    }

    public void horizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + angleOffset) % 360).build());
    }

    public void horizontalFaceBlock(Block block, ModelFile model) {
        this.horizontalFaceBlock(block, model, 180);
    }

    public void horizontalFaceBlock(Block block, ModelFile model, int angleOffset) {
        this.horizontalFaceBlock(block, (BlockState $) -> model, angleOffset);
    }

    public void horizontalFaceBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.horizontalBlock(block, modelFunc, 180);
    }

    public void horizontalFaceBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(((AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K)).ordinal() * 90).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + angleOffset + (state.func_177229_b((Property)BlockStateProperties.field_208158_K) == AttachFace.CEILING ? 180 : 0)) % 360).build());
    }

    public void directionalBlock(Block block, ModelFile model) {
        this.directionalBlock(block, model, 180);
    }

    public void directionalBlock(Block block, ModelFile model, int angleOffset) {
        this.directionalBlock(block, (BlockState $) -> model, angleOffset);
    }

    public void directionalBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalBlock(block, modelFunc, 180);
    }

    public void directionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + angleOffset) % 360).build();
        });
    }

    public void stairsBlock(StairsBlock block, ResourceLocation texture) {
        this.stairsBlock(block, texture, texture, texture);
    }

    public void stairsBlock(StairsBlock block, String name, ResourceLocation texture) {
        this.stairsBlock(block, name, texture, texture, texture);
    }

    public void stairsBlock(StairsBlock block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternal(block, block.getRegistryName().toString(), side, bottom, top);
    }

    public void stairsBlock(StairsBlock block, String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternal(block, name + "_stairs", side, bottom, top);
    }

    private void stairsBlockInternal(StairsBlock block, String baseName, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        Object stairs = this.models().stairs(baseName, side, bottom, top);
        Object stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        Object stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    public void stairsBlock(StairsBlock block, ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
            Half half = (Half)state.func_177229_b((Property)StairsBlock.field_176308_b);
            StairsShape shape = (StairsShape)state.func_177229_b((Property)StairsBlock.field_176310_M);
            int yRot = (int)facing.func_176746_e().func_185119_l();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{StairsBlock.field_204513_t});
    }

    public void slabBlock(SlabBlock block, ResourceLocation doubleslab, ResourceLocation texture) {
        this.slabBlock(block, doubleslab, texture, texture, texture);
    }

    public void slabBlock(SlabBlock block, ResourceLocation doubleslab, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlock(block, (ModelFile)this.models().slab(this.name((Block)block), side, bottom, top), (ModelFile)this.models().slabTop(this.name((Block)block) + "_top", side, bottom, top), this.models().getExistingFile(doubleslab));
    }

    public void slabBlock(SlabBlock block, ModelFile bottom, ModelFile top, ModelFile doubleslab) {
        this.getVariantBuilder((Block)block).partialState().with(SlabBlock.field_196505_a, SlabType.BOTTOM).addModels(new ConfiguredModel(bottom)).partialState().with(SlabBlock.field_196505_a, SlabType.TOP).addModels(new ConfiguredModel(top)).partialState().with(SlabBlock.field_196505_a, SlabType.DOUBLE).addModels(new ConfiguredModel(doubleslab));
    }

    public void fourWayBlock(FourWayBlock block, ModelFile post, ModelFile side) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block).part().modelFile(post).addModel().end();
        this.fourWayMultipart(builder, side);
    }

    public void fourWayMultipart(MultiPartBlockStateBuilder builder, ModelFile side) {
        SixWayBlock.field_196491_B.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.func_176740_k().func_176722_c()) {
                builder.part().modelFile(side).rotationY(((int)dir.func_185119_l() + 180) % 360).uvLock(true).addModel().condition((Property)e.getValue(), new Boolean[]{true});
            }
        });
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        String baseName = block.getRegistryName().toString();
        this.fourWayBlock((FourWayBlock)block, (ModelFile)this.models().fencePost(baseName + "_post", texture), (ModelFile)this.models().fenceSide(baseName + "_side", texture));
    }

    public void fenceBlock(FenceBlock block, String name, ResourceLocation texture) {
        this.fourWayBlock((FourWayBlock)block, (ModelFile)this.models().fencePost(name + "_fence_post", texture), (ModelFile)this.models().fenceSide(name + "_fence_side", texture));
    }

    public void fenceGateBlock(FenceGateBlock block, ResourceLocation texture) {
        this.fenceGateBlockInternal(block, block.getRegistryName().toString(), texture);
    }

    public void fenceGateBlock(FenceGateBlock block, String name, ResourceLocation texture) {
        this.fenceGateBlockInternal(block, name + "_fence_gate", texture);
    }

    private void fenceGateBlockInternal(FenceGateBlock block, String baseName, ResourceLocation texture) {
        Object gate = this.models().fenceGate(baseName, texture);
        Object gateOpen = this.models().fenceGateOpen(baseName + "_open", texture);
        Object gateWall = this.models().fenceGateWall(baseName + "_wall", texture);
        Object gateWallOpen = this.models().fenceGateWallOpen(baseName + "_wall_open", texture);
        this.fenceGateBlock(block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void fenceGateBlock(FenceGateBlock block, ModelFile gate, ModelFile gateOpen, ModelFile gateWall, ModelFile gateWallOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            ModelFile model = gate;
            if (((Boolean)state.func_177229_b((Property)FenceGateBlock.field_176467_M)).booleanValue()) {
                model = gateWall;
            }
            if (((Boolean)state.func_177229_b((Property)FenceGateBlock.field_176466_a)).booleanValue()) {
                model = model == gateWall ? gateWallOpen : gateOpen;
            }
            return ConfiguredModel.builder().modelFile(model).rotationY((int)((Direction)state.func_177229_b((Property)FenceGateBlock.field_185512_D)).func_185119_l()).uvLock(true).build();
        }, new Property[]{FenceGateBlock.field_176465_b});
    }

    public void wallBlock(WallBlock block, ResourceLocation texture) {
        this.wallBlockInternal(block, block.getRegistryName().toString(), texture);
    }

    public void wallBlock(WallBlock block, String name, ResourceLocation texture) {
        this.wallBlockInternal(block, name + "_wall", texture);
    }

    private void wallBlockInternal(WallBlock block, String baseName, ResourceLocation texture) {
        this.wallBlock(block, (ModelFile)this.models().wallPost(baseName + "_post", texture), (ModelFile)this.models().wallSide(baseName + "_side", texture), (ModelFile)this.models().wallSideTall(baseName + "_side_tall", texture));
    }

    public void wallBlock(WallBlock block, ModelFile post, ModelFile side, ModelFile sideTall) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block).part().modelFile(post).addModel().condition((Property)WallBlock.field_176256_a, new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).func_176740_k().func_176722_c()).forEach(e -> {
            this.wallSidePart(builder, side, (Map.Entry<Direction, Property<WallHeight>>)e, WallHeight.LOW);
            this.wallSidePart(builder, sideTall, (Map.Entry<Direction, Property<WallHeight>>)e, WallHeight.TALL);
        });
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, Map.Entry<Direction, Property<WallHeight>> entry, WallHeight height) {
        builder.part().modelFile(model).rotationY(((int)entry.getKey().func_185119_l() + 180) % 360).uvLock(true).addModel().condition(entry.getValue(), (Comparable[])new WallHeight[]{height});
    }

    public void paneBlock(PaneBlock block, ResourceLocation pane, ResourceLocation edge) {
        this.paneBlockInternal(block, block.getRegistryName().toString(), pane, edge);
    }

    public void paneBlock(PaneBlock block, String name, ResourceLocation pane, ResourceLocation edge) {
        this.paneBlockInternal(block, name + "_pane", pane, edge);
    }

    private void paneBlockInternal(PaneBlock block, String baseName, ResourceLocation pane, ResourceLocation edge) {
        Object post = this.models().panePost(baseName + "_post", pane, edge);
        Object side = this.models().paneSide(baseName + "_side", pane, edge);
        Object sideAlt = this.models().paneSideAlt(baseName + "_side_alt", pane, edge);
        Object noSide = this.models().paneNoSide(baseName + "_noside", pane);
        Object noSideAlt = this.models().paneNoSideAlt(baseName + "_noside_alt", pane);
        this.paneBlock(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
    }

    public void paneBlock(PaneBlock block, ModelFile post, ModelFile side, ModelFile sideAlt, ModelFile noSide, ModelFile noSideAlt) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block).part().modelFile(post).addModel().end();
        SixWayBlock.field_196491_B.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.func_176740_k().func_176722_c()) {
                boolean alt = dir == Direction.SOUTH;
                builder.part().modelFile(alt || dir == Direction.WEST ? sideAlt : side).rotationY(dir.func_176740_k() == Direction.Axis.X ? 90 : 0).addModel().condition((Property)e.getValue(), new Boolean[]{true}).end().part().modelFile(alt || dir == Direction.EAST ? noSideAlt : noSide).rotationY(dir == Direction.WEST ? 270 : (dir == Direction.SOUTH ? 90 : 0)).addModel().condition((Property)e.getValue(), new Boolean[]{false});
            }
        });
    }

    public void doorBlock(DoorBlock block, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockInternal(block, block.getRegistryName().toString(), bottom, top);
    }

    public void doorBlock(DoorBlock block, String name, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockInternal(block, name + "_door", bottom, top);
    }

    private void doorBlockInternal(DoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation top) {
        Object bottomLeft = this.models().doorBottomLeft(baseName + "_bottom", bottom, top);
        Object bottomRight = this.models().doorBottomRight(baseName + "_bottom_hinge", bottom, top);
        Object topLeft = this.models().doorTopLeft(baseName + "_top", bottom, top);
        Object topRight = this.models().doorTopRight(baseName + "_top_hinge", bottom, top);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomRight, (ModelFile)topLeft, (ModelFile)topRight);
    }

    public void doorBlock(DoorBlock block, ModelFile bottomLeft, ModelFile bottomRight, ModelFile topLeft, ModelFile topRight) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.func_177229_b((Property)DoorBlock.field_176520_a)).func_185119_l() + 90;
            boolean rh = state.func_177229_b((Property)DoorBlock.field_176521_M) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.func_177229_b((Property)DoorBlock.field_176519_b);
            boolean right = rh ^ open;
            if (open) {
                yRot += 90;
            }
            if (rh && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(state.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER ? (right ? bottomRight : bottomLeft) : (right ? topRight : topLeft)).rotationY(yRot %= 360).build();
        }, new Property[]{DoorBlock.field_176522_N});
    }

    public void trapdoorBlock(TrapDoorBlock block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockInternal(block, block.getRegistryName().toString(), texture, orientable);
    }

    public void trapdoorBlock(TrapDoorBlock block, String name, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockInternal(block, name + "_trapdoor", texture, orientable);
    }

    private void trapdoorBlockInternal(TrapDoorBlock block, String baseName, ResourceLocation texture, boolean orientable) {
        Object bottom = orientable ? this.models().trapdoorOrientableBottom(baseName + "_bottom", texture) : this.models().trapdoorBottom(baseName + "_bottom", texture);
        Object top = orientable ? this.models().trapdoorOrientableTop(baseName + "_top", texture) : this.models().trapdoorTop(baseName + "_top", texture);
        Object open = orientable ? this.models().trapdoorOrientableOpen(baseName + "_open", texture) : this.models().trapdoorOpen(baseName + "_open", texture);
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
    }

    public void trapdoorBlock(TrapDoorBlock block, ModelFile bottom, ModelFile top, ModelFile open, boolean orientable) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int xRot = 0;
            int yRot = (int)((Direction)state.func_177229_b((Property)TrapDoorBlock.field_185512_D)).func_185119_l() + 180;
            boolean isOpen = (Boolean)state.func_177229_b((Property)TrapDoorBlock.field_176283_b);
            if (orientable && isOpen && state.func_177229_b((Property)TrapDoorBlock.field_176285_M) == Half.TOP) {
                xRot += 180;
                yRot += 180;
            }
            if (!orientable && !isOpen) {
                yRot = 0;
            }
            return ConfiguredModel.builder().modelFile(isOpen ? open : (state.func_177229_b((Property)TrapDoorBlock.field_176285_M) == Half.TOP ? top : bottom)).rotationX(xRot).rotationY(yRot %= 360).build();
        }, new Property[]{TrapDoorBlock.field_196381_c, TrapDoorBlock.field_204614_t});
    }

    private void saveBlockState(DirectoryCache cache, JsonObject stateJson, Block owner) {
        ResourceLocation blockName = (ResourceLocation)Preconditions.checkNotNull((Object)owner.getRegistryName());
        Path mainOutput = this.generator.func_200391_b();
        String pathSuffix = "assets/" + blockName.func_110624_b() + "/blockstates/" + blockName.func_110623_a() + ".json";
        Path outputPath = mainOutput.resolve(pathSuffix);
        try {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)stateJson, (Path)outputPath);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save blockstate to {}", (Object)outputPath, (Object)e);
        }
    }

    @Nonnull
    public String func_200397_b() {
        return "Block States: " + this.modid;
    }

    public static class ConfiguredModelList {
        private final List<ConfiguredModel> models;

        private ConfiguredModelList(List<ConfiguredModel> models) {
            Preconditions.checkArgument((!models.isEmpty() ? 1 : 0) != 0);
            this.models = models;
        }

        public ConfiguredModelList(ConfiguredModel model) {
            this((List<ConfiguredModel>)ImmutableList.of((Object)model));
        }

        public ConfiguredModelList(ConfiguredModel ... models) {
            this(Arrays.asList(models));
        }

        public JsonElement toJSON() {
            if (this.models.size() == 1) {
                return this.models.get(0).toJSON(false);
            }
            JsonArray ret = new JsonArray();
            for (ConfiguredModel m : this.models) {
                ret.add((JsonElement)m.toJSON(true));
            }
            return ret;
        }

        public ConfiguredModelList append(ConfiguredModel ... models) {
            return new ConfiguredModelList((List<ConfiguredModel>)ImmutableList.builder().addAll(this.models).add((Object[])models).build());
        }
    }
}

