/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;

public class ExistingFileHelper {
    private final SimpleReloadableResourceManager clientResources = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES);
    private final SimpleReloadableResourceManager serverData = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
    private final boolean enable;

    public ExistingFileHelper(Collection<Path> existingPacks, boolean enable) {
        this.clientResources.func_199021_a((IResourcePack)new VanillaPack(new String[]{"minecraft", "realms"}));
        this.serverData.func_199021_a((IResourcePack)new VanillaPack(new String[]{"minecraft"}));
        for (Path existing : existingPacks) {
            File file = existing.toFile();
            FolderPack pack = file.isDirectory() ? new FolderPack(file) : new FilePack(file);
            this.clientResources.func_199021_a((IResourcePack)pack);
            this.serverData.func_199021_a((IResourcePack)pack);
        }
        this.enable = enable;
    }

    private IResourceManager getManager(ResourcePackType type) {
        return type == ResourcePackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
    }

    private ResourceLocation getLocation(ResourceLocation base, String suffix, String prefix) {
        return new ResourceLocation(base.func_110624_b(), prefix + "/" + base.func_110623_a() + suffix);
    }

    public boolean exists(ResourceLocation loc, ResourcePackType type, String pathSuffix, String pathPrefix) {
        if (!this.enable) {
            return true;
        }
        return this.getManager(type).func_219533_b(this.getLocation(loc, pathSuffix, pathPrefix));
    }

    @VisibleForTesting
    public IResource getResource(ResourceLocation loc, ResourcePackType type, String pathSuffix, String pathPrefix) throws IOException {
        return this.getManager(type).func_199002_a(this.getLocation(loc, pathSuffix, pathPrefix));
    }

    public boolean isEnabled() {
        return this.enable;
    }
}

