/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class ModelBuilder<T extends ModelBuilder<T>>
extends ModelFile {
    @Nullable
    protected ModelFile parent;
    protected final Map<String, String> textures = new LinkedHashMap<String, String>();
    protected final TransformsBuilder transforms = new TransformsBuilder();
    protected final ExistingFileHelper existingFileHelper;
    protected boolean ambientOcclusion = true;
    protected BlockModel.GuiLight guiLight = null;
    protected final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();

    protected ModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation);
        this.existingFileHelper = existingFileHelper;
    }

    private T self() {
        return (T)this;
    }

    @Override
    protected boolean exists() {
        return true;
    }

    public T parent(ModelFile parent) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        parent.assertExistence();
        this.parent = parent;
        return this.self();
    }

    public T texture(String key, String texture) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        if (texture.charAt(0) == '#') {
            this.textures.put(key, texture);
            return this.self();
        }
        ResourceLocation asLoc = texture.contains(":") ? new ResourceLocation(texture) : new ResourceLocation(this.getLocation().func_110624_b(), texture);
        return this.texture(key, asLoc);
    }

    public T texture(String key, ResourceLocation texture) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(texture, ResourcePackType.CLIENT_RESOURCES, ".png", "textures"), (String)"Texture %s does not exist in any known resource pack", (Object)texture);
        this.textures.put(key, texture.toString());
        return this.self();
    }

    public TransformsBuilder transforms() {
        return this.transforms;
    }

    public T ao(boolean ao) {
        this.ambientOcclusion = ao;
        return this.self();
    }

    @Deprecated
    public T gui3d(boolean gui3d) {
        return this.self();
    }

    public T guiLight(BlockModel.GuiLight light) {
        this.guiLight = light;
        return this.self();
    }

    public ElementBuilder element() {
        ElementBuilder ret = new ElementBuilder();
        this.elements.add(ret);
        return ret;
    }

    public ElementBuilder element(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.elements.size(), (String)"Element index");
        return this.elements.get(index);
    }

    @VisibleForTesting
    public JsonObject toJson() {
        Map<Perspective, ItemTransformVec3f> transforms;
        JsonObject root = new JsonObject();
        if (this.parent != null) {
            root.addProperty("parent", this.parent.getLocation().toString());
        }
        if (!this.ambientOcclusion) {
            root.addProperty("ambientocclusion", Boolean.valueOf(this.ambientOcclusion));
        }
        if (this.guiLight != null) {
            root.addProperty("gui_light", this.guiLight.getSerializedName());
        }
        if (!(transforms = this.transforms.build()).isEmpty()) {
            JsonObject display = new JsonObject();
            for (Map.Entry<Perspective, ItemTransformVec3f> entry : transforms.entrySet()) {
                JsonObject transform = new JsonObject();
                ItemTransformVec3f vec = entry.getValue();
                if (vec.equals((Object)ItemTransformVec3f.field_178366_a)) continue;
                if (!vec.field_178364_b.equals((Object)ItemTransformVec3f.Deserializer.field_178362_a)) {
                    transform.add("rotation", (JsonElement)this.serializeVector3f(vec.field_178364_b));
                }
                if (!vec.field_178365_c.equals((Object)ItemTransformVec3f.Deserializer.field_178360_b)) {
                    transform.add("translation", (JsonElement)this.serializeVector3f(entry.getValue().field_178365_c));
                }
                if (!vec.field_178363_d.equals((Object)ItemTransformVec3f.Deserializer.field_178361_c)) {
                    transform.add("scale", (JsonElement)this.serializeVector3f(entry.getValue().field_178363_d));
                }
                display.add(entry.getKey().name, (JsonElement)transform);
            }
            root.add("display", (JsonElement)display);
        }
        if (!this.textures.isEmpty()) {
            JsonObject textures = new JsonObject();
            for (Map.Entry<Object, Object> entry : this.textures.entrySet()) {
                textures.addProperty((String)entry.getKey(), this.serializeLocOrKey((String)entry.getValue()));
            }
            root.add("textures", (JsonElement)textures);
        }
        if (!this.elements.isEmpty()) {
            JsonArray elements = new JsonArray();
            this.elements.stream().map(ElementBuilder::build).forEach(part -> {
                JsonObject partObj = new JsonObject();
                partObj.add("from", (JsonElement)this.serializeVector3f(part.field_178241_a));
                partObj.add("to", (JsonElement)this.serializeVector3f(part.field_178239_b));
                if (part.field_178237_d != null) {
                    JsonObject rotation = new JsonObject();
                    rotation.add("origin", (JsonElement)this.serializeVector3f(part.field_178237_d.field_178344_a));
                    rotation.addProperty("axis", part.field_178237_d.field_178342_b.func_176610_l());
                    rotation.addProperty("angle", (Number)Float.valueOf(part.field_178237_d.field_178343_c));
                    if (part.field_178237_d.field_178341_d) {
                        rotation.addProperty("rescale", Boolean.valueOf(part.field_178237_d.field_178341_d));
                    }
                    partObj.add("rotation", (JsonElement)rotation);
                }
                if (!part.field_178238_e) {
                    partObj.addProperty("shade", Boolean.valueOf(part.field_178238_e));
                }
                JsonObject faces = new JsonObject();
                for (Direction dir : Direction.values()) {
                    BlockPartFace face = (BlockPartFace)part.field_178240_c.get(dir);
                    if (face == null) continue;
                    JsonObject faceObj = new JsonObject();
                    faceObj.addProperty("texture", this.serializeLocOrKey(face.field_178242_d));
                    if (!Arrays.equals(face.field_178243_e.field_178351_a, part.func_178236_a(dir))) {
                        faceObj.add("uv", new Gson().toJsonTree((Object)face.field_178243_e.field_178351_a));
                    }
                    if (face.field_178244_b != null) {
                        faceObj.addProperty("cullface", face.field_178244_b.func_176610_l());
                    }
                    if (face.field_178243_e.field_178350_b != 0) {
                        faceObj.addProperty("rotation", (Number)face.field_178243_e.field_178350_b);
                    }
                    if (face.field_178245_c != -1) {
                        faceObj.addProperty("tintindex", (Number)face.field_178245_c);
                    }
                    faces.add(dir.func_176610_l(), (JsonElement)faceObj);
                }
                if (!part.field_178240_c.isEmpty()) {
                    partObj.add("faces", (JsonElement)faces);
                }
                elements.add((JsonElement)partObj);
            });
            root.add("elements", (JsonElement)elements);
        }
        return root;
    }

    private String serializeLocOrKey(String tex) {
        if (tex.charAt(0) == '#') {
            return tex;
        }
        return new ResourceLocation(tex).toString();
    }

    private JsonArray serializeVector3f(Vector3f vec) {
        JsonArray ret = new JsonArray();
        ret.add(this.serializeFloat(vec.func_195899_a()));
        ret.add(this.serializeFloat(vec.func_195900_b()));
        ret.add(this.serializeFloat(vec.func_195902_c()));
        return ret;
    }

    private Number serializeFloat(float f) {
        if ((float)((int)f) == f) {
            return (int)f;
        }
        return Float.valueOf(f);
    }

    public class TransformsBuilder {
        private final Map<Perspective, net.minecraftforge.client.model.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder> transforms = new LinkedHashMap<Perspective, net.minecraftforge.client.model.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder>();

        public net.minecraftforge.client.model.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder transform(Perspective type) {
            Preconditions.checkNotNull((Object)((Object)type), (Object)"Perspective cannot be null");
            return this.transforms.computeIfAbsent(type, x$0 -> new TransformVecBuilder((Perspective)((Object)x$0)));
        }

        Map<Perspective, ItemTransformVec3f> build() {
            return this.transforms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TransformVecBuilder)e.getValue()).build(), (k1, k2) -> {
                throw new IllegalArgumentException();
            }, LinkedHashMap::new));
        }

        public T end() {
            return ModelBuilder.this.self();
        }

        public class TransformVecBuilder {
            private Vector3f rotation = new Vector3f();
            private Vector3f translation = new Vector3f();
            private Vector3f scale = new Vector3f();

            TransformVecBuilder(Perspective type) {
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder rotation(float x, float y, float z) {
                this.rotation = new Vector3f(x, y, z);
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder translation(float x, float y, float z) {
                this.translation = new Vector3f(x, y, z);
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder scale(float sc) {
                return this.scale(sc, sc, sc);
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder scale(float x, float y, float z) {
                this.scale = new Vector3f(x, y, z);
                return this;
            }

            ItemTransformVec3f build() {
                return new ItemTransformVec3f(this.rotation, this.translation, this.scale);
            }

            public TransformsBuilder end() {
                return TransformsBuilder.this;
            }
        }
    }

    public static enum Perspective {
        THIRDPERSON_RIGHT(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, "thirdperson_righthand"),
        THIRDPERSON_LEFT(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, "thirdperson_lefthand"),
        FIRSTPERSON_RIGHT(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, "firstperson_righthand"),
        FIRSTPERSON_LEFT(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, "firstperson_lefthand"),
        HEAD(ItemCameraTransforms.TransformType.HEAD, "head"),
        GUI(ItemCameraTransforms.TransformType.GUI, "gui"),
        GROUND(ItemCameraTransforms.TransformType.GROUND, "ground"),
        FIXED(ItemCameraTransforms.TransformType.FIXED, "fixed");

        public final ItemCameraTransforms.TransformType vanillaType;
        final String name;

        private Perspective(ItemCameraTransforms.TransformType vanillaType, String name) {
            this.vanillaType = vanillaType;
            this.name = name;
        }
    }

    public static enum FaceRotation {
        ZERO(0),
        CLOCKWISE_90(90),
        UPSIDE_DOWN(180),
        COUNTERCLOCKWISE_90(270);

        final int rotation;

        private FaceRotation(int rotation) {
            this.rotation = rotation;
        }
    }

    public class ElementBuilder {
        private Vector3f from = new Vector3f();
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private final Map<Direction, net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder> faces = new LinkedHashMap<Direction, net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder>();
        private net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.RotationBuilder rotation;
        private boolean shade = true;

        private void validateCoordinate(float coord, char name) {
            Preconditions.checkArgument((!(coord < -16.0f) && !(coord > 32.0f) ? 1 : 0) != 0, (String)("Position " + name + " out of range, must be within [-16, 32]. Found: %d"), (Object)Float.valueOf(coord));
        }

        private void validatePosition(Vector3f pos) {
            this.validateCoordinate(pos.func_195899_a(), 'x');
            this.validateCoordinate(pos.func_195900_b(), 'y');
            this.validateCoordinate(pos.func_195902_c(), 'z');
        }

        public ElementBuilder from(float x, float y, float z) {
            this.from = new Vector3f(x, y, z);
            this.validatePosition(this.from);
            return this;
        }

        public ElementBuilder to(float x, float y, float z) {
            this.to = new Vector3f(x, y, z);
            this.validatePosition(this.to);
            return this;
        }

        public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder face(Direction dir) {
            Preconditions.checkNotNull((Object)dir, (Object)"Direction must not be null");
            return this.faces.computeIfAbsent(dir, x$0 -> new FaceBuilder((Direction)x$0));
        }

        public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.RotationBuilder rotation() {
            if (this.rotation == null) {
                this.rotation = new RotationBuilder();
            }
            return this.rotation;
        }

        public ElementBuilder shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        public ElementBuilder allFaces(BiConsumer<Direction, net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder> action) {
            Arrays.stream(Direction.values()).forEach(d -> action.accept((Direction)d, (net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder)this.face((Direction)d)));
            return this;
        }

        public ElementBuilder faces(BiConsumer<Direction, net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder> action) {
            this.faces.entrySet().stream().forEach(e -> action.accept((Direction)e.getKey(), (net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder)e.getValue()));
            return this;
        }

        public ElementBuilder textureAll(String texture) {
            return this.allFaces(this.addTexture(texture));
        }

        public ElementBuilder texture(String texture) {
            return this.faces(this.addTexture(texture));
        }

        public ElementBuilder cube(String texture) {
            return this.allFaces(this.addTexture(texture).andThen((dir, f) -> f.cullface(dir)));
        }

        private BiConsumer<Direction, net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder> addTexture(String texture) {
            return ($, f) -> f.texture(texture);
        }

        BlockPart build() {
            Map faces = this.faces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FaceBuilder)e.getValue()).build(), (k1, k2) -> {
                throw new IllegalArgumentException();
            }, LinkedHashMap::new));
            return new BlockPart(this.from, this.to, faces, this.rotation == null ? null : this.rotation.build(), this.shade);
        }

        public T end() {
            return ModelBuilder.this.self();
        }

        public class RotationBuilder {
            private Vector3f origin;
            private Direction.Axis axis;
            private float angle;
            private boolean rescale;

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.RotationBuilder origin(float x, float y, float z) {
                this.origin = new Vector3f(x, y, z);
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.RotationBuilder axis(Direction.Axis axis) {
                Preconditions.checkNotNull((Object)axis, (Object)"Axis must not be null");
                this.axis = axis;
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.RotationBuilder angle(float angle) {
                Preconditions.checkArgument((angle == 0.0f || MathHelper.func_76135_e((float)angle) == 22.5f || MathHelper.func_76135_e((float)angle) == 45.0f ? 1 : 0) != 0, (String)"Invalid rotation %f found, only -45/-22.5/0/22.5/45 allowed", (Object)Float.valueOf(angle));
                this.angle = angle;
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.RotationBuilder rescale(boolean rescale) {
                this.rescale = rescale;
                return this;
            }

            BlockPartRotation build() {
                return new BlockPartRotation(this.origin, this.axis, this.angle, this.rescale);
            }

            public ElementBuilder end() {
                return ElementBuilder.this;
            }
        }

        public class FaceBuilder {
            private Direction cullface;
            private int tintindex = -1;
            private String texture = MissingTextureSprite.func_195675_b().toString();
            private float[] uvs;
            private FaceRotation rotation = FaceRotation.ZERO;

            FaceBuilder(Direction dir) {
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder cullface(@Nullable Direction dir) {
                this.cullface = dir;
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder tintindex(int index) {
                this.tintindex = index;
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder texture(String texture) {
                Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
                this.texture = texture;
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder uvs(float u1, float v1, float u2, float v2) {
                this.uvs = new float[]{u1, v1, u2, v2};
                return this;
            }

            public net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder.FaceBuilder rotation(FaceRotation rot) {
                Preconditions.checkNotNull((Object)((Object)rot), (Object)"Rotation must not be null");
                this.rotation = rot;
                return this;
            }

            BlockPartFace build() {
                if (this.texture == null) {
                    throw new IllegalStateException("A model face must have a texture");
                }
                return new BlockPartFace(this.cullface, this.tintindex, this.texture, new BlockFaceUV(this.uvs, this.rotation.rotation));
            }

            public ElementBuilder end() {
                return ElementBuilder.this;
            }
        }
    }
}

