/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SidedInvWrapper
implements IItemHandlerModifiable {
    protected final ISidedInventory inv;
    @Nullable
    protected final Direction side;

    public static LazyOptional<IItemHandlerModifiable>[] create(ISidedInventory inv, Direction ... sides) {
        LazyOptional[] ret = new LazyOptional[sides.length];
        for (int x = 0; x < sides.length; ++x) {
            Direction side = sides[x];
            ret[x] = LazyOptional.of(() -> new SidedInvWrapper(inv, side));
        }
        return ret;
    }

    public SidedInvWrapper(ISidedInventory inv, @Nullable Direction side) {
        this.inv = inv;
        this.side = side;
    }

    public static int getSlot(ISidedInventory inv, int slot, @Nullable Direction side) {
        int[] slots = inv.func_180463_a(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedInvWrapper that = (SidedInvWrapper)o;
        return this.inv.equals(that.inv) && this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + (this.side == null ? 0 : this.side.hashCode());
        return result;
    }

    @Override
    public int getSlots() {
        return this.inv.func_180463_a(this.side).length;
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int i = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? ItemStack.field_190927_a : this.inv.func_70301_a(i);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.func_70301_a(slot1);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.inv.func_180462_a(slot1, stack, this.side) || !this.inv.func_94041_b(slot1, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.setInventorySlotContents(slot1, copy);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.inv.func_180462_a(slot1, stack, this.side) || !this.inv.func_94041_b(slot1, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setInventorySlotContents(slot1, stack.func_77979_a(m));
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot1, stack);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 != -1) {
            this.setInventorySlotContents(slot1, stack);
        }
    }

    private void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.func_70296_d();
        this.inv.func_70299_a(slot, stack);
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.inv.func_70301_a(slot1);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.inv.func_180461_b(slot1, stackInSlot, this.side)) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack ret = this.inv.func_70298_a(slot1, m);
        this.inv.func_70296_d();
        return ret;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.inv.func_70297_j_();
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return slot1 == -1 ? false : this.inv.func_94041_b(slot1, stack);
    }
}

