/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.command.EnumArgument;
import net.minecraftforge.server.command.ModIdArgument;

public class ConfigCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"config").then(ShowFile.register()));
    }

    public static class ShowFile {
        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"showfile").requires(cs -> cs.func_197034_c(0))).then(Commands.func_197056_a((String)"mod", (ArgumentType)ModIdArgument.modIdArgument()).then(Commands.func_197056_a((String)"type", EnumArgument.enumArgument(ModConfig.Type.class)).executes(ShowFile::showFile)));
        }

        private static int showFile(CommandContext<CommandSource> context) {
            ModConfig.Type type;
            String modId = (String)context.getArgument("mod", String.class);
            String configFileName = ConfigTracker.INSTANCE.getConfigFileName(modId, type = (ModConfig.Type)((Object)context.getArgument("type", ModConfig.Type.class)));
            if (configFileName != null) {
                File f = new File(configFileName);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.config.getwithtype", new Object[]{modId, type, new StringTextComponent(f.getName()).func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE}).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getAbsolutePath())))}), true);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.config.noconfig", new Object[]{modId, type}), true);
            }
            return 0;
        }
    }
}

