/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.ShulkerAABBHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShulkerBoxBlock
extends ContainerBlock {
    public static final EnumProperty<Direction> field_190957_a = DirectionalBlock.field_176387_N;
    public static final ResourceLocation field_220169_b = new ResourceLocation("contents");
    @Nullable
    private final DyeColor field_190958_b;

    public ShulkerBoxBlock(@Nullable DyeColor color, AbstractBlock.Properties properties) {
        super(properties);
        this.field_190958_b = color;
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_190957_a, (Comparable)((Object)Direction.UP))));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ShulkerBoxTileEntity(this.field_190958_b);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ShulkerBoxTileEntity) {
            boolean flag;
            ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)tileentity);
            if (shulkerboxtileentity.func_190591_p() == ShulkerBoxTileEntity.AnimationStatus.CLOSED) {
                Direction direction = (Direction)((Object)state.func_177229_b((Property)field_190957_a));
                flag = worldIn.func_226664_a_(ShulkerAABBHelper.func_233539_a_((BlockPos)pos, (Direction)direction));
            } else {
                flag = true;
            }
            if (flag) {
                player.func_213829_a((INamedContainerProvider)shulkerboxtileentity);
                player.func_195066_a(Stats.field_191272_ae);
                PiglinTasks.func_234478_a_(player, true);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_190957_a, (Comparable)((Object)context.func_196000_l())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_190957_a});
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ShulkerBoxTileEntity) {
            ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)tileentity);
            if (!worldIn.field_72995_K && player.func_184812_l_() && !shulkerboxtileentity.func_191420_l()) {
                ItemStack itemstack = ShulkerBoxBlock.func_190953_b(this.func_190956_e());
                CompoundNBT compoundnbt = shulkerboxtileentity.func_190580_f(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", compoundnbt);
                }
                if (shulkerboxtileentity.func_145818_k_()) {
                    itemstack.func_200302_a(shulkerboxtileentity.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c(itementity);
            } else {
                shulkerboxtileentity.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)((Object)builder.func_216019_b(LootParameters.field_216288_h));
        if (tileentity instanceof ShulkerBoxTileEntity) {
            ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)tileentity);
            builder = builder.func_216017_a(field_220169_b, (p_220168_1_, p_220168_2_) -> {
                for (int i = 0; i < shulkerboxtileentity.func_70302_i_(); ++i) {
                    p_220168_2_.accept(shulkerboxtileentity.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof ShulkerBoxTileEntity) {
            ((ShulkerBoxTileEntity)((Object)tileentity)).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof ShulkerBoxTileEntity) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("???????"));
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)((Object)ItemStack.field_190927_a));
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    IFormattableTextComponent iformattabletextcomponent = itemstack.func_200301_q().func_230532_e_();
                    iformattabletextcomponent.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                    tooltip.add((ITextComponent)iformattabletextcomponent);
                }
                if (j - i > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", j - i).func_240699_a_(TextFormatting.ITALIC));
                }
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof ShulkerBoxTileEntity ? VoxelShapes.func_197881_a((AxisAlignedBB)((ShulkerBoxTileEntity)((Object)tileentity)).func_190584_a(state)) : VoxelShapes.func_197868_b();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)worldIn.func_175625_s(pos));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.func_185473_a(worldIn, pos, state);
        ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)worldIn.func_175625_s(pos));
        CompoundNBT compoundnbt = shulkerboxtileentity.func_190580_f(new CompoundNBT());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", compoundnbt);
        }
        return itemstack;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static DyeColor func_190955_b(Item itemIn) {
        return ShulkerBoxBlock.func_190954_c(Block.func_149634_a(itemIn));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static DyeColor func_190954_c(Block blockIn) {
        return blockIn instanceof ShulkerBoxBlock ? ((ShulkerBoxBlock)((Object)blockIn)).func_190956_e() : null;
    }

    public static Block func_190952_a(@Nullable DyeColor colorIn) {
        if (colorIn == null) {
            return Blocks.field_204409_il;
        }
        switch (colorIn) {
            case WHITE: {
                return Blocks.field_190977_dl;
            }
            case ORANGE: {
                return Blocks.field_190978_dm;
            }
            case MAGENTA: {
                return Blocks.field_190979_dn;
            }
            case LIGHT_BLUE: {
                return Blocks.field_190980_do;
            }
            case YELLOW: {
                return Blocks.field_190981_dp;
            }
            case LIME: {
                return Blocks.field_190982_dq;
            }
            case PINK: {
                return Blocks.field_190983_dr;
            }
            case GRAY: {
                return Blocks.field_190984_ds;
            }
            case LIGHT_GRAY: {
                return Blocks.field_196875_ie;
            }
            case CYAN: {
                return Blocks.field_190986_du;
            }
            default: {
                return Blocks.field_190987_dv;
            }
            case BLUE: {
                return Blocks.field_190988_dw;
            }
            case BROWN: {
                return Blocks.field_190989_dx;
            }
            case GREEN: {
                return Blocks.field_190990_dy;
            }
            case RED: {
                return Blocks.field_190991_dz;
            }
            case BLACK: 
        }
        return Blocks.field_190975_dA;
    }

    @Nullable
    public DyeColor func_190956_e() {
        return this.field_190958_b;
    }

    public static ItemStack func_190953_b(@Nullable DyeColor colorIn) {
        return new ItemStack(ShulkerBoxBlock.func_190952_a(colorIn));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((Object)state.func_206870_a((Property)field_190957_a, (Comparable)((Object)rot.func_185831_a((Direction)((Object)state.func_177229_b((Property)field_190957_a))))));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)((Object)state.func_177229_b((Property)field_190957_a))));
    }
}

