/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class DisplayEffectsScreen<T extends Container>
extends ContainerScreen<T> {
    protected boolean field_147045_u;

    public DisplayEffectsScreen(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_175378_g();
    }

    protected void func_175378_g() {
        if (this.field_230706_i_.field_71439_g.func_70651_bq().isEmpty()) {
            this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
            this.field_147045_u = false;
        } else {
            this.field_147003_i = MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.PotionShiftEvent((Screen)this)) ? (this.field_230708_k_ - this.field_146999_f) / 2 : 160 + (this.field_230708_k_ - this.field_146999_f - 200) / 2;
            this.field_147045_u = true;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        if (this.field_147045_u) {
            this.func_238811_b_(p_230430_1_);
        }
    }

    private void func_238811_b_(MatrixStack p_238811_1_) {
        int i = this.field_147003_i - 124;
        Collection<EffectInstance> collection = this.field_230706_i_.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int j = 33;
            if (collection.size() > 5) {
                j = 132 / (collection.size() - 1);
            }
            Iterable iterable = collection.stream().filter(effectInstance -> effectInstance.shouldRender()).sorted().collect(Collectors.toList());
            this.func_238810_a_(p_238811_1_, i, j, iterable);
            this.func_238812_b_(p_238811_1_, i, j, iterable);
            this.func_238813_c_(p_238811_1_, i, j, iterable);
        }
    }

    private void func_238810_a_(MatrixStack p_238810_1_, int p_238810_2_, int p_238810_3_, Iterable<EffectInstance> p_238810_4_) {
        this.field_230706_i_.func_110434_K().func_110577_a(field_147001_a);
        int i = this.field_147009_r;
        for (EffectInstance effectinstance : p_238810_4_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(p_238810_1_, p_238810_2_, i, 0, 166, 140, 32);
            i += p_238810_3_;
        }
    }

    private void func_238812_b_(MatrixStack p_238812_1_, int p_238812_2_, int p_238812_3_, Iterable<EffectInstance> p_238812_4_) {
        PotionSpriteUploader potionspriteuploader = this.field_230706_i_.func_213248_ap();
        int i = this.field_147009_r;
        for (EffectInstance effectinstance : p_238812_4_) {
            Effect effect = effectinstance.func_188419_a();
            TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(effect);
            this.field_230706_i_.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
            DisplayEffectsScreen.func_238470_a_((MatrixStack)p_238812_1_, (int)(p_238812_2_ + 6), (int)(i + 7), (int)this.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            i += p_238812_3_;
        }
    }

    private void func_238813_c_(MatrixStack p_238813_1_, int p_238813_2_, int p_238813_3_, Iterable<EffectInstance> p_238813_4_) {
        int i = this.field_147009_r;
        for (EffectInstance effectinstance : p_238813_4_) {
            effectinstance.renderInventoryEffect(this, p_238813_1_, p_238813_2_, i, this.func_230927_p_());
            if (!effectinstance.shouldRenderInvText()) {
                i += p_238813_3_;
                continue;
            }
            String s = I18n.func_135052_a(effectinstance.func_188419_a().func_76393_a(), new Object[0]);
            if (effectinstance.func_76458_c() >= 1 && effectinstance.func_76458_c() <= 9) {
                s = s + ' ' + I18n.func_135052_a("enchantment.level." + (effectinstance.func_76458_c() + 1), new Object[0]);
            }
            this.field_230712_o_.func_238405_a_(p_238813_1_, s, (float)(p_238813_2_ + 10 + 18), (float)(i + 6), 0xFFFFFF);
            String s1 = EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)1.0f);
            this.field_230712_o_.func_238405_a_(p_238813_1_, s1, (float)(p_238813_2_ + 10 + 18), (float)(i + 6 + 10), 0x7F7F7F);
            i += p_238813_3_;
        }
    }
}

