/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.data.SmithingRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeProvider
implements IDataProvider {
    private static final Logger field_200411_a = LogManager.getLogger();
    private static final Gson field_200412_b = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator field_200413_c;

    public RecipeProvider(DataGenerator generatorIn) {
        this.field_200413_c = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.field_200413_c.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.func_200404_a(p_200410_3_ -> {
            if (!set.add(p_200410_3_.func_200442_b())) {
                throw new IllegalStateException("Duplicate recipe " + p_200410_3_.func_200442_b());
            }
            RecipeProvider.func_208311_a(cache, p_200410_3_.func_200441_a(), path.resolve("data/" + p_200410_3_.func_200442_b().func_110624_b() + "/recipes/" + p_200410_3_.func_200442_b().func_110623_a() + ".json"));
            JsonObject jsonobject = p_200410_3_.func_200440_c();
            if (jsonobject != null) {
                this.func_208310_b(cache, jsonobject, path.resolve("data/" + p_200410_3_.func_200442_b().func_110624_b() + "/advancements/" + p_200410_3_.func_200443_d().func_110623_a() + ".json"));
            }
        });
        if (this.getClass() == RecipeProvider.class) {
            this.func_208310_b(cache, Advancement.Builder.func_200278_a().func_200275_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200273_b(), path.resolve("data/minecraft/advancements/recipes/root.json"));
        }
    }

    private static void func_208311_a(DirectoryCache p_208311_0_, JsonObject cache, Path recipeJson) {
        try {
            String s = field_200412_b.toJson((JsonElement)cache);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(p_208311_0_.func_208323_a(recipeJson), s1) || !Files.exists(recipeJson, new LinkOption[0])) {
                Files.createDirectories(recipeJson.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(recipeJson, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            p_208311_0_.func_208316_a(recipeJson, s1);
        }
        catch (IOException ioexception) {
            field_200411_a.error("Couldn't save recipe {}", (Object)recipeJson, (Object)ioexception);
        }
    }

    protected void func_208310_b(DirectoryCache p_208310_0_, JsonObject cache, Path advancementJson) {
        try {
            String s = field_200412_b.toJson((JsonElement)cache);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(p_208310_0_.func_208323_a(advancementJson), s1) || !Files.exists(advancementJson, new LinkOption[0])) {
                Files.createDirectories(advancementJson.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(advancementJson, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            p_208310_0_.func_208316_a(advancementJson, s1);
        }
        catch (IOException ioexception) {
            field_200411_a.error("Couldn't save recipe advancement {}", (Object)advancementJson, (Object)ioexception);
        }
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> p_200404_0_) {
        RecipeProvider.func_240470_a_(p_200404_0_, Blocks.field_196670_r, ItemTags.field_203297_q);
        RecipeProvider.func_240472_b_(p_200404_0_, Blocks.field_196666_p, ItemTags.field_203296_p);
        RecipeProvider.func_240472_b_(p_200404_0_, Blocks.field_235344_mC_, ItemTags.field_232913_w_);
        RecipeProvider.func_240470_a_(p_200404_0_, Blocks.field_196672_s, ItemTags.field_203294_n);
        RecipeProvider.func_240472_b_(p_200404_0_, Blocks.field_196668_q, ItemTags.field_203298_r);
        RecipeProvider.func_240472_b_(p_200404_0_, Blocks.field_196662_n, ItemTags.field_203295_o);
        RecipeProvider.func_240472_b_(p_200404_0_, Blocks.field_196664_o, ItemTags.field_203299_s);
        RecipeProvider.func_240472_b_(p_200404_0_, Blocks.field_235345_mD_, ItemTags.field_232914_x_);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_196637_U, Blocks.field_196621_O);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_196631_S, Blocks.field_196619_M);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_196639_V, Blocks.field_196623_P);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_196634_T, Blocks.field_196620_N);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_196626_Q, Blocks.field_196617_K);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_196629_R, Blocks.field_196618_L);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_235379_ms_, Blocks.field_235377_mq_);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_235370_mj_, Blocks.field_235368_mh_);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_209393_af, Blocks.field_203208_V);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_209391_ad, Blocks.field_203206_T);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_209394_ag, Blocks.field_203209_W);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_209392_ae, Blocks.field_203207_U);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_209389_ab, Blocks.field_203204_R);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_209390_ac, Blocks.field_203205_S);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_235380_mt_, Blocks.field_235378_mr_);
        RecipeProvider.func_240471_a_(p_200404_0_, Blocks.field_235371_mk_, Blocks.field_235369_mi_);
        RecipeProvider.func_240473_b_(p_200404_0_, Items.field_185153_aK, Blocks.field_196670_r);
        RecipeProvider.func_240473_b_(p_200404_0_, Items.field_185151_aI, Blocks.field_196666_p);
        RecipeProvider.func_240473_b_(p_200404_0_, Items.field_185154_aL, Blocks.field_196672_s);
        RecipeProvider.func_240473_b_(p_200404_0_, Items.field_185152_aJ, Blocks.field_196668_q);
        RecipeProvider.func_240473_b_(p_200404_0_, Items.field_151124_az, Blocks.field_196662_n);
        RecipeProvider.func_240473_b_(p_200404_0_, Items.field_185150_aH, Blocks.field_196664_o);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_196697_eJ, Blocks.field_196670_r);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_180410_as, Blocks.field_196670_r);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_180405_aT, Blocks.field_196670_r);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_180387_bt, Blocks.field_196670_r);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_196671_cu, Blocks.field_196670_r);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_196632_bu, Blocks.field_196670_r);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_150400_ck, Blocks.field_196670_r);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_196682_da, Blocks.field_196670_r);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_222389_ca, Blocks.field_196670_r);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_196693_eH, Blocks.field_196666_p);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_180412_aq, Blocks.field_196666_p);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_180404_aQ, Blocks.field_196666_p);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_180392_bq, Blocks.field_196666_p);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_196667_cs, Blocks.field_196666_p);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_196627_bs, Blocks.field_196666_p);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_150487_bG, Blocks.field_196666_p);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_196641_cY, Blocks.field_196666_p);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_222386_bZ, Blocks.field_196666_p);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_235358_mQ_, Blocks.field_235344_mC_);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_235360_mS_, Blocks.field_235344_mC_);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_235350_mI_, Blocks.field_235344_mC_);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_235354_mM_, Blocks.field_235344_mC_);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_235348_mG_, Blocks.field_235344_mC_);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_235346_mE_, Blocks.field_235344_mC_);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_235356_mO_, Blocks.field_235344_mC_);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_235352_mK_, Blocks.field_235344_mC_);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_235362_mU_, Blocks.field_235344_mC_);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_196699_eK, Blocks.field_196672_s);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_180409_at, Blocks.field_196672_s);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_180406_aS, Blocks.field_196672_s);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_180385_bs, Blocks.field_196672_s);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_196673_cv, Blocks.field_196672_s);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_196635_bv, Blocks.field_196672_s);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_150401_cl, Blocks.field_196672_s);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_196684_db, Blocks.field_196672_s);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_222391_cc, Blocks.field_196672_s);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_196695_eI, Blocks.field_196668_q);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_180411_ar, Blocks.field_196668_q);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_180403_aR, Blocks.field_196668_q);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_180386_br, Blocks.field_196668_q);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_196669_ct, Blocks.field_196668_q);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_196630_bt, Blocks.field_196668_q);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_150481_bH, Blocks.field_196668_q);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_196644_cZ, Blocks.field_196668_q);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_222390_cb, Blocks.field_196668_q);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_196689_eF, Blocks.field_196662_n);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_180413_ao, Blocks.field_196662_n);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_180407_aO, Blocks.field_196662_n);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_180390_bo, Blocks.field_196662_n);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_196663_cq, Blocks.field_196662_n);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_196622_bq, Blocks.field_196662_n);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_150476_ad, Blocks.field_196662_n);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_196636_cW, Blocks.field_196662_n);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_222384_bX, Blocks.field_196662_n);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_196691_eG, Blocks.field_196664_o);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_180414_ap, Blocks.field_196664_o);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_180408_aP, Blocks.field_196664_o);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_180391_bp, Blocks.field_196664_o);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_196665_cr, Blocks.field_196664_o);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_196624_br, Blocks.field_196664_o);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_150485_bF, Blocks.field_196664_o);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_196638_cX, Blocks.field_196664_o);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_222385_bY, Blocks.field_196664_o);
        RecipeProvider.func_240474_c_(p_200404_0_, Blocks.field_235359_mR_, Blocks.field_235345_mD_);
        RecipeProvider.func_240475_d_(p_200404_0_, Blocks.field_235361_mT_, Blocks.field_235345_mD_);
        RecipeProvider.func_240476_e_(p_200404_0_, Blocks.field_235351_mJ_, Blocks.field_235345_mD_);
        RecipeProvider.func_240477_f_(p_200404_0_, Blocks.field_235355_mN_, Blocks.field_235345_mD_);
        RecipeProvider.func_240478_g_(p_200404_0_, Blocks.field_235349_mH_, Blocks.field_235345_mD_);
        RecipeProvider.func_240479_h_(p_200404_0_, Blocks.field_235347_mF_, Blocks.field_235345_mD_);
        RecipeProvider.func_240480_i_(p_200404_0_, Blocks.field_235357_mP_, Blocks.field_235345_mD_);
        RecipeProvider.func_240481_j_(p_200404_0_, Blocks.field_235353_mL_, Blocks.field_235345_mD_);
        RecipeProvider.func_240482_k_(p_200404_0_, Blocks.field_235363_mV_, Blocks.field_235345_mD_);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196602_ba, Items.field_222086_lz);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196753_fW, Blocks.field_196602_ba);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196753_fW, Items.field_222086_lz);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196099_bJ, Blocks.field_196602_ba);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196099_bJ, Items.field_222086_lz);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196206_ev, Blocks.field_196602_ba);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196567_aW, Items.field_222083_lx);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196745_fS, Blocks.field_196567_aW);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196745_fS, Items.field_222083_lx);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196095_bF, Blocks.field_196567_aW);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196095_bF, Items.field_222083_lx);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196202_er, Blocks.field_196567_aW);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196568_aX, Items.field_222085_ly);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196747_fT, Blocks.field_196568_aX);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196747_fT, Items.field_222085_ly);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196096_bG, Blocks.field_196568_aX);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196096_bG, Items.field_222085_ly);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196203_es, Blocks.field_196568_aX);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196565_aU, Items.field_196124_bl);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196741_fQ, Blocks.field_196565_aU);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196741_fQ, Items.field_196124_bl);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196093_bD, Blocks.field_196565_aU);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196093_bD, Items.field_196124_bl);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196200_ep, Blocks.field_196565_aU);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196563_aS, Items.field_196120_bj);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196737_fO, Blocks.field_196563_aS);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196737_fO, Items.field_196120_bj);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196091_bB, Blocks.field_196563_aS);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196091_bB, Items.field_196120_bj);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196198_en, Blocks.field_196563_aS);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196569_aY, Items.field_222079_lj);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196749_fU, Blocks.field_196569_aY);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196749_fU, Items.field_222079_lj);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196097_bH, Blocks.field_196569_aY);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196097_bH, Items.field_222079_lj);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196204_et, Blocks.field_196569_aY);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196559_aO, Items.field_196112_bf);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196729_fK, Blocks.field_196559_aO);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196729_fK, Items.field_196112_bf);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196146_bx, Blocks.field_196559_aO);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196146_bx, Items.field_196112_bf);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196194_ej, Blocks.field_196559_aO);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196564_aT, Items.field_196122_bk);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196739_fP, Blocks.field_196564_aT);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196739_fP, Items.field_196122_bk);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196092_bC, Blocks.field_196564_aT);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196092_bC, Items.field_196122_bk);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196199_eo, Blocks.field_196564_aT);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196561_aQ, Items.field_196116_bh);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196733_fM, Blocks.field_196561_aQ);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196733_fM, Items.field_196116_bh);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196150_bz, Blocks.field_196561_aQ);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196150_bz, Items.field_196116_bh);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196196_el, Blocks.field_196561_aQ);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196558_aN, Items.field_196110_be);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196727_fJ, Blocks.field_196558_aN);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196727_fJ, Items.field_196110_be);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196144_bw, Blocks.field_196558_aN);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196144_bw, Items.field_196110_be);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196193_ei, Blocks.field_196558_aN);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196557_aM, Items.field_196108_bd);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196725_fI, Blocks.field_196557_aM);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196725_fI, Items.field_196108_bd);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196142_bv, Blocks.field_196557_aM);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196142_bv, Items.field_196108_bd);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196192_eh, Blocks.field_196557_aM);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196562_aR, Items.field_196118_bi);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196735_fN, Blocks.field_196562_aR);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196735_fN, Items.field_196118_bi);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196090_bA, Blocks.field_196562_aR);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196090_bA, Items.field_196118_bi);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196197_em, Blocks.field_196562_aR);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196566_aV, Items.field_196126_bm);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196743_fR, Blocks.field_196566_aV);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196743_fR, Items.field_196126_bm);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196094_bE, Blocks.field_196566_aV);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196094_bE, Items.field_196126_bm);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196201_eq, Blocks.field_196566_aV);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196570_aZ, Items.field_222078_li);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196751_fV, Blocks.field_196570_aZ);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196751_fV, Items.field_222078_li);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196098_bI, Blocks.field_196570_aZ);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196098_bI, Items.field_222078_li);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196205_eu, Blocks.field_196570_aZ);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196724_fH, Blocks.field_196556_aL);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196140_bu, Blocks.field_196556_aL);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196191_eg, Blocks.field_196556_aL);
        RecipeProvider.func_240483_l_(p_200404_0_, Blocks.field_196560_aP, Items.field_222081_ls);
        RecipeProvider.func_240484_m_(p_200404_0_, Blocks.field_196731_fL, Blocks.field_196560_aP);
        RecipeProvider.func_240485_n_(p_200404_0_, Blocks.field_196731_fL, Items.field_222081_ls);
        RecipeProvider.func_240486_o_(p_200404_0_, Items.field_196148_by, Blocks.field_196560_aP);
        RecipeProvider.func_240487_p_(p_200404_0_, Items.field_196148_by, Items.field_222081_ls);
        RecipeProvider.func_240488_q_(p_200404_0_, Items.field_196195_ek, Blocks.field_196560_aP);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196824_gy, Items.field_222086_lz);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196776_gO, Blocks.field_196824_gy);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196776_gO, Items.field_222086_lz);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196820_gu, Items.field_222083_lx);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196771_gK, Blocks.field_196820_gu);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196771_gK, Items.field_222083_lx);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196821_gv, Items.field_222085_ly);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196773_gL, Blocks.field_196821_gv);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196773_gL, Items.field_222085_ly);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196818_gs, Items.field_196124_bl);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196768_gI, Blocks.field_196818_gs);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196768_gI, Items.field_196124_bl);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196815_gq, Items.field_196120_bj);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196765_gG, Blocks.field_196815_gq);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196765_gG, Items.field_196120_bj);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196822_gw, Items.field_222079_lj);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196774_gM, Blocks.field_196822_gw);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196774_gM, Items.field_222079_lj);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196810_gm, Items.field_196112_bf);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196760_gC, Blocks.field_196810_gm);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196760_gC, Items.field_196112_bf);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196816_gr, Items.field_196122_bk);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196767_gH, Blocks.field_196816_gr);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196767_gH, Items.field_196122_bk);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196812_go, Items.field_196116_bh);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196763_gE, Blocks.field_196812_go);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196763_gE, Items.field_196116_bh);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196809_gl, Items.field_196110_be);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196759_gB, Blocks.field_196809_gl);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196759_gB, Items.field_196110_be);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196808_gk, Items.field_196108_bd);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196758_gA, Blocks.field_196808_gk);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196758_gA, Items.field_196108_bd);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196813_gp, Items.field_196118_bi);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196764_gF, Blocks.field_196813_gp);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196764_gF, Items.field_196118_bi);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196819_gt, Items.field_196126_bm);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196769_gJ, Blocks.field_196819_gt);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196769_gJ, Items.field_196126_bm);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196823_gx, Items.field_222078_li);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196775_gN, Blocks.field_196823_gx);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196775_gN, Items.field_222078_li);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196807_gj, Items.field_222069_lA);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196825_gz, Blocks.field_196807_gj);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196825_gz, Items.field_222069_lA);
        RecipeProvider.func_240489_r_(p_200404_0_, Blocks.field_196811_gn, Items.field_222081_ls);
        RecipeProvider.func_240490_s_(p_200404_0_, Blocks.field_196761_gD, Blocks.field_196811_gn);
        RecipeProvider.func_240491_t_(p_200404_0_, Blocks.field_196761_gD, Items.field_222081_ls);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196722_fD, Items.field_222086_lz);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196797_fz, Items.field_222083_lx);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196719_fA, Items.field_222085_ly);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196793_fx, Items.field_196124_bl);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196789_fv, Items.field_196120_bj);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196720_fB, Items.field_222079_lj);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196782_fr, Items.field_196112_bf);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196791_fw, Items.field_196122_bk);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196785_ft, Items.field_196116_bh);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196780_fq, Items.field_196110_be);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196778_fp, Items.field_196108_bd);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196787_fu, Items.field_196118_bi);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196795_fy, Items.field_196126_bm);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196721_fC, Items.field_222078_li);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196777_fo, Items.field_222069_lA);
        RecipeProvider.func_240492_u_(p_200404_0_, Blocks.field_196783_fs, Items.field_222081_ls);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196884_jh, Items.field_222086_lz);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196880_jd, Items.field_222083_lx);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196881_je, Items.field_222085_ly);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196878_jb, Items.field_196124_bl);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196874_iZ, Items.field_196120_bj);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196882_jf, Items.field_222079_lj);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196866_iV, Items.field_196112_bf);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196877_ja, Items.field_196122_bk);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196870_iX, Items.field_196116_bh);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196864_iU, Items.field_196110_be);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196862_iT, Items.field_196108_bd);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196872_iY, Items.field_196118_bi);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196879_jc, Items.field_196126_bm);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196883_jg, Items.field_222078_li);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196860_iS, Items.field_222069_lA);
        RecipeProvider.func_240493_v_(p_200404_0_, Blocks.field_196868_iW, Items.field_222081_ls);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150408_cc, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XSX").func_200472_a("X#X").func_200472_a("XSX").func_200465_a("has_rail", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150448_aq)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196656_g, (int)2).func_200487_b((IItemProvider)Blocks.field_196654_e).func_200487_b((IItemProvider)Blocks.field_150347_e).func_200483_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150467_bQ).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_150339_S).func_200462_a(Character.valueOf('i'), (IItemProvider)Items.field_151042_j).func_200472_a("III").func_200472_a(" i ").func_200472_a("iii").func_200465_a("has_iron_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150339_S)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_179565_cj).func_200462_a(Character.valueOf('/'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('_'), (IItemProvider)Blocks.field_222401_hJ).func_200472_a("///").func_200472_a(" / ").func_200472_a("/_/").func_200465_a("has_stone_slab", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_222401_hJ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151032_g, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151145_ak).func_200462_a(Character.valueOf('Y'), (IItemProvider)Items.field_151008_G).func_200472_a("X").func_200472_a("#").func_200472_a("Y").func_200465_a("has_feather", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151008_G)).func_200465_a("has_flint", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151145_ak)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222422_lK, (int)1).func_200469_a(Character.valueOf('P'), ItemTags.field_199905_b).func_200469_a(Character.valueOf('S'), ItemTags.field_202899_i).func_200472_a("PSP").func_200472_a("P P").func_200472_a("PSP").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_199905_b)).func_200465_a("has_wood_slab", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_202899_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150461_bJ).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151156_bN).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_150343_Z).func_200472_a("GGG").func_200472_a("GSG").func_200472_a("OOO").func_200465_a("has_nether_star", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151156_bN)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_226906_mb_).func_200469_a(Character.valueOf('P'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_226635_pU_).func_200472_a("PPP").func_200472_a("HHH").func_200472_a("PPP").func_200465_a("has_honeycomb", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_226635_pU_)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_185165_cW).func_200487_b((IItemProvider)Items.field_151054_z).func_200491_b((IItemProvider)Items.field_185164_cV, 6).func_200483_a("has_beetroot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_185164_cV)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222086_lz).func_200487_b((IItemProvider)Items.field_196136_br).func_200490_a("black_dye").func_200483_a("has_ink_sac", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196136_br)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222086_lz).func_200487_b((IItemProvider)Blocks.field_222388_bz).func_200490_a("black_dye").func_200483_a("has_black_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_222388_bz)).func_200484_a(p_200404_0_, "black_dye_from_wither_rose");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151065_br, (int)2).func_200487_b((IItemProvider)Items.field_151072_bj).func_200483_a("has_blaze_rod", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151072_bj)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_196128_bn).func_200490_a("blue_dye").func_200483_a("has_lapis_lazuli", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196128_bn)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Blocks.field_222387_by).func_200490_a("blue_dye").func_200483_a("has_blue_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_222387_by)).func_200484_a(p_200404_0_, "blue_dye_from_cornflower");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_205164_gk).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150403_cj).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_packed_ice", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150403_cj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_189880_di).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196106_bc).func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_bonemeal", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196106_bc)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196106_bc, (int)3).func_200487_b((IItemProvider)Items.field_151103_aS).func_200490_a("bonemeal").func_200483_a("has_bone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151103_aS)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196106_bc, (int)9).func_200487_b((IItemProvider)Blocks.field_189880_di).func_200490_a("bonemeal").func_200483_a("has_bone_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_189880_di)).func_200484_a(p_200404_0_, "bone_meal_from_bone_block");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151122_aG).func_200491_b((IItemProvider)Items.field_151121_aF, 3).func_200487_b((IItemProvider)Items.field_151116_aA).func_200483_a("has_paper", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151121_aF)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150342_X).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151122_aG).func_200472_a("###").func_200472_a("XXX").func_200472_a("###").func_200465_a("has_book", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151122_aG)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151031_f).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151007_F).func_200472_a(" #X").func_200472_a("# X").func_200472_a(" #X").func_200465_a("has_string", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151007_F)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151054_z, (int)4).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_brown_mushroom", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150338_P)).func_200465_a("has_red_mushroom", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150337_Q)).func_200465_a("has_mushroom_stew", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151009_A)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151025_P).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151015_O).func_200472_a("###").func_200465_a("has_wheat", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151015_O)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150382_bo).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151072_bj).func_200469_a(Character.valueOf('#'), ItemTags.field_242176_ac).func_200472_a(" B ").func_200472_a("###").func_200465_a("has_blaze_rod", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151072_bj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196584_bK).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151118_aC).func_200472_a("##").func_200472_a("##").func_200465_a("has_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151118_aC)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196571_bA, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196584_bK).func_200472_a("###").func_200465_a("has_brick_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196584_bK)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150389_bf, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196584_bK).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_brick_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196584_bK)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222085_ly).func_200487_b((IItemProvider)Items.field_196130_bo).func_200490_a("brown_dye").func_200483_a("has_cocoa_beans", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196130_bo)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151133_ar).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150414_aQ).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_151117_aB).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151102_aT).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151015_O).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151110_aK).func_200472_a("AAA").func_200472_a("BEB").func_200472_a("CCC").func_200465_a("has_egg", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151110_aK)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222433_lV).func_200469_a(Character.valueOf('L'), ItemTags.field_200038_h).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('C'), ItemTags.field_219775_L).func_200472_a(" S ").func_200472_a("SCS").func_200472_a("LLL").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200465_a("has_coal", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_219775_L)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151146_bM).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151112_aM).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151172_bF).func_200472_a("# ").func_200472_a(" X").func_200465_a("has_carrot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151172_bF)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_234774_pk_).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151112_aM).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_234723_bx_).func_200472_a("# ").func_200472_a(" X").func_200465_a("has_warped_fungus", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_234723_bx_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150383_bp).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("# #").func_200472_a("# #").func_200472_a("###").func_200465_a("has_water_bucket", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151131_as)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222436_lZ).func_200469_a(Character.valueOf('#'), ItemTags.field_202899_i).func_200472_a("# #").func_200472_a("# #").func_200472_a("###").func_200465_a("has_wood_slab", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_202899_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150486_ae).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200465_a("has_lots_of_items", (ICriterionInstance)new InventoryChangeTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, MinMaxBounds.IntBound.func_211340_b((int)10), MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, new ItemPredicate[0])).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151108_aI).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150486_ae).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151143_au)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235393_nG_).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196575_bC).func_200472_a("#").func_200472_a("#").func_200465_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196772_fk).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196576_bD).func_200472_a("#").func_200472_a("#").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196770_fj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196702_dl).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196573_bB).func_200472_a("#").func_200472_a("#").func_200465_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_200033_c)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150435_aG).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151119_aD).func_200472_a("##").func_200472_a("##").func_200465_a("has_clay_ball", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151119_aD)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151113_aN).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151044_h, (int)9).func_200487_b((IItemProvider)Blocks.field_150402_ci).func_200483_a("has_coal_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150402_ci)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150402_ci).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151044_h).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_coal", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151044_h)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196660_k, (int)4).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150346_d).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150351_n).func_200472_a("DG").func_200472_a("GD").func_200465_a("has_gravel", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150351_n)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196646_bz, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150463_bK, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196762_fd).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_150348_b).func_200472_a(" # ").func_200472_a("#X#").func_200472_a("III").func_200465_a("has_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151128_bU)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151111_aL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151106_aX, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151015_O).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196130_bo).func_200472_a("#X#").func_200465_a("has_cocoa", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196130_bo)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150462_ai).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("##").func_200472_a("##").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_199905_b)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_222114_py).func_200462_a(Character.valueOf('~'), (IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('&'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('$'), (IItemProvider)Blocks.field_150479_bC).func_200472_a("#&#").func_200472_a("~$~").func_200472_a(" # ").func_200465_a("has_string", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151007_F)).func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200465_a("has_tripwire_hook", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150479_bC)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222421_lJ).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151007_F).func_200472_a("@@").func_200472_a("##").func_200465_a("has_string", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151007_F)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196798_hA).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196578_bE).func_200472_a("#").func_200472_a("#").func_200465_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_200465_a("has_chiseled_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196798_hA)).func_200465_a("has_cut_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196799_hB)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196583_aj).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196640_bx).func_200472_a("#").func_200472_a("#").func_200465_a("has_stone_slab", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196640_bx)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196124_bl, (int)2).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222079_lj).func_200483_a("has_green_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222079_lj)).func_200483_a("has_blue_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222083_lx)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196781_gR).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_222086_lz).func_200472_a("SSS").func_200472_a("SIS").func_200472_a("SSS").func_200465_a("has_prismarine_shard", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179562_cC)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203210_he, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180397_cI).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180397_cI)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203211_hf, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196779_gQ).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_prismarine_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196779_gQ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203212_hg, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196781_gR).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_dark_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196781_gR)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150453_bW).func_200462_a(Character.valueOf('Q'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150359_w).func_200471_a(Character.valueOf('W'), Ingredient.func_199805_a(ItemTags.field_202899_i)).func_200472_a("GGG").func_200472_a("QQQ").func_200472_a("WWW").func_200465_a("has_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151128_bU)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150319_E, (int)6).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150456_au).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("X#X").func_200472_a("XRX").func_200465_a("has_rail", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150448_aq)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151045_i, (int)9).func_200487_b((IItemProvider)Blocks.field_150484_ah).func_200483_a("has_diamond_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150484_ah)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151056_x).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150484_ah).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151045_i).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151175_af).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151163_ad).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151161_ac).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151012_L).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151173_ae).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151046_w).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151047_v).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151048_u).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196654_e, (int)2).func_200462_a(Character.valueOf('Q'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('C'), (IItemProvider)Blocks.field_150347_e).func_200472_a("CQ").func_200472_a("QC").func_200465_a("has_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151128_bU)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150367_z).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151031_f).func_200472_a("###").func_200472_a("#X#").func_200472_a("#R#").func_200465_a("has_bow", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151031_f)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150409_cd).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200472_a("# #").func_200472_a("#R#").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151166_bC, (int)9).func_200487_b((IItemProvider)Blocks.field_150475_bE).func_200483_a("has_emerald_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150475_bE)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150475_bE).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151166_bC).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_emerald", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151166_bC)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150381_bn).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150343_Z).func_200462_a(Character.valueOf('D'), (IItemProvider)Items.field_151045_i).func_200472_a(" B ").func_200472_a("D#D").func_200472_a("###").func_200465_a("has_obsidian", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150343_Z)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150477_bB).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150343_Z).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151061_bv).func_200472_a("###").func_200472_a("#E#").func_200472_a("###").func_200465_a("has_ender_eye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151061_bv)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151061_bv).func_200487_b((IItemProvider)Items.field_151079_bi).func_200487_b((IItemProvider)Items.field_151065_br).func_200483_a("has_blaze_powder", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151065_br)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196806_hJ, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150377_bs).func_200472_a("##").func_200472_a("##").func_200465_a("has_end_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150377_bs)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185158_cP).func_200462_a(Character.valueOf('T'), (IItemProvider)Items.field_151073_bk).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150359_w).func_200472_a("GGG").func_200472_a("GEG").func_200472_a("GTG").func_200465_a("has_ender_eye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151061_bv)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185764_cQ, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_185162_cT).func_200462_a(Character.valueOf('/'), (IItemProvider)Items.field_151072_bj).func_200472_a("/").func_200472_a("#").func_200465_a("has_chorus_fruit_popped", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_185162_cT)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151071_bq).func_200487_b((IItemProvider)Items.field_151070_bp).func_200487_b((IItemProvider)Blocks.field_150338_P).func_200487_b((IItemProvider)Items.field_151102_aT).func_200483_a("has_spider_eye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151070_bp)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151059_bz, (int)3).func_200487_b((IItemProvider)Items.field_151016_H).func_200487_b((IItemProvider)Items.field_151065_br).func_200489_a(Ingredient.func_199804_a(Items.field_151044_h, Items.field_196155_l)).func_200483_a("has_blaze_powder", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151065_br)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151112_aM).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151007_F).func_200472_a("  #").func_200472_a(" #X").func_200472_a("# X").func_200465_a("has_string", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151007_F)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151033_d).func_200487_b((IItemProvider)Items.field_151042_j).func_200487_b((IItemProvider)Items.field_151145_ak).func_200483_a("has_flint", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151145_ak)).func_200483_a("has_obsidian", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150343_Z)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150457_bL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151118_aC).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151118_aC)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150460_al).func_200469_a(Character.valueOf('#'), ItemTags.field_242176_ac).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_242176_ac)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151109_aJ).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150460_al).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151143_au)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151069_bo, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_glass", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150359_w)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150410_aZ, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200472_a("###").func_200472_a("###").func_200465_a("has_glass", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150359_w)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150426_aN).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151114_aO).func_200472_a("##").func_200472_a("##").func_200465_a("has_glowstone_dust", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151114_aO)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151153_ao).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151034_e).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151006_E).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151151_aj).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151150_bK).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151074_bl).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151172_bF).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_gold_nugget", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151074_bl)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151171_ah).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151169_ag).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151013_M).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151149_ai).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151005_D).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196552_aC, (int)6).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X X").func_200472_a("X#X").func_200472_a("XRX").func_200465_a("has_rail", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150448_aq)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151011_C).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151010_B).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150340_R).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151043_k, (int)9).func_200487_b((IItemProvider)Blocks.field_150340_R).func_200490_a("gold_ingot").func_200483_a("has_gold_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150340_R)).func_200484_a(p_200404_0_, "gold_ingot_from_gold_block");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151074_bl).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200473_b("gold_ingot").func_200465_a("has_gold_nugget", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151074_bl)).func_200466_a(p_200404_0_, "gold_ingot_from_nuggets");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151074_bl, (int)9).func_200487_b((IItemProvider)Items.field_151043_k).func_200483_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196650_c).func_200487_b((IItemProvider)Blocks.field_196654_e).func_200487_b((IItemProvider)Items.field_151128_bU).func_200483_a("has_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151128_bU)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196120_bj, (int)2).func_200487_b((IItemProvider)Items.field_222086_lz).func_200487_b((IItemProvider)Items.field_222069_lA).func_200483_a("has_white_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222069_lA)).func_200483_a("has_black_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222086_lz)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150407_cf).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151015_O).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_wheat", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151015_O)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150443_bT).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_226638_pX_, (int)4).func_200487_b((IItemProvider)Items.field_226639_pY_).func_200491_b((IItemProvider)Items.field_151069_bo, 4).func_200483_a("has_honey_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_226907_mc_)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_226907_mc_, (int)1).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_226638_pX_).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_honey_bottle", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_226638_pX_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_226908_md_).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_226635_pU_).func_200472_a("HH").func_200472_a("HH").func_200465_a("has_honeycomb", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_226635_pU_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150438_bZ).func_200462_a(Character.valueOf('C'), (IItemProvider)Blocks.field_150486_ae).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200472_a("I I").func_200472_a("ICI").func_200472_a(" I ").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151140_bW).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150438_bZ).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151143_au)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151036_c).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150411_aY, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("###").func_200472_a("###").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150339_S).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151167_ab).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151030_Z).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150454_av, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151028_Y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151019_K).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151042_j, (int)9).func_200487_b((IItemProvider)Blocks.field_150339_S).func_200490_a("iron_ingot").func_200483_a("has_iron_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150339_S)).func_200484_a(p_200404_0_, "iron_ingot_from_iron_block");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_191525_da).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200473_b("iron_ingot").func_200465_a("has_iron_nugget", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_191525_da)).func_200466_a(p_200404_0_, "iron_ingot_from_nuggets");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151165_aa).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_191525_da, (int)9).func_200487_b((IItemProvider)Items.field_151042_j).func_200483_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151035_b).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151037_a).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151040_l).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180400_cw).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("##").func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151160_bD).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_leather", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151116_aA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150421_aI).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_diamond", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151045_i)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150468_ap, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200472_a("# #").func_200472_a("###").func_200472_a("# #").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150368_y).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_196128_bn).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_lapis", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196128_bn)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196128_bn, (int)9).func_200487_b((IItemProvider)Blocks.field_150368_y).func_200483_a("has_lapis_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150368_y)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151058_ca, (int)2).func_200462_a(Character.valueOf('~'), (IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('O'), (IItemProvider)Items.field_151123_aH).func_200472_a("~~ ").func_200472_a("~O ").func_200472_a("  ~").func_200465_a("has_slime_ball", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151123_aH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151116_aA).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_179555_bs).func_200472_a("##").func_200472_a("##").func_200465_a("has_rabbit_hide", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179555_bs)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151021_T).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151116_aA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151027_R).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_leather", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151116_aA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151024_Q).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151116_aA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151026_S).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151116_aA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_222110_op).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("X X").func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151116_aA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222428_lQ).func_200469_a(Character.valueOf('S'), ItemTags.field_202899_i).func_200462_a(Character.valueOf('B'), (IItemProvider)Blocks.field_150342_X).func_200472_a("SSS").func_200472_a(" B ").func_200472_a(" S ").func_200465_a("has_book", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151122_aG)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150442_at).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("X").func_200472_a("#").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196112_bf).func_200487_b((IItemProvider)Blocks.field_196607_be).func_200490_a("light_blue_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196607_be)).func_200484_a(p_200404_0_, "light_blue_dye_from_blue_orchid");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196112_bf, (int)2).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("light_blue_dye").func_200483_a("has_blue_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222083_lx)).func_200483_a("has_white_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222069_lA)).func_200484_a(p_200404_0_, "light_blue_dye_from_blue_white_dye");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196122_bk).func_200487_b((IItemProvider)Blocks.field_196610_bg).func_200490_a("light_gray_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196610_bg)).func_200484_a(p_200404_0_, "light_gray_dye_from_azure_bluet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196122_bk, (int)2).func_200487_b((IItemProvider)Items.field_196120_bj).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("light_gray_dye").func_200483_a("has_gray_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196120_bj)).func_200483_a("has_white_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222069_lA)).func_200484_a(p_200404_0_, "light_gray_dye_from_gray_white_dye");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196122_bk, (int)3).func_200487_b((IItemProvider)Items.field_222086_lz).func_200491_b((IItemProvider)Items.field_222069_lA, 2).func_200490_a("light_gray_dye").func_200483_a("has_white_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222069_lA)).func_200483_a("has_black_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222086_lz)).func_200484_a(p_200404_0_, "light_gray_dye_from_black_white_dye");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196122_bk).func_200487_b((IItemProvider)Blocks.field_196616_bl).func_200490_a("light_gray_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196616_bl)).func_200484_a(p_200404_0_, "light_gray_dye_from_oxeye_daisy");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196122_bk).func_200487_b((IItemProvider)Blocks.field_196614_bj).func_200490_a("light_gray_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196614_bj)).func_200484_a(p_200404_0_, "light_gray_dye_from_white_tulip");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150445_bS).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200472_a("##").func_200465_a("has_gold_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151043_k)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196116_bh, (int)2).func_200487_b((IItemProvider)Items.field_222079_lj).func_200487_b((IItemProvider)Items.field_222069_lA).func_200483_a("has_green_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222079_lj)).func_200483_a("has_white_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222069_lA)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196628_cT).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_196625_cS).func_200462_a(Character.valueOf('B'), (IItemProvider)Blocks.field_150478_aa).func_200472_a("A").func_200472_a("B").func_200465_a("has_carved_pumpkin", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196625_cS)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196110_be).func_200487_b((IItemProvider)Blocks.field_196609_bf).func_200490_a("magenta_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196609_bf)).func_200484_a(p_200404_0_, "magenta_dye_from_allium");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)4).func_200487_b((IItemProvider)Items.field_222083_lx).func_200491_b((IItemProvider)Items.field_222078_li, 2).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("magenta_dye").func_200483_a("has_blue_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222083_lx)).func_200483_a("has_rose_red", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222078_li)).func_200483_a("has_white_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222069_lA)).func_200484_a(p_200404_0_, "magenta_dye_from_blue_red_white_dye");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)3).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_196118_bi).func_200490_a("magenta_dye").func_200483_a("has_pink_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196118_bi)).func_200483_a("has_blue_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222083_lx)).func_200483_a("has_red_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222078_li)).func_200484_a(p_200404_0_, "magenta_dye_from_blue_red_pink");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)2).func_200487_b((IItemProvider)Blocks.field_196801_ge).func_200490_a("magenta_dye").func_200483_a("has_double_plant", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196801_ge)).func_200484_a(p_200404_0_, "magenta_dye_from_lilac");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)2).func_200487_b((IItemProvider)Items.field_196126_bm).func_200487_b((IItemProvider)Items.field_196118_bi).func_200490_a("magenta_dye").func_200483_a("has_pink_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196118_bi)).func_200483_a("has_purple_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196126_bm)).func_200484_a(p_200404_0_, "magenta_dye_from_purple_and_pink");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196814_hQ).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151064_bs).func_200472_a("##").func_200472_a("##").func_200465_a("has_magma_cream", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151064_bs)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151064_bs).func_200487_b((IItemProvider)Items.field_151065_br).func_200487_b((IItemProvider)Items.field_151123_aH).func_200483_a("has_blaze_powder", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151065_br)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151148_bJ).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151121_aF).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151111_aL).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_compass", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151111_aL)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150440_ba).func_200462_a(Character.valueOf('M'), (IItemProvider)Items.field_151127_ba).func_200472_a("MMM").func_200472_a("MMM").func_200472_a("MMM").func_200465_a("has_melon", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151127_ba)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151081_bc).func_200487_b((IItemProvider)Items.field_151127_ba).func_200483_a("has_melon", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151127_ba)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151143_au).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("# #").func_200472_a("###").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150341_Y).func_200487_b((IItemProvider)Blocks.field_150347_e).func_200487_b((IItemProvider)Blocks.field_150395_bd).func_200483_a("has_vine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150395_bd)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196723_eg, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150341_Y).func_200472_a("###").func_200472_a("###").func_200465_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150341_Y)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196698_dj).func_200487_b((IItemProvider)Blocks.field_196696_di).func_200487_b((IItemProvider)Blocks.field_150395_bd).func_200483_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150341_Y)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151009_A).func_200487_b((IItemProvider)Blocks.field_150338_P).func_200487_b((IItemProvider)Blocks.field_150337_Q).func_200487_b((IItemProvider)Items.field_151054_z).func_200483_a("has_mushroom_stew", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151009_A)).func_200483_a("has_bowl", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151054_z)).func_200483_a("has_brown_mushroom", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150338_P)).func_200483_a("has_red_mushroom", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150337_Q)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196653_dH).func_200462_a(Character.valueOf('N'), (IItemProvider)Items.field_196154_dH).func_200472_a("NN").func_200472_a("NN").func_200465_a("has_netherbrick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196154_dH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150386_bk, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200462_a(Character.valueOf('-'), (IItemProvider)Items.field_196154_dH).func_200472_a("#-#").func_200472_a("#-#").func_200465_a("has_nether_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196575_bC, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200472_a("###").func_200465_a("has_nether_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150387_bl, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_nether_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_189878_dg).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151075_bm).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_nether_wart", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151075_bm)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196586_al).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_190976_dk).func_200462_a(Character.valueOf('Q'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200472_a("RRQ").func_200472_a("###").func_200465_a("has_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151128_bU)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196108_bd).func_200487_b((IItemProvider)Blocks.field_196613_bi).func_200490_a("orange_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196613_bi)).func_200484_a(p_200404_0_, "orange_dye_from_orange_tulip");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196108_bd, (int)2).func_200487_b((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_222081_ls).func_200490_a("orange_dye").func_200483_a("has_red_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222078_li)).func_200483_a("has_yellow_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222081_ls)).func_200484_a(p_200404_0_, "orange_dye_from_red_yellow");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151159_an).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('X'), Ingredient.func_199805_a(ItemTags.field_199904_a)).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_wool", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_199904_a)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151121_aF, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196608_cF).func_200472_a("###").func_200465_a("has_reeds", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196608_cF)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196770_fj, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150371_ca).func_200472_a("#").func_200472_a("#").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196770_fj)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150403_cj).func_200491_b((IItemProvider)Blocks.field_150432_aD, 9).func_200483_a("has_ice", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150432_aD)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196118_bi, (int)2).func_200487_b((IItemProvider)Blocks.field_196803_gg).func_200490_a("pink_dye").func_200483_a("has_double_plant", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196803_gg)).func_200484_a(p_200404_0_, "pink_dye_from_peony");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196118_bi).func_200487_b((IItemProvider)Blocks.field_196615_bk).func_200490_a("pink_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196615_bk)).func_200484_a(p_200404_0_, "pink_dye_from_pink_tulip");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196118_bi, (int)2).func_200487_b((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("pink_dye").func_200483_a("has_white_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222069_lA)).func_200483_a("has_red_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222078_li)).func_200484_a(p_200404_0_, "pink_dye_from_red_white_dye");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150331_J).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200469_a(Character.valueOf('T'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("TTT").func_200472_a("#X#").func_200472_a("#R#").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235338_cP_, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_235337_cO_).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_basalt", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235337_cO_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196652_d, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_196650_c).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196655_f, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_196654_e).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196657_h, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_196656_g).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180397_cI).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_prismarine_shard", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179562_cC)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196779_gQ).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200472_a("SSS").func_200472_a("SSS").func_200472_a("SSS").func_200465_a("has_prismarine_shard", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179562_cC)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203200_bP, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180397_cI).func_200472_a("###").func_200465_a("has_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180397_cI)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203201_bQ, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196779_gQ).func_200472_a("###").func_200465_a("has_prismarine_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196779_gQ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203202_bR, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196781_gR).func_200472_a("###").func_200465_a("has_dark_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196781_gR)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151158_bO).func_200487_b((IItemProvider)Blocks.field_150423_aK).func_200487_b((IItemProvider)Items.field_151102_aT).func_200487_b((IItemProvider)Items.field_151110_aK).func_200483_a("has_carved_pumpkin", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196625_cS)).func_200483_a("has_pumpkin", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150423_aK)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151080_bb, (int)4).func_200487_b((IItemProvider)Blocks.field_150423_aK).func_200483_a("has_pumpkin", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150423_aK)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196126_bm, (int)2).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222078_li).func_200483_a("has_blue_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222083_lx)).func_200483_a("has_red_dye", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_222078_li)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_204409_il).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150486_ae).func_200462_a(Character.valueOf('-'), (IItemProvider)Items.field_190930_cZ).func_200472_a("-").func_200472_a("#").func_200472_a("-").func_200465_a("has_shulker_shell", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_190930_cZ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185767_cT, (int)4).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_185162_cT).func_200472_a("FF").func_200472_a("FF").func_200465_a("has_chorus_fruit_popped", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_185162_cT)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_185768_cU).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_185771_cX).func_200472_a("#").func_200472_a("#").func_200465_a("has_purpur_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_185767_cT)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185771_cX, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_185767_cT, Blocks.field_185768_cU)).func_200472_a("###").func_200465_a("has_purpur_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_185767_cT)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185769_cV, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_185767_cT, Blocks.field_185768_cU)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_purpur_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_185767_cT)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150371_ca).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151128_bU).func_200472_a("##").func_200472_a("##").func_200465_a("has_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151128_bU)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235395_nI_, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150371_ca).func_200472_a("##").func_200472_a("##").func_200465_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196576_bD, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_196772_fk, Blocks.field_150371_ca, Blocks.field_196770_fj)).func_200472_a("###").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196770_fj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150370_cb, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_196772_fk, Blocks.field_150371_ca, Blocks.field_196770_fj)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196770_fj)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_179560_bq).func_200487_b((IItemProvider)Items.field_151168_bH).func_200487_b((IItemProvider)Items.field_179559_bp).func_200487_b((IItemProvider)Items.field_151054_z).func_200487_b((IItemProvider)Items.field_151172_bF).func_200487_b((IItemProvider)Blocks.field_150338_P).func_200490_a("rabbit_stew").func_200483_a("has_cooked_rabbit", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179559_bp)).func_200484_a(p_200404_0_, "rabbit_stew_from_brown_mushroom");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_179560_bq).func_200487_b((IItemProvider)Items.field_151168_bH).func_200487_b((IItemProvider)Items.field_179559_bp).func_200487_b((IItemProvider)Items.field_151054_z).func_200487_b((IItemProvider)Items.field_151172_bF).func_200487_b((IItemProvider)Blocks.field_150337_Q).func_200490_a("rabbit_stew").func_200483_a("has_cooked_rabbit", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179559_bp)).func_200484_a(p_200404_0_, "rabbit_stew_from_red_mushroom");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150448_aq, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("X#X").func_200472_a("X X").func_200465_a("has_minecart", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151143_au)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151137_ax, (int)9).func_200487_b((IItemProvider)Blocks.field_150451_bX).func_200483_a("has_redstone_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150451_bX)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150451_bX).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151137_ax).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150379_bu).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150426_aN).func_200472_a(" R ").func_200472_a("RGR").func_200472_a(" R ").func_200465_a("has_glowstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150426_aN)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a("X").func_200472_a("#").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_185164_cV).func_200490_a("red_dye").func_200483_a("has_beetroot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_185164_cV)).func_200484_a(p_200404_0_, "red_dye_from_beetroot");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Blocks.field_196606_bd).func_200490_a("red_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196606_bd)).func_200484_a(p_200404_0_, "red_dye_from_poppy");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_222078_li, (int)2).func_200487_b((IItemProvider)Blocks.field_196802_gf).func_200490_a("red_dye").func_200483_a("has_double_plant", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196802_gf)).func_200484_a(p_200404_0_, "red_dye_from_rose_bush");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Blocks.field_196612_bh).func_200490_a("red_dye").func_200483_a("has_red_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196612_bh)).func_200484_a(p_200404_0_, "red_dye_from_tulip");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196817_hS).func_200462_a(Character.valueOf('W'), (IItemProvider)Items.field_151075_bm).func_200462_a(Character.valueOf('N'), (IItemProvider)Items.field_196154_dH).func_200472_a("NW").func_200472_a("WN").func_200465_a("has_nether_wart", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151075_bm)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180395_cM).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196611_F).func_200472_a("##").func_200472_a("##").func_200465_a("has_sand", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196611_F)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196578_bE, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_180395_cM, Blocks.field_196798_hA)).func_200472_a("###").func_200465_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_200465_a("has_chiseled_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196798_hA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222403_hT, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196799_hB).func_200472_a("###").func_200465_a("has_cut_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196799_hB)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180396_cN, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_180395_cM, Blocks.field_196798_hA, Blocks.field_196799_hB)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_200465_a("has_chiseled_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196798_hA)).func_200465_a("has_cut_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196799_hB)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196633_cV).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_150348_b).func_200472_a("#X#").func_200472_a("III").func_200465_a("has_redstone_torch", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150429_aA)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150322_A).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150354_m).func_200472_a("##").func_200472_a("##").func_200465_a("has_sand", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150354_m)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196640_bx, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_150322_A, Blocks.field_196583_aj)).func_200472_a("###").func_200465_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_200465_a("has_chiseled_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196583_aj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222402_hL, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196585_ak).func_200472_a("###").func_200465_a("has_cut_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196585_ak)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150372_bz, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_200465_a("has_chiseled_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196583_aj)).func_200465_a("has_cut_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196585_ak)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180398_cJ).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_179563_cD).func_200472_a("SCS").func_200472_a("CCC").func_200472_a("SCS").func_200465_a("has_prismarine_crystals", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179563_cD)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151097_aZ).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a(" #").func_200472_a("# ").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185159_cQ).func_200469_a(Character.valueOf('W'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('o'), (IItemProvider)Items.field_151042_j).func_200472_a("WoW").func_200472_a("WWW").func_200472_a(" W ").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180399_cE).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151123_aH).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_slime_ball", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151123_aH)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151123_aH, (int)9).func_200487_b((IItemProvider)Blocks.field_180399_cE).func_200483_a("has_slime", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180399_cE)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196799_hB, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180395_cM).func_200472_a("##").func_200472_a("##").func_200465_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196585_ak, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150322_A).func_200472_a("##").func_200472_a("##").func_200465_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196604_cC).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151126_ay).func_200472_a("##").func_200472_a("##").func_200465_a("has_snowball", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151126_ay)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150433_aE, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196604_cC).func_200472_a("###").func_200465_a("has_snowball", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151126_ay)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235367_mf_).func_200469_a(Character.valueOf('L'), ItemTags.field_200038_h).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('#'), ItemTags.field_232906_Q_).func_200472_a(" S ").func_200472_a("S#S").func_200472_a("LLL").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200465_a("has_soul_sand", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232906_Q_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151060_bw).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151074_bl).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151127_ba).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_melon", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151127_ba)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_185166_h, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151114_aO).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151032_g).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_glowstone_dust", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151114_aO)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151055_y, (int)4).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("#").func_200472_a("#").func_200473_b("sticks").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_199905_b)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151055_y, (int)1).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_222405_kQ).func_200472_a("#").func_200472_a("#").func_200473_b("sticks").func_200465_a("has_bamboo", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_222405_kQ)).func_200466_a(p_200404_0_, "stick_from_bamboo_item");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150320_F).func_200462_a(Character.valueOf('P'), (IItemProvider)Blocks.field_150331_J).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151123_aH).func_200472_a("S").func_200472_a("P").func_200465_a("has_slime_ball", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151123_aH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196696_di, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("##").func_200472_a("##").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151049_t).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_232909_aa_).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232909_aa_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196573_bB, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196696_di).func_200472_a("###").func_200465_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_200033_c)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150390_bg, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196696_di).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_200033_c)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150430_aB).func_200487_b((IItemProvider)Blocks.field_150348_b).func_200483_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151018_J).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_232909_aa_).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232909_aa_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151050_s).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_232909_aa_).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232909_aa_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150456_au).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("##").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151051_r).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_232909_aa_).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232909_aa_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150333_U, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("###").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222401_hJ, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196579_bG).func_200472_a("###").func_200465_a("has_smooth_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196579_bG)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196659_cl, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151052_q).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_232909_aa_).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232909_aa_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196556_aL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151007_F).func_200472_a("##").func_200472_a("##").func_200465_a("has_string", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151007_F)).func_200466_a(p_200404_0_, "white_wool_from_string");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151102_aT).func_200487_b((IItemProvider)Blocks.field_196608_cF).func_200490_a("sugar").func_200483_a("has_reeds", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196608_cF)).func_200484_a(p_200404_0_, "sugar_from_sugar_cane");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151102_aT, (int)3).func_200487_b((IItemProvider)Items.field_226638_pX_).func_200490_a("sugar").func_200483_a("has_honey_bottle", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_226638_pX_)).func_200484_a(p_200404_0_, "sugar_from_honey_bottle");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235396_nb_).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_221807_eN).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200472_a(" R ").func_200472_a("RHR").func_200472_a(" R ").func_200465_a("has_redstone", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151137_ax)).func_200465_a("has_hay_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150407_cf)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150335_W).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_150354_m, Blocks.field_196611_F)).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151016_H).func_200472_a("X#X").func_200472_a("#X#").func_200472_a("X#X").func_200465_a("has_gunpowder", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151016_H)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151142_bV).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150335_W).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151143_au)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150478_aa, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('X'), Ingredient.func_199804_a(Items.field_151044_h, Items.field_196155_l)).func_200472_a("X").func_200472_a("#").func_200465_a("has_stone_pickaxe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151050_s)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235339_cQ_, (int)4).func_200471_a(Character.valueOf('X'), Ingredient.func_199804_a(Items.field_151044_h, Items.field_196155_l)).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('S'), ItemTags.field_232906_Q_).func_200472_a("X").func_200472_a("#").func_200472_a("S").func_200465_a("has_soul_sand", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232906_Q_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222432_lU).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221657_bQ).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_191525_da).func_200472_a("XXX").func_200472_a("X#X").func_200472_a("XXX").func_200465_a("has_iron_nugget", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_191525_da)).func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235366_md_).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_234737_dp_).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_191525_da).func_200472_a("XXX").func_200472_a("X#X").func_200472_a("XXX").func_200465_a("has_soul_torch", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_234737_dp_)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150447_bR).func_200487_b((IItemProvider)Blocks.field_150486_ae).func_200487_b((IItemProvider)Blocks.field_150479_bC).func_200483_a("has_tripwire_hook", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150479_bC)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150479_bC, (int)2).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200472_a("I").func_200472_a("S").func_200472_a("#").func_200465_a("has_string", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151007_F)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_203179_ao).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_203183_eM).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_scute", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_203183_eM)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151015_O, (int)9).func_200487_b((IItemProvider)Blocks.field_150407_cf).func_200483_a("has_hay_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150407_cf)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222069_lA).func_200487_b((IItemProvider)Items.field_196106_bc).func_200490_a("white_dye").func_200483_a("has_bone_meal", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196106_bc)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222069_lA).func_200487_b((IItemProvider)Blocks.field_222383_bA).func_200490_a("white_dye").func_200483_a("has_white_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_222383_bA)).func_200484_a(p_200404_0_, "white_dye_from_lily_of_the_valley");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151053_p).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151017_I).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151039_o).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151038_n).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151041_m).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_stick", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151055_y)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151099_bA).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b((IItemProvider)Items.field_196136_br).func_200487_b((IItemProvider)Items.field_151008_G).func_200483_a("has_book", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151122_aG)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222081_ls).func_200487_b((IItemProvider)Blocks.field_196605_bc).func_200490_a("yellow_dye").func_200483_a("has_yellow_flower", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196605_bc)).func_200484_a(p_200404_0_, "yellow_dye_from_dandelion");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_222081_ls, (int)2).func_200487_b((IItemProvider)Blocks.field_196800_gd).func_200490_a("yellow_dye").func_200483_a("has_double_plant", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196800_gd)).func_200484_a(p_200404_0_, "yellow_dye_from_sunflower");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_203180_bP, (int)9).func_200487_b((IItemProvider)Blocks.field_203216_jz).func_200483_a("has_dried_kelp_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_203216_jz)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_203216_jz).func_200491_b((IItemProvider)Items.field_203180_bP, 9).func_200483_a("has_dried_kelp", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_203180_bP)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_205165_jY).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_205157_eZ).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_205158_fa).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_nautilus_core", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_205158_fa)).func_200465_a("has_nautilus_shell", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_205157_eZ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222407_kV, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196652_d).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196652_d)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222408_kW, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196582_bJ).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_smooth_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196582_bJ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222409_kX, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196698_dj).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_mossy_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196698_dj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222410_kY, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196655_f).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196655_f)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222411_kZ, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150341_Y).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150341_Y)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222437_la, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196806_hJ).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_end_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196806_hJ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222438_lb, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222439_lc, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196580_bH).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_smooth_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196580_bH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222440_ld, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196581_bI).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_smooth_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196581_bI)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222441_le, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196650_c).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222442_lf, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196656_g).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222443_lg, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196817_hS).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_red_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196817_hS)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222444_lh, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196657_h).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196657_h)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222445_li, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196654_e).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222446_lj, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196652_d).func_200472_a("###").func_200465_a("has_polished_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196652_d)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222447_lk, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196582_bJ).func_200472_a("###").func_200465_a("has_smooth_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196582_bJ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222448_ll, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196698_dj).func_200472_a("###").func_200465_a("has_mossy_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196698_dj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222449_lm, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196655_f).func_200472_a("###").func_200465_a("has_polished_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196655_f)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222450_ln, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150341_Y).func_200472_a("###").func_200465_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150341_Y)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222451_lo, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196806_hJ).func_200472_a("###").func_200465_a("has_end_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196806_hJ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222452_lp, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196580_bH).func_200472_a("###").func_200465_a("has_smooth_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196580_bH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222453_lq, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196581_bI).func_200472_a("###").func_200465_a("has_smooth_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196581_bI)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222454_lr, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196650_c).func_200472_a("###").func_200465_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222455_ls, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196656_g).func_200472_a("###").func_200465_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222456_lt, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196817_hS).func_200472_a("###").func_200465_a("has_red_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196817_hS)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222457_lu, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196657_h).func_200472_a("###").func_200465_a("has_polished_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196657_h)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222458_lv, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196654_e).func_200472_a("###").func_200465_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222459_lw, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196584_bK).func_200472_a("###").func_200472_a("###").func_200465_a("has_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196584_bK)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222460_lx, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180397_cI).func_200472_a("###").func_200472_a("###").func_200465_a("has_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180397_cI)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222461_ly, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180395_cM).func_200472_a("###").func_200472_a("###").func_200465_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222462_lz, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196698_dj).func_200472_a("###").func_200472_a("###").func_200465_a("has_mossy_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196698_dj)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222412_lA, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196650_c).func_200472_a("###").func_200472_a("###").func_200465_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222413_lB, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196696_di).func_200472_a("###").func_200472_a("###").func_200465_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196696_di)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222414_lC, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200472_a("###").func_200472_a("###").func_200465_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222415_lD, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196656_g).func_200472_a("###").func_200472_a("###").func_200465_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222416_lE, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196817_hS).func_200472_a("###").func_200472_a("###").func_200465_a("has_red_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196817_hS)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222417_lF, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150322_A).func_200472_a("###").func_200472_a("###").func_200465_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222418_lG, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196806_hJ).func_200472_a("###").func_200472_a("###").func_200465_a("has_end_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196806_hJ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222419_lH, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196654_e).func_200472_a("###").func_200472_a("###").func_200465_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222096_pC).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Items.field_196185_dy).func_200483_a("has_creeper_head", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196185_dy)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222097_pD).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Items.field_196183_dw).func_200483_a("has_wither_skeleton_skull", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196183_dw)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222095_pB).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Blocks.field_196616_bl).func_200483_a("has_oxeye_daisy", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196616_bl)).func_200482_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222098_pE).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Items.field_196100_at).func_200483_a("has_enchanted_golden_apple", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196100_at)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222420_lI, (int)6).func_200462_a(Character.valueOf('~'), (IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_222405_kQ).func_200472_a("I~I").func_200472_a("I I").func_200472_a("I I").func_200465_a("has_bamboo", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_222405_kQ)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222427_lP).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('-'), (IItemProvider)Blocks.field_150333_U).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("I-I").func_200472_a("# #").func_200465_a("has_stone_slab", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150333_U)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222424_lM).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196579_bG).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150460_al).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200472_a("III").func_200472_a("IXI").func_200472_a("###").func_200465_a("has_smooth_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196579_bG)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222423_lL).func_200469_a(Character.valueOf('#'), ItemTags.field_200038_h).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150460_al).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_furnace", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150460_al)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222425_lN).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151121_aF).func_200472_a("@@").func_200472_a("##").func_200472_a("##").func_200465_a("has_paper", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151121_aF)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222429_lR).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151042_j).func_200472_a("@@").func_200472_a("##").func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222426_lO).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151145_ak).func_200472_a("@@").func_200472_a("##").func_200472_a("##").func_200465_a("has_flint", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151145_ak)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222430_lS).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a(" I ").func_200472_a("###").func_200465_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235405_no_).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_221782_da).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_234759_km_).func_200472_a("SSS").func_200472_a("S#S").func_200472_a("SSS").func_200465_a("has_netherite_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_234759_km_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235397_ng_).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_234759_km_).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_netherite_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_234759_km_)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_234759_km_, (int)9).func_200487_b((IItemProvider)Blocks.field_235397_ng_).func_200490_a("netherite_ingot").func_200483_a("has_netherite_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235397_ng_)).func_200484_a(p_200404_0_, "netherite_ingot_from_netherite_block");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_234759_km_).func_200491_b((IItemProvider)Items.field_234760_kn_, 4).func_200491_b((IItemProvider)Items.field_151043_k, 4).func_200490_a("netherite_ingot").func_200483_a("has_netherite_scrap", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_234760_kn_)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235400_nj_).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_235399_ni_).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150426_aN).func_200472_a("OOO").func_200472_a("GGG").func_200472_a("OOO").func_200465_a("has_obsidian", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235399_ni_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235407_nq_, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235406_np_).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235388_nB_, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235410_nt_).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235415_ny_, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235411_nu_).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_blackstone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235411_nu_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235409_ns_, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235406_np_).func_200472_a("###").func_200465_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235389_nC_, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235410_nt_).func_200472_a("###").func_200465_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235414_nx_, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235411_nu_).func_200472_a("###").func_200465_a("has_polished_blackstone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235411_nu_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235410_nt_, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_235406_np_).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235411_nu_, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235410_nt_).func_200472_a("##").func_200472_a("##").func_200465_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235413_nw_).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235389_nC_).func_200472_a("#").func_200472_a("#").func_200465_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235408_nr_, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235406_np_).func_200472_a("###").func_200472_a("###").func_200465_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235392_nF_, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235410_nt_).func_200472_a("###").func_200472_a("###").func_200465_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_235416_nz_, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235411_nu_).func_200472_a("###").func_200472_a("###").func_200465_a("has_polished_blackstone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235411_nu_)).func_200464_a(p_200404_0_);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_235391_nE_).func_200487_b((IItemProvider)Blocks.field_235410_nt_).func_200483_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_200482_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235390_nD_).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235410_nt_).func_200472_a("##").func_200465_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_200464_a(p_200404_0_);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235341_dI_).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('N'), (IItemProvider)Items.field_191525_da).func_200472_a("N").func_200472_a("I").func_200472_a("N").func_200465_a("has_iron_nugget", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_191525_da)).func_200465_a("has_iron_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151042_j)).func_200464_a(p_200404_0_);
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222159_c).func_200499_a(p_200404_0_, "armor_dye");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222167_k).func_200499_a(p_200404_0_, "banner_duplicate");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222160_d).func_200499_a(p_200404_0_, "book_cloning");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222163_g).func_200499_a(p_200404_0_, "firework_rocket");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222164_h).func_200499_a(p_200404_0_, "firework_star");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222165_i).func_200499_a(p_200404_0_, "firework_star_fade");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222161_e).func_200499_a(p_200404_0_, "map_cloning");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222162_f).func_200499_a(p_200404_0_, "map_extending");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_223550_o).func_200499_a(p_200404_0_, "repair_item");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222168_l).func_200499_a(p_200404_0_, "shield_decoration");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222169_m).func_200499_a(p_200404_0_, "shulker_box_coloring");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222166_j).func_200499_a(p_200404_0_, "tipped_arrow");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222170_n).func_200499_a(p_200404_0_, "suspicious_stew");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151174_bG), (IItemProvider)Items.field_151168_bH, (float)0.35f, (int)200).func_218628_a("has_potato", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151174_bG)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151119_aD), (IItemProvider)Items.field_151118_aC, (float)0.3f, (int)200).func_218628_a("has_clay_ball", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151119_aD)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(ItemTags.field_232912_o_), (IItemProvider)Items.field_196155_l, (float)0.15f, (int)200).func_218628_a("has_log", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232912_o_)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_185161_cS), (IItemProvider)Items.field_185162_cT, (float)0.1f, (int)200).func_218628_a("has_chorus_fruit", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_185161_cS)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150365_q.func_199767_j()), (IItemProvider)Items.field_151044_h, (float)0.1f, (int)200).func_218628_a("has_coal_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150365_q)).func_218632_a(p_200404_0_, "coal_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151082_bd), (IItemProvider)Items.field_151083_be, (float)0.35f, (int)200).func_218628_a("has_beef", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151082_bd)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151076_bf), (IItemProvider)Items.field_151077_bg, (float)0.35f, (int)200).func_218628_a("has_chicken", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151076_bf)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_196086_aW), (IItemProvider)Items.field_196102_ba, (float)0.35f, (int)200).func_218628_a("has_cod", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196086_aW)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_203214_jx), (IItemProvider)Items.field_203180_bP, (float)0.1f, (int)200).func_218628_a("has_kelp", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_203214_jx)).func_218632_a(p_200404_0_, "dried_kelp_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_196087_aX), (IItemProvider)Items.field_196104_bb, (float)0.35f, (int)200).func_218628_a("has_salmon", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196087_aX)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_179561_bm), (IItemProvider)Items.field_179557_bn, (float)0.35f, (int)200).func_218628_a("has_mutton", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179561_bm)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151147_al), (IItemProvider)Items.field_151157_am, (float)0.35f, (int)200).func_218628_a("has_porkchop", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151147_al)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_179558_bo), (IItemProvider)Items.field_179559_bp, (float)0.35f, (int)200).func_218628_a("has_rabbit", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179558_bo)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150482_ag.func_199767_j()), (IItemProvider)Items.field_151045_i, (float)1.0f, (int)200).func_218628_a("has_diamond_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150482_ag)).func_218632_a(p_200404_0_, "diamond_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150369_x.func_199767_j()), (IItemProvider)Items.field_196128_bn, (float)0.2f, (int)200).func_218628_a("has_lapis_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150369_x)).func_218632_a(p_200404_0_, "lapis_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150412_bA.func_199767_j()), (IItemProvider)Items.field_151166_bC, (float)1.0f, (int)200).func_218628_a("has_emerald_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150412_bA)).func_218632_a(p_200404_0_, "emerald_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(ItemTags.field_203440_u), (IItemProvider)Blocks.field_150359_w.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_sand", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_203440_u)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(ItemTags.field_232904_O_), (IItemProvider)Items.field_151043_k, (float)1.0f, (int)200).func_218628_a("has_gold_ore", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232904_O_)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_204913_jW.func_199767_j()), (IItemProvider)Items.field_196116_bh, (float)0.1f, (int)200).func_218628_a("has_sea_pickle", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_204913_jW)).func_218632_a(p_200404_0_, "lime_dye_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150434_aF.func_199767_j()), (IItemProvider)Items.field_222079_lj, (float)1.0f, (int)200).func_218628_a("has_cactus", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150434_aF)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M, Items.field_151010_B, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151136_bY), (IItemProvider)Items.field_151074_bl, (float)0.1f, (int)200).func_218628_a("has_golden_pickaxe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151005_D)).func_218628_a("has_golden_shovel", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151011_C)).func_218628_a("has_golden_axe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151006_E)).func_218628_a("has_golden_hoe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151013_M)).func_218628_a("has_golden_sword", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151010_B)).func_218628_a("has_golden_helmet", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151169_ag)).func_218628_a("has_golden_chestplate", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151171_ah)).func_218628_a("has_golden_leggings", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151149_ai)).func_218628_a("has_golden_boots", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151151_aj)).func_218628_a("has_golden_horse_armor", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151136_bY)).func_218632_a(p_200404_0_, "gold_nugget_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K, Items.field_151040_l, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151138_bX, Items.field_151020_U, Items.field_151023_V, Items.field_151022_W, Items.field_151029_X), (IItemProvider)Items.field_191525_da, (float)0.1f, (int)200).func_218628_a("has_iron_pickaxe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151035_b)).func_218628_a("has_iron_shovel", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151037_a)).func_218628_a("has_iron_axe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151036_c)).func_218628_a("has_iron_hoe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151019_K)).func_218628_a("has_iron_sword", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151040_l)).func_218628_a("has_iron_helmet", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151028_Y)).func_218628_a("has_iron_chestplate", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151030_Z)).func_218628_a("has_iron_leggings", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151165_aa)).func_218628_a("has_iron_boots", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151167_ab)).func_218628_a("has_iron_horse_armor", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151138_bX)).func_218628_a("has_chainmail_helmet", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151020_U)).func_218628_a("has_chainmail_chestplate", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151023_V)).func_218628_a("has_chainmail_leggings", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151022_W)).func_218628_a("has_chainmail_boots", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151029_X)).func_218632_a(p_200404_0_, "iron_nugget_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150366_p.func_199767_j()), (IItemProvider)Items.field_151042_j, (float)0.7f, (int)200).func_218628_a("has_iron_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150366_p.func_199767_j())).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150435_aG), (IItemProvider)Blocks.field_150405_ch.func_199767_j(), (float)0.35f, (int)200).func_218628_a("has_clay_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150435_aG)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150424_aL), (IItemProvider)Items.field_196154_dH, (float)0.1f, (int)200).func_218628_a("has_netherrack", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150424_aL)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196766_fg), (IItemProvider)Items.field_151128_bU, (float)0.2f, (int)200).func_218628_a("has_nether_quartz_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196766_fg)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150450_ax), (IItemProvider)Items.field_151137_ax, (float)0.7f, (int)200).func_218628_a("has_redstone_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150450_ax)).func_218632_a(p_200404_0_, "redstone_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196577_ad), (IItemProvider)Blocks.field_150360_v.func_199767_j(), (float)0.15f, (int)200).func_218628_a("has_wet_sponge", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196577_ad)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_150348_b.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196579_bG.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196580_bH.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196582_bJ.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196581_bI.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_196700_dk.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196696_di)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196722_fD), (IItemProvider)Blocks.field_192442_dQ.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_black_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196722_fD)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196797_fz), (IItemProvider)Blocks.field_192438_dM.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_blue_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196797_fz)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196719_fA), (IItemProvider)Blocks.field_192439_dN.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_brown_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196719_fA)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196793_fx), (IItemProvider)Blocks.field_192436_dK.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_cyan_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196793_fx)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196789_fv), (IItemProvider)Blocks.field_192434_dI.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_gray_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196789_fv)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196720_fB), (IItemProvider)Blocks.field_192440_dO.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_green_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196720_fB)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196782_fr), (IItemProvider)Blocks.field_192430_dE.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_light_blue_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196782_fr)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196791_fw), (IItemProvider)Blocks.field_196876_iu.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_light_gray_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196791_fw)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196785_ft), (IItemProvider)Blocks.field_192432_dG.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_lime_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196785_ft)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196780_fq), (IItemProvider)Blocks.field_192429_dD.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_magenta_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196780_fq)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196778_fp), (IItemProvider)Blocks.field_192428_dC.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_orange_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196778_fp)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196787_fu), (IItemProvider)Blocks.field_192433_dH.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_pink_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196787_fu)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196795_fy), (IItemProvider)Blocks.field_192437_dL.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_purple_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196795_fy)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196721_fC), (IItemProvider)Blocks.field_192441_dP.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_red_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196721_fC)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196777_fo), (IItemProvider)Blocks.field_192427_dB.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_white_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196777_fo)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196783_fs), (IItemProvider)Blocks.field_192431_dF.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_yellow_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196783_fs)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_235398_nh_), (IItemProvider)Items.field_234760_kn_, (float)2.0f, (int)200).func_218628_a("has_ancient_debris", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235398_nh_)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_235411_nu_), (IItemProvider)Blocks.field_235412_nv_.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_blackstone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235411_nu_)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_235394_nH_.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_218630_a(p_200404_0_);
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150366_p.func_199767_j()), (IItemProvider)Items.field_151042_j, (float)0.7f, (int)100).func_218628_a("has_iron_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150366_p.func_199767_j())).func_218632_a(p_200404_0_, "iron_ingot_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(ItemTags.field_232904_O_), (IItemProvider)Items.field_151043_k, (float)1.0f, (int)100).func_218628_a("has_gold_ore", (ICriterionInstance)RecipeProvider.func_200409_a(ItemTags.field_232904_O_)).func_218632_a(p_200404_0_, "gold_ingot_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150482_ag.func_199767_j()), (IItemProvider)Items.field_151045_i, (float)1.0f, (int)100).func_218628_a("has_diamond_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150482_ag)).func_218632_a(p_200404_0_, "diamond_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150369_x.func_199767_j()), (IItemProvider)Items.field_196128_bn, (float)0.2f, (int)100).func_218628_a("has_lapis_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150369_x)).func_218632_a(p_200404_0_, "lapis_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150450_ax), (IItemProvider)Items.field_151137_ax, (float)0.7f, (int)100).func_218628_a("has_redstone_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150450_ax)).func_218632_a(p_200404_0_, "redstone_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150365_q.func_199767_j()), (IItemProvider)Items.field_151044_h, (float)0.1f, (int)100).func_218628_a("has_coal_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150365_q)).func_218632_a(p_200404_0_, "coal_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150412_bA.func_199767_j()), (IItemProvider)Items.field_151166_bC, (float)1.0f, (int)100).func_218628_a("has_emerald_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150412_bA)).func_218632_a(p_200404_0_, "emerald_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_196766_fg), (IItemProvider)Items.field_151128_bU, (float)0.2f, (int)100).func_218628_a("has_nether_quartz_ore", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196766_fg)).func_218632_a(p_200404_0_, "quartz_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M, Items.field_151010_B, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151136_bY), (IItemProvider)Items.field_151074_bl, (float)0.1f, (int)100).func_218628_a("has_golden_pickaxe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151005_D)).func_218628_a("has_golden_shovel", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151011_C)).func_218628_a("has_golden_axe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151006_E)).func_218628_a("has_golden_hoe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151013_M)).func_218628_a("has_golden_sword", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151010_B)).func_218628_a("has_golden_helmet", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151169_ag)).func_218628_a("has_golden_chestplate", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151171_ah)).func_218628_a("has_golden_leggings", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151149_ai)).func_218628_a("has_golden_boots", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151151_aj)).func_218628_a("has_golden_horse_armor", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151136_bY)).func_218632_a(p_200404_0_, "gold_nugget_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K, Items.field_151040_l, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151138_bX, Items.field_151020_U, Items.field_151023_V, Items.field_151022_W, Items.field_151029_X), (IItemProvider)Items.field_191525_da, (float)0.1f, (int)100).func_218628_a("has_iron_pickaxe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151035_b)).func_218628_a("has_iron_shovel", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151037_a)).func_218628_a("has_iron_axe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151036_c)).func_218628_a("has_iron_hoe", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151019_K)).func_218628_a("has_iron_sword", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151040_l)).func_218628_a("has_iron_helmet", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151028_Y)).func_218628_a("has_iron_chestplate", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151030_Z)).func_218628_a("has_iron_leggings", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151165_aa)).func_218628_a("has_iron_boots", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151167_ab)).func_218628_a("has_iron_horse_armor", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151138_bX)).func_218628_a("has_chainmail_helmet", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151020_U)).func_218628_a("has_chainmail_chestplate", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151023_V)).func_218628_a("has_chainmail_leggings", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151022_W)).func_218628_a("has_chainmail_boots", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151029_X)).func_218632_a(p_200404_0_, "iron_nugget_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_235398_nh_), (IItemProvider)Items.field_234760_kn_, (float)2.0f, (int)100).func_218628_a("has_ancient_debris", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235398_nh_)).func_218632_a(p_200404_0_, "netherite_scrap_from_blasting");
        RecipeProvider.func_218445_a(p_200404_0_, "smoking", IRecipeSerializer.field_222173_q, 100);
        RecipeProvider.func_218445_a(p_200404_0_, "campfire_cooking", IRecipeSerializer.field_222174_r, 600);
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_150333_U, (int)2).func_218643_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218645_a(p_200404_0_, "stone_slab_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_222438_lb).func_218643_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218645_a(p_200404_0_, "stone_stairs_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196696_di).func_218643_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218645_a(p_200404_0_, "stone_bricks_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196573_bB, (int)2).func_218643_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218645_a(p_200404_0_, "stone_brick_slab_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_150390_bg).func_218643_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218645_a(p_200404_0_, "stone_brick_stairs_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196702_dl).func_218643_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218645_a(p_200404_0_, "chiseled_stone_bricks_stone_from_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_222413_lB).func_218643_a("has_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150348_b)).func_218645_a(p_200404_0_, "stone_brick_walls_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196585_ak).func_218643_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218645_a(p_200404_0_, "cut_sandstone_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196640_bx, (int)2).func_218643_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218645_a(p_200404_0_, "sandstone_slab_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_222402_hL, (int)2).func_218643_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218645_a(p_200404_0_, "cut_sandstone_slab_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196585_ak), (IItemProvider)Blocks.field_222402_hL, (int)2).func_218643_a("has_cut_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218645_a(p_200404_0_, "cut_sandstone_slab_from_cut_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_150372_bz).func_218643_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218645_a(p_200404_0_, "sandstone_stairs_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_222417_lF).func_218643_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218645_a(p_200404_0_, "sandstone_wall_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196583_aj).func_218643_a("has_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150322_A)).func_218645_a(p_200404_0_, "chiseled_sandstone_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196799_hB).func_218643_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218645_a(p_200404_0_, "cut_red_sandstone_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196578_bE, (int)2).func_218643_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218645_a(p_200404_0_, "red_sandstone_slab_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_222403_hT, (int)2).func_218643_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218645_a(p_200404_0_, "cut_red_sandstone_slab_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196799_hB), (IItemProvider)Blocks.field_222403_hT, (int)2).func_218643_a("has_cut_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218645_a(p_200404_0_, "cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_180396_cN).func_218643_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218645_a(p_200404_0_, "red_sandstone_stairs_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_222461_ly).func_218643_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218645_a(p_200404_0_, "red_sandstone_wall_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196798_hA).func_218643_a("has_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180395_cM)).func_218645_a(p_200404_0_, "chiseled_red_sandstone_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196576_bD, (int)2).func_218643_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_218645_a(p_200404_0_, "quartz_slab_from_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_150370_cb).func_218643_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_218645_a(p_200404_0_, "quartz_stairs_from_quartz_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196770_fj).func_218643_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_218645_a(p_200404_0_, "quartz_pillar_from_quartz_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196772_fk).func_218643_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_218645_a(p_200404_0_, "chiseled_quartz_block_from_quartz_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_235395_nI_).func_218643_a("has_quartz_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150371_ca)).func_218645_a(p_200404_0_, "quartz_bricks_from_quartz_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_196659_cl).func_218643_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_218645_a(p_200404_0_, "cobblestone_stairs_from_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_196646_bz, (int)2).func_218643_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_218645_a(p_200404_0_, "cobblestone_slab_from_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_150463_bK).func_218643_a("has_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150347_e)).func_218645_a(p_200404_0_, "cobblestone_wall_from_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_196573_bB, (int)2).func_218643_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196696_di)).func_218645_a(p_200404_0_, "stone_brick_slab_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_150390_bg).func_218643_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196696_di)).func_218645_a(p_200404_0_, "stone_brick_stairs_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_222413_lB).func_218643_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196696_di)).func_218645_a(p_200404_0_, "stone_brick_wall_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_196702_dl).func_218643_a("has_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196696_di)).func_218645_a(p_200404_0_, "chiseled_stone_bricks_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196584_bK), (IItemProvider)Blocks.field_196571_bA, (int)2).func_218643_a("has_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196584_bK)).func_218645_a(p_200404_0_, "brick_slab_from_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196584_bK), (IItemProvider)Blocks.field_150389_bf).func_218643_a("has_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196584_bK)).func_218645_a(p_200404_0_, "brick_stairs_from_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196584_bK), (IItemProvider)Blocks.field_222459_lw).func_218643_a("has_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196584_bK)).func_218645_a(p_200404_0_, "brick_wall_from_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_196575_bC, (int)2).func_218643_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_218645_a(p_200404_0_, "nether_brick_slab_from_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_150387_bl).func_218643_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_218645_a(p_200404_0_, "nether_brick_stairs_from_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_222414_lC).func_218643_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_218645_a(p_200404_0_, "nether_brick_wall_from_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_235393_nG_).func_218643_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196653_dH)).func_218645_a(p_200404_0_, "chiseled_nether_bricks_from_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196817_hS), (IItemProvider)Blocks.field_222456_lt, (int)2).func_218643_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196817_hS)).func_218645_a(p_200404_0_, "red_nether_brick_slab_from_red_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196817_hS), (IItemProvider)Blocks.field_222443_lg).func_218643_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196817_hS)).func_218645_a(p_200404_0_, "red_nether_brick_stairs_from_red_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196817_hS), (IItemProvider)Blocks.field_222416_lE).func_218643_a("has_nether_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196817_hS)).func_218645_a(p_200404_0_, "red_nether_brick_wall_from_red_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_185767_cT), (IItemProvider)Blocks.field_185771_cX, (int)2).func_218643_a("has_purpur_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_185767_cT)).func_218645_a(p_200404_0_, "purpur_slab_from_purpur_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_185767_cT), (IItemProvider)Blocks.field_185769_cV).func_218643_a("has_purpur_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_185767_cT)).func_218645_a(p_200404_0_, "purpur_stairs_from_purpur_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_185767_cT), (IItemProvider)Blocks.field_185768_cU).func_218643_a("has_purpur_block", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_185767_cT)).func_218645_a(p_200404_0_, "purpur_pillar_from_purpur_block_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180397_cI), (IItemProvider)Blocks.field_203200_bP, (int)2).func_218643_a("has_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180397_cI)).func_218645_a(p_200404_0_, "prismarine_slab_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180397_cI), (IItemProvider)Blocks.field_203210_he).func_218643_a("has_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180397_cI)).func_218645_a(p_200404_0_, "prismarine_stairs_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180397_cI), (IItemProvider)Blocks.field_222460_lx).func_218643_a("has_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_180397_cI)).func_218645_a(p_200404_0_, "prismarine_wall_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196779_gQ), (IItemProvider)Blocks.field_203201_bQ, (int)2).func_218643_a("has_prismarine_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196779_gQ)).func_218645_a(p_200404_0_, "prismarine_brick_slab_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196779_gQ), (IItemProvider)Blocks.field_203211_hf).func_218643_a("has_prismarine_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196779_gQ)).func_218645_a(p_200404_0_, "prismarine_brick_stairs_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196781_gR), (IItemProvider)Blocks.field_203202_bR, (int)2).func_218643_a("has_dark_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196781_gR)).func_218645_a(p_200404_0_, "dark_prismarine_slab_from_dark_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196781_gR), (IItemProvider)Blocks.field_203212_hg).func_218643_a("has_dark_prismarine", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196781_gR)).func_218645_a(p_200404_0_, "dark_prismarine_stairs_from_dark_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222455_ls, (int)2).func_218643_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_218645_a(p_200404_0_, "andesite_slab_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222442_lf).func_218643_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_218645_a(p_200404_0_, "andesite_stairs_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222415_lD).func_218643_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_218645_a(p_200404_0_, "andesite_wall_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_196657_h).func_218643_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_218645_a(p_200404_0_, "polished_andesite_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222457_lu, (int)2).func_218643_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_218645_a(p_200404_0_, "polished_andesite_slab_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222444_lh).func_218643_a("has_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196656_g)).func_218645_a(p_200404_0_, "polished_andesite_stairs_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196657_h), (IItemProvider)Blocks.field_222457_lu, (int)2).func_218643_a("has_polished_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196657_h)).func_218645_a(p_200404_0_, "polished_andesite_slab_from_polished_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196657_h), (IItemProvider)Blocks.field_222444_lh).func_218643_a("has_polished_andesite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196657_h)).func_218645_a(p_200404_0_, "polished_andesite_stairs_from_polished_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235337_cO_), (IItemProvider)Blocks.field_235338_cP_).func_218643_a("has_basalt", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235337_cO_)).func_218645_a(p_200404_0_, "polished_basalt_from_basalt_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222454_lr, (int)2).func_218643_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_218645_a(p_200404_0_, "granite_slab_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222441_le).func_218643_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_218645_a(p_200404_0_, "granite_stairs_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222412_lA).func_218643_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_218645_a(p_200404_0_, "granite_wall_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_196652_d).func_218643_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_218645_a(p_200404_0_, "polished_granite_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222446_lj, (int)2).func_218643_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_218645_a(p_200404_0_, "polished_granite_slab_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222407_kV).func_218643_a("has_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196650_c)).func_218645_a(p_200404_0_, "polished_granite_stairs_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196652_d), (IItemProvider)Blocks.field_222446_lj, (int)2).func_218643_a("has_polished_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196652_d)).func_218645_a(p_200404_0_, "polished_granite_slab_from_polished_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196652_d), (IItemProvider)Blocks.field_222407_kV).func_218643_a("has_polished_granite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196652_d)).func_218645_a(p_200404_0_, "polished_granite_stairs_from_polished_granite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222458_lv, (int)2).func_218643_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_218645_a(p_200404_0_, "diorite_slab_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222445_li).func_218643_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_218645_a(p_200404_0_, "diorite_stairs_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222419_lH).func_218643_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_218645_a(p_200404_0_, "diorite_wall_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_196655_f).func_218643_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196654_e)).func_218645_a(p_200404_0_, "polished_diorite_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222449_lm, (int)2).func_218643_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196655_f)).func_218645_a(p_200404_0_, "polished_diorite_slab_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222410_kY).func_218643_a("has_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196655_f)).func_218645_a(p_200404_0_, "polished_diorite_stairs_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196655_f), (IItemProvider)Blocks.field_222449_lm, (int)2).func_218643_a("has_polished_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196655_f)).func_218645_a(p_200404_0_, "polished_diorite_slab_from_polished_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196655_f), (IItemProvider)Blocks.field_222410_kY).func_218643_a("has_polished_diorite", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196655_f)).func_218645_a(p_200404_0_, "polished_diorite_stairs_from_polished_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196698_dj), (IItemProvider)Blocks.field_222448_ll, (int)2).func_218643_a("has_mossy_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196698_dj)).func_218645_a(p_200404_0_, "mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196698_dj), (IItemProvider)Blocks.field_222409_kX).func_218643_a("has_mossy_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196698_dj)).func_218645_a(p_200404_0_, "mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196698_dj), (IItemProvider)Blocks.field_222462_lz).func_218643_a("has_mossy_stone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196698_dj)).func_218645_a(p_200404_0_, "mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150341_Y), (IItemProvider)Blocks.field_222450_ln, (int)2).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150341_Y)).func_218645_a(p_200404_0_, "mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150341_Y), (IItemProvider)Blocks.field_222411_kZ).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150341_Y)).func_218645_a(p_200404_0_, "mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150341_Y), (IItemProvider)Blocks.field_196723_eg).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150341_Y)).func_218645_a(p_200404_0_, "mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196580_bH), (IItemProvider)Blocks.field_222452_lp, (int)2).func_218643_a("has_smooth_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196580_bH)).func_218645_a(p_200404_0_, "smooth_sandstone_slab_from_smooth_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196580_bH), (IItemProvider)Blocks.field_222439_lc).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196580_bH)).func_218645_a(p_200404_0_, "smooth_sandstone_stairs_from_smooth_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196582_bJ), (IItemProvider)Blocks.field_222447_lk, (int)2).func_218643_a("has_smooth_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196582_bJ)).func_218645_a(p_200404_0_, "smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196582_bJ), (IItemProvider)Blocks.field_222408_kW).func_218643_a("has_smooth_red_sandstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196582_bJ)).func_218645_a(p_200404_0_, "smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196581_bI), (IItemProvider)Blocks.field_222453_lq, (int)2).func_218643_a("has_smooth_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196581_bI)).func_218645_a(p_200404_0_, "smooth_quartz_slab_from_smooth_quartz_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196581_bI), (IItemProvider)Blocks.field_222440_ld).func_218643_a("has_smooth_quartz", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196581_bI)).func_218645_a(p_200404_0_, "smooth_quartz_stairs_from_smooth_quartz_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196806_hJ), (IItemProvider)Blocks.field_222451_lo, (int)2).func_218643_a("has_end_stone_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196806_hJ)).func_218645_a(p_200404_0_, "end_stone_brick_slab_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196806_hJ), (IItemProvider)Blocks.field_222437_la).func_218643_a("has_end_stone_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196806_hJ)).func_218645_a(p_200404_0_, "end_stone_brick_stairs_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196806_hJ), (IItemProvider)Blocks.field_222418_lG).func_218643_a("has_end_stone_brick", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196806_hJ)).func_218645_a(p_200404_0_, "end_stone_brick_wall_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_196806_hJ).func_218643_a("has_end_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150377_bs)).func_218645_a(p_200404_0_, "end_stone_bricks_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_222451_lo, (int)2).func_218643_a("has_end_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150377_bs)).func_218645_a(p_200404_0_, "end_stone_brick_slab_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_222437_la).func_218643_a("has_end_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150377_bs)).func_218645_a(p_200404_0_, "end_stone_brick_stairs_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_222418_lG).func_218643_a("has_end_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150377_bs)).func_218645_a(p_200404_0_, "end_stone_brick_wall_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196579_bG), (IItemProvider)Blocks.field_222401_hJ, (int)2).func_218643_a("has_smooth_stone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196579_bG)).func_218645_a(p_200404_0_, "smooth_stone_slab_from_smooth_stone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235409_ns_, (int)2).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "blackstone_slab_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235407_nq_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "blackstone_stairs_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235408_nr_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "blackstone_wall_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235410_nt_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235392_nF_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_wall_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235389_nC_, (int)2).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_slab_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235388_nB_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_stairs_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235413_nw_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "chiseled_polished_blackstone_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235411_nu_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_bricks_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235414_nx_, (int)2).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_slab_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235415_ny_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_stairs_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235406_np_), (IItemProvider)Blocks.field_235416_nz_).func_218643_a("has_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235406_np_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_wall_from_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235389_nC_, (int)2).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "polished_blackstone_slab_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235388_nB_).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "polished_blackstone_stairs_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235411_nu_).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "polished_blackstone_bricks_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235392_nF_).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "polished_blackstone_wall_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235414_nx_, (int)2).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_slab_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235415_ny_).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235416_nz_).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_wall_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235410_nt_), (IItemProvider)Blocks.field_235413_nw_).func_218643_a("has_polished_blackstone", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235410_nt_)).func_218645_a(p_200404_0_, "chiseled_polished_blackstone_from_polished_blackstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235411_nu_), (IItemProvider)Blocks.field_235414_nx_, (int)2).func_218643_a("has_polished_blackstone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235411_nu_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235411_nu_), (IItemProvider)Blocks.field_235415_ny_).func_218643_a("has_polished_blackstone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235411_nu_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_235411_nu_), (IItemProvider)Blocks.field_235416_nz_).func_218643_a("has_polished_blackstone_bricks", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_235411_nu_)).func_218645_a(p_200404_0_, "polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting");
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151163_ad, Items.field_234764_lt_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151173_ae, Items.field_234765_lu_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151161_ac, Items.field_234763_ls_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151175_af, Items.field_234766_lv_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151048_u, Items.field_234754_kI_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151056_x, Items.field_234757_kL_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151046_w, Items.field_234756_kK_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151012_L, Items.field_234758_kU_);
        RecipeProvider.func_240469_a_(p_200404_0_, Items.field_151047_v, Items.field_234755_kJ_);
    }

    private static void func_240469_a_(Consumer<IFinishedRecipe> p_240469_0_, Item p_240469_1_, Item p_240469_2_) {
        SmithingRecipeBuilder.func_240502_a_((Ingredient)Ingredient.func_199804_a(p_240469_1_), (Ingredient)Ingredient.func_199804_a(Items.field_234759_km_), (Item)p_240469_2_).func_240503_a_("has_netherite_ingot", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_234759_km_)).func_240504_a_(p_240469_0_, Registry.field_212630_s.func_177774_c((Object)p_240469_2_.func_199767_j()).func_110623_a() + "_smithing");
    }

    private static void func_240470_a_(Consumer<IFinishedRecipe> p_240470_0_, IItemProvider p_240470_1_, ITag<Item> p_240470_2_) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)p_240470_1_, (int)4).func_203221_a(p_240470_2_).func_200490_a("planks").func_200483_a("has_log", (ICriterionInstance)RecipeProvider.func_200409_a(p_240470_2_)).func_200482_a(p_240470_0_);
    }

    private static void func_240472_b_(Consumer<IFinishedRecipe> p_240472_0_, IItemProvider p_240472_1_, ITag<Item> p_240472_2_) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)p_240472_1_, (int)4).func_203221_a(p_240472_2_).func_200490_a("planks").func_200483_a("has_logs", (ICriterionInstance)RecipeProvider.func_200409_a(p_240472_2_)).func_200482_a(p_240472_0_);
    }

    private static void func_240471_a_(Consumer<IFinishedRecipe> p_240471_0_, IItemProvider p_240471_1_, IItemProvider p_240471_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240471_1_, (int)3).func_200462_a(Character.valueOf('#'), p_240471_2_).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)RecipeProvider.func_200403_a(p_240471_2_)).func_200464_a(p_240471_0_);
    }

    private static void func_240473_b_(Consumer<IFinishedRecipe> p_240473_0_, IItemProvider p_240473_1_, IItemProvider p_240473_2_) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)p_240473_1_).func_200462_a(Character.valueOf('#'), p_240473_2_).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)RecipeProvider.func_200407_a(Blocks.field_150355_j)).func_200464_a(p_240473_0_);
    }

    private static void func_240474_c_(Consumer<IFinishedRecipe> p_240474_0_, IItemProvider p_240474_1_, IItemProvider p_240474_2_) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)p_240474_1_).func_200487_b(p_240474_2_).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240474_2_)).func_200482_a(p_240474_0_);
    }

    private static void func_240475_d_(Consumer<IFinishedRecipe> p_240475_0_, IItemProvider p_240475_1_, IItemProvider p_240475_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240475_1_, (int)3).func_200462_a(Character.valueOf('#'), p_240475_2_).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240475_2_)).func_200464_a(p_240475_0_);
    }

    private static void func_240476_e_(Consumer<IFinishedRecipe> p_240476_0_, IItemProvider p_240476_1_, IItemProvider p_240476_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240476_1_, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), p_240476_2_).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240476_2_)).func_200464_a(p_240476_0_);
    }

    private static void func_240477_f_(Consumer<IFinishedRecipe> p_240477_0_, IItemProvider p_240477_1_, IItemProvider p_240477_2_) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)p_240477_1_).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), p_240477_2_).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240477_2_)).func_200464_a(p_240477_0_);
    }

    private static void func_240478_g_(Consumer<IFinishedRecipe> p_240478_0_, IItemProvider p_240478_1_, IItemProvider p_240478_2_) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)p_240478_1_).func_200462_a(Character.valueOf('#'), p_240478_2_).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240478_2_)).func_200464_a(p_240478_0_);
    }

    private static void func_240479_h_(Consumer<IFinishedRecipe> p_240479_0_, IItemProvider p_240479_1_, IItemProvider p_240479_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240479_1_, (int)6).func_200462_a(Character.valueOf('#'), p_240479_2_).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240479_2_)).func_200464_a(p_240479_0_);
    }

    private static void func_240480_i_(Consumer<IFinishedRecipe> p_240480_0_, IItemProvider p_240480_1_, IItemProvider p_240480_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240480_1_, (int)4).func_200462_a(Character.valueOf('#'), p_240480_2_).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240480_2_)).func_200464_a(p_240480_0_);
    }

    private static void func_240481_j_(Consumer<IFinishedRecipe> p_240481_0_, IItemProvider p_240481_1_, IItemProvider p_240481_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240481_1_, (int)2).func_200462_a(Character.valueOf('#'), p_240481_2_).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a(p_240481_2_)).func_200464_a(p_240481_0_);
    }

    private static void func_240482_k_(Consumer<IFinishedRecipe> p_240482_0_, IItemProvider p_240482_1_, IItemProvider p_240482_2_) {
        String s = Registry.field_212630_s.func_177774_c((Object)p_240482_2_.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240482_1_, (int)3).func_200473_b("sign").func_200462_a(Character.valueOf('#'), p_240482_2_).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_" + s, (ICriterionInstance)RecipeProvider.func_200403_a(p_240482_2_)).func_200464_a(p_240482_0_);
    }

    private static void func_240483_l_(Consumer<IFinishedRecipe> p_240483_0_, IItemProvider p_240483_1_, IItemProvider p_240483_2_) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)p_240483_1_).func_200487_b(p_240483_2_).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196556_aL)).func_200482_a(p_240483_0_);
    }

    private static void func_240484_m_(Consumer<IFinishedRecipe> p_240484_0_, IItemProvider p_240484_1_, IItemProvider p_240484_2_) {
        String s = Registry.field_212630_s.func_177774_c((Object)p_240484_2_.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240484_1_, (int)3).func_200462_a(Character.valueOf('#'), p_240484_2_).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_" + s, (ICriterionInstance)RecipeProvider.func_200403_a(p_240484_2_)).func_200464_a(p_240484_0_);
    }

    private static void func_240485_n_(Consumer<IFinishedRecipe> p_240485_0_, IItemProvider p_240485_1_, IItemProvider p_240485_2_) {
        String s = Registry.field_212630_s.func_177774_c((Object)p_240485_1_.func_199767_j()).func_110623_a();
        String s1 = Registry.field_212630_s.func_177774_c((Object)p_240485_2_.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240485_1_, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), p_240485_2_).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_" + s1, (ICriterionInstance)RecipeProvider.func_200403_a(p_240485_2_)).func_200466_a(p_240485_0_, s + "_from_white_carpet");
    }

    private static void func_240486_o_(Consumer<IFinishedRecipe> p_240486_0_, IItemProvider p_240486_1_, IItemProvider p_240486_2_) {
        String s = Registry.field_212630_s.func_177774_c((Object)p_240486_2_.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)p_240486_1_).func_200462_a(Character.valueOf('#'), p_240486_2_).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_" + s, (ICriterionInstance)RecipeProvider.func_200403_a(p_240486_2_)).func_200464_a(p_240486_0_);
    }

    private static void func_240487_p_(Consumer<IFinishedRecipe> p_240487_0_, IItemProvider p_240487_1_, IItemProvider p_240487_2_) {
        String s = Registry.field_212630_s.func_177774_c((Object)p_240487_1_.func_199767_j()).func_110623_a();
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)p_240487_1_).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b(p_240487_2_).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196140_bu)).func_200484_a(p_240487_0_, s + "_from_white_bed");
    }

    private static void func_240488_q_(Consumer<IFinishedRecipe> p_240488_0_, IItemProvider p_240488_1_, IItemProvider p_240488_2_) {
        String s = Registry.field_212630_s.func_177774_c((Object)p_240488_2_.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)p_240488_1_).func_200462_a(Character.valueOf('#'), p_240488_2_).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_" + s, (ICriterionInstance)RecipeProvider.func_200403_a(p_240488_2_)).func_200464_a(p_240488_0_);
    }

    private static void func_240489_r_(Consumer<IFinishedRecipe> p_240489_0_, IItemProvider p_240489_1_, IItemProvider p_240489_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240489_1_, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), p_240489_2_).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150359_w)).func_200464_a(p_240489_0_);
    }

    private static void func_240490_s_(Consumer<IFinishedRecipe> p_240490_0_, IItemProvider p_240490_1_, IItemProvider p_240490_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240490_1_, (int)16).func_200462_a(Character.valueOf('#'), p_240490_2_).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)RecipeProvider.func_200403_a(p_240490_2_)).func_200464_a(p_240490_0_);
    }

    private static void func_240491_t_(Consumer<IFinishedRecipe> p_240491_0_, IItemProvider p_240491_1_, IItemProvider p_240491_2_) {
        String s = Registry.field_212630_s.func_177774_c((Object)p_240491_1_.func_199767_j()).func_110623_a();
        String s1 = Registry.field_212630_s.func_177774_c((Object)p_240491_2_.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240491_1_, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), p_240491_2_).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_" + s1, (ICriterionInstance)RecipeProvider.func_200403_a(p_240491_2_)).func_200466_a(p_240491_0_, s + "_from_glass_pane");
    }

    private static void func_240492_u_(Consumer<IFinishedRecipe> p_240492_0_, IItemProvider p_240492_1_, IItemProvider p_240492_2_) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)p_240492_1_, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), p_240492_2_).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150405_ch)).func_200464_a(p_240492_0_);
    }

    private static void func_240493_v_(Consumer<IFinishedRecipe> p_240493_0_, IItemProvider p_240493_1_, IItemProvider p_240493_2_) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)p_240493_1_, (int)8).func_200487_b(p_240493_2_).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_150351_n)).func_200482_a(p_240493_0_);
    }

    private static void func_218445_a(Consumer<IFinishedRecipe> p_218445_0_, String recipeConsumerIn, CookingRecipeSerializer<?> cookingMethod, int serializerIn) {
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151082_bd), (IItemProvider)Items.field_151083_be, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_beef", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151082_bd)).func_218632_a(p_218445_0_, "cooked_beef_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151076_bf), (IItemProvider)Items.field_151077_bg, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_chicken", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151076_bf)).func_218632_a(p_218445_0_, "cooked_chicken_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_196086_aW), (IItemProvider)Items.field_196102_ba, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_cod", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196086_aW)).func_218632_a(p_218445_0_, "cooked_cod_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Blocks.field_203214_jx), (IItemProvider)Items.field_203180_bP, (float)0.1f, (int)serializerIn, cookingMethod).func_218628_a("has_kelp", (ICriterionInstance)RecipeProvider.func_200403_a(Blocks.field_203214_jx)).func_218632_a(p_218445_0_, "dried_kelp_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_196087_aX), (IItemProvider)Items.field_196104_bb, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_salmon", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_196087_aX)).func_218632_a(p_218445_0_, "cooked_salmon_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_179561_bm), (IItemProvider)Items.field_179557_bn, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_mutton", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179561_bm)).func_218632_a(p_218445_0_, "cooked_mutton_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151147_al), (IItemProvider)Items.field_151157_am, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_porkchop", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151147_al)).func_218632_a(p_218445_0_, "cooked_porkchop_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151174_bG), (IItemProvider)Items.field_151168_bH, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_potato", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_151174_bG)).func_218632_a(p_218445_0_, "baked_potato_from_" + recipeConsumerIn);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_179558_bo), (IItemProvider)Items.field_179559_bp, (float)0.35f, (int)serializerIn, cookingMethod).func_218628_a("has_rabbit", (ICriterionInstance)RecipeProvider.func_200403_a(Items.field_179558_bo)).func_218632_a(p_218445_0_, "cooked_rabbit_from_" + recipeConsumerIn);
    }

    protected static EnterBlockTrigger.Instance func_200407_a(Block p_200407_0_) {
        return new EnterBlockTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, p_200407_0_, StatePropertiesPredicate.field_227178_a_);
    }

    protected static InventoryChangeTrigger.Instance func_200403_a(IItemProvider p_200403_0_) {
        return RecipeProvider.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200308_a(p_200403_0_).func_200310_b());
    }

    protected static InventoryChangeTrigger.Instance func_200409_a(ITag<Item> p_200409_0_) {
        return RecipeProvider.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200307_a(p_200409_0_).func_200310_b());
    }

    protected static InventoryChangeTrigger.Instance func_200405_a(ItemPredicate ... p_200405_0_) {
        return new InventoryChangeTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, p_200405_0_);
    }

    public String func_200397_b() {
        return "Recipes";
    }
}

