/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.AsyncReloader;
import net.minecraft.resources.DebugAsyncReloader;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IAsyncReloader;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class SimpleReloadableResourceManager
implements IReloadableResourceManager {
    private static final Logger field_199012_a = LogManager.getLogger();
    private final Map<String, FallbackResourceManager> field_199014_c = Maps.newHashMap();
    private final List<IFutureReloadListener> field_199015_d = Lists.newArrayList();
    private final List<IFutureReloadListener> field_219539_d = Lists.newArrayList();
    private final Set<String> field_199016_e = Sets.newLinkedHashSet();
    private final List<IResourcePack> field_232636_f_ = Lists.newArrayList();
    private final ResourcePackType field_199017_f;

    public SimpleReloadableResourceManager(ResourcePackType p_i47905_1_) {
        this.field_199017_f = p_i47905_1_;
    }

    public void func_199021_a(IResourcePack resourcePack) {
        this.field_232636_f_.add(resourcePack);
        for (String s : resourcePack.func_195759_a(this.field_199017_f)) {
            this.field_199016_e.add(s);
            FallbackResourceManager fallbackresourcemanager = this.field_199014_c.get(s);
            if (fallbackresourcemanager == null) {
                fallbackresourcemanager = new FallbackResourceManager(this.field_199017_f, s);
                this.field_199014_c.put(s, fallbackresourcemanager);
            }
            fallbackresourcemanager.func_199021_a(resourcePack);
        }
    }

    public Set<String> func_199001_a() {
        return this.field_199016_e;
    }

    public IResource func_199002_a(ResourceLocation resourceLocationIn) throws IOException {
        IResourceManager iresourcemanager = this.field_199014_c.get(resourceLocationIn.func_110624_b());
        if (iresourcemanager != null) {
            return iresourcemanager.func_199002_a(resourceLocationIn);
        }
        throw new FileNotFoundException(resourceLocationIn.toString());
    }

    public boolean func_219533_b(ResourceLocation p_219533_1_) {
        IResourceManager iresourcemanager = this.field_199014_c.get(p_219533_1_.func_110624_b());
        return iresourcemanager != null ? iresourcemanager.func_219533_b(p_219533_1_) : false;
    }

    public List<IResource> func_199004_b(ResourceLocation resourceLocationIn) throws IOException {
        IResourceManager iresourcemanager = this.field_199014_c.get(resourceLocationIn.func_110624_b());
        if (iresourcemanager != null) {
            return iresourcemanager.func_199004_b(resourceLocationIn);
        }
        throw new FileNotFoundException(resourceLocationIn.toString());
    }

    public Collection<ResourceLocation> func_199003_a(String pathIn, Predicate<String> filter) {
        HashSet set = Sets.newHashSet();
        for (FallbackResourceManager fallbackresourcemanager : this.field_199014_c.values()) {
            set.addAll(fallbackresourcemanager.func_199003_a(pathIn, filter));
        }
        ArrayList list = Lists.newArrayList((Iterable)set);
        Collections.sort(list);
        return list;
    }

    private void func_199008_b() {
        this.field_199014_c.clear();
        this.field_199016_e.clear();
        this.field_232636_f_.forEach(IResourcePack::close);
        this.field_232636_f_.clear();
    }

    public void close() {
        this.func_199008_b();
    }

    public void func_219534_a(IFutureReloadListener p_219534_1_) {
        this.field_199015_d.add(p_219534_1_);
        this.field_219539_d.add(p_219534_1_);
    }

    protected IAsyncReloader func_219538_b(Executor backgroundExecutor, Executor gameExecutor, List<IFutureReloadListener> listeners, CompletableFuture<Unit> waitingFor) {
        Object iasyncreloader = field_199012_a.isDebugEnabled() ? new DebugAsyncReloader((IResourceManager)((Object)this), (List)Lists.newArrayList(listeners), backgroundExecutor, gameExecutor, waitingFor) : AsyncReloader.func_219562_a((IResourceManager)((Object)this), (List)Lists.newArrayList(listeners), (Executor)backgroundExecutor, (Executor)gameExecutor, waitingFor);
        this.field_219539_d.clear();
        return iasyncreloader;
    }

    public IAsyncReloader func_219537_a(Executor backgroundExecutor, Executor gameExecutor, CompletableFuture<Unit> waitingFor, List<IResourcePack> p_219537_4_) {
        this.func_199008_b();
        field_199012_a.info("Reloading ResourceManager: {}", new Supplier[]{() -> p_219537_4_.stream().map(IResourcePack::func_195762_a).collect(Collectors.joining(", "))});
        for (IResourcePack iresourcepack : p_219537_4_) {
            try {
                this.func_199021_a(iresourcepack);
            }
            catch (Exception exception) {
                field_199012_a.error("Failed to add resource pack {}", (Object)iresourcepack.func_195762_a(), (Object)exception);
                return new FailedPackReloader(new FailedPackException(iresourcepack, (Throwable)exception));
            }
        }
        return this.func_219538_b(backgroundExecutor, gameExecutor, this.field_199015_d, waitingFor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Stream<IResourcePack> func_230232_b_() {
        return this.field_232636_f_.stream();
    }

    static class FailedPackReloader
    implements IAsyncReloader {
        private final FailedPackException field_230019_a_;
        private final CompletableFuture<Unit> field_230020_b_;

        public FailedPackReloader(FailedPackException p_i229961_1_) {
            this.field_230019_a_ = p_i229961_1_;
            this.field_230020_b_ = new CompletableFuture();
            this.field_230020_b_.completeExceptionally(p_i229961_1_);
        }

        public CompletableFuture<Unit> func_219552_a() {
            return this.field_230020_b_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float func_219555_b() {
            return 0.0f;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_219553_c() {
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_219554_d() {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_219556_e() {
            throw this.field_230019_a_;
        }
    }

    public static class FailedPackException
    extends RuntimeException {
        private final IResourcePack field_230021_a_;

        public FailedPackException(IResourcePack p_i229962_1_, Throwable p_i229962_2_) {
            super(p_i229962_1_.func_195762_a(), p_i229962_2_);
            this.field_230021_a_ = p_i229962_1_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public IResourcePack func_241203_a() {
            return this.field_230021_a_;
        }
    }
}

