/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.tags.TagCollectionReader;
import net.minecraft.tags.TagRegistryManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ForgeTagHandler;

public class NetworkTagManager
implements IFutureReloadListener {
    protected TagCollectionReader<Block> field_199719_a = new TagCollectionReader(arg_0 -> Registry.field_212618_g.func_241873_b(arg_0), "tags/blocks", "block");
    protected TagCollectionReader<Item> field_199720_b = new TagCollectionReader(arg_0 -> Registry.field_212630_s.func_241873_b(arg_0), "tags/items", "item");
    protected TagCollectionReader<Fluid> field_205705_c = new TagCollectionReader(arg_0 -> Registry.field_212619_h.func_241873_b(arg_0), "tags/fluids", "fluid");
    protected TagCollectionReader<EntityType<?>> field_215299_d = new TagCollectionReader(arg_0 -> Registry.field_212629_r.func_241873_b(arg_0), "tags/entity_types", "entity_type");
    protected Map<ResourceLocation, TagCollectionReader<?>> customTagTypeReaders = ForgeTagHandler.createCustomTagTypeReaders();
    private ITagCollectionSupplier field_242230_e = ITagCollectionSupplier.field_242208_a;

    public ITagCollectionSupplier func_242231_a() {
        return this.field_242230_e;
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        CompletableFuture completablefuture = this.field_199719_a.func_242224_a(resourceManager, backgroundExecutor);
        CompletableFuture completablefuture1 = this.field_199720_b.func_242224_a(resourceManager, backgroundExecutor);
        CompletableFuture completablefuture2 = this.field_205705_c.func_242224_a(resourceManager, backgroundExecutor);
        CompletableFuture completablefuture3 = this.field_215299_d.func_242224_a(resourceManager, backgroundExecutor);
        CompletableFuture customTagTypeResults = ForgeTagHandler.getCustomTagTypeReloadResults((IResourceManager)resourceManager, (Executor)backgroundExecutor, this.customTagTypeReaders);
        return ((CompletableFuture)CompletableFuture.allOf(completablefuture, completablefuture1, completablefuture2, completablefuture3, customTagTypeResults).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(p_232979_5_ -> {
            ITagCollection itagcollection = this.field_199719_a.func_242226_a((Map)completablefuture.join());
            ITagCollection itagcollection1 = this.field_199720_b.func_242226_a((Map)completablefuture1.join());
            ITagCollection itagcollection2 = this.field_205705_c.func_242226_a((Map)completablefuture2.join());
            ITagCollection itagcollection3 = this.field_215299_d.func_242226_a((Map)completablefuture3.join());
            ForgeTagHandler.updateCustomTagTypes((List)((List)customTagTypeResults.join()));
            ITagCollectionSupplier itagcollectionsupplier = ITagCollectionSupplier.func_242209_a(itagcollection, itagcollection1, itagcollection2, itagcollection3);
            Multimap<ResourceLocation, ResourceLocation> multimap = TagRegistryManager.func_242198_b(itagcollectionsupplier);
            if (!multimap.isEmpty()) {
                throw new IllegalStateException("Missing required tags: " + multimap.entries().stream().map(p_232978_0_ -> p_232978_0_.getKey() + ":" + p_232978_0_.getValue()).sorted().collect(Collectors.joining(",")));
            }
            TagCollectionManager.func_242180_a(itagcollectionsupplier);
            this.field_242230_e = itagcollectionsupplier;
        }, gameExecutor);
    }
}

