/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModsFolderLocator
extends AbstractJarFileLocator {
    private static final String SUFFIX = ".jar";
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modFolder;
    private final String customName;

    public ModsFolderLocator() {
        this(FMLPaths.MODSDIR.get());
    }

    ModsFolderLocator(Path modFolder) {
        this(modFolder, "mods folder");
    }

    ModsFolderLocator(Path modFolder, String name) {
        this.modFolder = modFolder;
        this.customName = name;
    }

    public List<IModFile> scanMods() {
        LOGGER.debug(LogMarkers.SCAN, "Scanning mods dir {} for mods", (Object)this.modFolder);
        List<Path> excluded = ModDirTransformerDiscoverer.allExcluded();
        return ((Stream)LamdbaExceptionUtils.uncheck(() -> Files.list(this.modFolder))).filter(p -> !excluded.contains(p)).sorted(Comparator.comparing(path -> StringUtils.toLowerCase(path.getFileName().toString()))).filter(p -> StringUtils.toLowerCase(p.getFileName().toString()).endsWith(SUFFIX)).map(p -> ModFile.newFMLInstance(p, this)).peek(f -> this.modJars.compute(f, (mf, fs) -> this.createFileSystem((IModFile)mf))).collect(Collectors.toList());
    }

    public String name() {
        return this.customName;
    }

    public String toString() {
        return "{" + this.customName + " locator at " + this.modFolder + "}";
    }

    public void initArguments(Map<String, ?> arguments) {
    }
}

