/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.registry.Registry;

public class ModifiableAttributeInstance {
    private final Attribute field_111136_b;
    private final Map<AttributeModifier.Operation, Set<AttributeModifier>> field_111137_c = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<UUID, AttributeModifier> field_233757_c_ = new Object2ObjectArrayMap();
    private final Set<AttributeModifier> field_111135_e = new ObjectArraySet();
    private double field_233759_e_;
    private boolean field_233760_f_ = true;
    private double field_233761_g_;
    private final Consumer<ModifiableAttributeInstance> field_233762_h_;

    public ModifiableAttributeInstance(Attribute attribute, Consumer<ModifiableAttributeInstance> consumer) {
        this.field_111136_b = attribute;
        this.field_233762_h_ = consumer;
        this.field_233759_e_ = attribute.func_111110_b();
    }

    public Attribute func_111123_a() {
        return this.field_111136_b;
    }

    public double func_111125_b() {
        return this.field_233759_e_;
    }

    public void func_111128_a(double d) {
        if (d == this.field_233759_e_) {
            return;
        }
        this.field_233759_e_ = d;
        this.func_233771_d_();
    }

    public Set<AttributeModifier> func_225504_a_(AttributeModifier.Operation operation2) {
        return this.field_111137_c.computeIfAbsent(operation2, operation -> Sets.newHashSet());
    }

    public Set<AttributeModifier> func_225505_c_() {
        return ImmutableSet.copyOf(this.field_233757_c_.values());
    }

    @Nullable
    public AttributeModifier func_111127_a(UUID uUID) {
        return this.field_233757_c_.get(uUID);
    }

    public boolean func_180374_a(AttributeModifier attributeModifier) {
        return this.field_233757_c_.get(attributeModifier.func_111167_a()) != null;
    }

    private void func_111121_a(AttributeModifier attributeModifier) {
        \u2603 = this.field_233757_c_.putIfAbsent(attributeModifier.func_111167_a(), attributeModifier);
        if (\u2603 != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.func_225504_a_(attributeModifier.func_220375_c()).add(attributeModifier);
        this.func_233771_d_();
    }

    public void func_233767_b_(AttributeModifier attributeModifier) {
        this.func_111121_a(attributeModifier);
    }

    public void func_233769_c_(AttributeModifier attributeModifier) {
        this.func_111121_a(attributeModifier);
        this.field_111135_e.add(attributeModifier);
    }

    protected void func_233771_d_() {
        this.field_233760_f_ = true;
        this.field_233762_h_.accept(this);
    }

    public void func_111124_b(AttributeModifier attributeModifier) {
        this.func_225504_a_(attributeModifier.func_220375_c()).remove(attributeModifier);
        this.field_233757_c_.remove(attributeModifier.func_111167_a());
        this.field_111135_e.remove(attributeModifier);
        this.func_233771_d_();
    }

    public void func_188479_b(UUID uUID) {
        AttributeModifier attributeModifier = this.func_111127_a(uUID);
        if (attributeModifier != null) {
            this.func_111124_b(attributeModifier);
        }
    }

    public boolean func_233770_c_(UUID uUID) {
        AttributeModifier attributeModifier = this.func_111127_a(uUID);
        if (attributeModifier != null && this.field_111135_e.contains(attributeModifier)) {
            this.func_111124_b(attributeModifier);
            return true;
        }
        return false;
    }

    public double func_111126_e() {
        if (this.field_233760_f_) {
            this.field_233761_g_ = this.func_111129_g();
            this.field_233760_f_ = false;
        }
        return this.field_233761_g_;
    }

    private double func_111129_g() {
        double d;
        double d2 = this.func_111125_b();
        for (AttributeModifier attributeModifier : this.func_220370_b(AttributeModifier.Operation.ADDITION)) {
            d2 += attributeModifier.func_111164_d();
        }
        d = d2;
        for (AttributeModifier attributeModifier : this.func_220370_b(AttributeModifier.Operation.MULTIPLY_BASE)) {
            d += d2 * attributeModifier.func_111164_d();
        }
        for (AttributeModifier attributeModifier : this.func_220370_b(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            d *= 1.0 + attributeModifier.func_111164_d();
        }
        return this.field_111136_b.func_111109_a(d);
    }

    private Collection<AttributeModifier> func_220370_b(AttributeModifier.Operation operation) {
        return this.field_111137_c.getOrDefault((Object)operation, Collections.emptySet());
    }

    public void func_233763_a_(ModifiableAttributeInstance modifiableAttributeInstance) {
        this.field_233759_e_ = modifiableAttributeInstance.field_233759_e_;
        this.field_233757_c_.clear();
        this.field_233757_c_.putAll(modifiableAttributeInstance.field_233757_c_);
        this.field_111135_e.clear();
        this.field_111135_e.addAll(modifiableAttributeInstance.field_111135_e);
        this.field_111137_c.clear();
        modifiableAttributeInstance.field_111137_c.forEach((operation, set) -> this.func_225504_a_((AttributeModifier.Operation)((Object)operation)).addAll((Collection<AttributeModifier>)set));
        this.func_233771_d_();
    }

    public CompoundNBT func_233772_g_() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("Name", Registry.field_239692_aP_.func_177774_c(this.field_111136_b).toString());
        compoundNBT.func_74780_a("Base", this.field_233759_e_);
        if (!this.field_111135_e.isEmpty()) {
            ListNBT listNBT = new ListNBT();
            for (AttributeModifier attributeModifier : this.field_111135_e) {
                listNBT.add(attributeModifier.func_233801_e_());
            }
            compoundNBT.func_218657_a("Modifiers", listNBT);
        }
        return compoundNBT;
    }

    public void func_233765_a_(CompoundNBT compoundNBT) {
        this.field_233759_e_ = compoundNBT.func_74769_h("Base");
        if (compoundNBT.func_150297_b("Modifiers", 9)) {
            ListNBT listNBT = compoundNBT.func_150295_c("Modifiers", 10);
            for (int i = 0; i < listNBT.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.func_233800_a_(listNBT.func_150305_b(i));
                if (attributeModifier == null) continue;
                this.field_233757_c_.put(attributeModifier.func_111167_a(), attributeModifier);
                this.func_225504_a_(attributeModifier.func_220375_c()).add(attributeModifier);
                this.field_111135_e.add(attributeModifier);
            }
        }
        this.func_233771_d_();
    }
}

