/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class SessionLockManager
implements AutoCloseable {
    private final FileChannel field_232994_a_;
    private final FileLock field_232995_b_;
    private static final ByteBuffer field_232996_c_;

    public static SessionLockManager func_232998_a_(Path path) throws IOException {
        \u2603 = path.resolve("session.lock");
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        FileChannel fileChannel = FileChannel.open(\u2603, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            fileChannel.write(field_232996_c_.duplicate());
            fileChannel.force(true);
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock == null) {
                throw AlreadyLockedException.func_233000_a_(\u2603);
            }
            return new SessionLockManager(fileChannel, fileLock);
        }
        catch (IOException iOException) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException2) {
                iOException.addSuppressed(iOException2);
            }
            throw iOException;
        }
    }

    private SessionLockManager(FileChannel fileChannel, FileLock fileLock) {
        this.field_232994_a_ = fileChannel;
        this.field_232995_b_ = fileLock;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.field_232995_b_.isValid()) {
                this.field_232995_b_.release();
            }
        }
        finally {
            if (this.field_232994_a_.isOpen()) {
                this.field_232994_a_.close();
            }
        }
    }

    public boolean func_232997_a_() {
        return this.field_232995_b_.isValid();
    }

    static {
        byte[] byArray = "\u2603".getBytes(Charsets.UTF_8);
        field_232996_c_ = ByteBuffer.allocateDirect(byArray.length);
        field_232996_c_.put(byArray);
        field_232996_c_.flip();
    }

    public static class AlreadyLockedException
    extends IOException {
        private AlreadyLockedException(Path path, String string) {
            super(path.toAbsolutePath() + ": " + string);
        }

        public static AlreadyLockedException func_233000_a_(Path path) {
            return new AlreadyLockedException(path, "already locked (possibly by other Minecraft instance?)");
        }
    }
}

