/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.EntityExplosionContext;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Explosion {
    private static final ExplosionContext field_242407_a = new ExplosionContext();
    private final boolean field_77286_a;
    private final Mode field_222260_b;
    private final Random field_77290_i = new Random();
    private final World field_77287_j;
    private final double field_77284_b;
    private final double field_77285_c;
    private final double field_77282_d;
    @Nullable
    private final Entity field_77283_e;
    private final float field_77280_f;
    private final DamageSource field_199593_j;
    private final ExplosionContext field_234893_k_;
    private final List<BlockPos> field_77281_g = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> field_77288_k = Maps.newHashMap();

    public Explosion(World world, @Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionContext explosionContext, double d, double d2, double d3, float f, boolean bl, Mode mode) {
        this.field_77287_j = world;
        this.field_77283_e = entity;
        this.field_77280_f = f;
        this.field_77284_b = d;
        this.field_77285_c = d2;
        this.field_77282_d = d3;
        this.field_77286_a = bl;
        this.field_222260_b = mode;
        this.field_199593_j = damageSource == null ? DamageSource.func_94539_a(this) : damageSource;
        this.field_234893_k_ = explosionContext == null ? this.func_234894_a_(entity) : explosionContext;
    }

    private ExplosionContext func_234894_a_(@Nullable Entity entity) {
        return entity == null ? field_242407_a : new EntityExplosionContext(entity);
    }

    public static float func_222259_a(Vector3d vector3d, Entity entity) {
        AxisAlignedBB axisAlignedBB = entity.func_174813_aQ();
        double \u26032 = 1.0 / ((axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) * 2.0 + 1.0);
        double \u26033 = 1.0 / ((axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b) * 2.0 + 1.0);
        double \u26034 = 1.0 / ((axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) * 2.0 + 1.0);
        double \u26035 = (1.0 - Math.floor(1.0 / \u26032) * \u26032) / 2.0;
        double \u26036 = (1.0 - Math.floor(1.0 / \u26034) * \u26034) / 2.0;
        if (\u26032 < 0.0 || \u26033 < 0.0 || \u26034 < 0.0) {
            return 0.0f;
        }
        int \u26037 = 0;
        int \u26038 = 0;
        float \u26039 = 0.0f;
        while (\u26039 <= 1.0f) {
            float f = 0.0f;
            while (f <= 1.0f) {
                \u260311 = 0.0f;
                while (\u260311 <= 1.0f) {
                    double d = MathHelper.func_219803_d(\u26039, axisAlignedBB.field_72340_a, axisAlignedBB.field_72336_d);
                    Vector3d \u260310 = new Vector3d(d + \u26035, \u2603 = MathHelper.func_219803_d(f, axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e), (\u2603 = MathHelper.func_219803_d(\u260311, axisAlignedBB.field_72339_c, axisAlignedBB.field_72334_f)) + \u26036);
                    if (entity.field_70170_p.func_217299_a(new RayTraceContext(\u260310, vector3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS) {
                        ++\u26037;
                    }
                    ++\u26038;
                    float \u260311 = (float)((double)\u260311 + \u26034);
                }
                f = (float)((double)f + \u26033);
            }
            \u26039 = (float)((double)\u26039 + \u26032);
        }
        return (float)\u26037 / (float)\u26038;
    }

    public void func_77278_a() {
        HashSet hashSet = Sets.newHashSet();
        int \u26032 = 16;
        for (int i = 0; i < 16; ++i) {
            for (\u26036 = 0; \u26036 < 16; ++\u26036) {
                for (\u26037 = 0; \u26037 < 16; ++\u26037) {
                    if (i != 0 && i != 15 && \u26036 != 0 && \u26036 != 15 && \u26037 != 0 && \u26037 != 15) continue;
                    double d = (float)i / 15.0f * 2.0f - 1.0f;
                    \u2603 = (float)\u26036 / 15.0f * 2.0f - 1.0f;
                    \u2603 = (float)\u26037 / 15.0f * 2.0f - 1.0f;
                    \u2603 = Math.sqrt(d * d + \u2603 * \u2603 + \u2603 * \u2603);
                    d /= \u2603;
                    \u2603 /= \u2603;
                    \u2603 /= \u2603;
                    \u2603 = this.field_77284_b;
                    \u2603 = this.field_77285_c;
                    \u2603 = this.field_77282_d;
                    float \u26033 = 0.3f;
                    for (float f = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockPos = new BlockPos(\u2603, \u2603, \u2603);
                        BlockState \u26034 = this.field_77287_j.func_180495_p(blockPos);
                        Optional<Float> \u26035 = this.field_234893_k_.func_230312_a_(this, this.field_77287_j, blockPos, \u26034, \u2603 = this.field_77287_j.func_204610_c(blockPos));
                        if (\u26035.isPresent()) {
                            f -= (\u26035.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.field_234893_k_.func_230311_a_(this, this.field_77287_j, blockPos, \u26034, f)) {
                            hashSet.add(blockPos);
                        }
                        \u2603 += d * (double)0.3f;
                        \u2603 += \u2603 * (double)0.3f;
                        \u2603 += \u2603 * (double)0.3f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(hashSet);
        float f = this.field_77280_f * 2.0f;
        int \u26036 = MathHelper.func_76128_c(this.field_77284_b - (double)f - 1.0);
        int \u26037 = MathHelper.func_76128_c(this.field_77284_b + (double)f + 1.0);
        int \u26038 = MathHelper.func_76128_c(this.field_77285_c - (double)f - 1.0);
        int \u26039 = MathHelper.func_76128_c(this.field_77285_c + (double)f + 1.0);
        int \u260310 = MathHelper.func_76128_c(this.field_77282_d - (double)f - 1.0);
        int \u260311 = MathHelper.func_76128_c(this.field_77282_d + (double)f + 1.0);
        List<Entity> \u260312 = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB(\u26036, \u26038, \u260310, \u26037, \u26039, \u260311));
        Vector3d \u260313 = new Vector3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (int i = 0; i < \u260312.size(); ++i) {
            Entity entity = \u260312.get(i);
            if (entity.func_180427_aV() || !((\u2603 = (double)(MathHelper.func_76133_a(entity.func_195048_a(\u260313)) / f)) <= 1.0) || (\u2603 = (double)MathHelper.func_76133_a((\u2603 = entity.func_226277_ct_() - this.field_77284_b) * \u2603 + (\u2603 = (entity instanceof TNTEntity ? entity.func_226278_cu_() : entity.func_226280_cw_()) - this.field_77285_c) * \u2603 + (\u2603 = entity.func_226281_cx_() - this.field_77282_d) * \u2603)) == 0.0) continue;
            \u2603 /= \u2603;
            \u2603 /= \u2603;
            \u2603 /= \u2603;
            double \u260314 = Explosion.func_222259_a(\u260313, entity);
            double \u260315 = (1.0 - \u2603) * \u260314;
            entity.func_70097_a(this.func_199591_b(), (int)((\u260315 * \u260315 + \u260315) / 2.0 * 7.0 * (double)f + 1.0));
            double \u260316 = \u260315;
            if (entity instanceof LivingEntity) {
                \u260316 = ProtectionEnchantment.func_92092_a((LivingEntity)entity, \u260315);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(\u2603 * \u260316, \u2603 * \u260316, \u2603 * \u260316));
            if (!(entity instanceof PlayerEntity) || (\u2603 = (PlayerEntity)entity).func_175149_v() || \u2603.func_184812_l_() && \u2603.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(\u2603, new Vector3d(\u2603 * \u260315, \u2603 * \u260315, \u2603 * \u260315));
        }
    }

    public void func_77279_a(boolean bl) {
        if (this.field_77287_j.field_72995_K) {
            this.field_77287_j.func_184134_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl2 = \u2603 = this.field_222260_b != Mode.NONE;
        if (bl) {
            if (this.field_77280_f < 2.0f || !\u2603) {
                this.field_77287_j.func_195594_a(ParticleTypes.field_197627_t, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            } else {
                this.field_77287_j.func_195594_a(ParticleTypes.field_197626_s, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            }
        }
        if (\u2603) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            Collections.shuffle(this.field_77281_g, this.field_77287_j.field_73012_v);
            for (BlockPos blockPos : this.field_77281_g) {
                BlockState blockState = this.field_77287_j.func_180495_p(blockPos);
                Block \u26032 = blockState.func_177230_c();
                if (blockState.func_196958_f()) continue;
                BlockPos \u26033 = blockPos.func_185334_h();
                this.field_77287_j.func_217381_Z().func_76320_a("explosion_blocks");
                if (\u26032.func_149659_a(this) && this.field_77287_j instanceof ServerWorld) {
                    TileEntity tileEntity = \u26032.func_235695_q_() ? this.field_77287_j.func_175625_s(blockPos) : null;
                    LootContext.Builder \u26034 = new LootContext.Builder((ServerWorld)this.field_77287_j).func_216023_a(this.field_77287_j.field_73012_v).func_216015_a(LootParameters.field_237457_g_, Vector3d.func_237489_a_(blockPos)).func_216015_a(LootParameters.field_216289_i, ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, tileEntity).func_216021_b(LootParameters.field_216281_a, this.field_77283_e);
                    if (this.field_222260_b == Mode.DESTROY) {
                        \u26034.func_216015_a(LootParameters.field_216290_j, Float.valueOf(this.field_77280_f));
                    }
                    blockState.func_215693_a(\u26034).forEach(itemStack -> Explosion.func_229976_a_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectArrayList, itemStack, \u26033));
                }
                this.field_77287_j.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
                \u26032.func_180652_a(this.field_77287_j, blockPos, this);
                this.field_77287_j.func_217381_Z().func_76319_b();
            }
            for (BlockPos blockPos : objectArrayList) {
                Block.func_180635_a(this.field_77287_j, (BlockPos)blockPos.getSecond(), (ItemStack)blockPos.getFirst());
            }
        }
        if (this.field_77286_a) {
            for (BlockPos blockPos : this.field_77281_g) {
                if (this.field_77290_i.nextInt(3) != 0 || !this.field_77287_j.func_180495_p(blockPos).func_196958_f() || !this.field_77287_j.func_180495_p(blockPos.func_177977_b()).func_200015_d(this.field_77287_j, blockPos.func_177977_b())) continue;
                this.field_77287_j.func_175656_a(blockPos, AbstractFireBlock.func_235326_a_(this.field_77287_j, blockPos));
            }
        }
    }

    private static void func_229976_a_(ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, ItemStack itemStack, BlockPos blockPos) {
        int n = objectArrayList.size();
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            Pair pair = (Pair)objectArrayList.get(\u2603);
            ItemStack \u26032 = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_(\u26032, itemStack)) continue;
            ItemStack \u26033 = ItemEntity.func_226533_a_(\u26032, itemStack, 16);
            objectArrayList.set(\u2603, (Object)Pair.of((Object)\u26033, (Object)pair.getSecond()));
            if (!itemStack.func_190926_b()) continue;
            return;
        }
        objectArrayList.add((Object)Pair.of((Object)itemStack, (Object)blockPos));
    }

    public DamageSource func_199591_b() {
        return this.field_199593_j;
    }

    public Map<PlayerEntity, Vector3d> func_77277_b() {
        return this.field_77288_k;
    }

    @Nullable
    public LivingEntity func_94613_c() {
        Entity entity;
        if (this.field_77283_e == null) {
            return null;
        }
        if (this.field_77283_e instanceof TNTEntity) {
            return ((TNTEntity)this.field_77283_e).func_94083_c();
        }
        if (this.field_77283_e instanceof LivingEntity) {
            return (LivingEntity)this.field_77283_e;
        }
        if (this.field_77283_e instanceof ProjectileEntity && (entity = ((ProjectileEntity)this.field_77283_e).func_234616_v_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void func_180342_d() {
        this.field_77281_g.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.field_77281_g;
    }

    public static enum Mode {
        NONE,
        BREAK,
        DESTROY;

    }
}

