/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnumerationHelper {
    public static <T> Enumeration<T> merge(final Enumeration<T> first, final Enumeration<T> second) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return first.hasMoreElements() || second.hasMoreElements();
            }

            @Override
            public T nextElement() {
                return first.hasMoreElements() ? first.nextElement() : second.nextElement();
            }
        };
    }

    public static <T> Function<String, Enumeration<T>> mergeFunctors(Function<String, Enumeration<T>> first, Function<String, Enumeration<T>> second) {
        return input -> EnumerationHelper.merge((Enumeration)first.apply((String)input), (Enumeration)second.apply((String)input));
    }

    public static <T> T firstElementOrNull(Enumeration<T> enumeration) {
        return enumeration.hasMoreElements() ? (T)enumeration.nextElement() : null;
    }

    public static <T> Function<String, Enumeration<T>> fromOptional(Function<String, Optional<T>> additionalClassBytesLocator) {
        return input -> Collections.enumeration(((Optional)additionalClassBytesLocator.apply((String)input)).map(Stream::of).orElseGet(Stream::empty).collect(Collectors.toList()));
    }
}

