/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ClassTransformer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

class TransformerClassWriter
extends ClassWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, String> CLASS_PARENTS = new ConcurrentHashMap<String, String>();
    private static final Map<String, Set<String>> CLASS_HIERARCHIES = new ConcurrentHashMap<String, Set<String>>();
    private static final Map<String, Boolean> IS_INTERFACE = new ConcurrentHashMap<String, Boolean>();
    private final ClassTransformer classTransformer;
    private final ClassNode clazzAccessor;
    private boolean computedThis = false;

    public static ClassWriter createClassWriter(int mlFlags, ClassTransformer classTransformer, ClassNode clazzAccessor) {
        int writerFlag = mlFlags & 0xFFFFFEFF;
        return (writerFlag & 2) != 0 ? new TransformerClassWriter(writerFlag, classTransformer, clazzAccessor) : new ClassWriter(writerFlag);
    }

    private TransformerClassWriter(int writerFlags, ClassTransformer classTransformer, ClassNode clazzAccessor) {
        super(writerFlags);
        this.classTransformer = classTransformer;
        this.clazzAccessor = clazzAccessor;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (!this.computedThis) {
            this.computeHierarchy(this.clazzAccessor);
            this.computedThis = true;
        }
        if (this.getSupers(type2).contains(type1)) {
            return type1;
        }
        if (this.getSupers(type1).contains(type2)) {
            return type2;
        }
        if (this.isIntf(type1) || this.isIntf(type2)) {
            return "java/lang/Object";
        }
        String type = type1;
        do {
            type = this.getSuper(type);
        } while (!this.getSupers(type2).contains(type));
        return type;
    }

    private Set<String> getSupers(String typeName) {
        this.computeHierarchy(typeName);
        return CLASS_HIERARCHIES.get(typeName);
    }

    private boolean isIntf(String typeName) {
        return IS_INTERFACE.get(typeName);
    }

    private String getSuper(String typeName) {
        this.computeHierarchy(typeName);
        return CLASS_PARENTS.get(typeName);
    }

    private void computeHierarchy(ClassNode clazzNode) {
        if (!CLASS_HIERARCHIES.containsKey(clazzNode.name)) {
            clazzNode.accept((ClassVisitor)new SuperCollectingVisitor());
        }
    }

    private void computeHierarchy(String className) {
        if (CLASS_HIERARCHIES.containsKey(className)) {
            return;
        }
        Class<?> clz = this.classTransformer.getTransformingClassLoader().getLoadedClass(className.replace('/', '.'));
        if (clz != null) {
            this.computeHierarchyFromClass(className, clz);
        } else {
            this.computeHierarchyFromFile(className);
        }
    }

    private void computeHierarchyFromClass(String name, Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        HashSet<String> hierarchies = new HashSet<String>();
        if (superClass != null) {
            String superName = superClass.getName().replace('.', '/');
            CLASS_PARENTS.put(name, superName);
            if (!CLASS_HIERARCHIES.containsKey(superName)) {
                this.computeHierarchyFromClass(superName, superClass);
            }
            hierarchies.add(name);
            hierarchies.addAll((Collection)CLASS_HIERARCHIES.get(superName));
        } else {
            hierarchies.add("java/lang/Object");
        }
        IS_INTERFACE.put(name, clazz.isInterface());
        Arrays.stream(clazz.getInterfaces()).forEach(c -> {
            String n = c.getName().replace('.', '/');
            if (!CLASS_HIERARCHIES.containsKey(n)) {
                this.computeHierarchyFromClass(n, (Class<?>)c);
            }
            hierarchies.add(n);
            hierarchies.addAll((Collection)CLASS_HIERARCHIES.get(n));
        });
        CLASS_HIERARCHIES.put(name, hierarchies);
    }

    private void computeHierarchyFromFile(String className) {
        try {
            byte[] classData = this.classTransformer.getTransformingClassLoader().buildTransformedClassNodeFor(className, "computing_frames");
            ClassReader classReader = new ClassReader(classData);
            classReader.accept((ClassVisitor)new SuperCollectingVisitor(), 7);
        }
        catch (ClassNotFoundException e) {
            try {
                this.computeHierarchyFromClass(className, Class.forName(className.replace('/', '.'), false, this.classTransformer.getTransformingClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.addSuppressed(e);
                LOGGER.fatal("Failed to find class {} ", (Object)className, (Object)classNotFoundException);
                throw new RuntimeException("Cannot find class " + className, classNotFoundException);
            }
        }
    }

    private class SuperCollectingVisitor
    extends ClassVisitor {
        public SuperCollectingVisitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            HashSet<String> hierarchies = new HashSet<String>();
            if (superName != null) {
                CLASS_PARENTS.put(name, superName);
                TransformerClassWriter.this.computeHierarchy(superName);
                hierarchies.add(name);
                hierarchies.addAll((Collection)CLASS_HIERARCHIES.get(superName));
            } else {
                hierarchies.add("java/lang/Object");
            }
            IS_INTERFACE.put(name, (access & 0x200) != 0);
            Arrays.stream(interfaces).forEach(n -> {
                TransformerClassWriter.this.computeHierarchy(n);
                hierarchies.add((String)n);
                hierarchies.addAll((Collection)CLASS_HIERARCHIES.get(n));
            });
            CLASS_HIERARCHIES.put(name, hierarchies);
        }
    }
}

