/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeehiveBlock
extends ContainerBlock {
    private static final Direction[] field_226871_a_ = new Direction[]{Direction.WEST, Direction.EAST, Direction.SOUTH};
    public static final DirectionProperty field_226872_b_ = HorizontalBlock.field_185512_D;
    public static final IntegerProperty field_226873_c_ = BlockStateProperties.field_227036_ao_;

    public BeehiveBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_226873_c_, Integer.valueOf(0)))).func_206870_a((Property)field_226872_b_, (Comparable)((Object)Direction.NORTH))));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((Property)field_226873_c_);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (!worldIn.field_72995_K && te instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)te;
            if (EnchantmentHelper.func_77506_a(Enchantments.field_185306_r, stack) == 0) {
                beehivetileentity.func_226963_a_(player, state, BeehiveTileEntity.State.EMERGENCY);
                worldIn.func_175666_e(pos, (Block)((Object)this));
                this.func_226881_b_(worldIn, pos);
            }
            CriteriaTriggers.field_229865_L_.func_226223_a_((ServerPlayerEntity)player, state.func_177230_c(), stack, beehivetileentity.func_226971_j_());
        }
    }

    private void func_226881_b_(World world, BlockPos pos) {
        List list = world.func_217357_a(BeeEntity.class, new AxisAlignedBB(pos).func_72314_b(8.0, 6.0, 8.0));
        if (!list.isEmpty()) {
            List list1 = world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(pos).func_72314_b(8.0, 6.0, 8.0));
            if (list1.isEmpty()) {
                return;
            }
            int i = list1.size();
            for (BeeEntity beeentity : list) {
                if (beeentity.func_70638_az() != null) continue;
                beeentity.func_70624_b((LivingEntity)((Object)list1.get(world.field_73012_v.nextInt(i))));
            }
        }
    }

    public static void func_226878_a_(World world, BlockPos pos) {
        BeehiveBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_226635_pU_, 3));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        int i = (Integer)state.func_177229_b((Property)field_226873_c_);
        boolean flag = false;
        if (i >= 5) {
            if (itemstack.func_77973_b() instanceof ShearsItem) {
                worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                BeehiveBlock.func_226878_a_(worldIn, pos);
                itemstack.func_222118_a(1, player, p_226874_1_ -> p_226874_1_.func_213334_d(handIn));
                flag = true;
            } else if (itemstack.func_77973_b() == Items.field_151069_bo) {
                itemstack.func_190918_g(1);
                worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(handIn, new ItemStack(Items.field_226638_pX_));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_226638_pX_))) {
                    player.func_71019_a(new ItemStack(Items.field_226638_pX_), false);
                }
                flag = true;
            }
        }
        if (flag) {
            if (!CampfireBlock.func_235474_a_(worldIn, pos)) {
                if (this.func_226882_d_(worldIn, pos)) {
                    this.func_226881_b_(worldIn, pos);
                }
                this.func_226877_a_(worldIn, state, pos, player, BeehiveTileEntity.State.EMERGENCY);
            } else {
                this.func_226876_a_(worldIn, state, pos);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    private boolean func_226882_d_(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            return !beehivetileentity.func_226969_f_();
        }
        return false;
    }

    public void func_226877_a_(World world, BlockState state, BlockPos pos, @Nullable PlayerEntity player, BeehiveTileEntity.State tileState) {
        this.func_226876_a_(world, state, pos);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            beehivetileentity.func_226963_a_(player, state, tileState);
        }
    }

    public void func_226876_a_(World world, BlockState state, BlockPos pos) {
        world.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_226873_c_, Integer.valueOf(0))), 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((Property)field_226873_c_) >= 5) {
            for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                this.func_226879_a_(worldIn, pos, stateIn);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_226879_a_(World world, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.func_204520_s().func_206888_e() && !(world.field_73012_v.nextFloat() < 0.3f) && (d0 = (voxelshape = state.func_196952_d((IBlockReader)((Object)world), pos)).func_197758_c(Direction.Axis.Y)) >= 1.0 && !state.func_235714_a_(BlockTags.field_211923_H)) {
            double d1 = voxelshape.func_197762_b(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.func_226880_a_(world, pos, voxelshape, (double)pos.func_177956_o() + d1 - 0.05);
            } else {
                BlockPos blockpos = pos.func_177977_b();
                BlockState blockstate = world.func_180495_p(blockpos);
                VoxelShape voxelshape1 = blockstate.func_196952_d((IBlockReader)((Object)world), blockpos);
                double d2 = voxelshape1.func_197758_c(Direction.Axis.Y);
                if ((d2 < 1.0 || !blockstate.func_235785_r_((IBlockReader)((Object)world), blockpos)) && blockstate.func_204520_s().func_206888_e()) {
                    this.func_226880_a_(world, pos, voxelshape, (double)pos.func_177956_o() - 0.05);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_226880_a_(World world, BlockPos pos, VoxelShape shape, double y) {
        this.func_226875_a_(world, (double)pos.func_177958_n() + shape.func_197762_b(Direction.Axis.X), (double)pos.func_177958_n() + shape.func_197758_c(Direction.Axis.X), (double)pos.func_177952_p() + shape.func_197762_b(Direction.Axis.Z), (double)pos.func_177952_p() + shape.func_197758_c(Direction.Axis.Z), y);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_226875_a_(World particleData, double x1, double x2, double z1, double z2, double y) {
        particleData.func_195594_a((IParticleData)ParticleTypes.field_229427_ag_, MathHelper.func_219803_d((double)particleData.field_73012_v.nextDouble(), (double)x1, (double)x2), y, MathHelper.func_219803_d((double)particleData.field_73012_v.nextDouble(), (double)z1, (double)z2), 0.0, 0.0, 0.0);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_226872_b_, (Comparable)((Object)context.func_195992_f().func_176734_d())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_226873_c_, field_226872_b_});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BeehiveTileEntity();
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && player.func_184812_l_() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && (tileentity = worldIn.func_175625_s(pos)) instanceof BeehiveTileEntity) {
            boolean flag;
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            ItemStack itemstack = new ItemStack((IItemProvider)this);
            int i = (Integer)state.func_177229_b((Property)field_226873_c_);
            boolean bl = flag = !beehivetileentity.func_226969_f_();
            if (!flag && i == 0) {
                return;
            }
            if (flag) {
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_218657_a("Bees", (INBT)beehivetileentity.func_226974_m_());
                itemstack.func_77983_a("BlockEntityTag", compoundnbt);
            }
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_74768_a("honey_level", i);
            itemstack.func_77983_a("BlockStateTag", compoundnbt1);
            ItemEntity itementity = new ItemEntity(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), itemstack);
            itementity.func_174869_p();
            worldIn.func_217376_c(itementity);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity;
        Entity entity = (Entity)((Object)builder.func_216019_b(LootParameters.field_216281_a));
        if ((entity instanceof TNTEntity || entity instanceof CreeperEntity || entity instanceof WitherSkullEntity || entity instanceof WitherEntity || entity instanceof TNTMinecartEntity) && (tileentity = (TileEntity)((Object)builder.func_216019_b(LootParameters.field_216288_h))) instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            beehivetileentity.func_226963_a_((PlayerEntity)null, state, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.func_220076_a(state, builder);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TileEntity tileentity;
        if (worldIn.func_180495_p(facingPos).func_177230_c() instanceof FireBlock && (tileentity = worldIn.func_175625_s(currentPos)) instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            beehivetileentity.func_226963_a_((PlayerEntity)null, stateIn, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public static Direction func_235331_a_(Random rand) {
        return (Direction)((Object)Util.func_240989_a_((Object[])field_226871_a_, (Random)rand));
    }
}

