/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PistonBlockStructureHelper {
    private final World field_177261_a;
    private final BlockPos field_177259_b;
    private final boolean field_211724_c;
    private final BlockPos field_177260_c;
    private final Direction field_177257_d;
    private final List<BlockPos> field_177258_e = Lists.newArrayList();
    private final List<BlockPos> field_177256_f = Lists.newArrayList();
    private final Direction field_211906_h;

    public PistonBlockStructureHelper(World worldIn, BlockPos posIn, Direction pistonFacing, boolean extending) {
        this.field_177261_a = worldIn;
        this.field_177259_b = posIn;
        this.field_211906_h = pistonFacing;
        this.field_211724_c = extending;
        if (extending) {
            this.field_177257_d = pistonFacing;
            this.field_177260_c = posIn.func_177972_a(pistonFacing);
        } else {
            this.field_177257_d = pistonFacing.func_176734_d();
            this.field_177260_c = posIn.func_177967_a(pistonFacing, 2);
        }
    }

    public boolean func_177253_a() {
        this.field_177258_e.clear();
        this.field_177256_f.clear();
        BlockState blockstate = this.field_177261_a.func_180495_p(this.field_177260_c);
        if (!PistonBlock.func_185646_a(blockstate, this.field_177261_a, this.field_177260_c, this.field_177257_d, false, this.field_211906_h)) {
            if (this.field_211724_c && blockstate.func_185905_o() == PushReaction.DESTROY) {
                this.field_177256_f.add(this.field_177260_c);
                return true;
            }
            return false;
        }
        if (!this.func_177251_a(this.field_177260_c, this.field_177257_d)) {
            return false;
        }
        for (int i = 0; i < this.field_177258_e.size(); ++i) {
            BlockPos blockpos = this.field_177258_e.get(i);
            if (!this.field_177261_a.func_180495_p(blockpos).isStickyBlock() || this.func_177250_b(blockpos)) continue;
            return false;
        }
        return true;
    }

    private boolean func_177251_a(BlockPos origin, Direction facingIn) {
        BlockState blockstate = this.field_177261_a.func_180495_p(origin);
        if (this.field_177261_a.func_175623_d(origin)) {
            return true;
        }
        if (!PistonBlock.func_185646_a(blockstate, this.field_177261_a, origin, this.field_177257_d, false, facingIn)) {
            return true;
        }
        if (origin.equals((Object)this.field_177259_b)) {
            return true;
        }
        if (this.field_177258_e.contains(origin)) {
            return true;
        }
        int i = 1;
        if (i + this.field_177258_e.size() > 12) {
            return false;
        }
        while (blockstate.isStickyBlock()) {
            BlockPos blockpos = origin.func_177967_a(this.field_177257_d.func_176734_d(), i);
            BlockState oldState = blockstate;
            blockstate = this.field_177261_a.func_180495_p(blockpos);
            if (blockstate.isAir((IBlockReader)((Object)this.field_177261_a), blockpos) || !oldState.canStickTo(blockstate) || !PistonBlock.func_185646_a(blockstate, this.field_177261_a, blockpos, this.field_177257_d, false, this.field_177257_d.func_176734_d()) || blockpos.equals((Object)this.field_177259_b)) break;
            if (++i + this.field_177258_e.size() <= 12) continue;
            return false;
        }
        int l = 0;
        for (int i1 = i - 1; i1 >= 0; --i1) {
            this.field_177258_e.add(origin.func_177967_a(this.field_177257_d.func_176734_d(), i1));
            ++l;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1;
            int j;
            if ((j = this.field_177258_e.indexOf(blockpos1 = origin.func_177967_a(this.field_177257_d, j1))) > -1) {
                this.func_177255_a(l, j);
                for (int k = 0; k <= j + l; ++k) {
                    BlockPos blockpos2 = this.field_177258_e.get(k);
                    if (!this.field_177261_a.func_180495_p(blockpos2).isStickyBlock() || this.func_177250_b(blockpos2)) continue;
                    return false;
                }
                return true;
            }
            blockstate = this.field_177261_a.func_180495_p(blockpos1);
            if (blockstate.isAir((IBlockReader)((Object)this.field_177261_a), blockpos1)) {
                return true;
            }
            if (!PistonBlock.func_185646_a(blockstate, this.field_177261_a, blockpos1, this.field_177257_d, true, this.field_177257_d) || blockpos1.equals((Object)this.field_177259_b)) {
                return false;
            }
            if (blockstate.func_185905_o() == PushReaction.DESTROY) {
                this.field_177256_f.add(blockpos1);
                return true;
            }
            if (this.field_177258_e.size() >= 12) {
                return false;
            }
            this.field_177258_e.add(blockpos1);
            ++l;
            ++j1;
        }
    }

    private void func_177255_a(int offsets, int index) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.field_177258_e.subList(0, index));
        list1.addAll(this.field_177258_e.subList(this.field_177258_e.size() - offsets, this.field_177258_e.size()));
        list2.addAll(this.field_177258_e.subList(index, this.field_177258_e.size() - offsets));
        this.field_177258_e.clear();
        this.field_177258_e.addAll(list);
        this.field_177258_e.addAll(list1);
        this.field_177258_e.addAll(list2);
    }

    private boolean func_177250_b(BlockPos fromPos) {
        BlockState blockstate = this.field_177261_a.func_180495_p(fromPos);
        for (Direction direction : Direction.values()) {
            BlockPos blockpos;
            BlockState blockstate1;
            if (direction.func_176740_k() == this.field_177257_d.func_176740_k() || !(blockstate1 = this.field_177261_a.func_180495_p(blockpos = fromPos.func_177972_a(direction))).canStickTo(blockstate) || this.func_177251_a(blockpos, direction)) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> func_177254_c() {
        return this.field_177258_e;
    }

    public List<BlockPos> func_177252_d() {
        return this.field_177256_f;
    }
}

