/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class TurtleEggBlock
extends Block {
    private static final VoxelShape field_203172_c = Block.func_208617_a(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape field_206843_t = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 7.0, 15.0);
    public static final IntegerProperty field_203170_a = BlockStateProperties.field_208128_ac;
    public static final IntegerProperty field_203171_b = BlockStateProperties.field_208127_ab;

    public TurtleEggBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_203170_a, Integer.valueOf(0)))).func_206870_a((Property)field_203171_b, Integer.valueOf(1))));
    }

    @Override
    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.func_203167_a(worldIn, pos, entityIn, 100);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @Override
    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!(entityIn instanceof ZombieEntity)) {
            this.func_203167_a(worldIn, pos, entityIn, 3);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    private void func_203167_a(World worldIn, BlockPos pos, Entity trampler, int chances) {
        BlockState blockstate;
        if (this.func_212570_a(worldIn, trampler) && !worldIn.field_72995_K && worldIn.field_73012_v.nextInt(chances) == 0 && (blockstate = worldIn.func_180495_p(pos)).func_203425_a(Blocks.field_203213_jA)) {
            this.func_203166_c(worldIn, pos, blockstate);
        }
    }

    private void func_203166_c(World worldIn, BlockPos pos, BlockState state) {
        worldIn.func_184133_a(null, pos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f);
        int i = (Integer)state.func_177229_b((Property)field_203171_b);
        if (i <= 1) {
            worldIn.func_175655_b(pos, false);
        } else {
            worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_203171_b, Integer.valueOf(i - 1))), 2);
            worldIn.func_217379_c(2001, pos, Block.func_196246_j(state));
        }
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.func_203169_a(worldIn) && TurtleEggBlock.func_203168_a((IBlockReader)((Object)worldIn), pos)) {
            int i = (Integer)state.func_177229_b((Property)field_203170_a);
            if (i < 2) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_203280_iy, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_203170_a, Integer.valueOf(i + 1))), 2);
            } else {
                worldIn.func_184133_a(null, pos, SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.func_217377_a(pos, false);
                for (int j = 0; j < (Integer)state.func_177229_b((Property)field_203171_b); ++j) {
                    worldIn.func_217379_c(2001, pos, Block.func_196246_j(state));
                    TurtleEntity turtleentity = EntityType.field_203099_aq.func_200721_a(worldIn);
                    turtleentity.func_70873_a(-24000);
                    turtleentity.func_203011_g(pos);
                    turtleentity.func_70012_b((double)pos.func_177958_n() + 0.3 + (double)j * 0.2, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.3, 0.0f, 0.0f);
                    worldIn.func_217376_c((Entity)turtleentity);
                }
            }
        }
    }

    public static boolean func_203168_a(IBlockReader reader, BlockPos blockReader) {
        return TurtleEggBlock.func_241473_b_(reader, blockReader.func_177977_b());
    }

    public static boolean func_241473_b_(IBlockReader reader, BlockPos pos) {
        return reader.func_180495_p(pos).func_235714_a_(BlockTags.field_203436_u);
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (TurtleEggBlock.func_203168_a((IBlockReader)((Object)worldIn), pos) && !worldIn.field_72995_K) {
            worldIn.func_217379_c(2005, pos, 0);
        }
    }

    private boolean func_203169_a(World worldIn) {
        float f = worldIn.func_242415_f(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return worldIn.field_73012_v.nextInt(500) == 0;
    }

    @Override
    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.func_203166_c(worldIn, pos, state);
    }

    @Override
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)field_203171_b) < 4 ? true : super.func_196253_a(state, useContext);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        return blockstate.func_203425_a(this) ? (BlockState)((Object)blockstate.func_206870_a((Property)field_203171_b, Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((Property)field_203171_b) + 1)))) : super.func_196258_a(context);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Integer)state.func_177229_b((Property)field_203171_b) > 1 ? field_206843_t : field_203172_c;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_203170_a, field_203171_b});
    }

    private boolean func_212570_a(World worldIn, Entity trampler) {
        if (!(trampler instanceof TurtleEntity) && !(trampler instanceof BatEntity)) {
            if (!(trampler instanceof LivingEntity)) {
                return false;
            }
            return trampler instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)trampler);
        }
        return false;
    }
}

