/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AccessibilityScreen;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.LanguageScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.MultiplayerWarningScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsBridgeScreen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class MainMenuScreen
extends Screen {
    private static final Logger field_238656_b_ = LogManager.getLogger();
    public static final RenderSkyboxCube field_213098_a = new RenderSkyboxCube(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation field_213099_c = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation field_213100_d = new ResourceLocation("textures/gui/accessibility.png");
    private final boolean field_213101_e;
    @Nullable
    private String field_73975_c;
    private Button field_73973_d;
    private static final ResourceLocation field_110352_y = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation field_194400_H = new ResourceLocation("textures/gui/title/edition.png");
    private boolean field_183502_L;
    private Screen field_183503_M;
    private int field_193978_M;
    private int field_193979_N;
    private final RenderSkybox field_209101_K = new RenderSkybox(field_213098_a);
    private final boolean field_213102_y;
    private long field_213103_z;
    private NotificationModUpdateScreen modUpdateNotification;

    public MainMenuScreen() {
        this(false);
    }

    public MainMenuScreen(boolean fadeIn) {
        super((ITextComponent)new TranslationTextComponent("narrator.screen.title"));
        this.field_213102_y = fadeIn;
        this.field_213101_e = (double)new Random().nextFloat() < 1.0E-4;
    }

    private boolean func_183501_a() {
        return this.field_230706_i_.field_71474_y.field_183509_X && this.field_183503_M != null;
    }

    @Override
    public void func_231023_e_() {
        if (this.func_183501_a()) {
            this.field_183503_M.func_231023_e_();
        }
    }

    public static CompletableFuture<Void> func_213097_a(TextureManager texMngr, Executor backgroundExecutor) {
        return CompletableFuture.allOf(texMngr.func_215268_a(field_110352_y, backgroundExecutor), texMngr.func_215268_a(field_194400_H, backgroundExecutor), texMngr.func_215268_a(field_213099_c, backgroundExecutor), field_213098_a.func_217617_a(texMngr, backgroundExecutor));
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    @Override
    public boolean func_231178_ax__() {
        return false;
    }

    @Override
    protected void func_231160_c_() {
        if (this.field_73975_c == null) {
            this.field_73975_c = this.field_230706_i_.func_213269_at().func_215276_a();
        }
        this.field_193978_M = this.field_230712_o_.func_78256_a("Copyright Mojang AB. Do not distribute!");
        this.field_193979_N = this.field_230708_k_ - this.field_193978_M - 2;
        int i = 24;
        int j = this.field_230709_l_ / 4 + 48;
        Button modButton = null;
        if (this.field_230706_i_.func_71355_q()) {
            this.func_73972_b(j, 24);
        } else {
            this.func_73969_a(j, 24);
            modButton = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, j + 48, 98, 20, (ITextComponent)new TranslationTextComponent("fml.menu.mods"), button -> this.field_230706_i_.func_147108_a((Screen)new ModListScreen((Screen)this))));
        }
        this.modUpdateNotification = NotificationModUpdateScreen.init((MainMenuScreen)this, modButton);
        this.func_230480_a_(new ImageButton(this.field_230708_k_ / 2 - 124, j + 72 + 12, 20, 20, 0, 106, 20, Button.field_230687_i_, 256, 256, p_213090_1_ -> this.field_230706_i_.func_147108_a((Screen)((Object)((Object)((Object)new LanguageScreen(this, this.field_230706_i_.field_71474_y, this.field_230706_i_.func_135016_M()))))), (ITextComponent)new TranslationTextComponent("narrator.button.language")));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, j + 72 + 12, 98, 20, (ITextComponent)new TranslationTextComponent("menu.options"), p_213096_1_ -> this.field_230706_i_.func_147108_a(new OptionsScreen(this, this.field_230706_i_.field_71474_y))));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 2, j + 72 + 12, 98, 20, (ITextComponent)new TranslationTextComponent("menu.quit"), p_213094_1_ -> this.field_230706_i_.func_71400_g()));
        this.func_230480_a_(new ImageButton(this.field_230708_k_ / 2 + 104, j + 72 + 12, 20, 20, 0, 0, 20, field_213100_d, 32, 64, p_213088_1_ -> this.field_230706_i_.func_147108_a((Screen)new AccessibilityScreen((Screen)this, this.field_230706_i_.field_71474_y)), (ITextComponent)new TranslationTextComponent("narrator.button.accessibility")));
        this.field_230706_i_.func_181537_a(false);
        if (this.field_230706_i_.field_71474_y.field_183509_X && !this.field_183502_L) {
            RealmsBridgeScreen realmsbridgescreen = new RealmsBridgeScreen();
            this.field_183503_M = realmsbridgescreen.func_239555_b_((Screen)this);
            this.field_183502_L = true;
        }
        if (this.func_183501_a()) {
            this.field_183503_M.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
    }

    private void func_73969_a(int yIn, int rowHeightIn) {
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, yIn, 200, 20, (ITextComponent)new TranslationTextComponent("menu.singleplayer"), p_213089_1_ -> this.field_230706_i_.func_147108_a((Screen)new WorldSelectionScreen((Screen)this))));
        boolean flag = this.field_230706_i_.func_238216_r_();
        Button.ITooltip button$itooltip = flag ? Button.field_238486_s_ : (p_238659_1_, p_238659_2_, p_238659_3_, p_238659_4_) -> {
            if (!p_238659_1_.field_230693_o_) {
                this.func_238654_b_(p_238659_2_, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("title.multiplayer.disabled"), Math.max(this.field_230708_k_ / 2 - 43, 170)), p_238659_3_, p_238659_4_);
            }
        };
        this.func_230480_a_(new Button((int)(this.field_230708_k_ / 2 - 100), (int)(yIn + rowHeightIn * 1), (int)200, (int)20, (ITextComponent)new TranslationTextComponent((String)"menu.multiplayer"), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$addSingleplayerMultiplayerButtons$7(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((MainMenuScreen)this), (Button.ITooltip)button$itooltip)).field_230693_o_ = flag;
        this.func_230480_a_(new Button((int)(this.field_230708_k_ / 2 + 2), (int)(yIn + rowHeightIn * 2), (int)98, (int)20, (ITextComponent)new TranslationTextComponent((String)"menu.online"), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$addSingleplayerMultiplayerButtons$8(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((MainMenuScreen)this), (Button.ITooltip)button$itooltip)).field_230693_o_ = flag;
    }

    private void func_73972_b(int yIn, int rowHeightIn) {
        boolean flag = this.func_243319_k();
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, yIn, 200, 20, (ITextComponent)new TranslationTextComponent("menu.playdemo"), p_213091_2_ -> {
            if (flag) {
                this.field_230706_i_.func_238191_a_("Demo_World");
            } else {
                DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
                this.field_230706_i_.func_238192_a_("Demo_World", MinecraftServer.field_213219_c, dynamicregistries$impl, DimensionGeneratorSettings.func_242752_a(dynamicregistries$impl));
            }
        }));
        this.field_73973_d = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, yIn + rowHeightIn * 1, 200, 20, (ITextComponent)new TranslationTextComponent("menu.resetdemo"), p_238658_1_ -> {
            SaveFormat saveformat = this.field_230706_i_.func_71359_d();
            try (SaveFormat.LevelSave saveformat$levelsave = saveformat.func_237274_c_("Demo_World");){
                WorldSummary worldsummary = saveformat$levelsave.func_237296_d_();
                if (worldsummary != null) {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(this::func_213087_a, (ITextComponent)new TranslationTextComponent("selectWorld.deleteQuestion"), (ITextComponent)new TranslationTextComponent("selectWorld.deleteWarning", worldsummary.func_75788_b()), (ITextComponent)new TranslationTextComponent("selectWorld.deleteButton"), DialogTexts.field_240633_d_));
                }
            }
            catch (IOException ioexception) {
                SystemToast.func_238535_a_((Minecraft)this.field_230706_i_, (String)"Demo_World");
                field_238656_b_.warn("Failed to access demo world", (Throwable)ioexception);
            }
        }));
        this.field_73973_d.field_230693_o_ = flag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean func_243319_k() {
        try (SaveFormat.LevelSave saveformat$levelsave = this.field_230706_i_.func_71359_d().func_237274_c_("Demo_World");){
            boolean bl = saveformat$levelsave.func_237296_d_() != null;
            return bl;
        }
        catch (IOException ioexception) {
            SystemToast.func_238535_a_((Minecraft)this.field_230706_i_, (String)"Demo_World");
            field_238656_b_.warn("Failed to read demo world data", (Throwable)ioexception);
            return false;
        }
    }

    private void func_140005_i() {
        RealmsBridgeScreen realmsbridgescreen = new RealmsBridgeScreen();
        realmsbridgescreen.func_231394_a_((Screen)this);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_213103_z == 0L && this.field_213102_y) {
            this.field_213103_z = Util.func_211177_b();
        }
        float f = this.field_213102_y ? (float)(Util.func_211177_b() - this.field_213103_z) / 1000.0f : 1.0f;
        MainMenuScreen.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1);
        this.field_209101_K.func_217623_a(partialTicks, MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f));
        int i = 274;
        int j = this.field_230708_k_ / 2 - 137;
        int k = 30;
        this.field_230706_i_.func_110434_K().func_110577_a(field_213099_c);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.field_213102_y ? (float)MathHelper.func_76123_f((float)MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f)) : 1.0f));
        MainMenuScreen.func_238466_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        float f1 = this.field_213102_y ? MathHelper.func_76131_a((float)(f - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int l = MathHelper.func_76123_f((float)(f1 * 255.0f)) << 24;
        if ((l & 0xFC000000) != 0) {
            this.field_230706_i_.func_110434_K().func_110577_a(field_110352_y);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            if (this.field_213101_e) {
                this.func_238459_a_(j, 30, (p_238660_2_, p_238660_3_) -> {
                    this.func_238474_b_(matrixStack, p_238660_2_ + 0, (int)p_238660_3_, 0, 0, 99, 44);
                    this.func_238474_b_(matrixStack, p_238660_2_ + 99, (int)p_238660_3_, 129, 0, 27, 44);
                    this.func_238474_b_(matrixStack, p_238660_2_ + 99 + 26, (int)p_238660_3_, 126, 0, 3, 44);
                    this.func_238474_b_(matrixStack, p_238660_2_ + 99 + 26 + 3, (int)p_238660_3_, 99, 0, 26, 44);
                    this.func_238474_b_(matrixStack, p_238660_2_ + 155, (int)p_238660_3_, 0, 45, 155, 44);
                });
            } else {
                this.func_238459_a_(j, 30, (p_238657_2_, p_238657_3_) -> {
                    this.func_238474_b_(matrixStack, p_238657_2_ + 0, (int)p_238657_3_, 0, 0, 155, 44);
                    this.func_238474_b_(matrixStack, p_238657_2_ + 155, (int)p_238657_3_, 0, 45, 155, 44);
                });
            }
            this.field_230706_i_.func_110434_K().func_110577_a(field_194400_H);
            MainMenuScreen.func_238463_a_((MatrixStack)matrixStack, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            ForgeHooksClient.renderMainMenu((MainMenuScreen)this, (MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (int)this.field_230708_k_, (int)this.field_230709_l_);
            if (this.field_73975_c != null) {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(this.field_230708_k_ / 2 + 90), (float)70.0f, (float)0.0f);
                RenderSystem.rotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                float f2 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Util.func_211177_b() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                f2 = f2 * 100.0f / (float)(this.field_230712_o_.func_78256_a(this.field_73975_c) + 32);
                RenderSystem.scalef((float)f2, (float)f2, (float)f2);
                MainMenuScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.field_73975_c, (int)0, (int)-8, (int)(0xFFFF00 | l));
                RenderSystem.popMatrix();
            }
            String s = "Minecraft " + SharedConstants.func_215069_a().getName();
            s = this.field_230706_i_.func_71355_q() ? s + " Demo" : s + ("release".equalsIgnoreCase(this.field_230706_i_.func_184123_d()) ? "" : "/" + this.field_230706_i_.func_184123_d());
            if (this.field_230706_i_.func_230151_c_()) {
                s = s + I18n.func_135052_a("menu.modded", new Object[0]);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                int n = brdline;
                this.field_230712_o_.getClass();
                MainMenuScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)brd, (int)2, (int)(this.field_230709_l_ - (10 + n * (9 + 1))), (int)(0xFFFFFF | l));
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                int n = this.field_230708_k_ - this.field_230712_o_.func_78256_a(brd);
                int n2 = brdline + 1;
                this.field_230712_o_.getClass();
                MainMenuScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)brd, (int)n, (int)(this.field_230709_l_ - (10 + n2 * (9 + 1))), (int)(0xFFFFFF | l));
            });
            MainMenuScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Copyright Mojang AB. Do not distribute!", (int)this.field_193979_N, (int)(this.field_230709_l_ - 10), (int)(0xFFFFFF | l));
            if (mouseX > this.field_193979_N && mouseX < this.field_193979_N + this.field_193978_M && mouseY > this.field_230709_l_ - 10 && mouseY < this.field_230709_l_) {
                MainMenuScreen.func_238467_a_((MatrixStack)matrixStack, (int)this.field_193979_N, (int)(this.field_230709_l_ - 1), (int)(this.field_193979_N + this.field_193978_M), (int)this.field_230709_l_, (int)(0xFFFFFF | l));
            }
            for (Widget widget : this.field_230710_m_) {
                widget.func_230986_a_(f1);
            }
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.func_183501_a() && f1 >= 1.0f) {
                this.field_183503_M.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.modUpdateNotification.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.func_183501_a() && this.field_183503_M.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX > (double)this.field_193979_N && mouseX < (double)(this.field_193979_N + this.field_193978_M) && mouseY > (double)(this.field_230709_l_ - 10) && mouseY < (double)this.field_230709_l_) {
            this.field_230706_i_.func_147108_a((Screen)new WinGameScreen(false, Runnables.doNothing()));
        }
        return false;
    }

    @Override
    public void func_231164_f_() {
        if (this.field_183503_M != null) {
            this.field_183503_M.func_231164_f_();
        }
    }

    private void func_213087_a(boolean p_213087_1_) {
        if (p_213087_1_) {
            try (SaveFormat.LevelSave saveformat$levelsave = this.field_230706_i_.func_71359_d().func_237274_c_("Demo_World");){
                saveformat$levelsave.func_237299_g_();
            }
            catch (IOException ioexception) {
                SystemToast.func_238538_b_((Minecraft)this.field_230706_i_, (String)"Demo_World");
                field_238656_b_.warn("Failed to delete demo world", (Throwable)ioexception);
            }
        }
        this.field_230706_i_.func_147108_a(this);
    }

    private /* synthetic */ void lambda$addSingleplayerMultiplayerButtons$8(Button p_238661_1_) {
        this.func_140005_i();
    }

    private /* synthetic */ void lambda$addSingleplayerMultiplayerButtons$7(Button p_213095_1_) {
        MultiplayerScreen screen = this.field_230706_i_.field_71474_y.field_230152_Z_ ? new MultiplayerScreen(this) : new MultiplayerWarningScreen((Screen)this);
        this.field_230706_i_.func_147108_a(screen);
    }
}

