/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeeEntity
extends AnimalEntity
implements IAngerable,
IFlyingAnimal {
    private static final DataParameter<Byte> field_226374_bw_ = EntityDataManager.func_187226_a(BeeEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Integer> field_226375_bx_ = EntityDataManager.func_187226_a(BeeEntity.class, DataSerializers.field_187192_b);
    private static final RangedInteger field_234180_bw_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID field_226376_by_;
    private float field_226377_bz_;
    private float field_226361_bA_;
    private int field_226362_bB_;
    private int field_226363_bC_;
    private int field_226364_bD_;
    private int field_226365_bE_;
    private int field_226366_bF_ = 0;
    private int field_226367_bG_ = 0;
    @Nullable
    private BlockPos field_226368_bH_ = null;
    @Nullable
    private BlockPos field_226369_bI_ = null;
    private PollinateGoal field_226370_bJ_;
    private FindBeehiveGoal field_226371_bK_;
    private FindFlowerGoal field_226372_bL_;
    private int field_226373_bM_;

    public BeeEntity(EntityType<? extends BeeEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)((Object)this), 20, true);
        this.field_70749_g = new BeeLookController((MobEntity)((Object)this));
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_226374_bw_, (byte)0);
        this.field_70180_af.func_187214_a(field_226375_bx_, 0);
    }

    @Override
    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new StingGoal((CreatureEntity)this, 1.4f, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new EnterBeehiveGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199805_a(ItemTags.field_226159_I_), false));
        this.field_226370_bJ_ = new PollinateGoal();
        this.field_70714_bg.func_75776_a(4, (Goal)this.field_226370_bJ_);
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new UpdateBeehiveGoal());
        this.field_226371_bK_ = new FindBeehiveGoal();
        this.field_70714_bg.func_75776_a(5, (Goal)this.field_226371_bK_);
        this.field_226372_bL_ = new FindFlowerGoal();
        this.field_70714_bg.func_75776_a(6, (Goal)this.field_226372_bL_);
        this.field_70714_bg.func_75776_a(7, (Goal)new FindPollinationTargetGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (Goal)new AngerGoal(this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new ResetAngerGoal((MobEntity)((Object)this), true));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.func_226409_eA_()) {
            compound.func_218657_a("HivePos", NBTUtil.func_186859_a((BlockPos)this.func_226410_eB_()));
        }
        if (this.func_226425_er_()) {
            compound.func_218657_a("FlowerPos", NBTUtil.func_186859_a((BlockPos)this.func_226424_eq_()));
        }
        compound.func_74757_a("HasNectar", this.func_226411_eD_());
        compound.func_74757_a("HasStung", this.func_226412_eE_());
        compound.func_74768_a("TicksSincePollination", this.field_226363_bC_);
        compound.func_74768_a("CannotEnterHiveTicks", this.field_226364_bD_);
        compound.func_74768_a("CropsGrownSincePollination", this.field_226365_bE_);
        this.func_233682_c_(compound);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.field_226369_bI_ = null;
        if (compound.func_74764_b("HivePos")) {
            this.field_226369_bI_ = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HivePos"));
        }
        this.field_226368_bH_ = null;
        if (compound.func_74764_b("FlowerPos")) {
            this.field_226368_bH_ = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("FlowerPos"));
        }
        super.func_70037_a(compound);
        this.func_226447_r_(compound.func_74767_n("HasNectar"));
        this.func_226449_s_(compound.func_74767_n("HasStung"));
        this.field_226363_bC_ = compound.func_74762_e("TicksSincePollination");
        this.field_226364_bD_ = compound.func_74762_e("CannotEnterHiveTicks");
        this.field_226365_bE_ = compound.func_74762_e("CropsGrownSincePollination");
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_226252_a_((LivingEntity)((Object)this)), (int)this.func_233637_b_(Attributes.field_233823_f_));
        if (flag) {
            this.func_174815_a((LivingEntity)((Object)this), entityIn);
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_226300_q_(((LivingEntity)entityIn).func_226297_df_() + 1);
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 18;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20, 0));
                }
            }
            this.func_226449_s_(true);
            this.func_241356_K__();
            this.func_184185_a(SoundEvents.field_226128_ac_, 1.0f, 1.0f);
        }
        return flag;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_226411_eD_() && this.func_226419_eM_() < 10 && this.field_70146_Z.nextFloat() < 0.05f) {
            for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                this.func_226397_a_(this.field_70170_p, this.func_226277_ct_() - (double)0.3f, this.func_226277_ct_() + (double)0.3f, this.func_226281_cx_() - (double)0.3f, this.func_226281_cx_() + (double)0.3f, this.func_226283_e_(0.5), (IParticleData)ParticleTypes.field_229430_aj_);
            }
        }
        this.func_226416_eJ_();
    }

    private void func_226397_a_(World worldIn, double p_226397_2_, double p_226397_4_, double p_226397_6_, double p_226397_8_, double posY, IParticleData particleData) {
        worldIn.func_195594_a(particleData, MathHelper.func_219803_d((double)worldIn.field_73012_v.nextDouble(), (double)p_226397_2_, (double)p_226397_4_), posY, MathHelper.func_219803_d((double)worldIn.field_73012_v.nextDouble(), (double)p_226397_6_, (double)p_226397_8_), 0.0, 0.0, 0.0);
    }

    private void func_226433_h_(BlockPos pos) {
        Vector3d vector3d1;
        Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)pos);
        int i = 0;
        BlockPos blockpos = this.func_233580_cy_();
        int j = (int)vector3d.field_72448_b - blockpos.func_177956_o();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.func_218139_n((Vector3i)pos);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vector3d1 = RandomPositionGenerator.func_226344_b_((CreatureEntity)this, (int)k, (int)l, (int)i, (Vector3d)vector3d, (double)0.3141592741012573)) != null) {
            this.field_70699_by.func_226335_a_(0.5f);
            this.field_70699_by.func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, 1.0);
        }
    }

    @Nullable
    public BlockPos func_226424_eq_() {
        return this.field_226368_bH_;
    }

    public boolean func_226425_er_() {
        return this.field_226368_bH_ != null;
    }

    public void func_226431_g_(BlockPos pos) {
        this.field_226368_bH_ = pos;
    }

    private boolean func_226414_eH_() {
        return this.field_226363_bC_ > 3600;
    }

    private boolean func_226415_eI_() {
        if (this.field_226364_bD_ <= 0 && !this.field_226370_bJ_.func_226503_k_() && !this.func_226412_eE_() && this.func_70638_az() == null) {
            boolean flag = this.func_226414_eH_() || this.field_70170_p.func_72896_J() || this.field_70170_p.func_226690_K_() || this.func_226411_eD_();
            return flag && !this.func_226417_eK_();
        }
        return false;
    }

    public void func_226450_t_(int p_226450_1_) {
        this.field_226364_bD_ = p_226450_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_226455_v_(float p_226455_1_) {
        return MathHelper.func_219799_g((float)p_226455_1_, (float)this.field_226361_bA_, (float)this.field_226377_bz_);
    }

    private void func_226416_eJ_() {
        this.field_226361_bA_ = this.field_226377_bz_;
        this.field_226377_bz_ = this.func_226423_eQ_() ? Math.min(1.0f, this.field_226377_bz_ + 0.2f) : Math.max(0.0f, this.field_226377_bz_ - 0.24f);
    }

    @Override
    protected void func_70619_bc() {
        boolean flag = this.func_226412_eE_();
        this.field_226373_bM_ = this.func_203005_aq() ? ++this.field_226373_bM_ : 0;
        if (this.field_226373_bM_ > 20) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (flag) {
            ++this.field_226362_bB_;
            if (this.field_226362_bB_ % 5 == 0 && this.field_70146_Z.nextInt(MathHelper.func_76125_a((int)(1200 - this.field_226362_bB_), (int)1, (int)1200)) == 0) {
                this.func_70097_a(DamageSource.field_76377_j, this.func_110143_aJ());
            }
        }
        if (!this.func_226411_eD_()) {
            ++this.field_226363_bC_;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, false);
        }
    }

    public void func_226426_eu_() {
        this.field_226363_bC_ = 0;
    }

    private boolean func_226417_eK_() {
        if (this.field_226369_bI_ == null) {
            return false;
        }
        TileEntity tileentity = this.field_70170_p.func_175625_s(this.field_226369_bI_);
        return tileentity instanceof BeehiveTileEntity && ((BeehiveTileEntity)tileentity).func_226968_d_();
    }

    public int func_230256_F__() {
        return this.field_70180_af.func_187225_a(field_226375_bx_);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(field_226375_bx_, time);
    }

    public UUID func_230257_G__() {
        return this.field_226376_by_;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.field_226376_by_ = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234180_bw_.func_233018_a_(this.field_70146_Z));
    }

    private boolean func_226435_i_(BlockPos pos) {
        TileEntity tileentity = this.field_70170_p.func_175625_s(pos);
        if (tileentity instanceof BeehiveTileEntity) {
            return !((BeehiveTileEntity)tileentity).func_226970_h_();
        }
        return false;
    }

    public boolean func_226409_eA_() {
        return this.field_226369_bI_ != null;
    }

    @Nullable
    public BlockPos func_226410_eB_() {
        return this.field_226369_bI_;
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_229749_a_((BeeEntity)this);
    }

    private int func_226419_eM_() {
        return this.field_226365_bE_;
    }

    private void func_226420_eN_() {
        this.field_226365_bE_ = 0;
    }

    private void func_226421_eO_() {
        ++this.field_226365_bE_;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_226364_bD_ > 0) {
                --this.field_226364_bD_;
            }
            if (this.field_226366_bF_ > 0) {
                --this.field_226366_bF_;
            }
            if (this.field_226367_bG_ > 0) {
                --this.field_226367_bG_;
            }
            boolean flag = this.func_233678_J__() && !this.func_226412_eE_() && this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)((Object)this)) < 4.0;
            this.func_226452_t_(flag);
            if (this.field_70173_aa % 20 == 0 && !this.func_226422_eP_()) {
                this.field_226369_bI_ = null;
            }
        }
    }

    private boolean func_226422_eP_() {
        if (!this.func_226409_eA_()) {
            return false;
        }
        TileEntity tileentity = this.field_70170_p.func_175625_s(this.field_226369_bI_);
        return tileentity instanceof BeehiveTileEntity;
    }

    public boolean func_226411_eD_() {
        return this.func_226456_v_(8);
    }

    private void func_226447_r_(boolean p_226447_1_) {
        if (p_226447_1_) {
            this.func_226426_eu_();
        }
        this.func_226404_d_(8, p_226447_1_);
    }

    public boolean func_226412_eE_() {
        return this.func_226456_v_(4);
    }

    private void func_226449_s_(boolean p_226449_1_) {
        this.func_226404_d_(4, p_226449_1_);
    }

    private boolean func_226423_eQ_() {
        return this.func_226456_v_(2);
    }

    private void func_226452_t_(boolean p_226452_1_) {
        this.func_226404_d_(2, p_226452_1_);
    }

    private boolean func_226437_j_(BlockPos pos) {
        return !this.func_226401_b_(pos, 32);
    }

    private void func_226404_d_(int flagId, boolean p_226404_2_) {
        if (p_226404_2_) {
            this.field_70180_af.func_187227_b(field_226374_bw_, (byte)(this.field_70180_af.func_187225_a(field_226374_bw_) | flagId));
        } else {
            this.field_70180_af.func_187227_b(field_226374_bw_, (byte)(this.field_70180_af.func_187225_a(field_226374_bw_) & ~flagId));
        }
    }

    private boolean func_226456_v_(int flagId) {
        return (this.field_70180_af.func_187225_a(field_226374_bw_) & flagId) != 0;
    }

    public static AttributeModifierMap.MutableAttribute func_234182_eX_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233822_e_, (double)0.6f).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)((Object)this), worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }

            public void func_75501_e() {
                if (!BeeEntity.this.field_226370_bJ_.func_226503_k_()) {
                    super.func_75501_e();
                }
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(ItemTags.field_226159_I_);
    }

    private boolean func_226439_k_(BlockPos pos) {
        return this.field_70170_p.func_195588_v(pos) && this.field_70170_p.func_180495_p(pos).func_177230_c().func_203417_a(BlockTags.field_226149_I_);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_226125_Z_;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_226124_Y_;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public BeeEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return EntityType.field_226289_e_.func_200721_a(p_241840_1_);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.5f : sizeIn.field_220316_b * 0.5f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public void func_226413_eG_() {
        this.func_226447_r_(false);
        this.func_226420_eN_();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (!this.field_70170_p.field_72995_K) {
            this.field_226370_bJ_.func_226504_l_();
        }
        return super.func_70097_a(source, amount);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_180466_bG(ITag<Fluid> fluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.5f * this.func_70047_e(), this.func_213311_cf() * 0.2f);
    }

    private boolean func_226401_b_(BlockPos pos, int distance) {
        return pos.func_218141_a((Vector3i)this.func_233580_cy_(), (double)distance);
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return BeeEntity.this.field_70699_by.func_75500_f() && BeeEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return BeeEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.func_226509_g_();
            if (vector3d != null) {
                BeeEntity.this.field_70699_by.func_75484_a(BeeEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d func_226509_g_() {
            Vector3d vector3d;
            if (BeeEntity.this.func_226422_eP_() && !BeeEntity.this.func_226401_b_(BeeEntity.this.field_226369_bI_, 22)) {
                Vector3d vector3d1 = Vector3d.func_237489_a_((Vector3i)BeeEntity.this.field_226369_bI_);
                vector3d = vector3d1.func_178788_d(BeeEntity.this.func_213303_ch()).func_72432_b();
            } else {
                vector3d = BeeEntity.this.func_70676_i(0.0f);
            }
            int i = 8;
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)BeeEntity.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)BeeEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }

    class UpdateBeehiveGoal
    extends PassiveGoal {
        private UpdateBeehiveGoal() {
        }

        @Override
        public boolean func_225506_g_() {
            return BeeEntity.this.field_226366_bF_ == 0 && !BeeEntity.this.func_226409_eA_() && BeeEntity.this.func_226415_eI_();
        }

        @Override
        public boolean func_225507_h_() {
            return false;
        }

        public void func_75249_e() {
            BeeEntity.this.field_226366_bF_ = 200;
            List<BlockPos> list = this.func_226489_j_();
            if (!list.isEmpty()) {
                for (BlockPos blockpos : list) {
                    if (BeeEntity.this.field_226371_bK_.func_226473_b_(blockpos)) continue;
                    BeeEntity.this.field_226369_bI_ = blockpos;
                    return;
                }
                BeeEntity.this.field_226371_bK_.func_226477_j_();
                BeeEntity.this.field_226369_bI_ = list.get(0);
            }
        }

        private List<BlockPos> func_226489_j_() {
            BlockPos blockpos = BeeEntity.this.func_233580_cy_();
            PointOfInterestManager pointofinterestmanager = ((ServerWorld)BeeEntity.this.field_70170_p).func_217443_B();
            Stream stream = pointofinterestmanager.func_219146_b(p_226486_0_ -> p_226486_0_ == PointOfInterestType.field_226356_s_ || p_226486_0_ == PointOfInterestType.field_226357_t_, blockpos, 20, PointOfInterestManager.Status.ANY);
            return stream.map(PointOfInterest::func_218261_f).filter(p_226487_1_ -> BeeEntity.this.func_226435_i_(p_226487_1_)).sorted(Comparator.comparingDouble(p_226488_1_ -> p_226488_1_.func_177951_i((Vector3i)blockpos))).collect(Collectors.toList());
        }
    }

    class StingGoal
    extends MeleeAttackGoal {
        StingGoal(CreatureEntity creatureIn, double speedIn, boolean useLongMemory) {
            super(creatureIn, speedIn, useLongMemory);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && BeeEntity.this.func_233678_J__() && !BeeEntity.this.func_226412_eE_();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && BeeEntity.this.func_233678_J__() && !BeeEntity.this.func_226412_eE_();
        }
    }

    class PollinateGoal
    extends PassiveGoal {
        private final Predicate<BlockState> field_226492_c_;
        private int field_226493_d_;
        private int field_226494_e_;
        private boolean field_226495_f_;
        private Vector3d field_226496_g_;
        private int field_226497_h_;

        PollinateGoal() {
            this.field_226492_c_ = p_226499_0_ -> {
                if (p_226499_0_.func_235714_a_(BlockTags.field_226148_H_)) {
                    if (p_226499_0_.func_203425_a(Blocks.field_196800_gd)) {
                        return p_226499_0_.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER;
                    }
                    return true;
                }
                return p_226499_0_.func_235714_a_(BlockTags.field_219746_E);
            };
            this.field_226493_d_ = 0;
            this.field_226494_e_ = 0;
            this.field_226497_h_ = 0;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_225506_g_() {
            if (BeeEntity.this.field_226367_bG_ > 0) {
                return false;
            }
            if (BeeEntity.this.func_226411_eD_()) {
                return false;
            }
            if (BeeEntity.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (BeeEntity.this.field_70146_Z.nextFloat() < 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.func_226507_o_();
            if (optional.isPresent()) {
                BeeEntity.this.field_226368_bH_ = optional.get();
                BeeEntity.this.field_70699_by.func_75492_a((double)BeeEntity.this.field_226368_bH_.func_177958_n() + 0.5, (double)BeeEntity.this.field_226368_bH_.func_177956_o() + 0.5, (double)BeeEntity.this.field_226368_bH_.func_177952_p() + 0.5, 1.2f);
                return true;
            }
            return false;
        }

        @Override
        public boolean func_225507_h_() {
            if (!this.field_226495_f_) {
                return false;
            }
            if (!BeeEntity.this.func_226425_er_()) {
                return false;
            }
            if (BeeEntity.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (this.func_226502_j_()) {
                return BeeEntity.this.field_70146_Z.nextFloat() < 0.2f;
            }
            if (BeeEntity.this.field_70173_aa % 20 == 0 && !BeeEntity.this.func_226439_k_(BeeEntity.this.field_226368_bH_)) {
                BeeEntity.this.field_226368_bH_ = null;
                return false;
            }
            return true;
        }

        private boolean func_226502_j_() {
            return this.field_226493_d_ > 400;
        }

        private boolean func_226503_k_() {
            return this.field_226495_f_;
        }

        private void func_226504_l_() {
            this.field_226495_f_ = false;
        }

        public void func_75249_e() {
            this.field_226493_d_ = 0;
            this.field_226497_h_ = 0;
            this.field_226494_e_ = 0;
            this.field_226495_f_ = true;
            BeeEntity.this.func_226426_eu_();
        }

        public void func_75251_c() {
            if (this.func_226502_j_()) {
                BeeEntity.this.func_226447_r_(true);
            }
            this.field_226495_f_ = false;
            BeeEntity.this.field_70699_by.func_75499_g();
            BeeEntity.this.field_226367_bG_ = 200;
        }

        public void func_75246_d() {
            ++this.field_226497_h_;
            if (this.field_226497_h_ > 600) {
                BeeEntity.this.field_226368_bH_ = null;
            } else {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)BeeEntity.this.field_226368_bH_).func_72441_c(0.0, 0.6f, 0.0);
                if (vector3d.func_72438_d(BeeEntity.this.func_213303_ch()) > 1.0) {
                    this.field_226496_g_ = vector3d;
                    this.func_226505_m_();
                } else {
                    if (this.field_226496_g_ == null) {
                        this.field_226496_g_ = vector3d;
                    }
                    boolean flag = BeeEntity.this.func_213303_ch().func_72438_d(this.field_226496_g_) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.field_226497_h_ > 600) {
                        BeeEntity.this.field_226368_bH_ = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = BeeEntity.this.field_70146_Z.nextInt(25) == 0;
                            if (flag2) {
                                this.field_226496_g_ = new Vector3d(vector3d.func_82615_a() + (double)this.func_226506_n_(), vector3d.func_82617_b(), vector3d.func_82616_c() + (double)this.func_226506_n_());
                                BeeEntity.this.field_70699_by.func_75499_g();
                            } else {
                                flag1 = false;
                            }
                            BeeEntity.this.func_70671_ap().func_220679_a(vector3d.func_82615_a(), vector3d.func_82617_b(), vector3d.func_82616_c());
                        }
                        if (flag1) {
                            this.func_226505_m_();
                        }
                        ++this.field_226493_d_;
                        if (BeeEntity.this.field_70146_Z.nextFloat() < 0.05f && this.field_226493_d_ > this.field_226494_e_ + 60) {
                            this.field_226494_e_ = this.field_226493_d_;
                            BeeEntity.this.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void func_226505_m_() {
            BeeEntity.this.func_70605_aq().func_75642_a(this.field_226496_g_.func_82615_a(), this.field_226496_g_.func_82617_b(), this.field_226496_g_.func_82616_c(), (double)0.35f);
        }

        private float func_226506_n_() {
            return (BeeEntity.this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> func_226507_o_() {
            return this.func_226500_a_(this.field_226492_c_, 5.0);
        }

        private Optional<BlockPos> func_226500_a_(Predicate<BlockState> p_226500_1_, double distance) {
            BlockPos blockpos = BeeEntity.this.func_233580_cy_();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = 0;
            while ((double)i <= distance) {
                int j = 0;
                while ((double)j < distance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            blockpos$mutable.func_239621_a_((Vector3i)blockpos, k, i - 1, l);
                            if (blockpos.func_218141_a((Vector3i)blockpos$mutable, distance) && p_226500_1_.test(BeeEntity.this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable))) {
                                return Optional.of(blockpos$mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    abstract class PassiveGoal
    extends Goal {
        private PassiveGoal() {
        }

        public abstract boolean func_225506_g_();

        public abstract boolean func_225507_h_();

        public boolean func_75250_a() {
            return this.func_225506_g_() && !BeeEntity.this.func_233678_J__();
        }

        public boolean func_75253_b() {
            return this.func_225507_h_() && !BeeEntity.this.func_233678_J__();
        }
    }

    class FindPollinationTargetGoal
    extends PassiveGoal {
        private FindPollinationTargetGoal() {
        }

        @Override
        public boolean func_225506_g_() {
            if (BeeEntity.this.func_226419_eM_() >= 10) {
                return false;
            }
            if (BeeEntity.this.field_70146_Z.nextFloat() < 0.3f) {
                return false;
            }
            return BeeEntity.this.func_226411_eD_() && BeeEntity.this.func_226422_eP_();
        }

        @Override
        public boolean func_225507_h_() {
            return this.func_225506_g_();
        }

        public void func_75246_d() {
            if (BeeEntity.this.field_70146_Z.nextInt(30) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    int k;
                    BlockPos blockpos = BeeEntity.this.func_233580_cy_().func_177979_c(i);
                    BlockState blockstate = BeeEntity.this.field_70170_p.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    boolean flag = false;
                    IntegerProperty integerproperty = null;
                    if (!block.func_203417_a(BlockTags.field_226153_ac_)) continue;
                    if (block instanceof CropsBlock) {
                        CropsBlock cropsblock = (CropsBlock)block;
                        if (!cropsblock.func_185525_y(blockstate)) {
                            flag = true;
                            integerproperty = cropsblock.func_185524_e();
                        }
                    } else if (block instanceof StemBlock) {
                        int j = (Integer)blockstate.func_177229_b((Property)StemBlock.field_176484_a);
                        if (j < 7) {
                            flag = true;
                            integerproperty = StemBlock.field_176484_a;
                        }
                    } else if (block == Blocks.field_222434_lW && (k = ((Integer)blockstate.func_177229_b((Property)SweetBerryBushBlock.field_220125_a)).intValue()) < 3) {
                        flag = true;
                        integerproperty = SweetBerryBushBlock.field_220125_a;
                    }
                    if (!flag) continue;
                    BeeEntity.this.field_70170_p.func_217379_c(2005, blockpos, 0);
                    BeeEntity.this.field_70170_p.func_175656_a(blockpos, (BlockState)((Object)blockstate.func_206870_a((Property)integerproperty, Integer.valueOf((Integer)blockstate.func_177229_b((Property)integerproperty) + 1))));
                    BeeEntity.this.func_226421_eO_();
                }
            }
        }
    }

    public class FindFlowerGoal
    extends PassiveGoal {
        private int field_226481_c_;

        FindFlowerGoal() {
            this.field_226481_c_ = BeeEntity.this.field_70170_p.field_73012_v.nextInt(10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_225506_g_() {
            return BeeEntity.this.field_226368_bH_ != null && !BeeEntity.this.func_213394_dL() && this.func_226482_j_() && BeeEntity.this.func_226439_k_(BeeEntity.this.field_226368_bH_) && !BeeEntity.this.func_226401_b_(BeeEntity.this.field_226368_bH_, 2);
        }

        @Override
        public boolean func_225507_h_() {
            return this.func_225506_g_();
        }

        public void func_75249_e() {
            this.field_226481_c_ = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.field_226481_c_ = 0;
            BeeEntity.this.field_70699_by.func_75499_g();
            BeeEntity.this.field_70699_by.func_226336_g_();
        }

        public void func_75246_d() {
            if (BeeEntity.this.field_226368_bH_ != null) {
                ++this.field_226481_c_;
                if (this.field_226481_c_ > 600) {
                    BeeEntity.this.field_226368_bH_ = null;
                } else if (!BeeEntity.this.field_70699_by.func_226337_n_()) {
                    if (BeeEntity.this.func_226437_j_(BeeEntity.this.field_226368_bH_)) {
                        BeeEntity.this.field_226368_bH_ = null;
                    } else {
                        BeeEntity.this.func_226433_h_(BeeEntity.this.field_226368_bH_);
                    }
                }
            }
        }

        private boolean func_226482_j_() {
            return BeeEntity.this.field_226363_bC_ > 2400;
        }
    }

    public class FindBeehiveGoal
    extends PassiveGoal {
        private int field_226468_c_;
        private List<BlockPos> field_226469_d_;
        @Nullable
        private Path field_226470_e_;
        private int field_234183_f_;

        FindBeehiveGoal() {
            this.field_226468_c_ = BeeEntity.this.field_70170_p.field_73012_v.nextInt(10);
            this.field_226469_d_ = Lists.newArrayList();
            this.field_226470_e_ = null;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_225506_g_() {
            return BeeEntity.this.field_226369_bI_ != null && !BeeEntity.this.func_213394_dL() && BeeEntity.this.func_226415_eI_() && !this.func_226476_d_(BeeEntity.this.field_226369_bI_) && BeeEntity.this.field_70170_p.func_180495_p(BeeEntity.this.field_226369_bI_).func_235714_a_(BlockTags.field_226151_aa_);
        }

        @Override
        public boolean func_225507_h_() {
            return this.func_225506_g_();
        }

        public void func_75249_e() {
            this.field_226468_c_ = 0;
            this.field_234183_f_ = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.field_226468_c_ = 0;
            this.field_234183_f_ = 0;
            BeeEntity.this.field_70699_by.func_75499_g();
            BeeEntity.this.field_70699_by.func_226336_g_();
        }

        public void func_75246_d() {
            if (BeeEntity.this.field_226369_bI_ != null) {
                ++this.field_226468_c_;
                if (this.field_226468_c_ > 600) {
                    this.func_226478_k_();
                } else if (!BeeEntity.this.field_70699_by.func_226337_n_()) {
                    if (!BeeEntity.this.func_226401_b_(BeeEntity.this.field_226369_bI_, 16)) {
                        if (BeeEntity.this.func_226437_j_(BeeEntity.this.field_226369_bI_)) {
                            this.func_226479_l_();
                        } else {
                            BeeEntity.this.func_226433_h_(BeeEntity.this.field_226369_bI_);
                        }
                    } else {
                        boolean flag = this.func_226472_a_(BeeEntity.this.field_226369_bI_);
                        if (!flag) {
                            this.func_226478_k_();
                        } else if (this.field_226470_e_ != null && BeeEntity.this.field_70699_by.func_75505_d().func_75876_a(this.field_226470_e_)) {
                            ++this.field_234183_f_;
                            if (this.field_234183_f_ > 60) {
                                this.func_226479_l_();
                                this.field_234183_f_ = 0;
                            }
                        } else {
                            this.field_226470_e_ = BeeEntity.this.field_70699_by.func_75505_d();
                        }
                    }
                }
            }
        }

        private boolean func_226472_a_(BlockPos pos) {
            BeeEntity.this.field_70699_by.func_226335_a_(10.0f);
            BeeEntity.this.field_70699_by.func_75492_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0);
            return BeeEntity.this.field_70699_by.func_75505_d() != null && BeeEntity.this.field_70699_by.func_75505_d().func_224771_h();
        }

        private boolean func_226473_b_(BlockPos pos) {
            return this.field_226469_d_.contains(pos);
        }

        private void func_226475_c_(BlockPos pos) {
            this.field_226469_d_.add(pos);
            while (this.field_226469_d_.size() > 3) {
                this.field_226469_d_.remove(0);
            }
        }

        private void func_226477_j_() {
            this.field_226469_d_.clear();
        }

        private void func_226478_k_() {
            if (BeeEntity.this.field_226369_bI_ != null) {
                this.func_226475_c_(BeeEntity.this.field_226369_bI_);
            }
            this.func_226479_l_();
        }

        private void func_226479_l_() {
            BeeEntity.this.field_226369_bI_ = null;
            BeeEntity.this.field_226366_bF_ = 200;
        }

        private boolean func_226476_d_(BlockPos pos) {
            if (BeeEntity.this.func_226401_b_(pos, 2)) {
                return true;
            }
            Path path = BeeEntity.this.field_70699_by.func_75505_d();
            return path != null && path.func_224770_k().equals((Object)pos) && path.func_224771_h() && path.func_75879_b();
        }
    }

    class EnterBeehiveGoal
    extends PassiveGoal {
        private EnterBeehiveGoal() {
        }

        @Override
        public boolean func_225506_g_() {
            TileEntity tileentity;
            if (BeeEntity.this.func_226409_eA_() && BeeEntity.this.func_226415_eI_() && BeeEntity.this.field_226369_bI_.func_218137_a((IPosition)BeeEntity.this.func_213303_ch(), 2.0) && (tileentity = BeeEntity.this.field_70170_p.func_175625_s(BeeEntity.this.field_226369_bI_)) instanceof BeehiveTileEntity) {
                BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
                if (!beehivetileentity.func_226970_h_()) {
                    return true;
                }
                BeeEntity.this.field_226369_bI_ = null;
            }
            return false;
        }

        @Override
        public boolean func_225507_h_() {
            return false;
        }

        public void func_75249_e() {
            TileEntity tileentity = BeeEntity.this.field_70170_p.func_175625_s(BeeEntity.this.field_226369_bI_);
            if (tileentity instanceof BeehiveTileEntity) {
                BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
                beehivetileentity.func_226961_a_((Entity)((Object)BeeEntity.this), BeeEntity.this.func_226411_eD_());
            }
        }
    }

    class BeeLookController
    extends LookController {
        BeeLookController(MobEntity beeIn) {
            super(beeIn);
        }

        public void func_75649_a() {
            if (!BeeEntity.this.func_233678_J__()) {
                super.func_75649_a();
            }
        }

        protected boolean func_220680_b() {
            return !BeeEntity.this.field_226370_bJ_.func_226503_k_();
        }
    }

    static class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        AttackPlayerGoal(BeeEntity beeIn) {
            super((MobEntity)((Object)beeIn), PlayerEntity.class, 10, true, false, arg_0 -> ((BeeEntity)beeIn).func_233680_b_(arg_0));
        }

        public boolean func_75250_a() {
            return this.func_226465_h_() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            boolean flag = this.func_226465_h_();
            if (flag && this.field_75299_d.func_70638_az() != null) {
                return super.func_75253_b();
            }
            this.field_188509_g = null;
            return false;
        }

        private boolean func_226465_h_() {
            BeeEntity beeentity = (BeeEntity)((Object)this.field_75299_d);
            return beeentity.func_233678_J__() && !beeentity.func_226412_eE_();
        }
    }

    class AngerGoal
    extends HurtByTargetGoal {
        AngerGoal(BeeEntity beeIn) {
            super((CreatureEntity)beeIn, new Class[0]);
        }

        public boolean func_75253_b() {
            return BeeEntity.this.func_233678_J__() && super.func_75253_b();
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof BeeEntity && this.field_75299_d.func_70685_l(targetIn)) {
                mobIn.func_70624_b(targetIn);
            }
        }
    }
}

