/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.entity.passive.horse.CoatTypes;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HorseEntity
extends AbstractHorseEntity {
    private static final UUID field_184786_bD = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> field_184789_bG = EntityDataManager.func_187226_a(HorseEntity.class, DataSerializers.field_187192_b);

    public HorseEntity(EntityType<? extends HorseEntity> type, World worldIn) {
        super((EntityType<? extends AbstractHorseEntity>)type, worldIn);
    }

    @Override
    protected void func_230273_eI_() {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.func_110267_cL());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.func_110203_cN());
        this.func_110148_a(Attributes.field_233830_m_).func_111128_a(this.func_110245_cM());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184789_bG, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.func_234241_eS_());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_218657_a("ArmorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public ItemStack func_213803_dV() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    private void func_213805_k(ItemStack p_213805_1_) {
        this.func_184201_a(EquipmentSlotType.CHEST, p_213805_1_);
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.func_234242_w_(compound.func_74762_e("Variant"));
        if (compound.func_150297_b("ArmorItem", 10) && !(itemstack = ItemStack.func_199557_a(compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(itemstack)) {
            this.field_110296_bG.func_70299_a(1, itemstack);
        }
        this.func_230275_fc_();
    }

    private void func_234242_w_(int p_234242_1_) {
        this.field_70180_af.func_187227_b(field_184789_bG, p_234242_1_);
    }

    private int func_234241_eS_() {
        return this.field_70180_af.func_187225_a(field_184789_bG);
    }

    private void func_234238_a_(CoatColors p_234238_1_, CoatTypes p_234238_2_) {
        this.func_234242_w_(p_234238_1_.func_234253_a_() & 0xFF | p_234238_2_.func_234247_a_() << 8 & 0xFF00);
    }

    public CoatColors func_234239_eK_() {
        return CoatColors.func_234254_a_((int)(this.func_234241_eS_() & 0xFF));
    }

    public CoatTypes func_234240_eM_() {
        return CoatTypes.func_234248_a_((int)((this.func_234241_eS_() & 0xFF00) >> 8));
    }

    @Override
    protected void func_230275_fc_() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_230275_fc_();
            this.func_213804_l(this.field_110296_bG.func_70301_a(1));
            this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
        }
    }

    private void func_213804_l(ItemStack p_213804_1_) {
        this.func_213805_k(p_213804_1_);
        if (!this.field_70170_p.field_72995_K) {
            int i;
            this.func_110148_a(Attributes.field_233826_i_).func_188479_b(field_184786_bD);
            if (this.func_190682_f(p_213804_1_) && (i = ((HorseArmorItem)p_213804_1_.func_77973_b()).func_219977_e()) != 0) {
                this.func_110148_a(Attributes.field_233826_i_).func_233767_b_(new AttributeModifier(field_184786_bD, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Override
    public void func_76316_a(IInventory invBasic) {
        ItemStack itemstack = this.func_213803_dV();
        super.func_76316_a(invBasic);
        ItemStack itemstack1 = this.func_213803_dV();
        if (this.field_70173_aa > 20 && this.func_190682_f(itemstack1) && itemstack != itemstack1) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_190680_a(SoundType p_190680_1_) {
        ItemStack stack;
        super.func_190680_a(p_190680_1_);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, p_190680_1_.func_185843_a() * 0.6f, p_190680_1_.func_185847_b());
        }
        if (this.func_190682_f(stack = this.field_110296_bG.func_70301_a(1))) {
            stack.onHorseArmorTick(this.field_70170_p, (MobEntity)((Object)this));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    @Override
    @Nullable
    protected SoundEvent func_230274_fe_() {
        return SoundEvents.field_187711_cp;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187717_cr;
    }

    @Override
    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && p_230254_1_.func_226563_dT_()) {
                this.func_110199_f(p_230254_1_);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.func_184207_aI()) {
                return super.func_230254_b_(p_230254_1_, p_230254_2_);
            }
        }
        if (!itemstack.func_190926_b()) {
            boolean flag;
            if (this.func_70877_b(itemstack)) {
                return this.func_241395_b_(p_230254_1_, itemstack);
            }
            ActionResultType actionresulttype = itemstack.func_111282_a_(p_230254_1_, (LivingEntity)((Object)this), p_230254_2_);
            if (actionresulttype.func_226246_a_()) {
                return actionresulttype;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            boolean bl = flag = !this.func_70631_g_() && !this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av;
            if (this.func_190682_f(itemstack) || flag) {
                this.func_110199_f(p_230254_1_);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
        }
        if (this.func_70631_g_()) {
            return super.func_230254_b_(p_230254_1_, p_230254_2_);
        }
        this.func_110237_h(p_230254_1_);
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    @Override
    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof DonkeyEntity) && !(otherAnimal instanceof HorseEntity)) {
            return false;
        }
        return this.func_110200_cJ() && ((AbstractHorseEntity)otherAnimal).func_110200_cJ();
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        AbstractHorseEntity abstracthorseentity;
        if (p_241840_2_ instanceof DonkeyEntity) {
            abstracthorseentity = (AbstractHorseEntity)EntityType.field_200779_S.func_200721_a(p_241840_1_);
        } else {
            HorseEntity horseentity = (HorseEntity)p_241840_2_;
            abstracthorseentity = EntityType.field_200762_B.func_200721_a(p_241840_1_);
            int i = this.field_70146_Z.nextInt(9);
            CoatColors coatcolors = i < 4 ? this.func_234239_eK_() : (i < 8 ? horseentity.func_234239_eK_() : (CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)this.field_70146_Z));
            int j = this.field_70146_Z.nextInt(5);
            CoatTypes coattypes = j < 2 ? this.func_234240_eM_() : (j < 4 ? horseentity.func_234240_eM_() : (CoatTypes)Util.func_240989_a_((Object[])CoatTypes.values(), (Random)this.field_70146_Z));
            ((HorseEntity)abstracthorseentity).func_234238_a_(coatcolors, coattypes);
        }
        this.func_190681_a(p_241840_2_, abstracthorseentity);
        return abstracthorseentity;
    }

    @Override
    public boolean func_230276_fq_() {
        return true;
    }

    @Override
    public boolean func_190682_f(ItemStack stack) {
        return stack.func_77973_b() instanceof HorseArmorItem;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        CoatColors coatcolors;
        if (spawnDataIn instanceof HorseData) {
            coatcolors = ((HorseData)((Object)spawnDataIn)).field_190885_a;
        } else {
            coatcolors = (CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)this.field_70146_Z);
            spawnDataIn = new HorseData(coatcolors);
        }
        this.func_234238_a_(coatcolors, (CoatTypes)Util.func_240989_a_((Object[])CoatTypes.values(), (Random)this.field_70146_Z));
        return super.func_213386_a(worldIn, difficultyIn, reason, (ILivingEntityData)spawnDataIn, dataTag);
    }

    public static class HorseData
    extends AgeableEntity.AgeableData {
        public final CoatColors field_190885_a;

        public HorseData(CoatColors p_i231557_1_) {
            super(true);
            this.field_190885_a = p_i231557_1_;
        }
    }
}

