/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty field_207209_a = BlockStateProperties.field_208183_j;
    public static final IntegerProperty field_207210_b = BlockStateProperties.field_208131_af;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>> field_212756_e = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    private final Map<FluidState, VoxelShape> field_215669_f = Maps.newIdentityHashMap();

    @Override
    protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
        builder.func_206894_a(new Property[]{field_207209_a});
    }

    @Override
    public Vector3d func_215663_a(IBlockReader blockReader, BlockPos pos, FluidState fluidState) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            FluidState fluidstate = blockReader.func_204610_c((BlockPos)blockpos$mutable);
            if (!this.func_212189_g(fluidstate)) continue;
            float f = fluidstate.func_223408_f();
            float f1 = 0.0f;
            if (f == 0.0f) {
                BlockPos blockpos;
                FluidState fluidstate1;
                if (!blockReader.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c() && this.func_212189_g(fluidstate1 = blockReader.func_204610_c(blockpos = blockpos$mutable.func_177977_b())) && (f = fluidstate1.func_223408_f()) > 0.0f) {
                    f1 = fluidState.func_223408_f() - (f - 0.8888889f);
                }
            } else if (f > 0.0f) {
                f1 = fluidState.func_223408_f() - f;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)direction.func_82601_c() * f1);
            d1 += (double)((float)direction.func_82599_e() * f1);
        }
        Vector3d vector3d = new Vector3d(d0, 0.0, d1);
        if (((Boolean)fluidState.func_177229_b((Property)field_207209_a)).booleanValue()) {
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                blockpos$mutable.func_239622_a_((Vector3i)pos, direction1);
                if (!this.func_205573_a(blockReader, (BlockPos)blockpos$mutable, direction1) && !this.func_205573_a(blockReader, blockpos$mutable.func_177984_a(), direction1)) continue;
                vector3d = vector3d.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        return vector3d.func_72432_b();
    }

    private boolean func_212189_g(FluidState state) {
        return state.func_206888_e() || state.func_206886_c().func_207187_a(this);
    }

    protected boolean func_205573_a(IBlockReader worldIn, BlockPos neighborPos, Direction side) {
        BlockState blockstate = worldIn.func_180495_p(neighborPos);
        FluidState fluidstate = worldIn.func_204610_c(neighborPos);
        if (fluidstate.func_206886_c().func_207187_a(this)) {
            return false;
        }
        if (side == Direction.UP) {
            return true;
        }
        return blockstate.func_185904_a() == Material.field_151588_w ? false : blockstate.func_224755_d(worldIn, neighborPos, side);
    }

    protected void func_205575_a(IWorld worldIn, BlockPos pos, FluidState stateIn) {
        if (!stateIn.func_206888_e()) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            BlockPos blockpos = pos.func_177977_b();
            BlockState blockstate1 = worldIn.func_180495_p(blockpos);
            FluidState fluidstate = this.func_205576_a((IWorldReader)worldIn, blockpos, blockstate1);
            if (this.func_205570_b((IBlockReader)worldIn, pos, blockstate, Direction.DOWN, blockpos, blockstate1, worldIn.func_204610_c(blockpos), fluidstate.func_206886_c())) {
                this.func_205574_a(worldIn, blockpos, blockstate1, Direction.DOWN, fluidstate);
                if (this.func_207936_a((IWorldReader)worldIn, pos) >= 3) {
                    this.func_207937_a(worldIn, pos, stateIn, blockstate);
                }
            } else if (stateIn.func_206889_d() || !this.func_211759_a((IBlockReader)worldIn, fluidstate.func_206886_c(), pos, blockstate, blockpos, blockstate1)) {
                this.func_207937_a(worldIn, pos, stateIn, blockstate);
            }
        }
    }

    private void func_207937_a(IWorld p_207937_1_, BlockPos p_207937_2_, FluidState p_207937_3_, BlockState p_207937_4_) {
        int i = p_207937_3_.func_206882_g() - this.func_204528_b((IWorldReader)p_207937_1_);
        if (((Boolean)p_207937_3_.func_177229_b((Property)field_207209_a)).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map<Direction, FluidState> map = this.func_205572_b((IWorldReader)p_207937_1_, p_207937_2_, p_207937_4_);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                BlockState blockstate;
                Direction direction = entry.getKey();
                FluidState fluidstate = entry.getValue();
                BlockPos blockpos = p_207937_2_.func_177972_a(direction);
                if (!this.func_205570_b((IBlockReader)p_207937_1_, p_207937_2_, p_207937_4_, direction, blockpos, blockstate = p_207937_1_.func_180495_p(blockpos), p_207937_1_.func_204610_c(blockpos), fluidstate.func_206886_c())) continue;
                this.func_205574_a(p_207937_1_, blockpos, blockstate, direction, fluidstate);
            }
        }
    }

    protected FluidState func_205576_a(IWorldReader worldIn, BlockPos pos, BlockState blockStateIn) {
        BlockPos blockpos1;
        BlockState blockstate2;
        FluidState fluidstate2;
        int i = 0;
        int j = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            FluidState fluidstate = blockstate.func_204520_s();
            if (!fluidstate.func_206886_c().func_207187_a(this) || !this.func_212751_a(direction, (IBlockReader)((Object)worldIn), pos, blockStateIn, blockpos, blockstate)) continue;
            if (fluidstate.func_206889_d() && ForgeEventFactory.canCreateFluidSource((IWorldReader)worldIn, (BlockPos)blockpos, (BlockState)blockstate, (boolean)this.func_205579_d())) {
                ++j;
            }
            i = Math.max(i, fluidstate.func_206882_g());
        }
        if (j >= 2) {
            BlockState blockstate1 = worldIn.func_180495_p(pos.func_177977_b());
            FluidState fluidstate1 = blockstate1.func_204520_s();
            if (blockstate1.func_185904_a().func_76220_a() || this.func_211758_g(fluidstate1)) {
                return this.func_207204_a(false);
            }
        }
        if (!(fluidstate2 = (blockstate2 = worldIn.func_180495_p(blockpos1 = pos.func_177984_a())).func_204520_s()).func_206888_e() && fluidstate2.func_206886_c().func_207187_a(this) && this.func_212751_a(Direction.UP, (IBlockReader)((Object)worldIn), pos, blockStateIn, blockpos1, blockstate2)) {
            return this.func_207207_a(8, true);
        }
        int k = i - this.func_204528_b(worldIn);
        return k <= 0 ? Fluids.field_204541_a.func_207188_f() : this.func_207207_a(k, false);
    }

    private boolean func_212751_a(Direction p_212751_1_, IBlockReader p_212751_2_, BlockPos p_212751_3_, BlockState p_212751_4_, BlockPos p_212751_5_, BlockState p_212751_6_) {
        VoxelShape voxelshape;
        VoxelShape voxelshape1;
        boolean flag;
        Block.RenderSideCacheKey block$rendersidecachekey;
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2bytelinkedopenhashmap = !p_212751_4_.func_177230_c().func_208619_r() && !p_212751_6_.func_177230_c().func_208619_r() ? field_212756_e.get() : null;
        if (object2bytelinkedopenhashmap != null) {
            block$rendersidecachekey = new Block.RenderSideCacheKey(p_212751_4_, p_212751_6_, p_212751_1_);
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block$rendersidecachekey);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            block$rendersidecachekey = null;
        }
        boolean bl = flag = !VoxelShapes.func_204642_b((VoxelShape)(voxelshape1 = p_212751_4_.func_196952_d(p_212751_2_, p_212751_3_)), (VoxelShape)(voxelshape = p_212751_6_.func_196952_d(p_212751_2_, p_212751_5_)), (Direction)p_212751_1_);
        if (object2bytelinkedopenhashmap != null) {
            if (object2bytelinkedopenhashmap.size() == 200) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block$rendersidecachekey, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    public abstract Fluid func_210197_e();

    public FluidState func_207207_a(int level, boolean falling) {
        return (FluidState)((Object)((FluidState)((Object)this.func_210197_e().func_207188_f().func_206870_a((Property)field_207210_b, Integer.valueOf(level)))).func_206870_a((Property)field_207209_a, Boolean.valueOf(falling)));
    }

    public abstract Fluid func_210198_f();

    public FluidState func_207204_a(boolean falling) {
        return (FluidState)((Object)this.func_210198_f().func_207188_f().func_206870_a((Property)field_207209_a, Boolean.valueOf(falling)));
    }

    protected abstract boolean func_205579_d();

    protected void func_205574_a(IWorld worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
        if (blockStateIn.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)blockStateIn.func_177230_c()).func_204509_a(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.func_196958_f()) {
                this.func_205580_a(worldIn, pos, blockStateIn);
            }
            worldIn.func_180501_a(pos, fluidStateIn.func_206883_i(), 3);
        }
    }

    protected abstract void func_205580_a(IWorld var1, BlockPos var2, BlockState var3);

    private static short func_212752_a(BlockPos p_212752_0_, BlockPos p_212752_1_) {
        int i = p_212752_1_.func_177958_n() - p_212752_0_.func_177958_n();
        int j = p_212752_1_.func_177952_p() - p_212752_0_.func_177952_p();
        return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
    }

    protected int func_205571_a(IWorldReader p_205571_1_, BlockPos p_205571_2_, int p_205571_3_, Direction p_205571_4_, BlockState p_205571_5_, BlockPos p_205571_6_, Short2ObjectMap<Pair<BlockState, FluidState>> p_205571_7_, Short2BooleanMap p_205571_8_) {
        int i = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            if (direction == p_205571_4_) continue;
            BlockPos blockpos = p_205571_2_.func_177972_a(direction);
            short short1 = FlowingFluid.func_212752_a(p_205571_6_, blockpos);
            Pair pair = (Pair)p_205571_7_.computeIfAbsent(short1, p_212748_2_ -> {
                BlockState blockstate1 = p_205571_1_.func_180495_p(blockpos);
                return Pair.of((Object)((Object)blockstate1), (Object)((Object)blockstate1.func_204520_s()));
            });
            BlockState blockstate = (BlockState)((Object)pair.getFirst());
            FluidState fluidstate = (FluidState)((Object)pair.getSecond());
            if (!this.func_211760_a((IBlockReader)((Object)p_205571_1_), this.func_210197_e(), p_205571_2_, p_205571_5_, direction, blockpos, blockstate, fluidstate)) continue;
            boolean flag = p_205571_8_.computeIfAbsent(short1, p_212749_4_ -> {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState blockstate1 = p_205571_1_.func_180495_p(blockpos1);
                return this.func_211759_a((IBlockReader)((Object)p_205571_1_), this.func_210197_e(), blockpos, blockstate, blockpos1, blockstate1);
            });
            if (flag) {
                return p_205571_3_;
            }
            if (p_205571_3_ >= this.func_185698_b(p_205571_1_) || (j = this.func_205571_a(p_205571_1_, blockpos, p_205571_3_ + 1, direction.func_176734_d(), blockstate, p_205571_6_, p_205571_7_, p_205571_8_)) >= i) continue;
            i = j;
        }
        return i;
    }

    private boolean func_211759_a(IBlockReader p_211759_1_, Fluid p_211759_2_, BlockPos p_211759_3_, BlockState p_211759_4_, BlockPos p_211759_5_, BlockState p_211759_6_) {
        if (!this.func_212751_a(Direction.DOWN, p_211759_1_, p_211759_3_, p_211759_4_, p_211759_5_, p_211759_6_)) {
            return false;
        }
        return p_211759_6_.func_204520_s().func_206886_c().func_207187_a(this) ? true : this.func_211761_a(p_211759_1_, p_211759_5_, p_211759_6_, p_211759_2_);
    }

    private boolean func_211760_a(IBlockReader p_211760_1_, Fluid p_211760_2_, BlockPos p_211760_3_, BlockState p_211760_4_, Direction p_211760_5_, BlockPos p_211760_6_, BlockState p_211760_7_, FluidState p_211760_8_) {
        return !this.func_211758_g(p_211760_8_) && this.func_212751_a(p_211760_5_, p_211760_1_, p_211760_3_, p_211760_4_, p_211760_6_, p_211760_7_) && this.func_211761_a(p_211760_1_, p_211760_6_, p_211760_7_, p_211760_2_);
    }

    private boolean func_211758_g(FluidState stateIn) {
        return stateIn.func_206886_c().func_207187_a(this) && stateIn.func_206889_d();
    }

    protected abstract int func_185698_b(IWorldReader var1);

    private int func_207936_a(IWorldReader worldIn, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction);
            FluidState fluidstate = worldIn.func_204610_c(blockpos);
            if (!this.func_211758_g(fluidstate)) continue;
            ++i;
        }
        return i;
    }

    protected Map<Direction, FluidState> func_205572_b(IWorldReader p_205572_1_, BlockPos p_205572_2_, BlockState p_205572_3_) {
        int i = 1000;
        EnumMap map = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap short2objectmap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap short2booleanmap = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_205572_2_.func_177972_a(direction);
            short short1 = FlowingFluid.func_212752_a(p_205572_2_, blockpos);
            Pair pair = (Pair)short2objectmap.computeIfAbsent(short1, p_212755_2_ -> {
                BlockState blockstate1 = p_205572_1_.func_180495_p(blockpos);
                return Pair.of((Object)((Object)blockstate1), (Object)((Object)blockstate1.func_204520_s()));
            });
            BlockState blockstate = (BlockState)((Object)pair.getFirst());
            FluidState fluidstate = (FluidState)((Object)pair.getSecond());
            FluidState fluidstate1 = this.func_205576_a(p_205572_1_, blockpos, blockstate);
            if (!this.func_211760_a((IBlockReader)((Object)p_205572_1_), fluidstate1.func_206886_c(), p_205572_2_, p_205572_3_, direction, blockpos, blockstate, fluidstate)) continue;
            BlockPos blockpos1 = blockpos.func_177977_b();
            boolean flag = short2booleanmap.computeIfAbsent(short1, p_212753_5_ -> {
                BlockState blockstate1 = p_205572_1_.func_180495_p(blockpos1);
                return this.func_211759_a((IBlockReader)((Object)p_205572_1_), this.func_210197_e(), blockpos, blockstate, blockpos1, blockstate1);
            });
            int j = flag ? 0 : this.func_205571_a(p_205572_1_, blockpos, 1, direction.func_176734_d(), blockstate, p_205572_2_, (Short2ObjectMap<Pair<BlockState, FluidState>>)short2objectmap, (Short2BooleanMap)short2booleanmap);
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, fluidstate1);
            i = j;
        }
        return map;
    }

    private boolean func_211761_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        Block block = state.func_177230_c();
        if (block instanceof ILiquidContainer) {
            return ((ILiquidContainer)block).func_204510_a(worldIn, pos, state, fluidIn);
        }
        if (!(block instanceof DoorBlock) && !block.func_203417_a(BlockTags.field_219753_V) && block != Blocks.field_150468_ap && block != Blocks.field_196608_cF && block != Blocks.field_203203_C) {
            Material material = state.func_185904_a();
            if (material != Material.field_151567_E && material != Material.field_189963_J && material != Material.field_203243_f && material != Material.field_204868_h) {
                return !material.func_76230_c();
            }
            return false;
        }
        return false;
    }

    protected boolean func_205570_b(IBlockReader worldIn, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluidIn) {
        return toFluidState.func_215677_a(worldIn, toPos, fluidIn, direction) && this.func_212751_a(direction, worldIn, fromPos, fromBlockState, toPos, toBlockState) && this.func_211761_a(worldIn, toPos, toBlockState, fluidIn);
    }

    protected abstract int func_204528_b(IWorldReader var1);

    protected int func_215667_a(World world, BlockPos pos, FluidState p_215667_3_, FluidState p_215667_4_) {
        return this.func_205569_a((IWorldReader)((Object)world));
    }

    @Override
    public void func_207191_a(World worldIn, BlockPos pos, FluidState state) {
        if (!state.func_206889_d()) {
            FluidState fluidstate = this.func_205576_a((IWorldReader)((Object)worldIn), pos, worldIn.func_180495_p(pos));
            int i = this.func_215667_a(worldIn, pos, state, fluidstate);
            if (fluidstate.func_206888_e()) {
                state = fluidstate;
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (!((Object)((Object)fluidstate)).equals((Object)state)) {
                state = fluidstate;
                BlockState blockstate = fluidstate.func_206883_i();
                worldIn.func_180501_a(pos, blockstate, 2);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidstate.func_206886_c(), i);
                worldIn.func_195593_d(pos, blockstate.func_177230_c());
            }
        }
        this.func_205575_a(worldIn, pos, state);
    }

    protected static int func_207205_e(FluidState state) {
        return state.func_206889_d() ? 0 : 8 - Math.min(state.func_206882_g(), 8) + ((Boolean)state.func_177229_b((Property)field_207209_a) != false ? 8 : 0);
    }

    private static boolean func_215666_c(FluidState p_215666_0_, IBlockReader p_215666_1_, BlockPos p_215666_2_) {
        return p_215666_0_.func_206886_c().func_207187_a(p_215666_1_.func_204610_c(p_215666_2_.func_177984_a()).func_206886_c());
    }

    @Override
    public float func_215662_a(FluidState p_215662_1_, IBlockReader p_215662_2_, BlockPos p_215662_3_) {
        return FlowingFluid.func_215666_c(p_215662_1_, p_215662_2_, p_215662_3_) ? 1.0f : p_215662_1_.func_223408_f();
    }

    @Override
    public float func_223407_a(FluidState p_223407_1_) {
        return (float)p_223407_1_.func_206882_g() / 9.0f;
    }

    @Override
    public VoxelShape func_215664_b(FluidState p_215664_1_, IBlockReader p_215664_2_, BlockPos p_215664_3_) {
        return p_215664_1_.func_206882_g() == 9 && FlowingFluid.func_215666_c(p_215664_1_, p_215664_2_, p_215664_3_) ? VoxelShapes.func_197868_b() : this.field_215669_f.computeIfAbsent(p_215664_1_, p_215668_2_ -> VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)p_215668_2_.func_215679_a(p_215664_2_, p_215664_3_), (double)1.0));
    }
}

