/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DeadCoralWallFanBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;

public class BoneMealItem
extends Item {
    public BoneMealItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(context.func_196000_l());
        if (BoneMealItem.applyBonemeal(context.func_195996_i(), world, blockpos, context.func_195999_j())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, blockpos, 0);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        BlockState blockstate = world.func_180495_p(blockpos);
        boolean flag = blockstate.func_224755_d((IBlockReader)((Object)world), blockpos, context.func_196000_l());
        if (flag && BoneMealItem.func_203173_b(context.func_195996_i(), world, blockpos1, context.func_196000_l())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, blockpos1, 0);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Deprecated
    public static boolean func_195966_a(ItemStack stack, World worldIn, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            return BoneMealItem.applyBonemeal(stack, worldIn, pos, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)worldIn)));
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack stack, World worldIn, BlockPos pos, PlayerEntity player) {
        IGrowable igrowable;
        BlockState blockstate = worldIn.func_180495_p(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)worldIn, (BlockPos)pos, (BlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)((Object)worldIn), pos, blockstate, worldIn.field_72995_K)) {
            if (worldIn instanceof ServerWorld) {
                if (igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos, blockstate)) {
                    igrowable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, blockstate);
                }
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public static boolean func_203173_b(ItemStack stack, World worldIn, BlockPos pos, @Nullable Direction side) {
        if (worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(pos).func_206882_g() == 8) {
            if (!(worldIn instanceof ServerWorld)) {
                return true;
            }
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                BlockState blockstate = Blocks.field_203198_aQ.func_176223_P();
                for (int j = 0; j < i / 16; ++j) {
                    if (worldIn.func_180495_p(blockpos = blockpos.func_177982_a(field_77697_d.nextInt(3) - 1, (field_77697_d.nextInt(3) - 1) * field_77697_d.nextInt(3) / 2, field_77697_d.nextInt(3) - 1)).func_235785_r_((IBlockReader)((Object)worldIn), blockpos)) continue block0;
                }
                Optional optional = worldIn.func_242406_i(blockpos);
                if (Objects.equals(optional, Optional.of(Biomes.field_203614_T)) || Objects.equals(optional, Optional.of(Biomes.field_203617_W))) {
                    if (i == 0 && side != null && side.func_176740_k().func_176722_c()) {
                        blockstate = (BlockState)((Object)((Block)((Object)BlockTags.field_211922_B.func_205596_a(worldIn.field_73012_v))).func_176223_P().func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)((Object)side)));
                    } else if (field_77697_d.nextInt(4) == 0) {
                        blockstate = ((Block)((Object)BlockTags.field_212741_H.func_205596_a(field_77697_d))).func_176223_P();
                    }
                }
                if (blockstate.func_177230_c().func_203417_a(BlockTags.field_211922_B)) {
                    for (int k = 0; !blockstate.func_196955_c((IWorldReader)((Object)worldIn), blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)((Object)blockstate.func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)((Object)Direction.Plane.HORIZONTAL.func_179518_a(field_77697_d))));
                    }
                }
                if (!blockstate.func_196955_c((IWorldReader)((Object)worldIn), blockpos)) continue;
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                if (blockstate1.func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(blockpos).func_206882_g() == 8) {
                    worldIn.func_180501_a(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.func_203425_a(Blocks.field_203198_aQ) || field_77697_d.nextInt(10) != 0) continue;
                ((IGrowable)Blocks.field_203198_aQ).func_225535_a_((ServerWorld)worldIn, field_77697_d, blockpos, blockstate1);
            }
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_195965_a(IWorld worldIn, BlockPos posIn, int data) {
        BlockState blockstate;
        if (data == 0) {
            data = 15;
        }
        if (!(blockstate = worldIn.func_180495_p(posIn)).isAir((IBlockReader)worldIn, posIn)) {
            double d1;
            double d0 = 0.5;
            if (blockstate.func_203425_a(Blocks.field_150355_j)) {
                data *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.func_200015_d((IBlockReader)worldIn, posIn)) {
                posIn = posIn.func_177984_a();
                data *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.func_196954_c((IBlockReader)worldIn, posIn).func_197758_c(Direction.Axis.Y);
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)posIn.func_177958_n() + 0.5, (double)posIn.func_177956_o() + 0.5, (double)posIn.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            for (int i = 0; i < data; ++i) {
                double d8;
                double d7;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                double d3 = field_77697_d.nextGaussian() * 0.02;
                double d4 = field_77697_d.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)posIn.func_177958_n() + d5 + field_77697_d.nextDouble() * d0 * 2.0;
                if (worldIn.func_180495_p(new BlockPos(d6, d7 = (double)posIn.func_177956_o() + field_77697_d.nextDouble() * d1, d8 = (double)posIn.func_177952_p() + d5 + field_77697_d.nextDouble() * d0 * 2.0).func_177977_b()).func_196958_f()) continue;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197632_y, d6, d7, d8, d2, d3, d4);
            }
        }
    }
}

