/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.extensions.IForgeEffect;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Effect
extends ForgeRegistryEntry<Effect>
implements IForgeEffect {
    private final Map<Attribute, AttributeModifier> field_111188_I = Maps.newHashMap();
    private final EffectType field_220305_b;
    private final int field_76414_N;
    @Nullable
    private String field_76416_I;

    @Nullable
    public static Effect func_188412_a(int potionID) {
        return (Effect)((Object)Registry.field_212631_t.func_148745_a(potionID));
    }

    public static int func_188409_a(Effect potionIn) {
        return Registry.field_212631_t.func_148757_b(potionIn);
    }

    protected Effect(EffectType typeIn, int liquidColorIn) {
        this.field_220305_b = typeIn;
        this.field_76414_N = liquidColorIn;
    }

    public void func_76394_a(LivingEntity entityLivingBaseIn, int amplifier) {
        if (this == Effects.field_76428_l) {
            if (entityLivingBaseIn.func_110143_aJ() < entityLivingBaseIn.func_110138_aP()) {
                entityLivingBaseIn.func_70691_i(1.0f);
            }
        } else if (this == Effects.field_76436_u) {
            if (entityLivingBaseIn.func_110143_aJ() > 1.0f) {
                entityLivingBaseIn.func_70097_a(DamageSource.field_76376_m, 1.0f);
            }
        } else if (this == Effects.field_82731_v) {
            entityLivingBaseIn.func_70097_a(DamageSource.field_82727_n, 1.0f);
        } else if (this == Effects.field_76438_s && entityLivingBaseIn instanceof PlayerEntity) {
            ((PlayerEntity)entityLivingBaseIn).func_71020_j(0.005f * (float)(amplifier + 1));
        } else if (this == Effects.field_76443_y && entityLivingBaseIn instanceof PlayerEntity) {
            if (!entityLivingBaseIn.field_70170_p.field_72995_K) {
                ((PlayerEntity)entityLivingBaseIn).func_71024_bL().func_75122_a(amplifier + 1, 1.0f);
            }
        } else if (!(this == Effects.field_76432_h && !entityLivingBaseIn.func_70662_br() || this == Effects.field_76433_i && entityLivingBaseIn.func_70662_br())) {
            if (this == Effects.field_76433_i && !entityLivingBaseIn.func_70662_br() || this == Effects.field_76432_h && entityLivingBaseIn.func_70662_br()) {
                entityLivingBaseIn.func_70097_a(DamageSource.field_76376_m, 6 << amplifier);
            }
        } else {
            entityLivingBaseIn.func_70691_i(Math.max(4 << amplifier, 0));
        }
    }

    public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entityLivingBaseIn, int amplifier, double health) {
        if (!(this == Effects.field_76432_h && !entityLivingBaseIn.func_70662_br() || this == Effects.field_76433_i && entityLivingBaseIn.func_70662_br())) {
            if (this == Effects.field_76433_i && !entityLivingBaseIn.func_70662_br() || this == Effects.field_76432_h && entityLivingBaseIn.func_70662_br()) {
                int j = (int)(health * (double)(6 << amplifier) + 0.5);
                if (source == null) {
                    entityLivingBaseIn.func_70097_a(DamageSource.field_76376_m, j);
                } else {
                    entityLivingBaseIn.func_70097_a(DamageSource.func_76354_b((Entity)source, (Entity)indirectSource), j);
                }
            } else {
                this.func_76394_a(entityLivingBaseIn, amplifier);
            }
        } else {
            int i = (int)(health * (double)(4 << amplifier) + 0.5);
            entityLivingBaseIn.func_70691_i(i);
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        if (this == Effects.field_76428_l) {
            int k = 50 >> amplifier;
            if (k > 0) {
                return duration % k == 0;
            }
            return true;
        }
        if (this == Effects.field_76436_u) {
            int j = 25 >> amplifier;
            if (j > 0) {
                return duration % j == 0;
            }
            return true;
        }
        if (this == Effects.field_82731_v) {
            int i = 40 >> amplifier;
            if (i > 0) {
                return duration % i == 0;
            }
            return true;
        }
        return this == Effects.field_76438_s;
    }

    public boolean func_76403_b() {
        return false;
    }

    protected String func_210758_b() {
        if (this.field_76416_I == null) {
            this.field_76416_I = Util.func_200697_a((String)"effect", (ResourceLocation)Registry.field_212631_t.func_177774_c(this));
        }
        return this.field_76416_I;
    }

    public String func_76393_a() {
        return this.func_210758_b();
    }

    public ITextComponent func_199286_c() {
        return new TranslationTextComponent(this.func_76393_a());
    }

    public EffectType func_220303_e() {
        return this.field_220305_b;
    }

    public int func_76401_j() {
        return this.field_76414_N;
    }

    public Effect func_220304_a(Attribute attributeIn, String uuid, double amount, AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this::func_76393_a, amount, operation);
        this.field_111188_I.put(attributeIn, attributemodifier);
        return this;
    }

    public Map<Attribute, AttributeModifier> func_111186_k() {
        return this.field_111188_I;
    }

    public void func_111187_a(LivingEntity entityLivingBaseIn, AttributeModifierManager attributeMapIn, int amplifier) {
        for (Map.Entry<Attribute, AttributeModifier> entry : this.field_111188_I.entrySet()) {
            ModifiableAttributeInstance modifiableattributeinstance = attributeMapIn.func_233779_a_(entry.getKey());
            if (modifiableattributeinstance == null) continue;
            modifiableattributeinstance.func_111124_b(entry.getValue());
        }
    }

    public void func_111185_a(LivingEntity entityLivingBaseIn, AttributeModifierManager attributeMapIn, int amplifier) {
        for (Map.Entry<Attribute, AttributeModifier> entry : this.field_111188_I.entrySet()) {
            ModifiableAttributeInstance modifiableattributeinstance = attributeMapIn.func_233779_a_(entry.getKey());
            if (modifiableattributeinstance == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            modifiableattributeinstance.func_111124_b(attributemodifier);
            modifiableattributeinstance.func_233769_c_(new AttributeModifier(attributemodifier.func_111167_a(), this.func_76393_a() + " " + amplifier, this.func_111183_a(amplifier, attributemodifier), attributemodifier.func_220375_c()));
        }
    }

    public double func_111183_a(int amplifier, AttributeModifier modifier) {
        return modifier.func_111164_d() * (double)(amplifier + 1);
    }

    public boolean func_188408_i() {
        return this.field_220305_b == EffectType.BENEFICIAL;
    }
}

