/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.MainThread;
import net.minecraft.network.rcon.QueryThread;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraft.server.dedicated.ServerHangWatchdog;
import net.minecraft.server.dedicated.ServerInfoMBean;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.DefaultWithNameUncaughtExceptionHandler;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.filter.ChatFilterClient;
import net.minecraft.util.text.filter.IChatFilter;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.server.console.TerminalHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DedicatedServer
extends MinecraftServer
implements IServer {
    private static final Logger field_155771_h = LogManager.getLogger();
    private static final Pattern field_189647_l = Pattern.compile("^[a-fA-F0-9]{40}$");
    public final List<PendingCommand> field_71341_l = Collections.synchronizedList(Lists.newArrayList());
    private QueryThread field_71342_m;
    private final RConConsoleSource field_184115_n;
    private MainThread field_71339_n;
    private final ServerPropertiesProvider field_71340_o;
    @Nullable
    private MinecraftServerGui field_213225_q;
    @Nullable
    private final ChatFilterClient field_244714_r;

    public DedicatedServer(Thread p_i232601_1_, DynamicRegistries.Impl p_i232601_2_, SaveFormat.LevelSave p_i232601_3_, ResourcePackList p_i232601_4_, DataPackRegistries p_i232601_5_, IServerConfiguration p_i232601_6_, ServerPropertiesProvider p_i232601_7_, DataFixer p_i232601_8_, MinecraftSessionService p_i232601_9_, GameProfileRepository p_i232601_10_, PlayerProfileCache p_i232601_11_, IChunkStatusListenerFactory p_i232601_12_) {
        super(p_i232601_1_, p_i232601_2_, p_i232601_3_, p_i232601_6_, p_i232601_4_, Proxy.NO_PROXY, p_i232601_8_, p_i232601_5_, p_i232601_9_, p_i232601_10_, p_i232601_11_, p_i232601_12_);
        this.field_71340_o = p_i232601_7_;
        this.field_184115_n = new RConConsoleSource(this);
        this.field_244714_r = null;
    }

    @Override
    public boolean func_71197_b() throws IOException {
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (TerminalHandler.handleCommands((DedicatedServer)DedicatedServer.this)) {
                    return;
                }
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    String s1;
                    while (!DedicatedServer.this.func_71241_aa() && DedicatedServer.this.func_71278_l() && (s1 = bufferedreader.readLine()) != null) {
                        DedicatedServer.this.func_195581_a(s1, DedicatedServer.this.func_195573_aM());
                    }
                }
                catch (IOException ioexception1) {
                    field_155771_h.error("Exception handling console input", (Throwable)ioexception1);
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_155771_h));
        thread.start();
        field_155771_h.info("Starting minecraft server version " + SharedConstants.func_215069_a().getName());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            field_155771_h.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        field_155771_h.info("Loading properties");
        ServerProperties serverproperties = this.field_71340_o.func_219034_a();
        if (this.func_71264_H()) {
            this.func_71189_e("127.0.0.1");
        } else {
            this.func_71229_d(serverproperties.field_219007_a);
            this.func_190517_e(serverproperties.field_219008_b);
            this.func_71189_e(serverproperties.field_219009_c);
        }
        this.func_71188_g(serverproperties.field_219012_f);
        this.func_71245_h(serverproperties.field_219013_g);
        this.func_180507_a_(serverproperties.field_219014_h, this.func_184113_aK());
        this.func_71205_p(serverproperties.field_219015_i);
        this.func_104055_i(serverproperties.field_219016_j);
        super.func_143006_e((Integer)serverproperties.field_219005_R.get());
        this.func_205741_k(serverproperties.field_219017_k);
        this.field_240768_i_.func_230392_a_(serverproperties.field_219020_n);
        field_155771_h.info("Default game type: {}", (Object)serverproperties.field_219020_n);
        InetAddress inetaddress = null;
        if (!this.func_71211_k().isEmpty()) {
            inetaddress = InetAddress.getByName(this.func_71211_k());
        }
        if (this.func_71215_F() < 0) {
            this.func_71208_b(serverproperties.field_219025_s);
        }
        this.func_244801_P();
        field_155771_h.info("Starting Minecraft server on {}:{}", (Object)(this.func_71211_k().isEmpty() ? "*" : this.func_71211_k()), (Object)this.func_71215_F());
        try {
            this.func_147137_ag().func_151265_a(inetaddress, this.func_71215_F());
        }
        catch (IOException ioexception) {
            field_155771_h.warn("**** FAILED TO BIND TO PORT!");
            field_155771_h.warn("The exception was: {}", (Object)ioexception.toString());
            field_155771_h.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.func_71266_T()) {
            field_155771_h.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            field_155771_h.warn("The server will make no attempt to authenticate usernames. Beware.");
            field_155771_h.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            field_155771_h.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.func_152368_aE()) {
            this.func_152358_ax().func_152658_c();
        }
        if (!PreYggdrasilConverter.func_219587_e((MinecraftServer)this)) {
            return false;
        }
        this.func_184105_a((PlayerList)new DedicatedPlayerList(this, this.field_240767_f_, this.field_240766_e_));
        long i = Util.func_211178_c();
        this.func_71191_d(serverproperties.field_219026_t);
        SkullTileEntity.func_184293_a((PlayerProfileCache)this.func_152358_ax());
        SkullTileEntity.func_184294_a((MinecraftSessionService)this.func_147130_as());
        PlayerProfileCache.func_187320_a((boolean)this.func_71266_T());
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        field_155771_h.info("Preparing level \"{}\"", (Object)this.func_230542_k__());
        this.func_240800_l__();
        long j = Util.func_211178_c() - i;
        String s = String.format(Locale.ROOT, "%.3fs", (double)j / 1.0E9);
        field_155771_h.info("Done ({})! For help, type \"help\"", (Object)s);
        this.field_211151_aa = Util.func_211177_b();
        if (serverproperties.field_219027_u != null) {
            ((GameRules.BooleanValue)this.func_200252_aR().func_223585_a(GameRules.field_223620_w)).func_223570_a(serverproperties.field_219027_u.booleanValue(), (MinecraftServer)this);
        }
        if (serverproperties.field_219028_v) {
            field_155771_h.info("Starting GS4 status listener");
            this.field_71342_m = QueryThread.func_242129_a((IServer)this);
        }
        if (serverproperties.field_219030_x) {
            field_155771_h.info("Starting remote control listener");
            this.field_71339_n = MainThread.func_242130_a((IServer)this);
        }
        if (this.func_175593_aQ() > 0L) {
            Thread thread1 = new Thread(new ServerHangWatchdog(this));
            thread1.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultWithNameUncaughtExceptionHandler(field_155771_h));
            thread1.setName("Server Watchdog");
            thread1.setDaemon(true);
            thread1.start();
        }
        Items.field_190931_a.func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)NonNullList.func_191196_a());
        if (serverproperties.field_241079_P_) {
            ServerInfoMBean.func_233490_a_((MinecraftServer)this);
        }
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    @Override
    public boolean func_230537_U_() {
        return this.func_213221_d_().field_219010_d && super.func_230537_U_();
    }

    @Override
    public boolean func_230536_N_() {
        return this.field_71340_o.func_219034_a().field_218992_E && super.func_230536_N_();
    }

    @Override
    public boolean func_230538_V_() {
        return this.field_71340_o.func_219034_a().field_219011_e && super.func_230538_V_();
    }

    public String func_184113_aK() {
        String s;
        ServerProperties serverproperties = this.field_71340_o.func_219034_a();
        if (!serverproperties.field_218989_B.isEmpty()) {
            s = serverproperties.field_218989_B;
            if (!Strings.isNullOrEmpty((String)serverproperties.field_218988_A)) {
                field_155771_h.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)serverproperties.field_218988_A)) {
            field_155771_h.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            s = serverproperties.field_218988_A;
        } else {
            s = "";
        }
        if (!s.isEmpty() && !field_189647_l.matcher(s).matches()) {
            field_155771_h.warn("Invalid sha1 for ressource-pack-sha1");
        }
        if (!serverproperties.field_219014_h.isEmpty() && s.isEmpty()) {
            field_155771_h.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        }
        return s;
    }

    public ServerProperties func_213221_d_() {
        return this.field_71340_o.func_219034_a();
    }

    @Override
    public void func_230543_p_() {
        this.func_147139_a(this.func_213221_d_().field_219019_m, true);
    }

    @Override
    public boolean func_71199_h() {
        return this.func_213221_d_().field_218990_C;
    }

    @Override
    public CrashReport func_71230_b(CrashReport report) {
        report = super.func_71230_b(report);
        report.func_85056_g().func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_230045_q_().orElse("Unknown (can't tell)")));
        report.func_85056_g().func_189529_a("Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> "Dedicated Server (map_server.txt)"));
        return report;
    }

    @Override
    public Optional<String> func_230045_q_() {
        String s = this.getServerModName();
        return !"vanilla".equals(s) ? Optional.of("Definitely; Server brand changed to '" + s + "'") : Optional.empty();
    }

    @Override
    public void func_71240_o() {
        if (this.field_244714_r != null) {
            this.field_244714_r.close();
        }
        if (this.field_213225_q != null) {
            this.field_213225_q.func_219050_b();
        }
        if (this.field_71339_n != null) {
            this.field_71339_n.func_219591_b();
        }
        if (this.field_71342_m != null) {
            this.field_71342_m.func_219591_b();
        }
    }

    @Override
    public void func_71190_q(BooleanSupplier hasTimeLeft) {
        super.func_71190_q(hasTimeLeft);
        this.func_71333_ah();
    }

    @Override
    public boolean func_71255_r() {
        return this.func_213221_d_().field_218991_D;
    }

    @Override
    public void func_70000_a(Snooper snooper) {
        snooper.func_152768_a("whitelist_enabled", (Object)this.func_184103_al().func_72383_n());
        snooper.func_152768_a("whitelist_count", (Object)this.func_184103_al().func_152598_l().length);
        super.func_70000_a(snooper);
    }

    public void func_195581_a(String p_195581_1_, CommandSource p_195581_2_) {
        this.field_71341_l.add(new PendingCommand(p_195581_1_, p_195581_2_));
    }

    public void func_71333_ah() {
        while (!this.field_71341_l.isEmpty()) {
            PendingCommand pendingcommand = this.field_71341_l.remove(0);
            this.func_195571_aL().func_197059_a(pendingcommand.field_73701_b, pendingcommand.field_73702_a);
        }
    }

    @Override
    public boolean func_71262_S() {
        return true;
    }

    @Override
    public int func_241871_k() {
        return this.func_213221_d_().field_244379_I;
    }

    @Override
    public boolean func_181035_ah() {
        return this.func_213221_d_().field_218994_G;
    }

    public DedicatedPlayerList func_184103_al() {
        return (DedicatedPlayerList)super.func_184103_al();
    }

    @Override
    public boolean func_71344_c() {
        return true;
    }

    public String func_71277_t() {
        return this.func_71211_k();
    }

    public int func_71234_u() {
        return this.func_71215_F();
    }

    public String func_71274_v() {
        return this.func_71273_Y();
    }

    public void func_120011_ar() {
        if (this.field_213225_q == null) {
            this.field_213225_q = MinecraftServerGui.func_219048_a(this);
        }
    }

    @Override
    public boolean func_71279_ae() {
        return this.field_213225_q != null;
    }

    @Override
    public boolean func_195565_a(GameType gameMode, boolean cheats, int port) {
        return false;
    }

    @Override
    public boolean func_82356_Z() {
        return this.func_213221_d_().field_218995_H;
    }

    @Override
    public int func_82357_ak() {
        return this.func_213221_d_().field_218996_I;
    }

    @Override
    public boolean func_175579_a(ServerWorld worldIn, BlockPos pos, PlayerEntity playerIn) {
        int j;
        if (worldIn.func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        if (this.func_184103_al().func_152603_m().func_152690_d()) {
            return false;
        }
        if (this.func_184103_al().func_152596_g(playerIn.func_146103_bH())) {
            return false;
        }
        if (this.func_82357_ak() <= 0) {
            return false;
        }
        BlockPos blockpos = worldIn.func_241135_u_();
        int i = MathHelper.func_76130_a((int)(pos.func_177958_n() - blockpos.func_177958_n()));
        int k = Math.max(i, j = MathHelper.func_76130_a((int)(pos.func_177952_p() - blockpos.func_177952_p())));
        return k <= this.func_82357_ak();
    }

    @Override
    public boolean func_230541_aj_() {
        return this.func_213221_d_().field_241080_Q_;
    }

    @Override
    public int func_110455_j() {
        return this.func_213221_d_().field_218997_J;
    }

    @Override
    public int func_223707_k() {
        return this.func_213221_d_().field_225395_K;
    }

    @Override
    public void func_143006_e(int idleTimeout) {
        super.func_143006_e(idleTimeout);
        this.field_71340_o.func_219033_a(p_213224_2_ -> (ServerProperties)p_213224_2_.field_219005_R.func_244381_a(this.func_244267_aX(), idleTimeout));
    }

    @Override
    public boolean func_195569_l() {
        return this.func_213221_d_().field_219002_O;
    }

    public boolean func_195041_r_() {
        return this.func_213221_d_().field_219003_P;
    }

    @Override
    public int func_175580_aG() {
        return this.func_213221_d_().field_219004_Q;
    }

    @Override
    public int func_175577_aI() {
        return this.func_213221_d_().field_219001_N;
    }

    protected boolean func_152368_aE() {
        boolean flag = false;
        for (int i = 0; !flag && i <= 2; ++i) {
            if (i > 0) {
                field_155771_h.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag = PreYggdrasilConverter.func_152724_a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (int j = 0; !flag1 && j <= 2; ++j) {
            if (j > 0) {
                field_155771_h.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag1 = PreYggdrasilConverter.func_152722_b((MinecraftServer)this);
        }
        boolean flag2 = false;
        for (int k = 0; !flag2 && k <= 2; ++k) {
            if (k > 0) {
                field_155771_h.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag2 = PreYggdrasilConverter.func_152718_c((MinecraftServer)this);
        }
        boolean flag3 = false;
        for (int l = 0; !flag3 && l <= 2; ++l) {
            if (l > 0) {
                field_155771_h.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag3 = PreYggdrasilConverter.func_152710_d((MinecraftServer)this);
        }
        boolean flag4 = false;
        for (int i1 = 0; !flag4 && i1 <= 2; ++i1) {
            if (i1 > 0) {
                field_155771_h.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag4 = PreYggdrasilConverter.func_152723_a((DedicatedServer)this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void func_152369_aG() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long func_175593_aQ() {
        return this.func_213221_d_().field_218998_K;
    }

    public String func_71258_A() {
        return "";
    }

    public String func_71252_i(String command) {
        this.field_184115_n.func_70007_b();
        this.func_213167_f(() -> this.func_195571_aL().func_197059_a(this.field_184115_n.func_195540_f(), command));
        return this.field_184115_n.func_70008_c();
    }

    public void func_213223_o(boolean p_213223_1_) {
        this.field_71340_o.func_219033_a(p_213222_2_ -> (ServerProperties)p_213222_2_.field_219006_S.func_244381_a(this.func_244267_aX(), p_213223_1_));
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        Util.func_240993_h_();
    }

    @Override
    public boolean func_213199_b(GameProfile profileIn) {
        return false;
    }

    @Override
    public void func_145747_a(ITextComponent message, UUID senderUUID) {
        field_155771_h.info(message.getString());
    }

    @Override
    public int func_230512_b_(int p_230512_1_) {
        return this.func_213221_d_().field_241081_R_ * p_230512_1_ / 100;
    }

    public String func_230542_k__() {
        return this.field_71310_m.func_237282_a_();
    }

    @Override
    public boolean func_230540_aS_() {
        return this.field_71340_o.func_219034_a().field_241078_O_;
    }

    @Override
    @Nullable
    public IChatFilter func_244435_a(ServerPlayerEntity p_244435_1_) {
        return this.field_244714_r != null ? this.field_244714_r.func_244566_a(p_244435_1_.func_146103_bH()) : null;
    }
}

