/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Style {
    public static final Style field_240709_b_ = new Style(null, null, null, null, null, null, null, null, null, null);
    public static final ResourceLocation field_240708_a_ = new ResourceLocation("minecraft", "default");
    @Nullable
    private final Color field_150247_b;
    @Nullable
    private final Boolean field_150248_c;
    @Nullable
    private final Boolean field_150245_d;
    @Nullable
    private final Boolean field_150246_e;
    @Nullable
    private final Boolean field_150243_f;
    @Nullable
    private final Boolean field_150244_g;
    @Nullable
    private final ClickEvent field_150251_h;
    @Nullable
    private final HoverEvent field_150252_i;
    @Nullable
    private final String field_179990_j;
    @Nullable
    private final ResourceLocation field_240710_l_;

    private Style(@Nullable Color color, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @Nullable ResourceLocation fontId) {
        this.field_150247_b = color;
        this.field_150248_c = bold;
        this.field_150245_d = italic;
        this.field_150246_e = underlined;
        this.field_150243_f = strikethrough;
        this.field_150244_g = obfuscated;
        this.field_150251_h = clickEvent;
        this.field_150252_i = hoverEvent;
        this.field_179990_j = insertion;
        this.field_240710_l_ = fontId;
    }

    @Nullable
    public Color func_240711_a_() {
        return this.field_150247_b;
    }

    public boolean func_150223_b() {
        return this.field_150248_c == Boolean.TRUE;
    }

    public boolean func_150242_c() {
        return this.field_150245_d == Boolean.TRUE;
    }

    public boolean func_150236_d() {
        return this.field_150243_f == Boolean.TRUE;
    }

    public boolean func_150234_e() {
        return this.field_150246_e == Boolean.TRUE;
    }

    public boolean func_150233_f() {
        return this.field_150244_g == Boolean.TRUE;
    }

    public boolean func_150229_g() {
        return this == field_240709_b_;
    }

    @Nullable
    public ClickEvent func_150235_h() {
        return this.field_150251_h;
    }

    @Nullable
    public HoverEvent func_150210_i() {
        return this.field_150252_i;
    }

    @Nullable
    public String func_179986_j() {
        return this.field_179990_j;
    }

    public ResourceLocation func_240729_k_() {
        return this.field_240710_l_ != null ? this.field_240710_l_ : field_240708_a_;
    }

    public Style func_240718_a_(@Nullable Color color) {
        return new Style(color, this.field_150248_c, this.field_150245_d, this.field_150246_e, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240712_a_(@Nullable TextFormatting formatting) {
        return this.func_240718_a_(formatting != null ? Color.func_240744_a_((TextFormatting)formatting) : null);
    }

    public Style func_240713_a_(@Nullable Boolean bold) {
        return new Style(this.field_150247_b, bold, this.field_150245_d, this.field_150246_e, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240722_b_(@Nullable Boolean italic) {
        return new Style(this.field_150247_b, this.field_150248_c, italic, this.field_150246_e, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Style func_244282_c(@Nullable Boolean p_244282_1_) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, p_244282_1_, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style setUnderlined(@Nullable Boolean underlined) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, underlined, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style setStrikethrough(@Nullable Boolean strikethrough) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, this.field_150246_e, strikethrough, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style setObfuscated(@Nullable Boolean obfuscated) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, this.field_150246_e, this.field_150243_f, obfuscated, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240715_a_(@Nullable ClickEvent clickEvent) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, this.field_150246_e, this.field_150243_f, this.field_150244_g, clickEvent, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240716_a_(@Nullable HoverEvent hoverEvent) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, this.field_150246_e, this.field_150243_f, this.field_150244_g, this.field_150251_h, hoverEvent, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240714_a_(@Nullable String insertion) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, this.field_150246_e, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, insertion, this.field_240710_l_);
    }

    public Style func_240719_a_(@Nullable ResourceLocation fontId) {
        return new Style(this.field_150247_b, this.field_150248_c, this.field_150245_d, this.field_150246_e, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j, fontId);
    }

    public Style func_240721_b_(TextFormatting formatting) {
        Color color = this.field_150247_b;
        Boolean obool = this.field_150248_c;
        Boolean obool1 = this.field_150245_d;
        Boolean obool2 = this.field_150243_f;
        Boolean obool3 = this.field_150246_e;
        Boolean obool4 = this.field_150244_g;
        switch (formatting) {
            case OBFUSCATED: {
                obool4 = true;
                break;
            }
            case BOLD: {
                obool = true;
                break;
            }
            case STRIKETHROUGH: {
                obool2 = true;
                break;
            }
            case UNDERLINE: {
                obool3 = true;
                break;
            }
            case ITALIC: {
                obool1 = true;
                break;
            }
            case RESET: {
                return field_240709_b_;
            }
            default: {
                color = Color.func_240744_a_((TextFormatting)formatting);
            }
        }
        return new Style(color, obool, obool1, obool3, obool2, obool4, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240723_c_(TextFormatting formatting) {
        Color color = this.field_150247_b;
        Boolean obool = this.field_150248_c;
        Boolean obool1 = this.field_150245_d;
        Boolean obool2 = this.field_150243_f;
        Boolean obool3 = this.field_150246_e;
        Boolean obool4 = this.field_150244_g;
        switch (formatting) {
            case OBFUSCATED: {
                obool4 = true;
                break;
            }
            case BOLD: {
                obool = true;
                break;
            }
            case STRIKETHROUGH: {
                obool2 = true;
                break;
            }
            case UNDERLINE: {
                obool3 = true;
                break;
            }
            case ITALIC: {
                obool1 = true;
                break;
            }
            case RESET: {
                return field_240709_b_;
            }
            default: {
                obool4 = false;
                obool = false;
                obool2 = false;
                obool3 = false;
                obool1 = false;
                color = Color.func_240744_a_((TextFormatting)formatting);
            }
        }
        return new Style(color, obool, obool1, obool3, obool2, obool4, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240720_a_(TextFormatting ... formatings) {
        Color color = this.field_150247_b;
        Boolean obool = this.field_150248_c;
        Boolean obool1 = this.field_150245_d;
        Boolean obool2 = this.field_150243_f;
        Boolean obool3 = this.field_150246_e;
        Boolean obool4 = this.field_150244_g;
        block8: for (TextFormatting textformatting : formatings) {
            switch (textformatting) {
                case OBFUSCATED: {
                    obool4 = true;
                    continue block8;
                }
                case BOLD: {
                    obool = true;
                    continue block8;
                }
                case STRIKETHROUGH: {
                    obool2 = true;
                    continue block8;
                }
                case UNDERLINE: {
                    obool3 = true;
                    continue block8;
                }
                case ITALIC: {
                    obool1 = true;
                    continue block8;
                }
                case RESET: {
                    return field_240709_b_;
                }
                default: {
                    color = Color.func_240744_a_((TextFormatting)textformatting);
                }
            }
        }
        return new Style(color, obool, obool1, obool3, obool2, obool4, this.field_150251_h, this.field_150252_i, this.field_179990_j, this.field_240710_l_);
    }

    public Style func_240717_a_(Style style) {
        if (this == field_240709_b_) {
            return style;
        }
        return style == field_240709_b_ ? this : new Style(this.field_150247_b != null ? this.field_150247_b : style.field_150247_b, this.field_150248_c != null ? this.field_150248_c : style.field_150248_c, this.field_150245_d != null ? this.field_150245_d : style.field_150245_d, this.field_150246_e != null ? this.field_150246_e : style.field_150246_e, this.field_150243_f != null ? this.field_150243_f : style.field_150243_f, this.field_150244_g != null ? this.field_150244_g : style.field_150244_g, this.field_150251_h != null ? this.field_150251_h : style.field_150251_h, this.field_150252_i != null ? this.field_150252_i : style.field_150252_i, this.field_179990_j != null ? this.field_179990_j : style.field_179990_j, this.field_240710_l_ != null ? this.field_240710_l_ : style.field_240710_l_);
    }

    public String toString() {
        return "Style{ color=" + this.field_150247_b + ", bold=" + this.field_150248_c + ", italic=" + this.field_150245_d + ", underlined=" + this.field_150246_e + ", strikethrough=" + this.field_150243_f + ", obfuscated=" + this.field_150244_g + ", clickEvent=" + this.func_150235_h() + ", hoverEvent=" + this.func_150210_i() + ", insertion=" + this.func_179986_j() + ", font=" + this.func_240729_k_() + '}';
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Style)) {
            return false;
        }
        Style style = (Style)p_equals_1_;
        return this.func_150223_b() == style.func_150223_b() && Objects.equals(this.func_240711_a_(), style.func_240711_a_()) && this.func_150242_c() == style.func_150242_c() && this.func_150233_f() == style.func_150233_f() && this.func_150236_d() == style.func_150236_d() && this.func_150234_e() == style.func_150234_e() && Objects.equals(this.func_150235_h(), style.func_150235_h()) && Objects.equals(this.func_150210_i(), style.func_150210_i()) && Objects.equals(this.func_179986_j(), style.func_179986_j()) && Objects.equals(this.func_240729_k_(), style.func_240729_k_());
    }

    public int hashCode() {
        return Objects.hash(this.field_150247_b, this.field_150248_c, this.field_150245_d, this.field_150246_e, this.field_150243_f, this.field_150244_g, this.field_150251_h, this.field_150252_i, this.field_179990_j);
    }

    public static class Serializer
    implements JsonDeserializer<Style>,
    JsonSerializer<Style> {
        @Nullable
        public Style deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            if (p_deserialize_1_.isJsonObject()) {
                JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
                if (jsonobject == null) {
                    return null;
                }
                Boolean obool = Serializer.func_240733_a_(jsonobject, "bold");
                Boolean obool1 = Serializer.func_240733_a_(jsonobject, "italic");
                Boolean obool2 = Serializer.func_240733_a_(jsonobject, "underlined");
                Boolean obool3 = Serializer.func_240733_a_(jsonobject, "strikethrough");
                Boolean obool4 = Serializer.func_240733_a_(jsonobject, "obfuscated");
                Color color = Serializer.func_240737_e_(jsonobject);
                String s = Serializer.func_240736_d_(jsonobject);
                ClickEvent clickevent = Serializer.func_240735_c_(jsonobject);
                HoverEvent hoverevent = Serializer.func_240734_b_(jsonobject);
                ResourceLocation resourcelocation = Serializer.func_240732_a_(jsonobject);
                return new Style(color, obool, obool1, obool2, obool3, obool4, clickevent, hoverevent, s, resourcelocation);
            }
            return null;
        }

        @Nullable
        private static ResourceLocation func_240732_a_(JsonObject json) {
            if (json.has("font")) {
                String s = JSONUtils.func_151200_h((JsonObject)json, (String)"font");
                try {
                    return new ResourceLocation(s);
                }
                catch (ResourceLocationException resourcelocationexception) {
                    throw new JsonSyntaxException("Invalid font name: " + s);
                }
            }
            return null;
        }

        @Nullable
        private static HoverEvent func_240734_b_(JsonObject json) {
            JsonObject jsonobject;
            HoverEvent hoverevent;
            if (json.has("hoverEvent") && (hoverevent = HoverEvent.func_240661_a_((JsonObject)(jsonobject = JSONUtils.func_152754_s((JsonObject)json, (String)"hoverEvent")))) != null && hoverevent.func_150701_a().func_150686_a()) {
                return hoverevent;
            }
            return null;
        }

        @Nullable
        private static ClickEvent func_240735_c_(JsonObject json) {
            if (json.has("clickEvent")) {
                JsonObject jsonobject = JSONUtils.func_152754_s((JsonObject)json, (String)"clickEvent");
                String s = JSONUtils.func_151219_a((JsonObject)jsonobject, (String)"action", (String)null);
                ClickEvent.Action clickevent$action = s == null ? null : ClickEvent.Action.func_150672_a((String)s);
                String s1 = JSONUtils.func_151219_a((JsonObject)jsonobject, (String)"value", (String)null);
                if (clickevent$action != null && s1 != null && clickevent$action.func_150674_a()) {
                    return new ClickEvent(clickevent$action, s1);
                }
            }
            return null;
        }

        @Nullable
        private static String func_240736_d_(JsonObject json) {
            return JSONUtils.func_151219_a((JsonObject)json, (String)"insertion", (String)null);
        }

        @Nullable
        private static Color func_240737_e_(JsonObject json) {
            if (json.has("color")) {
                String s = JSONUtils.func_151200_h((JsonObject)json, (String)"color");
                return Color.func_240745_a_((String)s);
            }
            return null;
        }

        @Nullable
        private static Boolean func_240733_a_(JsonObject json, String memberName) {
            return json.has(memberName) ? Boolean.valueOf(json.get(memberName).getAsBoolean()) : null;
        }

        @Nullable
        public JsonElement serialize(Style p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            if (p_serialize_1_.func_150229_g()) {
                return null;
            }
            JsonObject jsonobject = new JsonObject();
            if (p_serialize_1_.field_150248_c != null) {
                jsonobject.addProperty("bold", p_serialize_1_.field_150248_c);
            }
            if (p_serialize_1_.field_150245_d != null) {
                jsonobject.addProperty("italic", p_serialize_1_.field_150245_d);
            }
            if (p_serialize_1_.field_150246_e != null) {
                jsonobject.addProperty("underlined", p_serialize_1_.field_150246_e);
            }
            if (p_serialize_1_.field_150243_f != null) {
                jsonobject.addProperty("strikethrough", p_serialize_1_.field_150243_f);
            }
            if (p_serialize_1_.field_150244_g != null) {
                jsonobject.addProperty("obfuscated", p_serialize_1_.field_150244_g);
            }
            if (p_serialize_1_.field_150247_b != null) {
                jsonobject.addProperty("color", p_serialize_1_.field_150247_b.func_240747_b_());
            }
            if (p_serialize_1_.field_179990_j != null) {
                jsonobject.add("insertion", p_serialize_3_.serialize((Object)p_serialize_1_.field_179990_j));
            }
            if (p_serialize_1_.field_150251_h != null) {
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("action", p_serialize_1_.field_150251_h.func_150669_a().func_150673_b());
                jsonobject1.addProperty("value", p_serialize_1_.field_150251_h.func_150668_b());
                jsonobject.add("clickEvent", (JsonElement)jsonobject1);
            }
            if (p_serialize_1_.field_150252_i != null) {
                jsonobject.add("hoverEvent", (JsonElement)p_serialize_1_.field_150252_i.func_240663_b_());
            }
            if (p_serialize_1_.field_240710_l_ != null) {
                jsonobject.addProperty("font", p_serialize_1_.field_240710_l_.toString());
            }
            return jsonobject;
        }
    }
}

