/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeGenerationSettings {
    public static final Logger field_242479_a = LogManager.getLogger();
    public static final BiomeGenerationSettings field_242480_b = new BiomeGenerationSettings(() -> ConfiguredSurfaceBuilders.field_244184_p, (Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>>)ImmutableMap.of(), (List<List<Supplier<ConfiguredFeature<?, ?>>>>)ImmutableList.of(), (List<Supplier<StructureFeature<?, ?>>>)ImmutableList.of());
    public static final MapCodec<BiomeGenerationSettings> field_242481_c = RecordCodecBuilder.mapCodec(p_242495_0_ -> p_242495_0_.group((App)ConfiguredSurfaceBuilder.field_244393_b_.fieldOf("surface_builder").forGetter(p_242501_0_ -> p_242501_0_.field_242482_d), (App)Codec.simpleMap((Codec)GenerationStage.Carving.field_236074_c_, (Codec)ConfiguredCarver.field_242759_c.promotePartial(Util.func_240982_a_((String)"Carver: ", arg_0 -> ((Logger)field_242479_a).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])GenerationStage.Carving.values())).fieldOf("carvers").forGetter(p_242499_0_ -> p_242499_0_.field_242483_e), (App)ConfiguredFeature.field_242764_c.promotePartial(Util.func_240982_a_((String)"Feature: ", arg_0 -> ((Logger)field_242479_a).error(arg_0))).listOf().fieldOf("features").forGetter(p_242497_0_ -> p_242497_0_.field_242484_f), (App)StructureFeature.field_242770_c.promotePartial(Util.func_240982_a_((String)"Structure start: ", arg_0 -> ((Logger)field_242479_a).error(arg_0))).fieldOf("starts").forGetter(p_242488_0_ -> p_242488_0_.field_242485_g)).apply((Applicative)p_242495_0_, BiomeGenerationSettings::new));
    private final Supplier<ConfiguredSurfaceBuilder<?>> field_242482_d;
    private final Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>> field_242483_e;
    private final Set<GenerationStage.Carving> carversView;
    private final List<List<Supplier<ConfiguredFeature<?, ?>>>> field_242484_f;
    private final List<Supplier<StructureFeature<?, ?>>> field_242485_g;
    private final List<ConfiguredFeature<?, ?>> field_242486_h;

    private BiomeGenerationSettings(Supplier<ConfiguredSurfaceBuilder<?>> surfaceBuilder, Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>> carversIn, List<List<Supplier<ConfiguredFeature<?, ?>>>> features, List<Supplier<StructureFeature<?, ?>>> structures) {
        this.field_242482_d = surfaceBuilder;
        this.field_242483_e = carversIn;
        this.field_242484_f = features;
        this.field_242485_g = structures;
        this.field_242486_h = (List)features.stream().flatMap(Collection::stream).map(Supplier::get).flatMap(ConfiguredFeature::func_242768_d).filter(p_242490_0_ -> p_242490_0_.field_222737_a == Feature.field_227247_y_).collect(ImmutableList.toImmutableList());
        this.carversView = Collections.unmodifiableSet(this.field_242483_e.keySet());
    }

    public List<Supplier<ConfiguredCarver<?>>> func_242489_a(GenerationStage.Carving carvingType) {
        return (List)this.field_242483_e.getOrDefault(carvingType, (List<Supplier<ConfiguredCarver<?>>>)ImmutableList.of());
    }

    public Set<GenerationStage.Carving> getCarvingStages() {
        return this.carversView;
    }

    public boolean func_242493_a(Structure<?> structure) {
        return this.field_242485_g.stream().anyMatch(p_242494_1_ -> ((StructureFeature)p_242494_1_.get()).field_236268_b_ == structure);
    }

    public Collection<Supplier<StructureFeature<?, ?>>> func_242487_a() {
        return this.field_242485_g;
    }

    public StructureFeature<?, ?> func_242491_a(StructureFeature<?, ?> structure) {
        return (StructureFeature)DataFixUtils.orElse(this.field_242485_g.stream().map(Supplier::get).filter(p_242492_1_ -> p_242492_1_.field_236268_b_ == structure.field_236268_b_).findAny(), structure);
    }

    public List<ConfiguredFeature<?, ?>> func_242496_b() {
        return this.field_242486_h;
    }

    public List<List<Supplier<ConfiguredFeature<?, ?>>>> func_242498_c() {
        return this.field_242484_f;
    }

    public Supplier<ConfiguredSurfaceBuilder<?>> func_242500_d() {
        return this.field_242482_d;
    }

    public ISurfaceBuilderConfig func_242502_e() {
        return this.field_242482_d.get().func_215452_a();
    }

    public static class Builder {
        protected Optional<Supplier<ConfiguredSurfaceBuilder<?>>> field_242504_a = Optional.empty();
        protected final Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>> field_242505_b = Maps.newLinkedHashMap();
        protected final List<List<Supplier<ConfiguredFeature<?, ?>>>> field_242506_c = Lists.newArrayList();
        protected final List<Supplier<StructureFeature<?, ?>>> field_242507_d = Lists.newArrayList();

        public Builder func_242517_a(ConfiguredSurfaceBuilder<?> configuredSurfaceBuilder) {
            return this.func_242519_a(() -> configuredSurfaceBuilder);
        }

        public Builder func_242519_a(Supplier<ConfiguredSurfaceBuilder<?>> configuredSurfaceBuilderSupplier) {
            this.field_242504_a = Optional.of(configuredSurfaceBuilderSupplier);
            return this;
        }

        public Builder func_242513_a(GenerationStage.Decoration decorationStage, ConfiguredFeature<?, ?> feature) {
            return this.func_242510_a(decorationStage.ordinal(), () -> feature);
        }

        public Builder func_242510_a(int stage, Supplier<ConfiguredFeature<?, ?>> features) {
            this.func_242509_a(stage);
            this.field_242506_c.get(stage).add(features);
            return this;
        }

        public <C extends ICarverConfig> Builder func_242512_a(GenerationStage.Carving carvingStage, ConfiguredCarver<C> carver) {
            this.field_242505_b.computeIfAbsent(carvingStage, p_242511_0_ -> Lists.newArrayList()).add(() -> carver);
            return this;
        }

        public Builder func_242516_a(StructureFeature<?, ?> structure) {
            this.field_242507_d.add(() -> structure);
            return this;
        }

        protected void func_242509_a(int stage) {
            while (this.field_242506_c.size() <= stage) {
                this.field_242506_c.add(Lists.newArrayList());
            }
        }

        public BiomeGenerationSettings func_242508_a() {
            return new BiomeGenerationSettings(this.field_242504_a.orElseThrow(() -> new IllegalStateException("Missing surface builder")), (Map)this.field_242505_b.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_242518_0_ -> ImmutableList.copyOf((Collection)((Collection)p_242518_0_.getValue())))), (List)this.field_242506_c.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList()), (List)ImmutableList.copyOf(this.field_242507_d));
        }
    }
}

